/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.fileupload;

import com.sun.javaee.blueprints.components.ui.fileupload.CustomServletRequestContext;
import com.sun.javaee.blueprints.components.ui.fileupload.FileUploadStatus;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class FileUploadPhaseListener
implements PhaseListener {
    private Logger _logger = null;
    private static final String FILE_UPLOAD_LOGGER = "com.sun.javaee.blueprints.components.ui.fileupload";
    private static final String FILE_UPLOAD_LOG_STRINGS = "com.sun.javaee.blueprints.components.ui.fileupload.LogStrings";
    public static final String PROCESS_FILE_UPLOAD = "ProcessFileUpload";
    public static final String FILE_UPLOAD_STATUS = "FileUploadStatus";
    public static final String DEFAULT_SERVER_LOCATION_DIR = System.getProperty("com.sun.aas.instanceRoot", "/fileupload") + "/lib/upload";
    public static final boolean bDebug = true;

    public void afterPhase(PhaseEvent event) {
        String rootId = event.getFacesContext().getViewRoot().getViewId();
        System.out.println("PhaseListener - Root ID " + rootId);
        if (rootId.indexOf(PROCESS_FILE_UPLOAD) > -1) {
            this.handleFileUpload(event);
        } else if (rootId.indexOf(FILE_UPLOAD_STATUS) > -1) {
            this.handleFileStatus(event);
        }
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void handleFileStatus(PhaseEvent event) {
        StringBuffer sb = new StringBuffer();
        try {
            FacesContext context = event.getFacesContext();
            Object object = context.getExternalContext().getRequest();
            if (!(object instanceof HttpServletRequest)) {
                return;
            }
            HttpServletRequest request = (HttpServletRequest)object;
            HttpSession session = request.getSession();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            FileUploadStatus status = (FileUploadStatus)session.getAttribute(FILE_UPLOAD_STATUS);
            response.setContentType("text/xml;charset=UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            sb.append("<response>");
            if (status != null) {
                sb.append("<message>");
                sb.append(status.getMessage());
                sb.append("</message>");
                sb.append("<status>");
                sb.append(status.getStatus());
                sb.append("</status>");
                sb.append("<current_item>");
                sb.append(status.getCurrentItem());
                sb.append("</current_item>");
                sb.append("<percent_complete>");
                sb.append(status.getPercentageComplete());
                sb.append("</percent_complete>");
            } else {
                sb.append("<message>No Status</message>");
                sb.append("<status>No Status</status>");
                sb.append("<current_item>None</current_item>");
                sb.append("<percent_complete>0</percent_complete>");
            }
            sb.append("</response>");
            response.getWriter().write(sb.toString());
        }
        catch (IOException iox) {
            System.out.println("FileUploadPhaseListener error writting AJAX response : " + iox);
            this.getLogger().log(Level.SEVERE, "response.exeception", iox);
        }
        System.out.println("STATUS RETURN = " + sb.toString());
        event.getFacesContext().responseComplete();
    }

    protected void handleFileUpload(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        Object object = context.getExternalContext().getRequest();
        if (!(object instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)object;
        Enumeration enumx = request.getHeaderNames();
        String key = "";
        String listx = "";
        while (enumx.hasMoreElements()) {
            key = (String)enumx.nextElement();
            listx = listx + "\n" + key + ":" + request.getHeader(key);
        }
        System.out.println("Incoming Header Item:" + listx);
        HttpSession session = request.getSession();
        FileUploadStatus status = new FileUploadStatus();
        try {
            session.setAttribute(FILE_UPLOAD_STATUS, (Object)status);
        }
        catch (IllegalStateException ie) {
            System.out.println("FileUploadStatus item \"FileUploadStatus\" can not be written to the session. FileUpload Monitoring will not be updated!");
        }
        HashMap hmUpload = new HashMap();
        long totalSizeOfUpload = request.getContentLength();
        status.setTotalUploadSize(totalSizeOfUpload);
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            try {
                CustomServletRequestContext csrc = new CustomServletRequestContext(request, status);
                List items = upload.parseRequest((RequestContext)csrc);
                status.setReadingComplete();
                Iterator iter = items.iterator();
                FileItem item = null;
                String itemName = null;
                long sizex = 0L;
                while (iter.hasNext()) {
                    item = (FileItem)iter.next();
                    if (!item.isFormField()) continue;
                    itemName = item.getFieldName();
                    sizex = item.getSize();
                    this.updateSessionStatus(status, itemName, sizex);
                    this.formItemFound(event, item, hmUpload);
                    System.out.println("Form field item:" + itemName + " = " + sizex);
                }
                String compName = (String)hmUpload.get("componentName");
                status.setName(compName);
                String serverLocationDir = (String)hmUpload.get(compName + "_" + "serverLocationDir");
                File fileDir = null;
                if (serverLocationDir == null) {
                    serverLocationDir = DEFAULT_SERVER_LOCATION_DIR;
                    fileDir = new File(serverLocationDir);
                    fileDir.mkdirs();
                }
                if (!(fileDir = new File(serverLocationDir)).isDirectory()) {
                    status.setMessage("Directory \"" + serverLocationDir + "\" doesn't exist!");
                    status.setStatus("ERROR");
                    this.getLogger().log(Level.SEVERE, "directory.inaccessable", serverLocationDir);
                    this.writeUploadResponse(event, hmUpload, status);
                    event.getFacesContext().responseComplete();
                    return;
                }
                iter = items.iterator();
                Object fileLocation = null;
                while (iter.hasNext()) {
                    item = (FileItem)iter.next();
                    if (item.isFormField()) continue;
                    this.fileItemFound(event, item, hmUpload, serverLocationDir, status);
                }
                status.setUploadComplete();
                System.out.println("Final session status - " + status);
            }
            catch (Exception e) {
                status.setMessage("FileUpload didn't complete successfully.  Exception received:" + e.toString());
                status.setStatus("ERROR");
                this.getLogger().log(Level.SEVERE, "file.upload.exception", e);
            }
        }
        this.writeUploadResponse(event, hmUpload, status);
        event.getFacesContext().responseComplete();
    }

    public void formItemFound(PhaseEvent event, FileItem item, HashMap hmUpload) {
        String key = item.getFieldName();
        String value = item.getString();
        System.out.println("Inserting form item in map " + key + " = " + value);
        hmUpload.put(key, value);
    }

    public void fileItemFound(PhaseEvent event, FileItem item, HashMap hmUpload, String serverLocationDir, FileUploadStatus status) throws Exception {
        String fileName = item.getName();
        if (fileName != null && !fileName.equals("")) {
            System.out.println("Have item - " + fileName);
            int iPos = fileName.lastIndexOf("/");
            if (iPos > -1) {
                fileName = fileName.substring(iPos + 1);
                System.out.println("Have full path, need to truncate \n" + item.getName() + "\n" + fileName);
            }
            if ((iPos = fileName.lastIndexOf("\\")) > -1) {
                fileName = fileName.substring(iPos + 1);
                System.out.println("Have full path, need to truncate \n" + item.getName() + "\n" + fileName);
            }
            String fileLocation = serverLocationDir + "/" + fileName;
            System.out.println("Writing item to " + fileLocation);
            File uploadedFile = new File(fileLocation);
            this.write(item, uploadedFile, status);
            String key = "fileLocation_" + fileName;
            System.out.println("Inserting form item in map " + key + " = " + fileLocation);
            hmUpload.put(key, fileLocation);
        }
    }

    public void writeUploadResponse(PhaseEvent event, HashMap hmUpload, FileUploadStatus status) {
        try {
            FacesContext context = event.getFacesContext();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            String compName = (String)hmUpload.get("componentName");
            String postProcessingMethod = (String)hmUpload.get(compName + "_" + "postProcessingMethod");
            if (postProcessingMethod != null) {
                try {
                    Class[] argTypes = new Class[]{PhaseEvent.class, HashMap.class, FileUploadStatus.class};
                    MethodExpression mex = context.getApplication().getExpressionFactory().createMethodExpression(context.getELContext(), postProcessingMethod, null, argTypes);
                    Object[] args = new Object[]{event, hmUpload, status};
                    mex.invoke(context.getELContext(), args);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.WARNING, "post.processing.exeception", e);
                }
            }
            if (!status.isCustomReturnEnabled()) {
                StringBuffer sb = new StringBuffer();
                response.setContentType("text/xml;charset=UTF-8");
                response.setHeader("Cache-Control", "no-cache");
                sb.append("<response>");
                sb.append("<message>");
                sb.append(status.getMessage());
                sb.append("</message>");
                sb.append("<status>");
                sb.append(status.getStatus());
                sb.append("</status>");
                sb.append("<duration>");
                sb.append(status.getUploadTime());
                sb.append("</duration>");
                sb.append("<duration_string>");
                sb.append(status.getUploadTimeString());
                sb.append("</duration_string>");
                sb.append("<start_date>");
                sb.append(status.getStartUploadDate());
                sb.append("</start_date>");
                sb.append("<end_date>");
                sb.append(status.getEndUploadDate());
                sb.append("</end_date>");
                sb.append("<upload_size>");
                sb.append(status.getTotalUploadSize());
                sb.append("</upload_size>");
                sb.append("</response>");
                response.getWriter().write(sb.toString());
            }
        }
        catch (IOException iox) {
            System.out.println("FileUploadPhaseListener error writting AJAX response : " + iox);
            this.getLogger().log(Level.SEVERE, "response.exeception", iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileItem item, File file, FileUploadStatus status) throws Exception {
        String itemName = item.getName();
        this.getLogger().log(Level.INFO, "uploaded.item", file.toString());
        this.updateSessionStatus(status, itemName, 0L);
        if (item.isInMemory()) {
            System.out.println("Getting fileItem from memory - " + itemName);
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(file);
                fout.write(item.get());
                this.updateSessionStatus(status, "", item.getSize());
            }
            finally {
                if (fout != null) {
                    fout.close();
                }
            }
        }
        System.out.println("Getting fileItem from stream - " + itemName);
        DiskFileItem dfItem = (DiskFileItem)item;
        File outputFile = dfItem.getStoreLocation();
        if (outputFile != null) {
            if (!outputFile.renameTo(file)) {
                BufferedInputStream in = null;
                FilterOutputStream out = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(outputFile));
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    int byteCnt = 0;
                    byte[] buffer = new byte[4096];
                    while ((byteCnt = in.read(buffer)) != -1) {
                        if (out == null || byteCnt <= 0) continue;
                        ((BufferedOutputStream)out).write(buffer, 0, byteCnt);
                        this.updateSessionStatus(status, itemName, byteCnt);
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        } else {
            throw new FileUploadException("Cannot write uploaded file to disk!");
        }
    }

    public void updateSessionStatus(FileUploadStatus status, String itemName, long incrementAmount) {
        status.setCurrentItem(itemName);
        status.incrementCurrentSizeWritten(incrementAmount);
    }

    public Logger getLogger() {
        if (this._logger == null) {
            this._logger = Logger.getLogger(FILE_UPLOAD_LOGGER, FILE_UPLOAD_LOG_STRINGS);
        }
        return this._logger;
    }
}

