/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.dev.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.dev.wizard.PortChooser;
import org.netbeans.modules.websvc.dev.wizard.WebServiceTypePanel;
import org.netbeans.modules.websvc.dev.wizard.WsdlServiceHandler;
import org.netbeans.modules.websvc.dev.wizard.nodes.WsdlNode;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperGenerator;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperHandler;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.SAXException;

public class WebServiceFromWSDLPanel
extends JPanel
implements HelpCtx.Provider,
DocumentListener {
    private final List listeners = new ArrayList();
    private static String previousDirectory = "";
    private final FileFilter WSDL_FILE_FILTER = new WsdlFileFilter();
    private boolean isWaitingForScan = false;
    private WsdlModeler wsdlModeler;
    private WsdlModel wsdlModel;
    private WsdlService service;
    private WsdlPort port;
    private WsdlServiceHandler wsdlServiceHandler;
    private Project project;
    private WizardDescriptor wizardDescriptor;
    private JAXWSSupport wss;
    private boolean jsr109Supported;
    private boolean jsr109oldSupported;
    private boolean jwsdpSupported;
    private boolean wsitSupported;
    private RequestProcessor.Task generateWsdlModelTask;
    private URL wsdlURL;
    private JButton jButtonBrowsePort;
    private JButton jButtonWSDLFileBrowse;
    private JLabel jLabelPort;
    private JLabel jLabelPortDescription;
    private JLabel jLabelWSDLFile;
    private JTextField jTextFieldPort;
    private JTextField jTextFieldWSDLFile;

    public WebServiceFromWSDLPanel(Project project) {
        this.project = project;
        this.initComponents();
        this.initJsr109Info();
        this.jTextFieldWSDLFile.getDocument().addDocumentListener(this);
        this.generateWsdlModelTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                WsdlWrapperHandler handler = null;
                try {
                    handler = WsdlWrapperGenerator.parse((String)WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                }
                catch (ParserConfigurationException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                catch (SAXException ex) {
                    String mes = NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_SAXException", (Object)ex.getLocalizedMessage());
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                if (handler != null && !handler.isServiceElement()) {
                    StreamSource source = new StreamSource(WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                    try {
                        File wsdlFile = new File(System.getProperty("java.io.tmpdir"), WsdlWrapperGenerator.getWrapperName((URL)WebServiceFromWSDLPanel.this.wsdlURL));
                        if (!wsdlFile.exists()) {
                            try {
                                wsdlFile.createNewFile();
                            }
                            catch (IOException ex) {
                                String mes = NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_UnableToCreateTempFile", (Object)wsdlFile.getPath());
                                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                                return;
                            }
                        }
                        WsdlWrapperGenerator.generateWrapperWSDLContent((File)wsdlFile, (StreamSource)source, (String)handler.getTargetNsPrefix(), (String)WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                        WebServiceFromWSDLPanel.this.wsdlURL = wsdlFile.toURL();
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
                final WsdlWrapperHandler wsdlHandler = handler;
                WebServiceFromWSDLPanel.this.wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(WebServiceFromWSDLPanel.this.wsdlURL);
                WebServiceFromWSDLPanel.this.wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                    public void modelCreated(WsdlModel model) {
                        WebServiceFromWSDLPanel.this.wsdlModel = model;
                        if (WebServiceFromWSDLPanel.this.wsdlModel == null) {
                            String serviceName = null;
                            String portName = null;
                            try {
                                WebServiceFromWSDLPanel.this.wsdlServiceHandler = WsdlServiceHandler.parse(WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                                serviceName = WebServiceFromWSDLPanel.this.wsdlServiceHandler.getServiceName();
                                portName = WebServiceFromWSDLPanel.this.wsdlServiceHandler.getPortName();
                            }
                            catch (ParserConfigurationException ex) {
                            }
                            catch (SAXException ex) {
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                            if (serviceName != null && portName != null) {
                                WebServiceFromWSDLPanel.this.jTextFieldPort.setText(serviceName + "#" + portName);
                            } else {
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"TXT_CannotGenerateService", (Object)WebServiceFromWSDLPanel.this.wsdlModeler.getCreationException().getLocalizedMessage()), 2));
                            }
                        } else {
                            WebServiceFromWSDLPanel.this.jButtonBrowsePort.setEnabled(true);
                            List services = WebServiceFromWSDLPanel.this.wsdlModel.getServices();
                            if (services != null && services.size() > 0) {
                                WebServiceFromWSDLPanel.this.service = (WsdlService)services.get(0);
                                List ports = WebServiceFromWSDLPanel.this.service.getPorts();
                                if (ports != null && ports.size() > 0) {
                                    WebServiceFromWSDLPanel.this.port = (WsdlPort)ports.get(0);
                                }
                            }
                        }
                        if (WebServiceFromWSDLPanel.this.service != null && WebServiceFromWSDLPanel.this.port != null) {
                            String bindingType;
                            WebServiceFromWSDLPanel.this.jTextFieldPort.setText(WebServiceFromWSDLPanel.this.service.getName() + "#" + WebServiceFromWSDLPanel.this.port.getName());
                            if (wsdlHandler != null && (bindingType = wsdlHandler.getBindingTypeForPort(WebServiceFromWSDLPanel.this.port.getName())) != null) {
                                WebServiceFromWSDLPanel.this.port.setSOAPVersion(bindingType);
                            }
                        }
                        WebServiceFromWSDLPanel.this.fireChange();
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.jLabelWSDLFile = new JLabel();
        this.jTextFieldWSDLFile = new JTextField();
        this.jButtonWSDLFileBrowse = new JButton();
        this.jLabelPortDescription = new JLabel();
        this.jLabelPort = new JLabel();
        this.jTextFieldPort = new JTextField();
        this.jButtonBrowsePort = new JButton();
        this.jLabelWSDLFile.setDisplayedMnemonic(NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("MNE_WSDL_File").charAt(0));
        this.jLabelWSDLFile.setLabelFor(this.jTextFieldWSDLFile);
        this.jLabelWSDLFile.setText(NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_WSDL_File"));
        this.jTextFieldWSDLFile.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("A11Y_WSDLFilePath"));
        this.jButtonWSDLFileBrowse.setMnemonic(NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("MNE_Browse").charAt(0));
        this.jButtonWSDLFileBrowse.setText(NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_Browse"));
        this.jButtonWSDLFileBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebServiceFromWSDLPanel.this.jButtonWSDLFileBrowseActionPerformed(evt);
            }
        });
        this.jButtonWSDLFileBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("A11Y_WSDLFileButton"));
        this.jLabelPortDescription.setText(NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("LBL_PortMessage"));
        this.jLabelPort.setDisplayedMnemonic(NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("MNE_WebServicePort").charAt(0));
        this.jLabelPort.setLabelFor(this.jTextFieldPort);
        this.jLabelPort.setText(NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("LBL_WebServicePort"));
        this.jTextFieldPort.setEditable(false);
        this.jTextFieldPort.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("A11Y"));
        this.jButtonBrowsePort.setMnemonic(NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("MNE_BrowsePort").charAt(0));
        this.jButtonBrowsePort.setText(NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("LBL_Browse"));
        this.jButtonBrowsePort.setEnabled(false);
        this.jButtonBrowsePort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebServiceFromWSDLPanel.this.jButtonBrowsePortActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelPort).add((Component)this.jLabelWSDLFile)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldPort, -1, 576, Short.MAX_VALUE).add((Component)this.jTextFieldWSDLFile, -1, 576, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonBrowsePort, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonWSDLFileBrowse, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelPortDescription).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelWSDLFile).add((Component)this.jButtonWSDLFileBrowse).add((Component)this.jTextFieldWSDLFile, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabelPortDescription).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelPort).add((Component)this.jButtonBrowsePort).add((Component)this.jTextFieldPort, -2, -1, -2)).addContainerGap(223, Short.MAX_VALUE)));
    }

    private void jButtonBrowsePortActionPerformed(ActionEvent evt) {
        WsdlNode root = new WsdlNode(this.wsdlModel);
        PortChooser chooser = new PortChooser((Node)root);
        final DialogDescriptor dd = new DialogDescriptor((Object)chooser, NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_SelectPortDescription"));
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue;
                if (evt.getPropertyName().equals("portChooser_isValid") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                    dd.setValid(((Boolean)newvalue).booleanValue());
                }
            }
        });
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result == DialogDescriptor.OK_OPTION && (Util.isJavaEE5orHigher((Project)this.project) || !this.jsr109Supported && !this.jsr109oldSupported || !this.jsr109Supported && this.jsr109oldSupported && this.jwsdpSupported || this.wsitSupported)) {
            this.jTextFieldPort.setText(chooser.getSelectedPortOwnerName() + "#" + chooser.getSelectedNodes()[0].getDisplayName());
            this.service = this.wsdlModel.getServiceByName(chooser.getSelectedPortOwnerName());
            this.port = this.service.getPortByName(chooser.getSelectedNodes()[0].getDisplayName());
        }
    }

    private void jButtonWSDLFileBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(previousDirectory);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(this.WSDL_FILE_FILTER);
        chooser.setFileFilter(this.WSDL_FILE_FILTER);
        if (chooser.showOpenDialog(this) == 0) {
            File wsdlFile = chooser.getSelectedFile();
            this.jTextFieldWSDLFile.setText(wsdlFile.getAbsolutePath());
            previousDirectory = wsdlFile.getPath();
        }
    }

    void validate(WizardDescriptor wizardDescriptor) {
    }

    private void initJsr109Info() {
        J2eePlatform j2eePlatform;
        Map properties;
        String serverInstance;
        this.wss = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
        if (this.wss != null && (serverInstance = (String)(properties = this.wss.getAntProjectHelper().getStandardPropertyEvaluator().getProperties()).get("j2ee.server.instance")) != null && (j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance)) != null) {
            this.jsr109Supported = j2eePlatform.isToolSupported("jsr109");
            this.jsr109oldSupported = j2eePlatform.isToolSupported("wscompile");
            this.jwsdpSupported = j2eePlatform.isToolSupported("jwsdp");
            this.wsitSupported = j2eePlatform.isToolSupported("wsit");
        }
    }

    private boolean checkNonJsr109Valid() {
        if (this.wss != null && (!this.jsr109Supported && !this.jsr109oldSupported || !this.jsr109Supported && this.jsr109oldSupported && this.jwsdpSupported) && Util.isSourceLevel14orLower((Project)this.project)) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceTypePanel.class, (String)"ERR_NeedProperSourceLevel"));
            return false;
        }
        return true;
    }

    private boolean projectHasEmbeddedSpaces() {
        FileObject projectDir = this.project.getProjectDirectory();
        File projectDirFile = FileUtil.toFile((FileObject)projectDir);
        String path = projectDirFile.getAbsolutePath();
        int index = path.indexOf(" ");
        return index != -1;
    }

    boolean isValid(WizardDescriptor wizardDescriptor) {
        if (!this.checkNonJsr109Valid()) {
            return false;
        }
        String wsdlFilePath = this.jTextFieldWSDLFile.getText().trim();
        if (wsdlFilePath == null || wsdlFilePath.length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_EnterWsdlName"));
            return false;
        }
        File f = new File(wsdlFilePath);
        String wsdlFileText = f.getAbsolutePath();
        if ((f = WebServiceFromWSDLPanel.getCanonicalFile(f)) == null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_WsdlInvalid"));
            return false;
        }
        if (!f.exists()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_WsdlDoesNotExist"));
            return false;
        }
        if (Util.isJavaEE5orHigher((Project)this.project) || !this.jsr109Supported && !this.jsr109oldSupported || !this.jsr109Supported && this.jsr109oldSupported && this.jwsdpSupported || this.wsitSupported) {
            if (this.wsdlModel != null) {
                if (this.service == null) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_NoService"));
                    return false;
                }
                if (this.port == null) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_NoPort"));
                    return false;
                }
            } else {
                if (this.wsdlServiceHandler != null && this.wsdlServiceHandler.getServiceName() != null && this.wsdlServiceHandler.getPortName() != null) {
                    return true;
                }
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_NoPort"));
                return false;
            }
        }
        if (this.projectHasEmbeddedSpaces()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_SPACE_IN_PROJECT_PATH"));
        } else {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        }
        if (JavaMetamodel.getManager().isScanInProgress()) {
            if (!this.isWaitingForScan) {
                this.isWaitingForScan = true;
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        JavaMetamodel.getManager().waitScanFinished();
                        WebServiceFromWSDLPanel.this.isWaitingForScan = false;
                        WebServiceFromWSDLPanel.this.fireChange();
                    }
                });
            }
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_ScanningInProgress"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    void store(WizardDescriptor d) {
        d.putProperty("wsdlFilePath", (Object)this.jTextFieldWSDLFile.getText().trim());
        d.putProperty("wsdlModel", (Object)this.wsdlModel);
        d.putProperty("wsdlModeler", (Object)this.wsdlModeler);
        d.putProperty("wsdlService", (Object)this.service);
        d.putProperty("wsdlPort", (Object)this.port);
        d.putProperty("wsdlServiceHandler", (Object)this.wsdlServiceHandler);
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WebServiceFromWSDLPanel.class);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(e);
        }
    }

    private void updatePortBrowseButton() {
        this.wsdlModel = null;
        this.service = null;
        this.port = null;
        this.jTextFieldPort.setText("");
        String wsdlFilePath = this.jTextFieldWSDLFile.getText().trim();
        if (wsdlFilePath == null || wsdlFilePath.length() == 0) {
            this.jButtonBrowsePort.setEnabled(false);
        } else {
            File f = new File(wsdlFilePath);
            String wsdlFileText = f.getAbsolutePath();
            if ((f = WebServiceFromWSDLPanel.getCanonicalFile(f)) == null) {
                this.jButtonBrowsePort.setEnabled(false);
            } else if (!f.exists()) {
                this.jButtonBrowsePort.setEnabled(false);
            } else {
                this.fireChange();
                if (Util.isJavaEE5orHigher((Project)this.project) || !this.jsr109Supported && !this.jsr109oldSupported || !this.jsr109Supported && this.jsr109oldSupported && this.jwsdpSupported || this.wsitSupported) {
                    this.createModel();
                }
            }
        }
    }

    private void createModel() {
        File normalizedWsdlFilePath = FileUtil.normalizeFile((File)new File(this.jTextFieldWSDLFile.getText().trim()));
        this.wsdlURL = null;
        try {
            this.wsdlURL = normalizedWsdlFilePath.toURL();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        this.generateWsdlModelTask.schedule(1000);
    }

    public void insertUpdate(DocumentEvent e) {
        this.updatePortBrowseButton();
        this.fireChange();
    }

    public void removeUpdate(DocumentEvent e) {
        this.updatePortBrowseButton();
        this.fireChange();
    }

    public void changedUpdate(DocumentEvent e) {
        this.updatePortBrowseButton();
        this.fireChange();
    }

    public static File getCanonicalFile(File f) {
        File f1;
        try {
            f1 = f.getCanonicalFile();
        }
        catch (IOException e) {
            f1 = null;
        }
        return f1;
    }

    private static class WsdlFileFilter
    extends FileFilter {
        private WsdlFileFilter() {
        }

        public boolean accept(File f) {
            boolean result = f.isDirectory() || "wsdl".equalsIgnoreCase(FileUtil.getExtension((String)f.getName()));
            return result;
        }

        public String getDescription() {
            return NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_WsdlFilterDescription");
        }
    }
}

