/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.dev.wizard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.dev.dd.gen.wscreation.Bean;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.IndentEngine;
import org.openide.util.RequestProcessor;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WSGenerationUtil {
    public static final String TEMPLATE_BASE = "/org/netbeans/modules/websvc/dev/wizard/xsl/";
    private String genDate;
    private String genAuthor;
    private Map templateCache = new HashMap();

    public static String getSelectedPackageName(FileObject targetFolder, Project p) {
        Sources sources = ProjectUtils.getSources((Project)p);
        SourceGroup[] groups = sources.getSourceGroups("java");
        String packageName = null;
        for (int i = 0; i < groups.length && packageName == null; ++i) {
            packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)targetFolder);
        }
        if (packageName != null) {
            packageName = packageName.replaceAll("/", ".");
        }
        return packageName + "";
    }

    public String getBeanClassName(String wsName) {
        return wsName + "Impl";
    }

    public String getSEIName(String wsName) {
        return wsName + "SEI";
    }

    public Bean getDefaultBean() {
        Bean b = new Bean();
        b.setCommentData(true);
        if (this.genDate == null) {
            this.genDate = DateFormat.getDateTimeInstance().format(new Date());
            this.genAuthor = System.getProperty("user.name");
        }
        b.setCommentDataAuthor(this.genAuthor);
        b.setCommentDataDate(this.genDate);
        return b;
    }

    public String getFullClassName(String pkg, String className) {
        return pkg == null || pkg.length() == 0 ? className : pkg + "." + className;
    }

    public String generateClass(String template, Bean genData, FileObject pkg, boolean open) throws IOException {
        String clsName = genData.getClassnameName();
        clsName = FileUtil.findFreeFileName((FileObject)pkg, (String)clsName, (String)"java");
        genData.setClassnameName(clsName);
        this.generateClass(template, pkg, clsName, this.getStreamSource(genData), open);
        return clsName;
    }

    public String generateClass(String template, FileObject pkg, String clsName, String inputXml, boolean open) throws IOException {
        clsName = FileUtil.findFreeFileName((FileObject)pkg, (String)clsName, (String)"java");
        this.generateClass(template, pkg, clsName, this.getStreamSource(inputXml), open);
        return clsName;
    }

    public FileObject generateWSDL(String template, String wsName, String soapBinding, String portTypeName, FileObject folder, String wsdlName, StreamSource source) throws IOException {
        return this.generateWSDL(template, wsName, soapBinding, portTypeName, folder, null, wsdlName, source);
    }

    public FileObject generateWSDL(String template, String wsName, String soapBinding, String portTypeName, FileObject folder, FileObject originalFolder, String wsdlName, StreamSource source) throws IOException {
        FileObject wsdlFile = folder.createData(FileUtil.findFreeFileName((FileObject)folder, (String)wsdlName, (String)"wsdl"), "wsdl");
        FileLock fl = null;
        OutputStream os = null;
        try {
            fl = wsdlFile.lock();
            os = new BufferedOutputStream(wsdlFile.getOutputStream(fl));
            Transformer transformer = this.getTransformer(template);
            transformer.setParameter("WSNAME", wsName);
            transformer.setParameter("SOAPBINDING", soapBinding);
            if (portTypeName == null) {
                FileObject fileObject = wsdlFile;
                return fileObject;
            }
            transformer.setParameter("PORTTYPENAME", portTypeName);
            transformer.transform(source, new StreamResult(os));
            os.close();
        }
        catch (TransformerConfigurationException tce) {
            IOException ioe = new IOException();
            ioe.initCause(tce);
            throw ioe;
        }
        catch (TransformerException te) {
            IOException ioe = new IOException();
            ioe.initCause(te);
            throw ioe;
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (fl != null) {
                fl.releaseLock();
            }
        }
        this.copyImportedSchemas(originalFolder, folder, wsdlFile);
        return wsdlFile;
    }

    public void generateClass(String template, FileObject pkg, String clsName, StreamSource source, boolean open) throws IOException {
        FileObject cFile = pkg.createData(clsName, "java");
        FileLock fl = null;
        OutputStream os = null;
        Writer w = null;
        try {
            fl = cFile.lock();
            os = new BufferedOutputStream(cFile.getOutputStream(fl));
            this.getTransformer(template).transform(source, new StreamResult(new OutputStreamWriter(os)));
            os.close();
            fl.releaseLock();
            DataObject dobj = DataObject.find((FileObject)cFile);
            final EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            StyledDocument d = ec.openDocument();
            try {
                String fullText = d.getText(0, d.getLength());
                IndentEngine javaIndent = IndentEngine.find((Document)d);
                StringWriter writer = new StringWriter(d.getLength());
                w = javaIndent.createWriter((Document)d, 0, (Writer)writer);
                w.write(fullText);
                w.close();
                d.remove(0, d.getLength());
                d.insertString(0, writer.getBuffer().toString(), null);
                ec.saveDocument();
            }
            catch (BadLocationException ble) {
                ErrorManager.getDefault().notify((Throwable)ble);
            }
            if (open) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        ec.open();
                    }
                }, 1000);
            }
        }
        catch (TransformerConfigurationException tce) {
            IOException ioe = new IOException();
            ioe.initCause(tce);
            throw ioe;
        }
        catch (TransformerException te) {
            IOException ioe = new IOException();
            ioe.initCause(te);
            throw ioe;
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (w != null) {
                w.close();
            }
            if (fl != null) {
                fl.releaseLock();
            }
        }
    }

    public String getBaseName(String fullClassName) {
        return fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
    }

    private Transformer getTransformer(String template) throws TransformerConfigurationException {
        Templates t = (Templates)this.templateCache.get(template);
        if (t != null) {
            return t.newTransformer();
        }
        BufferedInputStream is = new BufferedInputStream(this.getClass().getResourceAsStream(template));
        TransformerFactory transFactory = TransformerFactory.newInstance();
        transFactory.setURIResolver(new URIResolver(){

            public Source resolve(String href, String base) throws TransformerException {
                InputStream is = this.getClass().getResourceAsStream(WSGenerationUtil.TEMPLATE_BASE + href.substring(href.lastIndexOf(47) + 1));
                if (is == null) {
                    return null;
                }
                return new StreamSource(is);
            }
        });
        t = transFactory.newTemplates(new StreamSource(is));
        this.templateCache.put(template, t);
        return t.newTransformer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSource getStreamSource(Bean genData) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            genData.write(bos);
        }
        finally {
            bos.close();
        }
        return new StreamSource(new ByteArrayInputStream(bos.toByteArray()));
    }

    private StreamSource getStreamSource(String xml) throws IOException {
        StringReader sr = new StringReader(xml);
        return new StreamSource(sr);
    }

    static List getSchemaNames(FileObject fo, boolean fromWsdl) {
        List result = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            DefaultHandler handler = fromWsdl ? new WsdlImportsHandler() : new SchemaImportsHandler();
            saxParser.parse(new InputSource(fo.getInputStream()), handler);
            result = handler.getSchemaNames();
        }
        catch (ParserConfigurationException ex) {
        }
        catch (SAXException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private synchronized void copyImportedSchemas(FileObject resourceFolder, FileObject targetFolder, FileObject fo) throws IOException {
        List schemaNames = WSGenerationUtil.getSchemaNames(fo, "wsdl".equals(fo.getExt()));
        for (String schemaName : schemaNames) {
            FileObject schemaFile = resourceFolder.getFileObject(schemaName);
            if (schemaFile == null) continue;
            FileObject target = targetFolder.getFileObject(schemaFile.getName(), schemaFile.getExt());
            if (target != null) {
                target.delete();
            }
            FileObject copy = schemaFile.copy(targetFolder, schemaFile.getName(), schemaFile.getExt());
            this.copyImportedSchemas(resourceFolder, targetFolder, copy);
        }
    }

    private static class SchemaImportsHandler
    extends DefaultHandler
    implements ImportsHandler {
        private List schemaNames = new ArrayList();

        SchemaImportsHandler() {
        }

        public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
            String schemaLocation;
            if ("import".equals(localname) && (schemaLocation = attributes.getValue("schemaLocation")) != null && schemaLocation.indexOf("/") < 0 && schemaLocation.endsWith(".xsd")) {
                this.schemaNames.add(schemaLocation);
            }
        }

        public List getSchemaNames() {
            return this.schemaNames;
        }
    }

    private static class WsdlImportsHandler
    extends DefaultHandler
    implements ImportsHandler {
        private static final String W3C_WSDL_SCHEMA = "http://schemas.xmlsoap.org/wsdl";
        private static final String W3C_WSDL_SCHEMA_SLASH = "http://schemas.xmlsoap.org/wsdl/";
        private List schemaNames = new ArrayList();
        private boolean insideSchema;

        WsdlImportsHandler() {
        }

        public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
            String schemaLocation;
            if (W3C_WSDL_SCHEMA.equals(uri) || W3C_WSDL_SCHEMA_SLASH.equals(uri)) {
                String wsdlLocation;
                if ("types".equals(localname)) {
                    this.insideSchema = true;
                }
                if ("import".equals(localname) && (wsdlLocation = attributes.getValue("location")) != null && wsdlLocation.indexOf("/") < 0 && wsdlLocation.endsWith(".wsdl")) {
                    this.schemaNames.add(wsdlLocation);
                }
            }
            if (this.insideSchema && "import".equals(localname) && (schemaLocation = attributes.getValue("schemaLocation")) != null && schemaLocation.indexOf("/") < 0 && schemaLocation.endsWith(".xsd")) {
                this.schemaNames.add(schemaLocation);
            }
        }

        public void endElement(String uri, String localname, String qname) throws SAXException {
            if ((W3C_WSDL_SCHEMA.equals(uri) || W3C_WSDL_SCHEMA_SLASH.equals(uri)) && "types".equals(localname)) {
                this.insideSchema = false;
            }
        }

        public List getSchemaNames() {
            return this.schemaNames;
        }
    }

    private static interface ImportsHandler {
        public List getSchemaNames();
    }
}

