/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.Assignment;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Condition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.InfixExpression;
import org.netbeans.jmi.javamodel.Invocation;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NewArrayExpression;
import org.netbeans.jmi.javamodel.OperatorEnum;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrefixExpression;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.ReturnStatement;
import org.netbeans.jmi.javamodel.SwitchStatement;
import org.netbeans.jmi.javamodel.ThisExpression;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeClass;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.ErrorManager;

final class DeclarationInfo {
    private static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.java.hints");
    private static Map primitiveTypeWeights = new HashMap();

    DeclarationInfo() {
    }

    public static String getSimpleName(Type type) {
        if (type instanceof JavaClass) {
            JavaClass clazz = (JavaClass)type;
            String name = clazz.getSimpleName();
            ClassDefinition declaring = clazz.getDeclaringClass();
            String declaringName = DeclarationInfo.getSimpleName((Type)declaring);
            if (declaringName != null) {
                return declaringName + "." + name;
            }
            return name;
        }
        if (type instanceof Array) {
            return DeclarationInfo.getSimpleName(((Array)type).getType()) + "[]";
        }
        if (type != null) {
            return type.getName();
        }
        return null;
    }

    private static String getPackageName(ClassDefinition jcls) {
        return jcls.getResource().getPackageName();
    }

    private static void collectMethods(ClassDefinition clazz, MethodMatcher matcher, List l, Set visited) {
        String n = clazz.getName();
        if (visited.contains(n)) {
            return;
        }
        visited.add(n);
        Object[] f = clazz.getContents().toArray();
        for (int i = 0; i < f.length; ++i) {
            Method m;
            if (!(f[i] instanceof Method) || DeclarationInfo.containsMethod(l, m = (Method)f[i]) || !matcher.matches(m)) continue;
            l.add(m);
        }
        JavaClass supr = clazz.getSuperClass();
        if (supr != null) {
            DeclarationInfo.collectMethods((ClassDefinition)supr, matcher, l, visited);
        }
        List intfList = clazz.getInterfaces();
        JavaClass[] intf = intfList.toArray(new JavaClass[0]);
        for (int i = 0; i < intf.length; ++i) {
            DeclarationInfo.collectMethods((ClassDefinition)intf[i], matcher, l, visited);
        }
    }

    public static boolean isAssignableFrom(Type t1, Type t2) {
        if (t1 instanceof PrimitiveType && t2 instanceof PrimitiveType) {
            int n2w;
            String n1 = ((PrimitiveType)t1).getName();
            String n2 = ((PrimitiveType)t2).getName();
            if (n1.equals("void") || n2.equals("void")) {
                return false;
            }
            if (n1.equals(n2)) {
                return true;
            }
            if (n1.equals("boolean") || n2.equals("boolean")) {
                return false;
            }
            int n1w = (Integer)primitiveTypeWeights.get(n1);
            return n1w >= (n2w = ((Integer)primitiveTypeWeights.get(n2)).intValue());
        }
        if (t1 instanceof ClassDefinition && t2 instanceof ClassDefinition) {
            ClassDefinition d1 = (ClassDefinition)t1;
            ClassDefinition d2 = (ClassDefinition)t2;
            return d1.getName().equals(d2.getName()) || d2.isSubTypeOf(d1);
        }
        return false;
    }

    private static boolean containsMethod(List l, Method m) {
        Iterator it = l.iterator();
        while (it.hasNext()) {
            if (!m.signatureEquals((Method)it.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean isFeatureAccessibleFrom(Feature f, ClassDefinition clazz, Expression featureUser) {
        int featureModif = f.getModifiers();
        if ((1 & featureModif) != 0) {
            return true;
        }
        ClassDefinition featureClass = f.getDeclaringClass();
        if ((2 & featureModif) != 0) {
            return DeclarationInfo.isSameOrInnerClassOf(f.getDeclaringClass(), clazz);
        }
        if ((4 & featureModif) != 0 && (featureUser == null || featureUser instanceof ThisExpression)) {
            return DeclarationInfo.getPackageName(featureClass).equals(DeclarationInfo.getPackageName(clazz)) || clazz.isSubTypeOf(featureClass);
        }
        return DeclarationInfo.getPackageName(featureClass).equals(DeclarationInfo.getPackageName(clazz));
    }

    public static boolean isSameOrInnerClassOf(ClassDefinition inner, ClassDefinition clazz) {
        ClassDefinition current = inner;
        while (inner != null) {
            if (inner.getName().equals(clazz.getName())) {
                return true;
            }
            if (inner instanceof JavaClass) {
                inner = ((JavaClass)inner).getDeclaringClass();
                continue;
            }
            inner = null;
        }
        return false;
    }

    public static ClassDefinition getContainingClass(Element element) {
        Element o = element;
        while (o != null && o instanceof RefObject && !(o instanceof ClassDefinition)) {
            o = ((RefObject)o).refImmediateComposite();
        }
        return o instanceof ClassDefinition ? (ClassDefinition)o : null;
    }

    public static Method getMethodByNameAndParamTypeNames(ClassDefinition def, String name, String[] paramTypeNames) {
        Feature[] f = def.getFeatures().toArray(new Feature[0]);
        for (int i = 0; i < f.length; ++i) {
            List paramList;
            Method m;
            if (!(f[i] instanceof Method) || !(m = (Method)f[i]).getName().equals(name) || (paramList = m.getParameters()).size() != paramTypeNames.length) continue;
            Parameter[] p = m.getParameters().toArray(new Parameter[0]);
            for (int j = 0; j < p.length; ++j) {
                if (p[j].getType().getName().equals(paramTypeNames[j])) continue;
            }
            return m;
        }
        return null;
    }

    public static List getMethodsByNameAndParamCount(ClassDefinition def, String name, int paramCount) {
        ArrayList l = new ArrayList();
        HashSet visited = new HashSet();
        DeclarationInfo.collectMethods(def, new MethodNameAndParamCountMatcher(name, paramCount), l, visited);
        return l;
    }

    public static List getConstructorsByParamCount(ClassDefinition def, int paramCount) {
        Feature[] f = def.getFeatures().toArray(new Feature[0]);
        ArrayList<Constructor> matches = new ArrayList<Constructor>();
        for (int i = 0; i < f.length; ++i) {
            Constructor c;
            Feature feat = f[i];
            if (!(feat instanceof Constructor) || (c = (Constructor)feat).getParameters().size() != paramCount) continue;
            matches.add(c);
        }
        return matches;
    }

    public static List getAbstractMethods(ClassDefinition def) {
        HashSet visitedClasses = new HashSet();
        ArrayList abstractMethods = new ArrayList();
        ArrayList visitedMethods = new ArrayList();
        DeclarationInfo.collectMethods(def, new AbstractMethodMatcher(visitedMethods), abstractMethods, visitedClasses);
        return abstractMethods;
    }

    protected static Type computeType(Element symbol) {
        Type t;
        Element previousElement;
        Element element = symbol;
        Object typedEl = null;
        do {
            previousElement = element;
        } while ((element = (Element)element.refImmediateComposite()) != null && !(element instanceof Assignment) && !(element instanceof LocalVariable) && !(element instanceof Field) && !(element instanceof ReturnStatement) && !(element instanceof Invocation) && !(element instanceof InfixExpression) && !(element instanceof PrefixExpression) && !(element instanceof SwitchStatement) && !(element instanceof Condition) && !(element instanceof NewArrayExpression));
        if (element instanceof ReturnStatement) {
            Feature f = JavaModelUtil.getDeclaringFeature((Element)element);
            typedEl = (Method)f;
        } else if (element instanceof Assignment) {
            Assignment assign = (Assignment)element;
            Expression rightSide = assign.getRightSide();
            PrimaryExpression leftSide = assign.getLeftSide();
            typedEl = previousElement.equals(rightSide) ? leftSide : rightSide;
        } else if (element instanceof Variable) {
            typedEl = (Variable)element;
        } else if (element instanceof Invocation) {
            List parameters;
            Invocation inv = (Invocation)element;
            CallableFeature callFeature = (CallableFeature)inv.getElement();
            int parIndex = inv.getParameters().indexOf(previousElement);
            if (callFeature != null && parIndex >= 0 && (parameters = callFeature.getParameters()).size() > parIndex) {
                typedEl = (Parameter)parameters.get(parIndex);
            }
        } else if (element instanceof InfixExpression) {
            InfixExpression expr = (InfixExpression)element;
            Expression rightSide = expr.getRightSide();
            Expression leftSide = expr.getLeftSide();
            typedEl = previousElement.equals(rightSide) ? leftSide : rightSide;
        } else {
            if (element instanceof PrefixExpression) {
                TypeClass typeClass = ((JavaModelPackage)element.refImmediatePackage()).getType();
                PrefixExpression expr = (PrefixExpression)element;
                if (OperatorEnum.NOT.equals((Object)expr.getOperator())) {
                    return typeClass.resolve("boolean");
                }
                return typeClass.resolve("int");
            }
            if (element instanceof SwitchStatement) {
                SwitchStatement swtch = (SwitchStatement)element;
                typedEl = swtch.getExpression();
            } else if (element instanceof Condition) {
                Condition cond = (Condition)element;
                if (cond.getExpression().equals(previousElement)) {
                    TypeClass typeClass = ((JavaModelPackage)element.refImmediatePackage()).getType();
                    return typeClass.resolve("boolean");
                }
            } else if (element instanceof NewArrayExpression) {
                TypeClass typeClass = ((JavaModelPackage)element.refImmediatePackage()).getType();
                return typeClass.resolve("int");
            }
        }
        if (typedEl != null && (t = typedEl.getType()) != null) {
            return t;
        }
        return DeclarationInfo.comupteDefaultType(symbol);
    }

    private static Type comupteDefaultType(Element symbol) {
        TypeClass typeClass = ((JavaModelPackage)symbol.refImmediatePackage()).getType();
        String typeString = symbol instanceof Invocation ? "void" : "java.lang.Object";
        return typeClass.resolve(typeString);
    }

    static boolean canbeCastTo(Type fromType, Type toType) {
        if (toType instanceof PrimitiveType && fromType instanceof PrimitiveType) {
            return true;
        }
        if (toType instanceof Array && fromType instanceof Array) {
            Array toArray = (Array)toType;
            Array fromArray = (Array)fromType;
            return DeclarationInfo.canbeCastTo(fromArray.getType(), toArray.getType());
        }
        if (toType instanceof ClassDefinition && fromType instanceof ClassDefinition) {
            ClassDefinition toClass = (ClassDefinition)toType;
            ClassDefinition fromClass = (ClassDefinition)fromType;
            if (fromClass instanceof TypeParameter) {
                ArrayList<JavaClass> classes = new ArrayList<JavaClass>(1);
                classes.add(fromClass.getSuperClass());
                classes.addAll(fromClass.getInterfaces());
                Iterator clIt = classes.iterator();
                while (clIt.hasNext()) {
                    if (!DeclarationInfo.canbeCastTo((Type)((JavaClass)clIt.next()), (Type)toClass)) continue;
                    return true;
                }
                return false;
            }
            if (toClass.isSubTypeOf(fromClass)) {
                return true;
            }
        }
        return false;
    }

    static {
        primitiveTypeWeights.put("byte", new Integer(0));
        primitiveTypeWeights.put("char", new Integer(1));
        primitiveTypeWeights.put("short", new Integer(2));
        primitiveTypeWeights.put("int", new Integer(3));
        primitiveTypeWeights.put("long", new Integer(4));
        primitiveTypeWeights.put("float", new Integer(5));
        primitiveTypeWeights.put("double", new Integer(6));
    }

    private static class ReturnTypeMatcher
    implements MethodMatcher {
        Type returnType;

        ReturnTypeMatcher(Type returnType) {
            this.returnType = returnType;
        }

        public boolean matches(Method m) {
            ClassDefinition cdActMethodType;
            ClassDefinition cdSearchedMethodType;
            Type actMethodType = m.getType();
            boolean matches = false;
            if (actMethodType instanceof PrimitiveType && this.returnType instanceof PrimitiveType) {
                String pActMethodType = ((PrimitiveType)actMethodType).getName();
                String pSearchedMethodType = ((PrimitiveType)this.returnType).getName();
                if (pSearchedMethodType.equals("boolean") && pActMethodType.equals("boolean")) {
                    return true;
                }
                if (!(pActMethodType.equals("void") || pActMethodType.equals("boolean") || pSearchedMethodType.equals("boolean"))) {
                    int actWeight = (Integer)primitiveTypeWeights.get(pActMethodType);
                    int searchedWeight = (Integer)primitiveTypeWeights.get(pSearchedMethodType);
                    if (searchedWeight >= actWeight) {
                        return true;
                    }
                }
            } else if (actMethodType instanceof ClassDefinition && this.returnType instanceof ClassDefinition && DeclarationInfo.isAssignableFrom((Type)(cdSearchedMethodType = (ClassDefinition)this.returnType), (Type)(cdActMethodType = (ClassDefinition)actMethodType))) {
                return true;
            }
            return false;
        }
    }

    private static class AbstractMethodMatcher
    implements MethodMatcher {
        List checkedMethods;

        AbstractMethodMatcher(List checkedMethods) {
            this.checkedMethods = checkedMethods;
        }

        public boolean matches(Method m) {
            boolean abstr = Modifier.isAbstract(m.getModifiers());
            if (abstr && DeclarationInfo.containsMethod(this.checkedMethods, m)) {
                abstr = false;
            }
            this.checkedMethods.add(m);
            return abstr;
        }
    }

    private static class MethodNameAndParamCountMatcher
    implements MethodMatcher {
        String name;
        int paramCount;

        MethodNameAndParamCountMatcher(String name, int paramCount) {
            this.name = name;
            this.paramCount = paramCount;
        }

        public boolean matches(Method m) {
            return m.getName().equals(this.name) && m.getParameters().size() == this.paramCount;
        }
    }

    private static interface MethodMatcher {
        public boolean matches(Method var1);
    }
}

