/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.j2seproject.ui.wizards.FolderList;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelConfigureProjectVisual;
import org.netbeans.modules.java.j2seproject.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PanelSourceFolders
extends SettingsPanel
implements PropertyChangeListener {
    private Panel firer;
    private WizardDescriptor wizardDescriptor;
    public static final String INITIAL_SOURCE_ROOT = "EXISTING_SOURCES_CURRENT_DIRECTORY";
    private JLabel jLabel3;
    private JPanel sourcePanel;
    private JPanel testsPanel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PanelSourceFolders(Panel panel) {
        this.firer = panel;
        this.initComponents();
        this.setName(NbBundle.getMessage((Class)PanelConfigureProjectVisual.class, (String)"LAB_ConfigureSourceRoots"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"TXT_JavaExtSourcesProjectLocation"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_PanelSourceFolders"));
        this.sourcePanel.addPropertyChangeListener(this);
        this.testsPanel.addPropertyChangeListener(this);
        ((FolderList)this.sourcePanel).setRelatedFolderList((FolderList)this.testsPanel);
        ((FolderList)this.testsPanel).setRelatedFolderList((FolderList)this.sourcePanel);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("files".equals(evt.getPropertyName())) {
            this.dataChanged();
        } else if ("lastUsedDir".equals(evt.getPropertyName())) {
            if (evt.getSource() == this.sourcePanel) {
                ((FolderList)this.testsPanel).setLastUsedDir((File)evt.getNewValue());
            } else if (evt.getSource() == this.testsPanel) {
                ((FolderList)this.sourcePanel).setLastUsedDir((File)evt.getNewValue());
            }
        }
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    void read(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        File projectLocation = (File)settings.getProperty("projdir");
        ((FolderList)this.sourcePanel).setProjectFolder(projectLocation);
        ((FolderList)this.testsPanel).setProjectFolder(projectLocation);
        File[] srcRoot = (File[])settings.getProperty("sourceRoot");
        if (!$assertionsDisabled && srcRoot == null) {
            throw new AssertionError((Object)"sourceRoot property must be initialized!");
        }
        ((FolderList)this.sourcePanel).setFiles(srcRoot);
        File[] testRoot = (File[])settings.getProperty("testRoot");
        if (!$assertionsDisabled && testRoot == null) {
            throw new AssertionError((Object)"testRoot property must be initialized!");
        }
        ((FolderList)this.testsPanel).setFiles(testRoot);
        File currentDirectory = null;
        FileObject folder = Templates.getExistingSourcesFolder((WizardDescriptor)this.wizardDescriptor);
        if (folder != null) {
            currentDirectory = FileUtil.toFile((FileObject)folder);
        }
        if (currentDirectory != null && currentDirectory.isDirectory()) {
            ((FolderList)this.sourcePanel).setLastUsedDir(currentDirectory);
            ((FolderList)this.testsPanel).setLastUsedDir(currentDirectory);
        }
    }

    void store(WizardDescriptor settings) {
        File[] sourceRoots = ((FolderList)this.sourcePanel).getFiles();
        File[] testRoots = ((FolderList)this.testsPanel).getFiles();
        settings.putProperty("sourceRoot", (Object)sourceRoots);
        settings.putProperty("testRoot", (Object)testRoots);
    }

    boolean valid(WizardDescriptor settings) {
        File[] testRoots;
        File[] sourceRoots;
        File projectLocation = (File)settings.getProperty("projdir");
        String result = PanelSourceFolders.checkValidity(projectLocation, sourceRoots = ((FolderList)this.sourcePanel).getFiles(), testRoots = ((FolderList)this.testsPanel).getFiles());
        if (result == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)result);
        return false;
    }

    static String checkValidity(File projectLocation, File[] sources, File[] tests) {
        int i;
        String ploc = projectLocation.getAbsolutePath();
        for (i = 0; i < sources.length; ++i) {
            if (!sources[i].isDirectory() || !sources[i].canRead()) {
                return MessageFormat.format(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_IllegalSources"), sources[i].getAbsolutePath());
            }
            String sloc = sources[i].getAbsolutePath();
            if (!ploc.equals(sloc) && !ploc.startsWith(sloc + File.separatorChar)) continue;
            return NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        for (i = 0; i < tests.length; ++i) {
            if (!tests[i].isDirectory() || !tests[i].canRead()) {
                return MessageFormat.format(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_IllegalTests"), sources[i].getAbsolutePath());
            }
            String tloc = tests[i].getAbsolutePath();
            if (!ploc.equals(tloc) && !ploc.startsWith(tloc + File.separatorChar)) continue;
            return NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        return null;
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
        this.searchClassFiles(((FolderList)this.sourcePanel).getFiles());
    }

    private void searchClassFiles(File[] folders) throws WizardValidationException {
        boolean found = false;
        for (int i = 0; i < folders.length; ++i) {
            FileObject folder = FileUtil.toFileObject((File)folders[i]);
            if (folder == null) continue;
            Enumeration en = folder.getData(true);
            while (!found && en.hasMoreElements()) {
                Object obj = en.nextElement();
                if (!$assertionsDisabled && !(obj instanceof FileObject)) {
                    throw new AssertionError((Object)("Instance of FileObject: " + obj));
                }
                FileObject fo = (FileObject)obj;
                found = "class".equals(fo.getExt()) && !fo.isVirtual();
            }
        }
        if (found) {
            JButton DELETE_OPTION = new JButton(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"TXT_DeleteOption"));
            JButton KEEP_OPTION = new JButton(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"TXT_KeepOption"));
            JButton CANCEL_OPTION = new JButton(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"TXT_CancelOption"));
            KEEP_OPTION.setMnemonic(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MNE_KeepOption").charAt(0));
            DELETE_OPTION.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_DeleteOption"));
            KEEP_OPTION.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_KeepOption"));
            CANCEL_OPTION.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_CancelOption"));
            NotifyDescriptor desc = new NotifyDescriptor((Object)NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_FoundClassFiles"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_FoundClassFiles_Title"), 1, 3, new Object[]{DELETE_OPTION, KEEP_OPTION, CANCEL_OPTION}, (Object)DELETE_OPTION);
            Object result = DialogDisplayer.getDefault().notify(desc);
            if (DELETE_OPTION.equals(result)) {
                this.deleteClassFiles(folders);
            } else if (!KEEP_OPTION.equals(result)) {
                throw new WizardValidationException((JComponent)this.sourcePanel, "", "");
            }
        }
    }

    private void deleteClassFiles(File[] folders) {
        for (int i = 0; i < folders.length; ++i) {
            FileObject folder = FileUtil.toFileObject((File)folders[i]);
            Enumeration en = folder.getData(true);
            while (en.hasMoreElements()) {
                Object obj = en.nextElement();
                if (!$assertionsDisabled && !(obj instanceof FileObject)) {
                    throw new AssertionError((Object)("Instance of FileObject: " + obj));
                }
                FileObject fo = (FileObject)obj;
                try {
                    if (!"class".equals(fo.getExt())) continue;
                    fo.delete();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.sourcePanel = new FolderList(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"CTL_SourceRoots"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MNE_SourceRoots").charAt(0), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_SourceRoots"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"CTL_AddSourceRoot"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MNE_AddSourceFolder").charAt(0), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_AddSourceFolder"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MNE_RemoveSourceFolder").charAt(0), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_RemoveSourceFolder"));
        this.testsPanel = new FolderList(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"CTL_TestRoots"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MNE_TestRoots").charAt(0), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_TestRoots"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"CTL_AddTestRoot"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MNE_AddTestFolder").charAt(0), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_AddTestFolder"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MNE_RemoveTestFolder").charAt(0), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_RemoveTestFolder"));
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"ACSD_PanelSourceFolders"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"LBL_SourceDirectoriesLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)PanelSourceFolders.class).getString("ACSN_jLabel3"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)PanelSourceFolders.class).getString("ACSD_jLabel3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.sourcePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.testsPanel, gridBagConstraints);
    }

    static {
        $assertionsDisabled = !PanelSourceFolders.class.desiredAssertionStatus();
    }

    static class Panel
    implements WizardDescriptor.ValidatingPanel {
        private ArrayList listeners;
        private PanelSourceFolders component;
        private WizardDescriptor settings;

        Panel() {
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(l);
        }

        public void addChangeListener(ChangeListener l) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(l);
        }

        public void readSettings(Object settings) {
            this.settings = (WizardDescriptor)settings;
            this.component.read(this.settings);
            Object substitute = this.component.getClientProperty("NewProjectWizard_Title");
            if (substitute != null) {
                this.settings.putProperty("NewProjectWizard_Title", substitute);
            }
        }

        public void storeSettings(Object settings) {
            this.component.store(this.settings);
        }

        public void validate() throws WizardValidationException {
            this.component.validate(this.settings);
        }

        public boolean isValid() {
            return this.component.valid(this.settings);
        }

        public synchronized Component getComponent() {
            if (this.component == null) {
                this.component = new PanelSourceFolders(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders == null ? (class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders = PanelSourceFolders.class$("org.netbeans.modules.java.j2seproject.ui.wizards.PanelSourceFolders")) : class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChangeEvent() {
            Iterator it = null;
            Panel panel = this;
            synchronized (panel) {
                if (this.listeners == null) {
                    return;
                }
                it = ((ArrayList)this.listeners.clone()).iterator();
            }
            ChangeEvent event = new ChangeEvent(this);
            while (it.hasNext()) {
                ((ChangeListener)it.next()).stateChanged(event);
            }
        }
    }
}

