/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.sax;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.Encoder;
import com.sun.xml.fastinfoset.EncodingConstants;
import com.sun.xml.fastinfoset.QualifiedName;
import com.sun.xml.fastinfoset.util.LocalNameQualifiedNamesMap;
import java.io.IOException;
import org.jvnet.fastinfoset.FastInfosetException;
import org.jvnet.fastinfoset.sax.EncodingAlgorithmAttributes;
import org.jvnet.fastinfoset.sax.FastInfosetWriter;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXDocumentSerializer
extends Encoder
implements FastInfosetWriter {
    protected boolean _elementHasNamespaces = false;
    protected boolean _charactersAsCDATA = false;

    public final void endCDATA() throws SAXException {
        this._charactersAsCDATA = false;
    }

    public final void endDTD() throws SAXException {
    }

    public final void endDocument() throws SAXException {
        try {
            this.encodeDocumentTermination();
        }
        catch (IOException e) {
            throw new SAXException("endDocument", e);
        }
    }

    public void reset() {
        super.reset();
        this._elementHasNamespaces = false;
        this._charactersAsCDATA = false;
    }

    public final void startCDATA() throws SAXException {
        this._charactersAsCDATA = true;
    }

    public final void startDocument() throws SAXException {
        try {
            this.reset();
            this.encodeHeader(false);
            this.encodeInitialVocabulary();
        }
        catch (IOException e) {
            throw new SAXException("startDocument", e);
        }
    }

    public final void bytes(byte[] b, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIOctetAlgorithmData(1, b, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            if (!this._charactersAsCDATA) {
                this.encodeCharacters(ch, start, length);
            } else {
                this.encodeCIIBuiltInAlgorithmDataAsCDATA(ch, start, length);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (FastInfosetException e) {
            throw new SAXException(e);
        }
    }

    public final void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.encodeTermination();
            this.encodeComment(ch, start, length);
        }
        catch (IOException e) {
            throw new SAXException("startElement", e);
        }
    }

    public void dateTimeCharacters(char[] ch, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeFourBitCharacters(1, EncodingConstants.DATE_TIME_CHARACTERS_TABLE, ch, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (FastInfosetException e) {
            throw new SAXException(e);
        }
    }

    public final void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public void numericCharacters(char[] ch, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeFourBitCharacters(0, EncodingConstants.NUMERIC_CHARACTERS_TABLE, ch, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (FastInfosetException e) {
            throw new SAXException(e);
        }
    }

    public final void doubles(double[] d, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(7, d, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (FastInfosetException e) {
            throw new SAXException(e);
        }
    }

    public final void floats(float[] f, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(6, f, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (FastInfosetException e) {
            throw new SAXException(e);
        }
    }

    public final void ints(int[] i, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(3, i, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (FastInfosetException e) {
            throw new SAXException(e);
        }
    }

    public final void longs(long[] l, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(4, l, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (FastInfosetException e) {
            throw new SAXException(e);
        }
    }

    public void uuids(long[] msblsb, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(8, msblsb, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (FastInfosetException e) {
            throw new SAXException(e);
        }
    }

    public final void shorts(short[] s, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(2, s, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (FastInfosetException e) {
            throw new SAXException(e);
        }
    }

    public final void booleans(boolean[] b, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(5, b, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (FastInfosetException e) {
            throw new SAXException(e);
        }
    }

    public final void endEntity(String name) throws SAXException {
    }

    public final void skippedEntity(String name) throws SAXException {
    }

    public final void startEntity(String name) throws SAXException {
    }

    public final void octets(String URI2, int id, byte[] b, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeNonIdentifyingStringOnThirdBit(URI2, id, b, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (FastInfosetException e) {
            throw new SAXException(e);
        }
    }

    public void alphabetCharacters(String alphabet, char[] ch, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeAlphabetCharacters(alphabet, ch, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (FastInfosetException e) {
            throw new SAXException(e);
        }
    }

    public final int countAttributes(Attributes atts) {
        int count = 0;
        int i = 0;
        while (i < atts.getLength()) {
            String uri = atts.getURI(i);
            if (uri != "http://www.w3.org/2000/xmlns/" && !uri.equals("http://www.w3.org/2000/xmlns/")) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public final void setDocumentLocator(Locator locator) {
    }

    public final void object(String URI2, int id, Object data) throws SAXException {
        try {
            this.encodeTermination();
            this.encodeNonIdentifyingStringOnThirdBit(URI2, id, data);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (FastInfosetException e) {
            throw new SAXException(e);
        }
    }

    public final void processingInstruction(String target, String data) throws SAXException {
        try {
            if (target == "") {
                throw new SAXException(CommonResourceBundle.getInstance().getString("message.processingInstructionTargetIsEmpty"));
            }
            this.encodeTermination();
            this.encodeProcessingInstruction(target, data);
        }
        catch (IOException e) {
            throw new SAXException("processingInstruction", e);
        }
    }

    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            if (!this._elementHasNamespaces) {
                this.encodeTermination();
                this.mark();
                this._elementHasNamespaces = true;
                this.write(56);
            }
            this.encodeNamespaceAttribute(prefix, uri);
        }
        catch (IOException e) {
            throw new SAXException("startElement", e);
        }
    }

    protected final void encodeElement(String namespaceURI, String qName, String localName) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.elementName.obtainEntry(qName);
        if (entry._valueIndex > 0) {
            QualifiedName[] names = entry._value;
            int i = 0;
            while (i < entry._valueIndex) {
                if (namespaceURI == names[i].namespaceName || namespaceURI.equals(names[i].namespaceName)) {
                    this.encodeNonZeroIntegerOnThirdBit(names[i].index);
                    return;
                }
                ++i;
            }
        }
        this.encodeLiteralElementQualifiedNameOnThirdBit(namespaceURI, Encoder.getPrefixFromQualifiedName(qName), localName, entry);
    }

    public final void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            this.encodeElementTermination();
        }
        catch (IOException e) {
            throw new SAXException("startElement", e);
        }
    }

    public final void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    protected final boolean encodeAttribute(String namespaceURI, String qName, String localName) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.attributeName.obtainEntry(qName);
        if (entry._valueIndex > 0) {
            QualifiedName[] names = entry._value;
            int i = 0;
            while (i < entry._valueIndex) {
                if (namespaceURI == names[i].namespaceName || namespaceURI.equals(names[i].namespaceName)) {
                    this.encodeNonZeroIntegerOnSecondBitFirstBitZero(names[i].index);
                    return true;
                }
                ++i;
            }
        }
        return this.encodeLiteralAttributeQualifiedNameOnSecondBit(namespaceURI, Encoder.getPrefixFromQualifiedName(qName), localName, entry);
    }

    public final void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        block15: {
            int attributeCount = atts.getLength() > 0 ? this.countAttributes(atts) : 0;
            try {
                if (this._elementHasNamespaces) {
                    this._elementHasNamespaces = false;
                    if (attributeCount > 0) {
                        int n = this._markIndex;
                        this._octetBuffer[n] = (byte)(this._octetBuffer[n] | 0x40);
                    }
                    this.resetMark();
                    this.write(240);
                    this._b = 0;
                } else {
                    this.encodeTermination();
                    this._b = 0;
                    if (attributeCount > 0) {
                        this._b |= 0x40;
                    }
                }
                this.encodeElement(namespaceURI, qName, localName);
                if (attributeCount <= 0) break block15;
                if (atts instanceof EncodingAlgorithmAttributes) {
                    EncodingAlgorithmAttributes eAtts = (EncodingAlgorithmAttributes)atts;
                    int i = 0;
                    while (i < eAtts.getLength()) {
                        if (this.encodeAttribute(atts.getURI(i), atts.getQName(i), atts.getLocalName(i))) {
                            String value = eAtts.getValue(i);
                            if (value != null) {
                                boolean addToTable = value.length() < this._v.attributeValueSizeConstraint;
                                this.encodeNonIdentifyingStringOnFirstBit(value, this._v.attributeValue, addToTable);
                            } else {
                                this.encodeNonIdentifyingStringOnFirstBit(eAtts.getAlgorithmURI(i), eAtts.getAlgorithmIndex(i), eAtts.getAlgorithmData(i));
                            }
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < atts.getLength()) {
                        if (this.encodeAttribute(atts.getURI(i), atts.getQName(i), atts.getLocalName(i))) {
                            String value = atts.getValue(i);
                            boolean addToTable = value.length() < this._v.attributeValueSizeConstraint;
                            this.encodeNonIdentifyingStringOnFirstBit(value, this._v.attributeValue, addToTable);
                        }
                        ++i;
                    }
                }
                this._b = 240;
                this._terminate = true;
            }
            catch (IOException e) {
                throw new SAXException("startElement", e);
            }
            catch (FastInfosetException e) {
                throw new SAXException("startElement", e);
            }
        }
    }
}

