/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.modules.editor.options.ColoringBean;
import org.netbeans.modules.editor.options.ColoringEditor;
import org.netbeans.modules.editor.options.OptionSupport;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ColoringArrayEditorPanel
extends JPanel {
    PropertyModel coloringModel;
    int actValueIndex = 0;
    int newValueIndex;
    private String typeName = "base";
    private String[] names;
    private HashMap value = new HashMap();
    private JPanel masterPanel;
    private JLabel syntaxLabel;
    private JScrollPane syntaxScroll;
    private JList syntaxList;
    private JPanel detailPanel;

    public ColoringArrayEditorPanel() {
        this.names = new String[]{"default"};
        this.value.put(this.names[0], new Coloring(Font.decode(null), Color.red, Color.blue));
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_CAEP_Panel"));
        this.syntaxLabel.setDisplayedMnemonic(this.getBundleString("CAEP_SyntaxLabel_Mnemonic").charAt(0));
        this.syntaxList.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_CAEP_Syntax"));
        this.coloringModel = new PropertyModelSupport(ColoringBean.class, ColoringEditor.class);
        this.coloringModel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                block3: {
                    try {
                        Coloring newColoring = ((ColoringBean)ColoringArrayEditorPanel.this.coloringModel.getValue()).coloring;
                        if (!newColoring.equals(ColoringArrayEditorPanel.this.value.get(ColoringArrayEditorPanel.this.names[ColoringArrayEditorPanel.this.actValueIndex]))) {
                            ColoringArrayEditorPanel.this.value = (HashMap)ColoringArrayEditorPanel.this.value.clone();
                            ColoringArrayEditorPanel.this.value.put(ColoringArrayEditorPanel.this.names[ColoringArrayEditorPanel.this.actValueIndex], newColoring);
                            ColoringArrayEditorPanel.this.actValueIndex = ColoringArrayEditorPanel.this.newValueIndex;
                            ColoringArrayEditorPanel.this.firePropertyChange("value", null, null);
                        }
                    }
                    catch (InvocationTargetException e) {
                        if (!Boolean.getBoolean("org.netbeans.exceptions")) break block3;
                        e.printStackTrace();
                    }
                }
            }
        });
        this.syntaxList.setSelectedIndex(this.actValueIndex);
        PropertyPanel editorPanel = new PropertyPanel(this.coloringModel, 2);
        this.detailPanel.add((Component)editorPanel, "Center");
    }

    private String getBundleString(String s) {
        return NbBundle.getMessage((Class)ColoringArrayEditorPanel.class, (String)s);
    }

    public HashMap getValue() {
        return this.value;
    }

    public void setValue(HashMap map) {
        boolean removed;
        if (map == null) {
            return;
        }
        int oldIndex = this.actValueIndex;
        this.value = map;
        try {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> kitClass = Class.forName((String)map.get(null), true, l);
            this.typeName = OptionSupport.getTypeName(kitClass);
        }
        catch (ClassNotFoundException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return;
        }
        Set keySet = map.keySet();
        HashMap<String, String> tempMap = new HashMap<String, String>(keySet.size() - 1);
        String[] names = new String[keySet.size() - 1];
        Iterator iter = keySet.iterator();
        String defaultName = null;
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (name == null) continue;
            String visualName = LocaleSupport.getString((String)("NAME_coloring_" + name));
            if (visualName == null) {
                visualName = LocaleSupport.getString((String)("NAME_coloring_base-" + name), (String)name);
            }
            if (name == "default") {
                defaultName = visualName;
            }
            tempMap.put(visualName, name);
        }
        ArrayList visualNamesList = new ArrayList(tempMap.keySet());
        Collections.sort(visualNamesList);
        if (defaultName != null && (removed = visualNamesList.remove(defaultName))) {
            visualNamesList.add(0, defaultName);
        }
        for (int i = 0; i < visualNamesList.size(); ++i) {
            names[i] = (String)tempMap.get(visualNamesList.get(i));
        }
        this.names = names;
        this.syntaxList.setListData(new Vector(visualNamesList));
        this.actValueIndex = oldIndex < visualNamesList.size() ? oldIndex : 0;
        this.syntaxList.setSelectedIndex(this.actValueIndex);
    }

    void setEditorValue(int index) {
        block4: {
            if (index < 0) {
                return;
            }
            String example = LocaleSupport.getString((String)("EXAMPLE_coloring_" + this.names[index]));
            if (example == null) {
                example = LocaleSupport.getString((String)("EXAMPLE_coloring_base-" + this.names[index]), (String)this.names[index]);
            }
            Coloring c = (Coloring)this.value.get(this.names[index]);
            ColoringBean bean = new ColoringBean((Coloring)this.value.get(this.names[index]), example, (Coloring)this.value.get(this.names[0]), index == 0);
            try {
                this.coloringModel.setValue((Object)bean);
            }
            catch (InvocationTargetException e) {
                if (!Boolean.getBoolean("org.netbeans.exceptions")) break block4;
                e.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.detailPanel = new JPanel();
        this.masterPanel = new JPanel();
        this.syntaxLabel = new JLabel();
        this.syntaxScroll = new JScrollPane();
        this.syntaxList = new JList();
        this.setLayout(new GridBagLayout());
        this.detailPanel.setLayout(new GridLayout(1, 1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 11, 11);
        this.add((Component)this.detailPanel, gridBagConstraints);
        this.masterPanel.setLayout(new GridBagLayout());
        this.syntaxLabel.setLabelFor(this.syntaxList);
        this.syntaxLabel.setText(this.getBundleString("CAEP_SyntaxLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.masterPanel.add((Component)this.syntaxLabel, gridBagConstraints);
        this.syntaxList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ColoringArrayEditorPanel.this.syntaxListValueChanged(evt);
            }
        });
        this.syntaxScroll.setViewportView(this.syntaxList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.masterPanel.add((Component)this.syntaxScroll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 11, 12);
        this.add((Component)this.masterPanel, gridBagConstraints);
    }

    private void syntaxListValueChanged(ListSelectionEvent evt) {
        if (this.syntaxList.getSelectedIndex() < 0) {
            return;
        }
        if (this.actValueIndex != this.syntaxList.getSelectedIndex()) {
            this.newValueIndex = this.syntaxList.getSelectedIndex();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ColoringArrayEditorPanel.this.actValueIndex = ColoringArrayEditorPanel.this.newValueIndex;
                    ColoringArrayEditorPanel.this.setEditorValue(ColoringArrayEditorPanel.this.actValueIndex);
                }
            });
        } else {
            this.actValueIndex = this.syntaxList.getSelectedIndex();
            this.setEditorValue(this.actValueIndex);
        }
    }

    private class PropertyModelSupport
    implements PropertyModel {
        private PropertyChangeSupport support = new PropertyChangeSupport(this);
        Class type;
        Class editor;
        Object value;

        public PropertyModelSupport(Class propertyType, Class propertyEditor) {
            this.type = propertyType;
            this.editor = propertyEditor;
        }

        public Class getPropertyType() {
            return this.type;
        }

        public Class getPropertyEditorClass() {
            return this.editor;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object v) {
            if (v != null && !v.equals(this.value)) {
                this.value = v;
                this.support.firePropertyChange("value", null, null);
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.support.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.support.removePropertyChangeListener(l);
        }
    }
}

