/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.util.Map;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.modules.editor.EditorModule;
import org.netbeans.modules.editor.options.ContextOptionsListener;
import org.netbeans.modules.editor.options.OptionSupport;
import org.openide.options.ContextSystemOption;
import org.openide.text.PrintSettings;
import org.openide.util.HelpCtx;

public class BasePrintOptions
extends OptionSupport {
    public static final String BASE = "base";
    public static final String PRINT_PREFIX = "print_";
    public static final String PRINT_COLORING_MAP_PROP = "printColoringMap";
    private static final String HELP_ID = "editing.fontsandcolors";
    static final String[] BASE_PROP_NAMES = new String[]{"printColoringMap"};
    static final long serialVersionUID = 7740651671176408299L;
    private transient Settings.Initializer printColoringMapInitializer;

    public BasePrintOptions() {
        this(BaseKit.class, BASE);
    }

    public BasePrintOptions(Class kitClass, String typeName) {
        super(kitClass, typeName);
    }

    public String displayName() {
        String name;
        try {
            name = this.getString("OPTIONS_print_" + this.getTypeName());
        }
        catch (Throwable t) {
            name = super.displayName();
        }
        return name;
    }

    public void init() {
        this.refreshContextListeners();
    }

    private void refreshContextListeners() {
        PrintSettings ps = (PrintSettings)PrintSettings.findObject((Class)PrintSettings.class, (boolean)true);
        ContextOptionsListener.processExistingAndListen((ContextSystemOption)ps);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    protected String getSettingsInitializerName() {
        return this.getTypeName() + "-print-options-initalizer";
    }

    protected void updateSettingsMap(Class kitClass, Map settingsMap) {
        super.updateSettingsMap(kitClass, settingsMap);
        if (this.printColoringMapInitializer != null) {
            this.printColoringMapInitializer.updateSettingsMap(kitClass, settingsMap);
        }
    }

    public boolean getPrintLineNumberVisible() {
        return (Boolean)this.getSettingValue("line-number-visible");
    }

    public void setPrintLineNumberVisible(boolean b) {
    }

    public Map getPrintColoringMap() {
        EditorModule.init();
        Map cm = SettingsUtil.getColoringMap((Class)this.getKitClass(), (boolean)true, (boolean)true);
        cm.put(null, this.getKitClass().getName());
        return cm;
    }

    public void setPrintColoringMap(Map coloringMap) {
        EditorModule.init();
        if (coloringMap != null) {
            coloringMap.remove(null);
            SettingsUtil.setColoringMap((Class)this.getKitClass(), (Map)coloringMap, (boolean)true);
            this.printColoringMapInitializer = SettingsUtil.getColoringMapInitializer((Class)this.getKitClass(), (Map)coloringMap, (boolean)true, (String)(this.getTypeName() + "-print-coloring-map-initializer"));
            this.firePropertyChange(PRINT_COLORING_MAP_PROP, null, null);
        }
    }
}

