/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.modules.editor.NbDialogSupport;
import org.netbeans.modules.editor.NbEditorSettingsInitializer;
import org.netbeans.modules.editor.NbImplementationProvider;
import org.netbeans.modules.editor.NbLocalizer;
import org.netbeans.modules.editor.options.AllOptions;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.AnnotationTypesFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.BasePrintOptions;
import org.openide.cookies.EditorCookie;
import org.openide.modules.ModuleInstall;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.windows.TopComponent;
import org.openidex.search.SearchHistory;
import org.openidex.search.SearchPattern;
import sun.awt.AppContext;

public class EditorModule
extends ModuleInstall {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.kits");
    static boolean inited = false;
    private PropertyChangeListener searchSelectedPatternListener;
    private PropertyChangeListener editorHistoryChangeListener;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$BaseOptions;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
    static /* synthetic */ Class class$javax$swing$text$EditorKit;
    static /* synthetic */ Class class$org$netbeans$editor$Settings;

    public static void init() {
        if (inited) {
            return;
        }
        inited = true;
        NbEditorSettingsInitializer.init();
        BasePrintOptions bpo = (BasePrintOptions)BasePrintOptions.findObject((Class)BasePrintOptions.class, (boolean)true);
        bpo.init();
    }

    public void restored() {
        LocaleSupport.addLocalizer((LocaleSupport.Localizer)new NbLocalizer(AllOptions.class));
        LocaleSupport.addLocalizer((LocaleSupport.Localizer)new NbLocalizer(BaseKit.class));
        DialogSupport.setDialogFactory((DialogSupport.DialogFactory)new NbDialogSupport());
        ImplementationProvider.registerDefault((ImplementationProvider)new NbImplementationProvider());
        AnnotationTypes.getTypes().registerLoader(new AnnotationTypes.Loader(){

            public void loadTypes() {
                AnnotationTypesFolder.getAnnotationTypesFolder();
            }

            public void loadSettings() {
                Boolean b;
                BaseOptions bo = (BaseOptions)BaseOptions.findObject((Class)(class$org$netbeans$modules$editor$options$BaseOptions == null ? (class$org$netbeans$modules$editor$options$BaseOptions = EditorModule.class$("org.netbeans.modules.editor.options.BaseOptions")) : class$org$netbeans$modules$editor$options$BaseOptions), (boolean)true);
                Integer i = (Integer)bo.getSettingValue("backgroundGlyphAlpha");
                if (i != null) {
                    AnnotationTypes.getTypes().setBackgroundGlyphAlpha(i.intValue());
                }
                if ((b = (Boolean)bo.getSettingValue("backgroundDrawing")) != null) {
                    AnnotationTypes.getTypes().setBackgroundDrawing(b);
                }
                if ((b = (Boolean)bo.getSettingValue("combineGlyphs")) != null) {
                    AnnotationTypes.getTypes().setCombineGlyphs(b);
                }
                if ((b = (Boolean)bo.getSettingValue("glyphsOverLineNumbers")) != null) {
                    AnnotationTypes.getTypes().setGlyphsOverLineNumbers(b);
                }
                if ((b = (Boolean)bo.getSettingValue("showGlyphGutter")) != null) {
                    AnnotationTypes.getTypes().setShowGlyphGutter(b);
                }
            }

            public void saveType(AnnotationType type) {
                AnnotationTypesFolder.getAnnotationTypesFolder().saveAnnotationType(type);
            }

            public void saveSetting(String settingName, Object value) {
                BaseOptions bo = (BaseOptions)BaseOptions.findObject((Class)(class$org$netbeans$modules$editor$options$BaseOptions == null ? (class$org$netbeans$modules$editor$options$BaseOptions = EditorModule.class$("org.netbeans.modules.editor.options.BaseOptions")) : class$org$netbeans$modules$editor$options$BaseOptions), (boolean)true);
                bo.setSettingValue(settingName, value);
            }
        });
        try {
            Field keyField = JEditorPane.class.getDeclaredField("kitRegistryKey");
            keyField.setAccessible(true);
            Object key = keyField.get(JEditorPane.class);
            Hashtable kitMapping = (Hashtable)AppContext.getAppContext().get(key);
            AppContext.getAppContext().put(key, new HackMap(kitMapping));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.searchSelectedPatternListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt == null) {
                    return;
                }
                FindSupport fs = FindSupport.getFindSupport();
                if ("last-selected".equals(evt.getPropertyName())) {
                    SearchPattern sp = SearchHistory.getDefault().getLastSelected();
                    if (sp == null) {
                        return;
                    }
                    FindSupport.SearchPatternWrapper spw = new FindSupport.SearchPatternWrapper(sp.getSearchExpression(), sp.isWholeWords(), sp.isMatchCase(), sp.isRegExp());
                    fs.setLastSelected(spw);
                } else if ("add-to-history".equals(evt.getPropertyName())) {
                    List searchPatterns = SearchHistory.getDefault().getSearchPatterns();
                    ArrayList<FindSupport.SearchPatternWrapper> history = new ArrayList<FindSupport.SearchPatternWrapper>();
                    for (int i = 0; i < searchPatterns.size(); ++i) {
                        SearchPattern sptr = (SearchPattern)searchPatterns.get(i);
                        FindSupport.SearchPatternWrapper spwrap = new FindSupport.SearchPatternWrapper(sptr.getSearchExpression(), sptr.isWholeWords(), sptr.isMatchCase(), sptr.isRegExp());
                        history.add(spwrap);
                    }
                    fs.setHistory(history);
                }
            }
        };
        this.editorHistoryChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt == null || !"find-history-prop".equals(evt.getPropertyName())) {
                    return;
                }
                FindSupport.SearchPatternWrapper spw = (FindSupport.SearchPatternWrapper)evt.getNewValue();
                SearchPattern spLast = SearchHistory.getDefault().getLastSelected();
                if (spw == null || spw.getSearchExpression() == null || "".equals(spw.getSearchExpression())) {
                    return;
                }
                SearchPattern sp = SearchPattern.create((String)spw.getSearchExpression(), (boolean)spw.isWholeWords(), (boolean)spw.isMatchCase(), (boolean)spw.isRegExp());
                if (sp == null || sp.equals((Object)spLast)) {
                    return;
                }
                SearchHistory.getDefault().add(sp);
                SearchHistory.getDefault().setLastSelected(sp);
            }
        };
        SearchHistory.getDefault().addPropertyChangeListener(this.searchSelectedPatternListener);
        FindSupport.getFindSupport().addPropertyChangeListener(this.editorHistoryChangeListener);
    }

    public void uninstalled() {
        AllOptionsFolder.unregisterModuleRegListener();
        try {
            Field keyField = JEditorPane.class.getDeclaredField("kitRegistryKey");
            keyField.setAccessible(true);
            Object key = keyField.get(JEditorPane.class);
            HackMap kitMapping = (HackMap)AppContext.getAppContext().get(key);
            if (kitMapping.getOriginal() != null) {
                AppContext.getAppContext().put(key, kitMapping.getOriginal());
            } else {
                AppContext.getAppContext().remove(key);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HashSet set = new HashSet();
                set.addAll(TopComponent.getRegistry().getOpened());
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    Node[] arr;
                    TopComponent topComp = (TopComponent)it.next();
                    if (!(topComp instanceof CloneableEditor) || (arr = topComp.getActivatedNodes()) == null) continue;
                    for (int i = 0; i < arr.length; ++i) {
                        JEditorPane[] pane;
                        EditorCookie ec = (EditorCookie)arr[i].getCookie(class$org$openide$cookies$EditorCookie == null ? EditorModule.class$("org.openide.cookies.EditorCookie") : class$org$openide$cookies$EditorCookie);
                        if (ec == null || (pane = ec.getOpenedPanes()) == null) continue;
                        for (int j = 0; j < pane.length; ++j) {
                            if (!(pane[j].getEditorKit() instanceof BaseKit)) continue;
                            topComp.close();
                        }
                    }
                }
            }
        });
        inited = false;
    }

    private static final class DebugHashtable
    extends Hashtable {
        DebugHashtable(Hashtable h) {
            if (h != null) {
                this.putAll(h);
                System.err.println("Existing kit classNames mappings: " + this);
            }
        }

        public Object put(Object key, Object value) {
            Object ret = super.put(key, value);
            System.err.println("registering mimeType=" + key + " -> kitClassName=" + value + " original was " + ret);
            return ret;
        }

        public Object remove(Object key) {
            Object ret = super.remove(key);
            System.err.println("removing kitClassName=" + ret + " for mimeType=" + key);
            return ret;
        }
    }

    private static class HackMap
    extends Hashtable {
        private Hashtable delegate;

        HackMap(Hashtable h) {
            this.delegate = h;
            if (debug) {
                if (h != null) {
                    System.err.println("Original kit mappings: " + h);
                }
                try {
                    Field keyField = (class$javax$swing$JEditorPane == null ? (class$javax$swing$JEditorPane = EditorModule.class$("javax.swing.JEditorPane")) : class$javax$swing$JEditorPane).getDeclaredField("kitTypeRegistryKey");
                    keyField.setAccessible(true);
                    Object key = keyField.get(class$javax$swing$JEditorPane == null ? (class$javax$swing$JEditorPane = EditorModule.class$("javax.swing.JEditorPane")) : class$javax$swing$JEditorPane);
                    Hashtable kitTypeMapping = (Hashtable)AppContext.getAppContext().get(key);
                    AppContext.getAppContext().put(key, new DebugHashtable(kitTypeMapping));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        private Object findKit(String type) {
            MimeLookup lookup = MimeLookup.getMimeLookup((String)type);
            return lookup.lookup(class$javax$swing$text$EditorKit == null ? (class$javax$swing$text$EditorKit = EditorModule.class$("javax.swing.text.EditorKit")) : class$javax$swing$text$EditorKit);
        }

        private String getKitClassName(String type) {
            try {
                Field keyField = (class$javax$swing$JEditorPane == null ? (class$javax$swing$JEditorPane = EditorModule.class$("javax.swing.JEditorPane")) : class$javax$swing$JEditorPane).getDeclaredField("kitTypeRegistryKey");
                keyField.setAccessible(true);
                Object key = keyField.get(class$javax$swing$JEditorPane == null ? (class$javax$swing$JEditorPane = EditorModule.class$("javax.swing.JEditorPane")) : class$javax$swing$JEditorPane);
                Hashtable kitTypeMapping = (Hashtable)AppContext.getAppContext().get(key);
                if (kitTypeMapping != null) {
                    return (String)kitTypeMapping.get(type);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object key) {
            Class clazz = class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = EditorModule.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings;
            synchronized (clazz) {
                Object retVal = null;
                if (this.delegate != null) {
                    retVal = this.delegate.get(key);
                    if (debug && retVal != null) {
                        System.err.println("Found cached instance kit=" + retVal + " for mimeType=" + key);
                    }
                }
                if ((retVal == null || retVal.getClass().getName().startsWith("javax.swing.")) && key instanceof String) {
                    Object kit;
                    String kitClassName = this.getKitClassName((String)key);
                    if (debug) {
                        System.err.println("Found kitClassName=" + kitClassName + " for mimeType=" + key);
                    }
                    if ((kitClassName == null || kitClassName.startsWith("javax.swing.")) && (kit = this.findKit((String)key)) != null) {
                        retVal = kit;
                        if (debug) {
                            System.err.println("Found kit=" + retVal + " in xml layers for mimeType=" + key);
                        }
                    }
                }
                return retVal;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object key, Object value) {
            Class clazz = class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = EditorModule.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings;
            synchronized (clazz) {
                if (this.delegate == null) {
                    this.delegate = new Hashtable();
                }
                Object ret = this.delegate.put(key, value);
                if (debug) {
                    System.err.println("registering mimeType=" + key + " -> kitInstance=" + value + " original was " + ret);
                }
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object key) {
            Class clazz = class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = EditorModule.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings;
            synchronized (clazz) {
                Object ret;
                Object v0 = ret = this.delegate != null ? this.delegate.remove(key) : null;
                if (debug) {
                    System.err.println("removing kitInstance=" + ret + " for mimeType=" + key);
                }
                return ret;
            }
        }

        Hashtable getOriginal() {
            return this.delegate;
        }
    }
}

