/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakEventListenerList;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public class CustomizableSideBar
extends JPanel {
    private static HashMap components = new HashMap(5);
    private static HashMap lookupResults = new HashMap(5);
    private static HashMap lookupListeners = new HashMap(5);
    private static HashMap changeListeners = new HashMap(5);
    public static final String FOLDER_NAME = "SideBar";
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$netbeans$editor$SideBarFactory;

    private CustomizableSideBar(List components, SideBarPosition position) {
        BoxLayout bl = new BoxLayout(this, position.getAxis());
        this.setLayout(bl);
        Iterator i = components.iterator();
        while (i.hasNext()) {
            this.add((JComponent)i.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WeakEventListenerList getListenerList(Class kitClass) {
        WeakEventListenerList listenerList;
        HashMap hashMap = changeListeners;
        synchronized (hashMap) {
            listenerList = (WeakEventListenerList)changeListeners.get(kitClass);
        }
        return listenerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addChangeListener(Class kitClass, ChangeListener l) {
        WeakEventListenerList listenerList;
        HashMap hashMap = changeListeners;
        synchronized (hashMap) {
            listenerList = (WeakEventListenerList)changeListeners.get(kitClass);
            if (listenerList == null) {
                listenerList = new WeakEventListenerList();
            }
            changeListeners.put(kitClass, listenerList);
        }
        listenerList.add(ChangeListener.class, (EventListener)l);
    }

    static void removeChangeListener(Class kitClass, ChangeListener l) {
        WeakEventListenerList listenerList = CustomizableSideBar.getListenerList(kitClass);
        if (listenerList == null) {
            return;
        }
        listenerList.remove(ChangeListener.class, (EventListener)l);
    }

    private static void fireChange(Class kitClass) {
        WeakEventListenerList listenerList = CustomizableSideBar.getListenerList(kitClass);
        if (listenerList == null) {
            return;
        }
        ChangeListener[] listeners = (ChangeListener[])listenerList.getListeners(ChangeListener.class);
        ChangeEvent evt = new ChangeEvent(CustomizableSideBar.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].stateChanged(evt);
        }
    }

    public static Map createSideBars(JTextComponent target) {
        Map components = CustomizableSideBar.getPanelComponents(target);
        HashMap<SideBarPosition, CustomizableSideBar> result = new HashMap<SideBarPosition, CustomizableSideBar>();
        Iterator entries = components.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            SideBarPosition position = (SideBarPosition)entry.getKey();
            result.put(position, new CustomizableSideBar((List)entry.getValue(), position));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getInstanceCookiesPerKitClass(Class kitClass) {
        Map result = new HashMap();
        if (kitClass == null) {
            return result;
        }
        HashMap hashMap = components;
        synchronized (hashMap) {
            Lookup.Result lookupResult;
            if (components.containsKey(kitClass)) {
                return (Map)components.get(kitClass);
            }
            BaseKit kit = BaseKit.getKit((Class)kitClass);
            String name = kit.getContentType();
            if (name == null) {
                return result;
            }
            MimeLookup lookup = MimeLookup.getMimeLookup((String)name);
            HashMap hashMap2 = lookupResults;
            synchronized (hashMap2) {
                lookupResult = (Lookup.Result)lookupResults.get(kitClass);
                if (lookupResult == null) {
                    lookupResult = lookup.lookup(new Lookup.Template(SideBarFactoryProvider.class));
                    lookupResults.put(kitClass, lookupResult);
                }
            }
            Collection instances = lookupResult.allInstances();
            if (instances.isEmpty()) {
                return result;
            }
            SideBarFactoryProvider provider = (SideBarFactoryProvider)instances.iterator().next();
            HashMap hashMap3 = lookupListeners;
            synchronized (hashMap3) {
                LookupListener lookupListener = (LookupListener)lookupListeners.get(kitClass);
                if (lookupListener == null) {
                    lookupListener = new MyLookupListener(kitClass);
                    LookupListener weakListener = (LookupListener)WeakListeners.create((Class)LookupListener.class, (EventListener)lookupListener, (Object)lookupResult);
                    lookupResult.addLookupListener(weakListener);
                    lookupListeners.put(kitClass, lookupListener);
                }
            }
            if (provider != null) {
                result = provider.getProviders();
            }
            if (result != null) {
                components.put(kitClass, result);
            }
            return result;
        }
    }

    private static Map getPanelComponents(JTextComponent target) {
        HashMap result = new HashMap();
        Map icMap = CustomizableSideBar.getInstanceCookiesPerKitClass(Utilities.getKitClass((JTextComponent)target));
        try {
            Iterator entries = icMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                List icList = (List)entry.getValue();
                ArrayList<JComponent> retList = new ArrayList<JComponent>();
                for (int i = 0; i < icList.size(); ++i) {
                    InstanceCookie ic = (InstanceCookie)icList.get(i);
                    Object obj = ic.instanceCreate();
                    JComponent sideBarObj = ((SideBarFactory)obj).createSideBar(target);
                    if (sideBarObj == null) continue;
                    retList.add(sideBarObj);
                }
                result.put(entry.getKey(), retList);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        return result;
    }

    private static class MyLookupListener
    implements LookupListener {
        private Class kitClass;

        public MyLookupListener(Class kitClass) {
            this.kitClass = kitClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            HashMap hashMap = components;
            synchronized (hashMap) {
                components.remove(this.kitClass);
            }
            CustomizableSideBar.fireChange(this.kitClass);
        }
    }

    public static class SideBarFactoryProvider
    implements InstanceProvider {
        List ordered;

        public SideBarFactoryProvider() {
        }

        public SideBarFactoryProvider(List ordered) {
            this.ordered = ordered;
        }

        public Map getProviders() {
            HashMap<SideBarPosition, ArrayList<InstanceCookie>> result = new HashMap<SideBarPosition, ArrayList<InstanceCookie>>();
            for (int i = 0; i < this.ordered.size(); ++i) {
                DataObject dob = (DataObject)this.ordered.get(i);
                InstanceCookie ic = (InstanceCookie)dob.getCookie(class$org$openide$cookies$InstanceCookie == null ? CustomizableSideBar.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                if (ic == null) continue;
                try {
                    if (!(class$org$netbeans$editor$SideBarFactory == null ? CustomizableSideBar.class$("org.netbeans.editor.SideBarFactory") : class$org$netbeans$editor$SideBarFactory).isAssignableFrom(ic.instanceClass())) continue;
                    SideBarPosition position = new SideBarPosition(dob.getPrimaryFile());
                    ArrayList<InstanceCookie> retList = (ArrayList<InstanceCookie>)result.get(position);
                    if (retList == null) {
                        retList = new ArrayList<InstanceCookie>();
                        result.put(position, retList);
                    }
                    retList.add(ic);
                    continue;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    cnfe.printStackTrace();
                }
            }
            return result;
        }

        public Object createInstance(List ordered) {
            return new SideBarFactoryProvider(ordered);
        }
    }

    static final class SideBarPosition {
        public static final int WEST = 1;
        public static final int NORTH = 2;
        public static final int SOUTH = 3;
        public static final int EAST = 4;
        public static final String WEST_NAME = "West";
        public static final String NORTH_NAME = "North";
        public static final String SOUTH_NAME = "South";
        public static final String EAST_NAME = "East";
        private int position;
        private boolean scrollable;
        private static String[] borderLayoutConstants = new String[]{"", "West", "North", "South", "East"};
        private static int[] axisConstants = new int[]{-1, 0, 1, 1, 0};

        SideBarPosition(FileObject fo) {
            Object position = fo.getAttribute("position");
            if (position != null && position instanceof String) {
                String positionName = (String)position;
                if (WEST_NAME.equals(positionName)) {
                    this.position = 1;
                } else if (NORTH_NAME.equals(positionName)) {
                    this.position = 2;
                } else if (SOUTH_NAME.equals(positionName)) {
                    this.position = 3;
                } else if (EAST_NAME.equals(positionName)) {
                    this.position = 4;
                } else {
                    if (ErrorManager.getDefault().isLoggable(1)) {
                        ErrorManager.getDefault().log(1, "Unsupported position: " + positionName);
                    }
                    this.position = 1;
                }
            } else {
                this.position = 1;
            }
            Object scrollable = fo.getAttribute("scrollable");
            this.scrollable = scrollable != null && scrollable instanceof Boolean ? (Boolean)scrollable : true;
            if (this.scrollable && (this.position == 3 || this.position == 4) && ErrorManager.getDefault().isLoggable(1)) {
                ErrorManager.getDefault().log(1, "Unsupported combination: scrollable == true, position=" + this.getBorderLayoutPosition());
            }
        }

        public int hashCode() {
            return this.scrollable ? this.position : -this.position;
        }

        public boolean equals(Object o) {
            if (o instanceof SideBarPosition) {
                SideBarPosition p = (SideBarPosition)o;
                if (this.scrollable != p.scrollable) {
                    return false;
                }
                return this.position == p.position;
            }
            return false;
        }

        public int getPosition() {
            return this.position;
        }

        public String getBorderLayoutPosition() {
            return borderLayoutConstants[this.getPosition()];
        }

        private int getAxis() {
            return axisConstants[this.getPosition()];
        }

        public boolean isScrollable() {
            return this.scrollable;
        }

        public String toString() {
            return "[SideBarPosition: scrollable=" + this.scrollable + ", position=" + this.position + "]";
        }
    }
}

