/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.navigation.spi.AbstractModel;
import org.netbeans.modules.java.navigation.spi.ListModelSupport;
import org.netbeans.modules.java.navigation.spi.NavigatorTreeModel;
import org.netbeans.modules.java.navigation.spi.diff.Change;
import org.netbeans.modules.java.navigation.spi.diff.Diff;
import org.netbeans.modules.java.navigation.spi.strings.WeightedString;
import org.openide.util.Cancellable;
import org.openide.util.Task;
import org.openide.util.Utilities;

public abstract class TreeModelSupport
extends AbstractModel
implements NavigatorTreeModel {
    private final Roots roots;
    protected final Object root;
    private HashMap mdls2roots = new HashMap();
    private HashMap roots2mdls = new HashMap();
    private List listeners = Collections.synchronizedList(new ArrayList());
    private boolean suppressChildFiring = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TreeModelSupport(Object root) {
        this.root = root;
        this.roots = new Roots(this);
        this.roots.setTree(this);
    }

    public final void doAddNotify() {
        this.roots.setTree(this);
        this.roots.addNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNotify() {
        List old = this.getList();
        this.roots.removeNotify();
        this.suppressChildFiring = true;
        try {
            Iterator i = this.mdls2roots.keySet().iterator();
            while (i.hasNext()) {
                AbstractModel supp = (AbstractModel)i.next();
                if (!supp.isActive()) continue;
                supp.removeNotify();
            }
        }
        finally {
            this.suppressChildFiring = false;
        }
    }

    protected final boolean isActive() {
        return this.roots.isActive();
    }

    public boolean acceptsStringFilter() {
        return false;
    }

    protected Task getWaitTask() {
        return null;
    }

    protected void cancelWaitTask(Cancellable waitTask) {
        waitTask.cancel();
    }

    public abstract Action[] getActions(Object var1);

    protected String getDisplayName(Object o) {
        return null;
    }

    protected WeightedString assembleName(WeightedString ws, Object o) {
        ws.startMarkupRun(512);
        ws.append("Unknown: ", 0.09f);
        ws.endMarkupRun();
        ws.append(o.toString(), 0.09f);
        return ws;
    }

    public final WeightedString getName(Object o) {
        WeightedString result = WeightedString.instance();
        String name = this.getDisplayName(o);
        if (name != null) {
            result.append(name, 0.09f);
        } else {
            result = this.assembleName(result, o);
        }
        return result;
    }

    public abstract Icon getIcon(Object var1);

    public String getTooltip(Object o) {
        return null;
    }

    public abstract Action getDefaultAction(Object var1);

    public final boolean isDefaultActionInstant() {
        return false;
    }

    public void notifyExpandedState(TreePath path, boolean expanded) {
        AbstractModel mdl = this.findModelFor(path, true);
        if (mdl.isActive() != expanded && expanded) {
            mdl.addNotify();
        }
    }

    AbstractModel findModelFor(TreePath path, boolean create) {
        return this.findModelFor(path.getLastPathComponent(), create);
    }

    AbstractModel findModelFor(Object o, boolean create) {
        AbstractModel result = this.modelForRootObject(o, create);
        if (result == null) {
            Iterator i = this.mdls2roots.keySet().iterator();
            while (i.hasNext()) {
                AbstractModel am = (AbstractModel)i.next();
                if (!am.owns(o)) continue;
                result = am.findModelFor(o, create);
            }
        }
        return result;
    }

    void notifyChildModelAddNotify(AbstractModel mdl) {
        if (mdl != this.roots) {
            List l = mdl.getLoadingTempList();
            TreeModelEvent tme = new TreeModelEvent((Object)this, mdl.getPath(), new int[]{0}, new Object[]{l.get(0)});
            this.childTreeFires(1, tme, mdl);
        }
    }

    public TreePath[] getDefaultExpandedPaths() {
        return new TreePath[0];
    }

    public boolean isShowRoot() {
        return true;
    }

    protected abstract List loadContents();

    protected void updated() {
    }

    protected abstract AbstractModel createModelFor(Object var1);

    protected void startListening() {
    }

    protected void stopListening() {
    }

    public boolean isReady() {
        return this.roots.isReady();
    }

    public void addChangeListener(ChangeListener cl) throws TooManyListenersException {
        this.roots.addChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.roots.removeChangeListener(cl);
    }

    protected final List getList() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"getList may only becalled on the dispatch thread");
        }
        return this.roots.getList();
    }

    public final Object getRoot() {
        return this.root;
    }

    public final int getIndexOfChild(Object parent, Object child) {
        if (this.root.equals(parent)) {
            return this.roots.indexOf(child);
        }
        AbstractModel am = this.findModelFor(parent, true);
        return am == null ? -1 : am.indexOf(child);
    }

    public final Object getChild(Object o, int index) {
        AbstractModel supp = this.findModelFor(o, true);
        if (supp != null) {
            return supp.getElementAt(index);
        }
        return null;
    }

    protected final AbstractModel modelForRootObject(Object o, boolean create) {
        if (this.root.equals(o)) {
            return this.roots;
        }
        if (this.roots.owns(o)) {
            AbstractModel result = (AbstractModel)this.roots2mdls.get(o);
            if (result == null) {
                result = this.createModelFor(o);
                result.setPath(TreeModelSupport.combine(this.getPath(), new TreePath(o)));
                result.setTree(this);
                this.mdls2roots.put(result, o);
                this.roots2mdls.put(o, result);
                this.notifyChildModelAddNotify(result);
            }
            return result;
        }
        return null;
    }

    public final int getChildCount(Object o) {
        AbstractModel supp = this.findModelFor(o, true);
        if (supp instanceof Roots && o != supp.getPath().getLastPathComponent()) {
            return 0;
        }
        if (supp != null) {
            return supp.getSize();
        }
        return 0;
    }

    TreePath getPath() {
        TreePath result = super.getPath();
        if (result == null) {
            return new TreePath(this.getRoot());
        }
        return result;
    }

    boolean owns(Object o) {
        boolean result;
        block1: {
            result = this.roots.owns(o);
            if (result) break block1;
            Iterator i = this.mdls2roots.keySet().iterator();
            while (i.hasNext() && !(result |= ((AbstractModel)i.next()).owns(o))) {
            }
        }
        return result;
    }

    int getSize() {
        return this.roots.getSize();
    }

    int fullSize() {
        int result = this.getSize();
        Iterator i = this.mdls2roots.keySet().iterator();
        while (i.hasNext()) {
            result += ((AbstractModel)i.next()).fullSize();
        }
        return result;
    }

    Object getElementAt(int i) {
        return this.roots.getElementAt(i);
    }

    int indexOf(Object o) {
        return this.roots.indexOf(o);
    }

    void childTreeFires(int type, TreeModelEvent tme, AbstractModel childModel) {
        if (this.suppressChildFiring) {
            return;
        }
        TreePath nuPath = TreeModelSupport.combine(this.getPath(), tme.getTreePath());
        TreeModelEvent nue = new TreeModelEvent((Object)this, nuPath, tme.getChildIndices(), tme.getChildren());
        this.fire(type, nue);
    }

    public final boolean isLeaf(Object o) {
        AbstractModel supp = this.findModelFor(o, true);
        if (supp instanceof ListModelSupport && !(supp instanceof Roots)) {
            Object root = supp.getPath().getLastPathComponent();
            return !o.equals(root);
        }
        return supp == null ? true : (!supp.isActive() ? false : supp.getSize() == 0);
    }

    public final void valueForPathChanged(TreePath treePath, Object obj) {
        throw new UnsupportedOperationException();
    }

    public final void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    public final void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    protected final void change() {
        this.roots.change();
    }

    protected final void change(int start, int end, int changeType) {
        this.roots.change(start, end, changeType);
    }

    protected final void change(List changes) {
        this.roots.change(changes);
    }

    void processDiffs(ListModelSupport list, Diff[] diff) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        Object rootForList = list == this.roots ? this.root : this.mdls2roots.get(list);
        TreePath rootPath = list == this.roots ? this.getPath() : list.getPath();
        for (int t = 0; t < diff.length; ++t) {
            List changes = diff[t].getChanges();
            if (rootForList == null || changes.isEmpty()) continue;
            int currType = -1;
            ArrayList indices = new ArrayList();
            ArrayList affected = new ArrayList();
            Change[] ch = changes.toArray(new Change[0]);
            for (int i = 0; i < ch.length; ++i) {
                Change change = ch[i];
                if (currType == change.getType() || currType == -1) {
                    currType = change.getType();
                    this.addIndicesForChange(change, indices, affected, diff[t].getOld(), diff[t].getNew());
                }
                if (i != ch.length - 1 && ch[i + 1].getType() == currType) continue;
                int[] childIndices = (int[])Utilities.toPrimitiveArray((Object[])indices.toArray(new Integer[indices.size()]));
                Object[] childObjects = affected.toArray();
                indices.clear();
                affected.clear();
                TreeModelEvent tme = new TreeModelEvent((Object)this, rootPath, childIndices, childObjects);
                this.fire(currType, tme);
                currType = -1;
            }
        }
    }

    private void addIndicesForChange(Change change, List indices, List affected, List oldValues, List newValues) {
        for (int j = change.getStart(); j <= change.getEnd(); ++j) {
            indices.add(new Integer(j));
            affected.add(change.getType() != 2 ? newValues.get(j) : oldValues.get(j));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(int type, TreeModelEvent tme) {
        TreeModelListener[] l = this.listeners.toArray(new TreeModelListener[0]);
        block8: for (int i = 0; i < l.length; ++i) {
            switch (type) {
                case 0: {
                    l[i].treeNodesChanged(tme);
                    continue block8;
                }
                case 1: {
                    l[i].treeNodesInserted(tme);
                    continue block8;
                }
                case 2: {
                    l[i].treeNodesRemoved(tme);
                    continue block8;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue block8;
                }
            }
        }
        TreeModelSupport rootTree = this.getRootTree();
        if (rootTree != this) {
            rootTree.childTreeFires(type, tme, this);
        }
        TreeModelSupport treeModelSupport = this;
        synchronized (treeModelSupport) {
            this.notifyAll();
        }
    }

    public String toString() {
        return "[TME for " + this.getRoot() + " path " + this.getPath() + "]";
    }

    static {
        $assertionsDisabled = !TreeModelSupport.class.desiredAssertionStatus();
    }

    private static final class Roots
    extends ListModelSupport {
        Roots(TreeModelSupport supp) {
            this.setTree(supp);
        }

        public Action[] getActions(Object o) {
            return this.getTree().getActions(o);
        }

        public Action getDefaultAction(Object o) {
            return this.getTree().getDefaultAction(o);
        }

        public Icon getIcon(Object o) {
            return this.getTree().getIcon(o);
        }

        protected List loadContents() {
            return this.getTree().loadContents();
        }

        protected Task getWaitTask() {
            return this.getTree().getWaitTask();
        }

        protected void cancelWaitTask(Cancellable waitTask) {
            this.getTree().cancelWaitTask(waitTask);
        }

        protected void startListening() {
            this.getTree().startListening();
        }

        protected void stopListening() {
            this.getTree().stopListening();
        }

        protected void updated() {
            this.getTree().updated();
        }

        TreePath getPath() {
            return this.getTree().getPath();
        }

        public JComponent getFilters() {
            return this.getTree().getFilters();
        }
    }
}

