/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.TooManyListenersException;
import org.netbeans.modules.java.navigation.spi.diff.ListDiff;

public interface RelatedItemProvider {
    public boolean isRelated(Object var1);

    public boolean isPrimary(Object var1);

    public Object getPrimaryItem();

    public void addRelatedItemListener(RelatedItemListener var1) throws TooManyListenersException;

    public void removeRelatedItemListener(RelatedItemListener var1);

    public void reset();

    public static final class RelatedItemEvent
    extends EventObject {
        private final Collection oldItems;
        private final Collection newItems;
        private final Object oldPrimary;
        private final Object newPrimary;

        public RelatedItemEvent(Object source, Collection oldItems, Collection newItems, Object oldPrimary, Object newPrimary) {
            super(source);
            this.oldItems = oldItems == null ? Collections.EMPTY_SET : oldItems;
            this.newItems = newItems == null ? Collections.EMPTY_SET : newItems;
            this.oldPrimary = oldPrimary;
            this.newPrimary = newPrimary;
        }

        public Collection getRelatedItems() {
            return this.newItems;
        }

        public Collection getPreviousRelatedItems() {
            return this.oldItems;
        }

        public Object getOldPrimary() {
            return this.oldPrimary;
        }

        public Object getNewPrimary() {
            return this.newPrimary;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(super.toString());
            try {
                List l1 = this.oldItems instanceof List ? (List)this.oldItems : new ArrayList(this.oldItems);
                List l2 = this.newItems instanceof List ? (List)this.newItems : new ArrayList(this.newItems);
                sb.append(ListDiff.createDiff(l1, l2));
            }
            catch (Exception e) {
                sb.append("Exception iterating the list: " + e);
            }
            return sb.toString();
        }
    }

    public static interface RelatedItemListener
    extends EventListener {
        public void itemsChanged(RelatedItemEvent var1);

        public void itemsCleared(RelatedItemEvent var1);
    }
}

