/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.navigation.spi.NavigatorListModel;
import org.netbeans.modules.java.navigation.spi.NavigatorTreeModel;
import org.openide.util.NbBundle;

public final class SearchPanel {
    private JPanel searchpanel = null;
    private SearchTextField searchTextField = new SearchTextField();
    private JTree treeTarget = null;
    private JList listTarget = null;
    private SearchKeyProcessor keyProcessor = new SearchKeyProcessor();
    private SearchFieldListener searchFieldListener = new SearchFieldListener();
    private List results = null;

    public SearchPanel() {
        this.searchTextField.addKeyListener(this.searchFieldListener);
        this.searchTextField.addFocusListener(this.searchFieldListener);
        this.searchTextField.getDocument().addDocumentListener(this.searchFieldListener);
    }

    public void prepare(JComponent component) {
        KeyListener[] keyListeners = (KeyListener[])component.getListeners(KeyListener.class);
        for (int i = 0; i < keyListeners.length; ++i) {
            component.removeKeyListener(keyListeners[i]);
        }
        component.addKeyListener(this.keyProcessor);
    }

    private void invoke(JTree target) {
        this.treeTarget = target;
        this.listTarget = null;
        this.show();
    }

    private void invoke(JList target) {
        this.treeTarget = null;
        this.listTarget = target;
        this.show();
    }

    private void detach() {
        if (this.searchpanel.isShowing()) {
            JComponent c = (JComponent)this.searchpanel.getParent();
            this.searchpanel.getParent().remove(this.searchpanel);
            c.repaint(this.searchpanel.getBounds());
        }
        this.results = null;
    }

    private JComponent getTarget() {
        return this.treeTarget == null ? this.listTarget : this.treeTarget;
    }

    private void show() {
        int height;
        this.prepareSearchPanel();
        JComponent target = (JComponent)this.getTarget().getParent().getParent();
        JLayeredPane dest = target.getRootPane().getLayeredPane();
        Point loc = new Point(target.getWidth() / 2, 5);
        loc = SwingUtilities.convertPoint(target, loc, dest);
        int width = target.getWidth() / 2;
        int n = height = this.getTarget() instanceof JTree ? ((JTree)this.getTarget()).getRowHeight() + 8 : ((JList)this.getTarget()).getFixedCellHeight() + 8;
        if (width < 120) {
            width = 160;
            loc.x -= 160;
        }
        if (loc.x < 0) {
            loc.x += target.getWidth();
        }
        this.searchTextField.setFont(this.getTarget().getFont());
        this.searchpanel.setBounds(loc.x, loc.y, width, height);
        dest.add((Component)this.searchpanel, JLayeredPane.POPUP_LAYER);
        this.searchpanel.setVisible(true);
        this.searchTextField.requestFocus();
    }

    private void prepareSearchPanel() {
        if (this.searchpanel == null) {
            this.searchpanel = new JPanel();
            JLabel lbl = new JLabel(NbBundle.getMessage((Class)SearchPanel.class, (String)"LBL_QUICKSEARCH"));
            this.searchpanel.setLayout(new BoxLayout(this.searchpanel, 0));
            this.searchpanel.add(lbl);
            this.searchpanel.add(this.searchTextField);
            lbl.setLabelFor(this.searchTextField);
            this.searchpanel.setBorder(BorderFactory.createRaisedBevelBorder());
            lbl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }
    }

    private List doSearch(String prefix) {
        JComponent jc = this.getTarget();
        if (jc == null) {
            System.err.println("SOMETHING IS WRONG!!!");
            return Collections.EMPTY_LIST;
        }
        List result = jc instanceof JList ? ((NavigatorListModel)((JList)jc).getModel()).getSearchResults(prefix) : ((NavigatorTreeModel)((JTree)jc).getModel()).getSearchResults(prefix);
        return result;
    }

    private class SearchFieldListener
    extends KeyAdapter
    implements DocumentListener,
    FocusListener {
        private List results = new ArrayList();
        private int currentSelectionIndex;

        SearchFieldListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            this.searchForNode();
        }

        public void insertUpdate(DocumentEvent e) {
            this.searchForNode();
        }

        public void removeUpdate(DocumentEvent e) {
            this.searchForNode();
        }

        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 27) {
                SearchPanel.this.detach();
                e.consume();
                SearchPanel.this.getTarget().requestFocus();
            } else if (keyCode == 38) {
                --this.currentSelectionIndex;
                this.displaySearchResult();
                e.consume();
            } else if (keyCode == 40) {
                ++this.currentSelectionIndex;
                this.displaySearchResult();
                e.consume();
            } else if (keyCode == 9) {
                e.consume();
            } else if (keyCode == 10) {
                SearchPanel.this.detach();
                this.performAction();
            }
        }

        private void performAction() {
            JComponent jc = SearchPanel.this.getTarget();
            if (jc instanceof JTree) {
                this.performActionTree();
            } else {
                this.performActionList();
            }
        }

        private void performActionTree() {
            TreeNode o;
            Action a;
            JTree tree = (JTree)SearchPanel.this.getTarget();
            NavigatorTreeModel mdl = (NavigatorTreeModel)tree.getModel();
            if (!(tree.getModel() instanceof NavigatorTreeModel)) {
                return;
            }
            TreePath selectedTPath = tree.getSelectionPath();
            if (selectedTPath != null && (a = mdl.getDefaultAction(o = (TreeNode)selectedTPath.getLastPathComponent())).isEnabled()) {
                a.actionPerformed(new ActionEvent(tree, 1001, null));
            }
        }

        private void performActionList() {
            Object o;
            Action a;
            JList list = (JList)SearchPanel.this.getTarget();
            if (!(list.getModel() instanceof NavigatorListModel)) {
                return;
            }
            NavigatorListModel mdl = (NavigatorListModel)list.getModel();
            int idx = list.getSelectedIndex();
            if (idx != -1 && (a = mdl.getDefaultAction(o = mdl.getElementAt(idx))).isEnabled()) {
                a.actionPerformed(new ActionEvent(list, 1001, null));
            }
        }

        private void searchForNode() {
            this.currentSelectionIndex = 0;
            this.results = null;
            String text = SearchPanel.this.searchTextField.getText();
            if (text.length() > 0) {
                this.results = SearchPanel.this.doSearch(text);
                this.displaySearchResult();
            }
        }

        private void displaySearchResult() {
            if (this.results == null) {
                return;
            }
            JComponent jc = SearchPanel.this.getTarget();
            if (jc instanceof JList) {
                this.displaySearchResultList();
            } else {
                this.displaySearchResultTree();
            }
        }

        private void displaySearchResultList() {
            JList list = (JList)SearchPanel.this.getTarget();
            NavigatorListModel mdl = (NavigatorListModel)list.getModel();
            int sz = this.results.size();
            if (sz > 0) {
                if (this.currentSelectionIndex < 0) {
                    this.currentSelectionIndex = sz - 1;
                } else if (this.currentSelectionIndex >= sz) {
                    this.currentSelectionIndex = 0;
                }
                Object node = this.results.get(this.currentSelectionIndex);
                int index = mdl.indexOf(node);
                list.setSelectedIndex(index);
                list.ensureIndexIsVisible(index);
            }
        }

        private void displaySearchResultTree() {
            JTree tree = (JTree)SearchPanel.this.getTarget();
            if (tree == null) {
                System.err.println("SOMETHING IS VERY WRONG");
                return;
            }
            int sz = this.results.size();
            if (sz > 0) {
                if (this.currentSelectionIndex < 0) {
                    this.currentSelectionIndex = sz - 1;
                } else if (this.currentSelectionIndex >= sz) {
                    this.currentSelectionIndex = 0;
                }
                TreePath path = (TreePath)this.results.get(this.currentSelectionIndex);
                tree.setSelectionPath(path);
                tree.scrollPathToVisible(path);
            } else {
                tree.clearSelection();
            }
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            SearchPanel.this.detach();
        }
    }

    private class SearchKeyProcessor
    extends KeyAdapter {
        private boolean armed = false;

        private SearchKeyProcessor() {
        }

        public void keyPressed(KeyEvent e) {
            int modifiers = e.getModifiers();
            int keyCode = e.getKeyCode();
            if (keyCode == 521 || keyCode == 45 || keyCode == 107 || keyCode == 109) {
                return;
            }
            if (modifiers > 0 && modifiers != 1 || e.isActionKey()) {
                return;
            }
            char c = e.getKeyChar();
            if (!Character.isISOControl(c) && keyCode != 16 && keyCode != 27) {
                this.armed = true;
                e.consume();
            }
        }

        public void keyTyped(KeyEvent e) {
            if (this.armed) {
                KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
                if (e.getSource() instanceof JTree) {
                    SearchPanel.this.invoke((JTree)e.getSource());
                } else {
                    SearchPanel.this.invoke((JList)e.getSource());
                }
                SearchPanel.this.searchTextField.setText(String.valueOf(stroke.getKeyChar()));
                e.consume();
                this.armed = false;
            }
        }
    }

    private class SearchTextField
    extends JTextField {
        private SearchTextField() {
        }

        public boolean isManagingFocus() {
            return true;
        }

        public void processKeyEvent(KeyEvent ke) {
            if (ke.getKeyCode() == 27) {
                final JComponent target = SearchPanel.this.getTarget();
                SearchPanel.this.detach();
                ke.consume();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        target.requestFocus();
                    }
                });
            } else {
                super.processKeyEvent(ke);
            }
        }
    }
}

