/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.java.navigation.jmi.JUtils;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.ErrorManager;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class OverrideAction
extends AbstractAction {
    private final Method m;
    private final JavaClass target;
    private final JavaDataObject jdo;
    private int first = -1;
    private int last = -1;
    private boolean sortByIndex = false;

    public OverrideAction(Method m, JavaClass target, JavaDataObject jdo) {
        this.m = m;
        this.target = target;
        this.jdo = jdo;
        this.putValue("Name", NbBundle.getMessage((Class)OverrideAction.class, (String)(this.isInterfaceMethod() ? "LBL_implement" : "LBL_override")));
    }

    private boolean isInterfaceMethod() {
        ClassDefinition jc = this.m.getDeclaringClass();
        if (jc instanceof JavaClass) {
            return ((JavaClass)jc).isInterface();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent ae) {
        block13: {
            TopComponent tc;
            HashSet toImport = new HashSet();
            String nue = this.create(toImport);
            JavaEditor ed = this.jdo.getJavaEditor();
            if (ed == null) {
                OpenCookie oc = (OpenCookie)this.jdo.getCookie(OpenCookie.class);
                if (oc == null) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                oc.open();
            }
            JEditorPane[] panes = ed != null ? ed.getOpenedPanes() : null;
            JEditorPane pane = panes != null && panes.length >= 0 ? ed.getOpenedPanes()[0] : null;
            BoundedRangeModel scModel = null;
            if (pane != null && !toImport.isEmpty()) {
                JScrollPane jsp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, pane);
                if (jsp != null) {
                    scModel = jsp.getHorizontalScrollBar().getModel();
                    scModel.setValueIsAdjusting(true);
                }
                pane.setIgnoreRepaint(true);
            }
            int curpos = 0;
            try {
                StyledDocument doc = ed.getDocument();
                int pos = OverrideAction.getInsertPosition(doc);
                try {
                    doc.insertString(pos - 1, nue, null);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                int importsLength = 0;
                if (!toImport.isEmpty()) {
                    importsLength = this.createImports(toImport, doc);
                    if (scModel != null) {
                        scModel.setValueIsAdjusting(false);
                    }
                }
                curpos = importsLength + pos + nue.indexOf("{") + 8;
                if (pane == null) break block13;
                pane.getCaret().setDot(curpos);
                tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, pane);
            }
            catch (Throwable throwable) {
                if (pane != null) {
                    pane.getCaret().setDot(curpos);
                    TopComponent tc2 = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, pane);
                    if (tc2 != null) {
                        tc2.requestActive();
                    }
                    pane.setIgnoreRepaint(false);
                }
                throw throwable;
            }
            if (tc != null) {
                tc.requestActive();
            }
            pane.setIgnoreRepaint(false);
        }
    }

    private static int getInsertPosition(Document doc) {
        Element el = doc.getDefaultRootElement();
        try {
            String s = doc.getText(0, doc.getLength());
            if (s.indexOf("}") >= 0) {
                return el.getStartOffset() + s.lastIndexOf("}");
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return doc.getLength() - 2;
    }

    private String create(Set toImport) {
        Iterator i;
        StringBuffer sb = new StringBuffer("\n\n");
        int mods = this.m.getModifiers();
        sb.append("    ");
        if ((mods & 1) != 0 || ((JavaClass)this.m.getDeclaringClass()).isInterface()) {
            sb.append("public ");
        }
        if ((mods & 4) != 0) {
            sb.append("protected ");
        }
        if ((mods & 8) != 0) {
            sb.append("static");
        }
        if (this.m.getType() != null) {
            sb.append(this.maybeStripPackage(this.m.getType(), toImport));
            sb.append(' ');
        } else {
            sb.append("void ");
        }
        sb.append(this.m.getName());
        sb.append('(');
        List params = this.m.getParameters();
        if (!params.isEmpty()) {
            HashSet varNames = new HashSet();
            i = params.iterator();
            while (i.hasNext()) {
                Parameter p = (Parameter)i.next();
                String name = p.getName();
                if (name == null || name.trim().length() == 0) {
                    name = JUtils.generateBelievableParameterName(p, varNames);
                }
                sb.append(this.maybeStripPackage(p.getType(), toImport));
                sb.append(' ');
                sb.append(name);
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(')');
        List es = this.m.getExceptions();
        if (!es.isEmpty()) {
            sb.append(" throws ");
            i = es.iterator();
            while (i.hasNext()) {
                ParameterizedType exc = (ParameterizedType)i.next();
                sb.append(this.maybeStripPackage((Type)exc, toImport));
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(" {\n        \n    }");
        return sb.toString();
    }

    private int createImports(Set imps, Document d) {
        int result = 0;
        Iterator i = imps.iterator();
        while (i.hasNext()) {
            Type t = (Type)i.next();
            int pos = this.findImportInsertLocation(d, t);
            StringBuffer sb = new StringBuffer();
            sb.append("import ");
            String tname = t.getName();
            int bkt = tname.indexOf("[");
            if (bkt > 0) {
                tname = tname.substring(0, bkt);
            }
            sb.append(tname);
            sb.append(";\n");
            result += sb.length();
            try {
                d.insertString(pos, sb.toString(), null);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return 0;
            }
        }
        return result;
    }

    private int findImportInsertLocation(Document d, Type t) {
        try {
            HashSet<ImpInfo> imps = new HashSet<ImpInfo>();
            int pkgLoc = 0;
            int ct = d.getDefaultRootElement().getElementCount();
            int ix = 0;
            for (int i = 0; i < ct; ++i) {
                Element e = d.getDefaultRootElement().getElement(i);
                String s = d.getText(e.getStartOffset(), e.getEndOffset() - e.getStartOffset());
                if (s.trim().startsWith("import")) {
                    imps.add(new ImpInfo(s, ix, e));
                    this.last = i;
                    if (this.first == -1) {
                        this.first = i;
                    }
                }
                if (s.trim().startsWith("package")) {
                    pkgLoc = e.getEndOffset();
                }
                ix += 2;
                if (i - this.last > 10 && this.first != -1) break;
            }
            if (imps.isEmpty()) {
                imps = null;
                return this.last != -1 ? d.getDefaultRootElement().getElement(this.last).getEndOffset() : pkgLoc;
            }
            ImpInfo toAdd = new ImpInfo("import " + t.getName() + ";\n", 0, null);
            imps.add(toAdd);
            Object[] sorted = imps.toArray(new ImpInfo[0]);
            Arrays.sort(sorted);
            int idx = Arrays.asList(sorted).indexOf(toAdd);
            if (idx > 0) {
                toAdd.idx = ((ImpInfo)sorted[idx - 1]).idx + 1;
                toAdd.element = ((ImpInfo)sorted[idx - 1]).element;
            }
            this.sortByIndex = true;
            Arrays.sort(sorted);
            this.sortByIndex = false;
            if (toAdd.element == null) {
                return pkgLoc;
            }
            int result = toAdd.element.getEndOffset();
            return result;
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return 0;
        }
    }

    private String maybeStripPackage(Type type, Set imps) {
        String typeName;
        int idx;
        if (!this.isImported(type)) {
            imps.add(type);
        }
        if ((idx = (typeName = type.getName()).lastIndexOf(".")) != -1) {
            typeName = typeName.substring(idx + 1);
        }
        return typeName;
    }

    private boolean isImported(Type type) {
        String typeName = type.getName();
        if (typeName.indexOf("java.lang.") == 0 && typeName.lastIndexOf(".") == 9) {
            return true;
        }
        if (JUtils.isPrimitiveTypeName(typeName)) {
            return true;
        }
        Resource r = JavaModel.getResource((FileObject)this.jdo.getPrimaryFile());
        List imps = r.getImports();
        String pkgpart = typeName;
        if (pkgpart.indexOf(".") != -1) {
            int idx = pkgpart.lastIndexOf(".");
            pkgpart = pkgpart.substring(0, idx);
        }
        Iterator i = imps.iterator();
        while (i.hasNext()) {
            Import imp = (Import)i.next();
            String imported = imp.getImportedNamespace().getName();
            if (imported.equals(typeName)) {
                return true;
            }
            if (!typeName.startsWith(pkgpart) || typeName.lastIndexOf(".") != pkgpart.length() || !imported.equals(pkgpart)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.target.isValid() && (this.m.getModifiers() & 0x10) == 0 && !this.isSerializationMethod() && (this.m.getModifiers() & 2) == 0 && !this.isSerializationMethod() && this.jdo.getCookie(OpenCookie.class) != null && this.jdo.getPrimaryFile().canWrite() && !JUtils.overridesMethod(this.target, this.m) && !this.originIsTarget();
    }

    private boolean originIsTarget() {
        return this.m.getDeclaringClass() == this.target;
    }

    private boolean isSerializationMethod() {
        return "readObject".equals(this.m.getName()) || "writeObject".equals(this.m.getName()) || "readExternal".equals(this.m.getName()) || "writeExternal".equals(this.m.getName());
    }

    private final class ImpInfo
    implements Comparable {
        int idx;
        final String s;
        Element element;

        public ImpInfo(String s, int idx, Element e) {
            this.s = s;
            this.idx = idx;
            this.element = e;
        }

        public int compareTo(Object o) {
            return OverrideAction.this.sortByIndex ? this.idx - ((ImpInfo)o).idx : this.toString().compareTo(o.toString());
        }

        public String toString() {
            return this.s;
        }
    }
}

