/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.navigation.jmi.JUtils;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public final class OpenAction
extends AbstractAction {
    private final Element elem;
    private static final JavaMetamodel jmm = JavaMetamodel.getManager();
    private static final MDRepository repo = JavaModel.getJavaRepository();

    private OpenAction(Element elem) {
        this.elem = elem;
        this.putValue("Name", NbBundle.getMessage((Class)OpenAction.class, (String)"LBL_Goto"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent ev) {
        boolean isSourceAvailable = false;
        repo.beginTrans(false);
        try {
            if (!this.elem.isValid()) {
                return;
            }
            ClassDefinition declaringClass = this.elem instanceof ClassDefinition ? (ClassDefinition)this.elem : ((Feature)this.elem).getDeclaringClass();
            isSourceAvailable = JUtils.getSourceForBinary(declaringClass) != null;
        }
        finally {
            repo.endTrans();
        }
        if (isSourceAvailable) {
            OpenAction.openElement(this.elem);
        } else {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)OpenAction.class, (String)"MSG_NoSource", (Object)this.elem));
        }
    }

    public boolean isEnabled() {
        return this.elem != null;
    }

    public static Action createOpenAction(Object o) {
        Resource r;
        List classifs;
        o = JUtils.unwrap(o);
        Element elem = null;
        if (o instanceof Element) {
            elem = (Element)o;
        } else if (o instanceof JavaDataObject && (classifs = (r = JavaModel.getResource((FileObject)((JavaDataObject)o).getPrimaryFile())).getClassifiers()) != null && classifs.size() > 0) {
            elem = (JavaClass)classifs.get(0);
        }
        return new OpenAction(elem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean openElement(final Element element) {
        repo.beginTrans(false);
        try {
            Resource resource;
            Resource resource2 = resource = element.isValid() ? element.getResource() : null;
            if (resource != null) {
                EditorCookie.Observable ec;
                JavaModel.setClassPath((Resource)resource);
                DataObject dob = jmm.getDataObject(resource);
                if (dob != null && (ec = (EditorCookie.Observable)dob.getCookie(EditorCookie.Observable.class)) != null) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)OpenAction.class, (String)"MSG_OpeningElement", (Object)(element instanceof NamedElement ? ((NamedElement)element).getName() : "")));
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JEditorPane[] panes = ec.getOpenedPanes();
                            if (panes != null && panes.length > 0) {
                                OpenAction.selectElementInPane(panes[0], element, false);
                            } else {
                                ec.addPropertyChangeListener(new PropertyChangeListener(){

                                    public void propertyChange(PropertyChangeEvent evt) {
                                        if ("openedPanes".equals(evt.getPropertyName())) {
                                            JEditorPane[] panes = ec.getOpenedPanes();
                                            if (panes != null && panes.length > 0) {
                                                OpenAction.selectElementInPane(panes[0], element, true);
                                            }
                                            ec.removePropertyChangeListener((PropertyChangeListener)this);
                                        }
                                    }
                                });
                                ec.open();
                            }
                        }
                    });
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            repo.endTrans(false);
        }
        return false;
    }

    private static void selectElementInPane(final JEditorPane pane, final Element element, boolean delayProcessing) {
        if (delayProcessing) {
            pane.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            OpenAction.jumpToElement(pane, element);
                        }
                    });
                    pane.removeFocusListener(this);
                }
            });
        } else {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    OpenAction.jumpToElement(pane, element);
                }
            });
            Container temp = pane;
            while (!(temp instanceof TopComponent)) {
                temp = temp.getParent();
            }
            ((TopComponent)temp).requestActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void jumpToElement(JEditorPane pane, Element element) {
        int caretPos = pane.getCaretPosition();
        Container parent = pane.getParent();
        Point viewPos = parent instanceof JViewport ? ((JViewport)parent).getViewPosition() : null;
        PositionBounds bounds = null;
        repo.beginTrans(false);
        try {
            if (element.isValid()) {
                JavaModel.setClassPath((Resource)element.getResource());
                bounds = jmm.getElementPosition(element);
            }
        }
        finally {
            repo.endTrans(false);
        }
        if (bounds != null && pane.getCaretPosition() == caretPos && (viewPos == null || viewPos.equals(((JViewport)parent).getViewPosition()))) {
            pane.setCaretPosition(bounds.getBegin().getOffset());
        }
        StatusDisplayer.getDefault().setStatusText("");
    }
}

