/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.java.navigation.base.FiltersDescription;
import org.netbeans.modules.java.navigation.base.FiltersManager;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public final class FilterSubmenuAction
extends AbstractAction
implements Presenter.Popup {
    private static final String PROP_FILTER_NAME = "nbFilterName";
    private FiltersManager filters;

    public FilterSubmenuAction(FiltersManager filters) {
        this.filters = filters;
    }

    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)source;
            String filterName = (String)menuItem.getClientProperty(PROP_FILTER_NAME);
            this.filters.setSelected(filterName, menuItem.isSelected());
        }
    }

    public final JMenuItem getPopupPresenter() {
        return this.createSubmenu();
    }

    private JMenuItem createSubmenu() {
        FiltersDescription filtersDesc = this.filters.getDescription();
        JMenu menu = new JMenu(NbBundle.getMessage((Class)FilterSubmenuAction.class, (String)"LBL_FilterSubmenu"));
        JCheckBoxMenuItem menuItem = null;
        String filterName = null;
        for (int i = 0; i < filtersDesc.getFilterCount(); ++i) {
            filterName = filtersDesc.getName(i);
            menuItem = new JCheckBoxMenuItem(filtersDesc.getDisplayName(i), this.filters.isSelected(filterName));
            menuItem.addActionListener(this);
            menuItem.putClientProperty(PROP_FILTER_NAME, filterName);
            ((Container)menu).add(menuItem);
        }
        return menu;
    }
}

