/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.rename;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.rename.AbstractRenameRefactoringElement;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.model.FunctionType;
import org.netbeans.modules.web.taglib.model.ListenerType;
import org.netbeans.modules.web.taglib.model.TagType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.taglib.model.ValidatorType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public final class TldRenameRefactoring {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.rename");

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, String newName, RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        if (!(refObject instanceof JavaClass)) return problem;
        JavaClass jClass = (JavaClass)refObject;
        String name = jClass.getName();
        err.log("name: " + name);
        newName = name.substring(0, name.lastIndexOf(46) + 1) + newName;
        err.log("newName: " + newName);
        Resource res = jClass.getResource();
        FileObject fo = JavaModel.getFileObject((Resource)res);
        WebModule wm = WebModule.getWebModule((FileObject)fo);
        if (wm == null) return problem;
        FileObject webInf = wm.getWebInf();
        Enumeration e = null;
        if (webInf != null) {
            e = webInf.getChildren(true);
        }
        if (e == null) return problem;
        while (e.hasMoreElements()) {
            FileObject tld = (FileObject)e.nextElement();
            if (!this.isTld(tld)) continue;
            DataObject tldData = null;
            try {
                tldData = DataObject.find((FileObject)tld);
            }
            catch (DataObjectNotFoundException dne) {
                // empty catch block
            }
            if (tldData == null || !(tldData instanceof TLDDataObject)) continue;
            Taglib taglib = null;
            try {
                taglib = ((TLDDataObject)tldData).getTaglib();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (taglib != null) {
                void var20_30;
                ListenerType[] listenerTypes;
                String validatorClass;
                ValidatorType validatorType;
                FunctionType[] functionTypes;
                TagType[] tagTypes = taglib.getTag();
                if (tagTypes != null && tagTypes.length > 0) {
                    for (int tt = 0; tt < tagTypes.length; ++tt) {
                        String string;
                        TagType tagT = tagTypes[tt];
                        String tagClass = tagT.getTagClass();
                        if (tagClass != null && tagClass.equals(name)) {
                            TaglibTagClassRenameRefactoringElement taglibTagClassRenameRefactoringElement = new TaglibTagClassRenameRefactoringElement(taglib, name, newName, tagT, tld);
                            refactoringElements.add(refactoring, (RefactoringElementImplementation)taglibTagClassRenameRefactoringElement);
                        }
                        if ((string = tagT.getTeiClass()) == null || !string.equals(name)) continue;
                        TaglibTeiClassRenameRefactoringElement taglibTeiClassRenameRefactoringElement = new TaglibTeiClassRenameRefactoringElement(taglib, name, newName, tagT, tld);
                        refactoringElements.add(refactoring, (RefactoringElementImplementation)taglibTeiClassRenameRefactoringElement);
                    }
                }
                if ((functionTypes = taglib.getFunction()) != null && functionTypes.length > 0) {
                    for (int tt = 0; tt < functionTypes.length; ++tt) {
                        FunctionType functionT = functionTypes[tt];
                        String string = functionT.getFunctionClass();
                        if (string == null || !string.equals(name)) continue;
                        TaglibFunctionClassRenameRefactoringElement taglibFunctionClassRenameRefactoringElement = new TaglibFunctionClassRenameRefactoringElement(taglib, name, newName, functionT, tld);
                        refactoringElements.add(refactoring, (RefactoringElementImplementation)taglibFunctionClassRenameRefactoringElement);
                    }
                }
                if ((validatorType = taglib.getValidator()) != null && (validatorClass = validatorType.getValidatorClass()) != null && validatorClass.equals(name)) {
                    TaglibValidatorClassRenameRefactoringElement taglibValidatorClassRenameRefactoringElement = new TaglibValidatorClassRenameRefactoringElement(taglib, name, newName, validatorType, tld);
                    refactoringElements.add(refactoring, (RefactoringElementImplementation)taglibValidatorClassRenameRefactoringElement);
                }
                if ((listenerTypes = taglib.getListener()) == null || listenerTypes.length <= 0) continue;
                boolean bl = false;
                while (var20_30 < listenerTypes.length) {
                    ListenerType listenerType = listenerTypes[var20_30];
                    String listenerClass = listenerType.getListenerClass();
                    if (listenerClass != null && listenerClass.equals(name)) {
                        TaglibListenerClassRenameRefactoringElement elem = new TaglibListenerClassRenameRefactoringElement(taglib, name, newName, listenerType, tld);
                        refactoringElements.add(refactoring, (RefactoringElementImplementation)elem);
                    }
                    ++var20_30;
                }
                continue;
            }
            Object[] args = new Object[]{tld.getNameExt()};
            String msg = MessageFormat.format(NbBundle.getMessage(TldRenameRefactoring.class, (String)"TXT_TaglibRenameInvalidProblem"), args);
            Problem newProblem = new Problem(false, msg);
            problem = Utility.addProblemsToEnd(problem, newProblem);
        }
        return problem;
    }

    private boolean isTld(FileObject fo) {
        String ext;
        boolean isTld = false;
        if (fo != null && "tld".equalsIgnoreCase(ext = fo.getExt())) {
            isTld = true;
        }
        return isTld;
    }

    public final class TaglibListenerClassRenameRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        protected Taglib tld;
        private ListenerType listenerType;

        public TaglibListenerClassRenameRefactoringElement(Taglib tld, String oldName, String newName, ListenerType listenerType, FileObject parentFile) {
            this.tld = tld;
            this.oldName = oldName;
            this.newName = newName;
            this.listenerType = listenerType;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(TldRenameRefactoring.class, (String)"TXT_TaglibListenerClassRename"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            this.listenerType.setListenerClass(this.newName);
            try {
                TLDDataObject tdo = (TLDDataObject)DataObject.find((FileObject)this.parentFile);
                if (tdo != null) {
                    tdo.write(this.tld);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void undoExternalChange() {
            this.listenerType.setListenerClass(this.oldName);
            try {
                TLDDataObject tdo = (TLDDataObject)DataObject.find((FileObject)this.parentFile);
                if (tdo != null) {
                    tdo.write(this.tld);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final class TaglibValidatorClassRenameRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        protected Taglib tld;
        private ValidatorType validatorType;

        public TaglibValidatorClassRenameRefactoringElement(Taglib tld, String oldName, String newName, ValidatorType validatorType, FileObject parentFile) {
            this.tld = tld;
            this.oldName = oldName;
            this.newName = newName;
            this.validatorType = validatorType;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(TldRenameRefactoring.class, (String)"TXT_TaglibValidatorClassRename"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            this.validatorType.setValidatorClass(this.newName);
            try {
                TLDDataObject tdo = (TLDDataObject)DataObject.find((FileObject)this.parentFile);
                if (tdo != null) {
                    tdo.write(this.tld);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void undoExternalChange() {
            this.validatorType.setValidatorClass(this.oldName);
            try {
                TLDDataObject tdo = (TLDDataObject)DataObject.find((FileObject)this.parentFile);
                if (tdo != null) {
                    tdo.write(this.tld);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final class TaglibFunctionClassRenameRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        protected Taglib tld;
        private FunctionType functionType;

        public TaglibFunctionClassRenameRefactoringElement(Taglib tld, String oldName, String newName, FunctionType functionType, FileObject parentFile) {
            this.tld = tld;
            this.oldName = oldName;
            this.newName = newName;
            this.functionType = functionType;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(TldRenameRefactoring.class, (String)"TXT_TaglibFunctionClassRename"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            this.functionType.setFunctionClass(this.newName);
            try {
                TLDDataObject tdo = (TLDDataObject)DataObject.find((FileObject)this.parentFile);
                if (tdo != null) {
                    tdo.write(this.tld);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void undoExternalChange() {
            this.functionType.setFunctionClass(this.oldName);
            try {
                TLDDataObject tdo = (TLDDataObject)DataObject.find((FileObject)this.parentFile);
                if (tdo != null) {
                    tdo.write(this.tld);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final class TaglibTeiClassRenameRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        protected Taglib tld;
        private TagType tagType;

        public TaglibTeiClassRenameRefactoringElement(Taglib tld, String oldName, String newName, TagType tagType, FileObject parentFile) {
            this.tld = tld;
            this.oldName = oldName;
            this.newName = newName;
            this.tagType = tagType;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(TldRenameRefactoring.class, (String)"TXT_TaglibTeiClassRename"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            this.tagType.setTeiClass(this.newName);
            try {
                TLDDataObject tdo = (TLDDataObject)DataObject.find((FileObject)this.parentFile);
                if (tdo != null) {
                    tdo.write(this.tld);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void undoExternalChange() {
            this.tagType.setTeiClass(this.oldName);
            try {
                TLDDataObject tdo = (TLDDataObject)DataObject.find((FileObject)this.parentFile);
                if (tdo != null) {
                    tdo.write(this.tld);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final class TaglibTagClassRenameRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        protected Taglib tld;
        private TagType tagType;

        public TaglibTagClassRenameRefactoringElement(Taglib tld, String oldName, String newName, TagType tagType, FileObject parentFile) {
            this.tld = tld;
            this.oldName = oldName;
            this.newName = newName;
            this.tagType = tagType;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(TldRenameRefactoring.class, (String)"TXT_TaglibTagClassRename"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            this.tagType.setTagClass(this.newName);
            try {
                TLDDataObject tdo = (TLDDataObject)DataObject.find((FileObject)this.parentFile);
                if (tdo != null) {
                    tdo.write(this.tld);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void undoExternalChange() {
            this.tagType.setTagClass(this.oldName);
            try {
                TLDDataObject tdo = (TLDDataObject)DataObject.find((FileObject)this.parentFile);
                if (tdo != null) {
                    tdo.write(this.tld);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

