/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.rename;

import java.text.MessageFormat;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.JaxWsXmlRefactoringElementSupport;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.JaxWsXmlRefactoringSupport;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JaxWsXmlRenameRefactoring
extends JaxWsXmlRefactoringSupport {
    public Problem prepare(AbstractRefactoring refactor, RefObject refObject, String newName, RefactoringElementsBag refactoringElements) {
        if (!(refObject instanceof JavaClass) || !this.isWebSvcFromWsdl((JavaClass)refObject)) {
            return null;
        }
        JavaClass javaClass = (JavaClass)refObject;
        JaxWsModel model = this.getModel(javaClass);
        if (model == null) {
            return null;
        }
        newName = Utility.renameClass(javaClass.getName(), newName);
        Service service = model.findServiceByImplementationClass(javaClass.getName());
        if (service != null) {
            JaxWsXmlRenameRefactoringElement refactoringElem = new JaxWsXmlRenameRefactoringElement(javaClass.getName(), newName, model, service, model.getJaxWsFile());
            refactoringElements.add(refactor, (RefactoringElementImplementation)refactoringElem);
        }
        return null;
    }

    private static class JaxWsXmlRenameRefactoringElement
    extends JaxWsXmlRefactoringElementSupport {
        public JaxWsXmlRenameRefactoringElement(String oldName, String newName, JaxWsModel model, Service service, FileObject parentFile) {
            super(oldName, newName, model, service, parentFile);
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(JaxWsXmlRenameRefactoring.class, (String)"TXT_JaxWsXmlRename"), args);
        }
    }
}

