/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.changeparam;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.MethodParams;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.j2ee.dd.api.ejb.QueryMethod;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.changeparam.AbstractChangeParamsRefactoringElement;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class EjbJarChangeParamRefactoring {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.changeparam");
    private boolean isCmpImplFinder = false;
    private boolean isCmpLocalHomeFinder = false;
    private boolean isCmpHomeFinder = false;
    ArrayList ifaceRefactors = new ArrayList();
    ArrayList implRefactors = new ArrayList();
    private static final String METHOD_EJBCREATE = "ejbCreate";

    public Problem preCheck(RefObject refObject) {
        Method method;
        Collection emodules;
        Problem[] problem = new Problem[]{null};
        if (refObject instanceof Method && (emodules = Utility.getRelevantEjbModules((Element)(method = (Method)refObject))) != null && emodules.size() > 0) {
            ClassDefinition declaringClass = method.getDeclaringClass();
            err.log("classdefinition jc: " + declaringClass);
            if (declaringClass instanceof JavaClass) {
                FileObject fo = JavaModel.getFileObject((Resource)method.getResource());
                if (Utility.isSubTypeOf(declaringClass, "javax.ejb.SessionBean")) {
                    this.checkSessionBeanImpl(problem, method, fo, declaringClass);
                } else if (Utility.isSubTypeOf(declaringClass, "javax.ejb.EntityBean")) {
                    this.checkEntityBeanImpl(problem, method, fo, declaringClass);
                } else if (Utility.isSubTypeOf(declaringClass, "javax.ejb.MessageDrivenBean")) {
                    this.checkMessageDrivenBeanImpl(problem, method, declaringClass);
                } else if (Utility.isSubTypeOf(declaringClass, "javax.ejb.EJBHome")) {
                    this.checkHomeInterface(problem, method, fo, declaringClass, false);
                } else if (Utility.isSubTypeOf(declaringClass, "javax.ejb.EJBLocalHome")) {
                    this.checkHomeInterface(problem, method, fo, declaringClass, true);
                }
            }
        }
        return problem[0];
    }

    private void checkSessionBeanImpl(Problem[] problem, Method method, FileObject fo, ClassDefinition jc) {
        if (Utility.isSignatureFromSessionBeanInterface(method)) {
            this.addFatalProblem(problem, "TXT_EjbJarMethodInJavaxInterfaceProblemChangeParam", "javax.ejb.SessionBean");
        } else if (!this.checkCreateInSession(problem, fo, method)) {
            String className = jc.getName();
            Method homeInHome = Utility.getHomeHomeMethodForSessionImplHomeMethod(method, fo, className, false);
            this.checkMethodInInterface(problem, homeInHome, "home");
            Method homeInLocalHome = Utility.getHomeHomeMethodForSessionImplHomeMethod(method, fo, className, true);
            this.checkMethodInInterface(problem, homeInLocalHome, "local home");
        }
    }

    private void checkEntityBeanImpl(Problem[] problem, Method method, FileObject fo, ClassDefinition jc) {
        if (Utility.isSignatureFromEntityBeanInterface(method)) {
            this.addFatalProblem(problem, "TXT_EjbJarMethodInJavaxInterfaceProblemChangeParam", "javax.ejb.EntityBean");
        } else {
            String className = jc.getName();
            String methodName = method.getName();
            if (methodName.startsWith(METHOD_EJBCREATE)) {
                Method createInHome = Utility.getHomeCreateMethodForEntityImplCreateMethod(method, fo, className, false);
                this.checkMethodInInterface(problem, createInHome, "home");
                Method createInLocalHome = Utility.getHomeCreateMethodForEntityImplCreateMethod(method, fo, className, true);
                this.checkMethodInInterface(problem, createInLocalHome, "local home");
                Method postCreateInImpl = Utility.getImplPostCreateMethodForEntityImplCreateMethod(method);
                this.checkMethodInImpl(problem, postCreateInImpl, "TXT_EjbJarPostCreateMethodWarningChangeParam");
            } else if (methodName.equals("ejbPostCreate")) {
                Method createInHome = Utility.getHomeCreateMethodForEntityImplPostCreateMethod(method, fo, className, false);
                this.checkMethodInInterface(problem, createInHome, "home");
                Method createInLocalHome = Utility.getHomeCreateMethodForEntityImplPostCreateMethod(method, fo, className, true);
                this.checkMethodInInterface(problem, createInLocalHome, "local home");
                Method createInImpl = Utility.getImplCreateMethodForEntityImplPostCreateMethod(method);
                this.checkMethodInImpl(problem, createInImpl, "TXT_EjbJarCreateMethodWarningChangeParam");
            } else if (methodName.startsWith("ejbFind")) {
                this.isCmpImplFinder = true;
                Method finderInHome = Utility.getHomeFinderMethodForImplFinderMethod(method, fo, className, false);
                this.checkMethodInInterface(problem, finderInHome, "home");
                Method finderInLocalHome = Utility.getHomeFinderMethodForImplFinderMethod(method, fo, className, true);
                this.checkMethodInInterface(problem, finderInLocalHome, "local home");
            } else {
                Method homeInHome = Utility.getHomeHomeMethodForEntityImplHomeMethod(method, fo, className, false);
                this.checkMethodInInterface(problem, homeInHome, "home");
                Method homeInLocalHome = Utility.getHomeHomeMethodForEntityImplHomeMethod(method, fo, className, true);
                this.checkMethodInInterface(problem, homeInLocalHome, "local home");
            }
        }
    }

    private void checkMessageDrivenBeanImpl(Problem[] problem, Method method, ClassDefinition jc) {
        if (Utility.isSignatureFromMessageDrivenBeanInterface(method)) {
            this.addFatalProblem(problem, "TXT_EjbJarMethodInJavaxInterfaceProblemChangeParam", "javax.ejb.MessageDrivenBean");
        }
        if (jc.isSubTypeOf((ClassDefinition)Utility.resolveRealClass("javax.jms.MessageListener")) && Utility.isSignatureFromMessageListenerInterface(method)) {
            this.addFatalProblem(problem, "TXT_EjbJarMethodInJavaxInterfaceProblemChangeParam", "javax.jms.MessageListener");
        }
    }

    private void addFatalProblem(Problem[] problem, String resName, String param) {
        String msg = NbBundle.getMessage(EjbJarChangeParamRefactoring.class, (String)resName, (Object)param);
        problem[0] = Utility.addProblemsToEnd(problem[0], new Problem(true, msg));
    }

    private void checkHomeInterface(Problem[] problem, Method method, FileObject fo, ClassDefinition classDefinition, boolean local) {
        String methodName = method.getName();
        String className = classDefinition.getName();
        if (methodName.startsWith("create")) {
            Method createInImpl = Utility.getImplCreateMethodForHomeCreateMethod(method, fo, className, local);
            if (this.checkCreateInSession(problem, fo, createInImpl)) {
                return;
            }
            this.checkMethodInImpl(problem, createInImpl);
            Method createInHome = Utility.getHomeCreateMethodForHomeCreateMethod(method, fo, className, !local);
            this.checkMethodInInterface(problem, createInHome);
            Method postCreateInImpl = Utility.getImplPostCreateMethodForHomeCreateMethod(method, fo, className, local);
            this.checkMethodInImpl(problem, postCreateInImpl);
        } else if (methodName.startsWith("find")) {
            if (local) {
                this.isCmpLocalHomeFinder = true;
            } else {
                this.isCmpHomeFinder = true;
            }
            Method finderInImpl = Utility.getImplFinderMethodForHomeFinderMethod(method, fo, className, local);
            this.checkMethodInImpl(problem, finderInImpl);
            Method finderInHome = Utility.getHomeFinderMethodForHomeFinderMethod(method, fo, className, !local);
            this.checkMethodInInterface(problem, finderInHome);
        } else {
            Method homeInImpl = Utility.getImplHomeMethodForHomeHomeMethod(method, fo, className, local);
            this.checkMethodInImpl(problem, homeInImpl);
            Method homeInHome = Utility.getHomeHomeMethodForHomeHomeMethod(method, fo, className, !local);
            this.checkMethodInInterface(problem, homeInHome);
        }
    }

    private boolean checkCreateInSession(Problem[] problem, FileObject fo, Method createInImpl) {
        if (createInImpl == null || !createInImpl.getName().equals(METHOD_EJBCREATE)) {
            return false;
        }
        ClassDefinition implClass = createInImpl.getDeclaringClass();
        if (!Utility.isSubTypeOf(implClass, "javax.ejb.SessionBean")) {
            return false;
        }
        List parameters = createInImpl.getParameters();
        if (parameters != null && parameters.size() > 0) {
            return false;
        }
        EnterpriseBeans enterpriseBeans = Utility.getEnterpriseBeansFromDD(fo);
        if (enterpriseBeans == null) {
            return false;
        }
        Session[] sessions = enterpriseBeans.getSession();
        if (sessions == null) {
            return false;
        }
        for (int i = 0; i < sessions.length; ++i) {
            Session session = sessions[i];
            String className = implClass.getName();
            if (!session.getEjbClass().equals(className)) continue;
            if ("Stateless".equals(session.getSessionType())) {
                String msg = NbBundle.getMessage(EjbJarChangeParamRefactoring.class, (String)"TXT_EjbJarCreateMethodErrorChangeParam");
                problem[0] = Utility.addProblemsToEnd(problem[0], new Problem(true, msg));
                return true;
            }
            Method createInHome = Utility.getMethodInHomeClassForImpl(fo, Session.class, className, "create", parameters, false);
            this.checkMethodInInterface(problem, createInHome, "home");
            Method createInLocalHome = Utility.getMethodInHomeClassForImpl(fo, Session.class, className, "create", parameters, true);
            this.checkMethodInInterface(problem, createInLocalHome, "local home");
            return true;
        }
        return false;
    }

    private boolean checkMethod(List refactorings, Problem[] problem, Method method, String resName, String param) {
        if (method != null) {
            ChangeParametersRefactoring refactoring = new ChangeParametersRefactoring((Object)method);
            problem[0] = Utility.addProblemsToEnd(problem[0], refactoring.preCheck());
            refactorings.add(refactoring);
            if (resName != null) {
                String msg = param != null ? NbBundle.getMessage(EjbJarChangeParamRefactoring.class, (String)resName, (Object)param) : NbBundle.getMessage(EjbJarChangeParamRefactoring.class, (String)resName);
                problem[0] = Utility.addProblemsToEnd(problem[0], new Problem(false, msg));
            }
            return true;
        }
        return false;
    }

    private boolean checkMethodInImpl(Problem[] problem, Method method) {
        return this.checkMethod(this.implRefactors, problem, method, null, null);
    }

    private void checkMethodInImpl(Problem[] problem, Method postCreateInImpl, String resName) {
        this.checkMethod(this.implRefactors, problem, postCreateInImpl, resName, null);
    }

    private boolean checkMethodInInterface(Problem[] problem, Method method) {
        return this.checkMethod(this.ifaceRefactors, problem, method, null, null);
    }

    private boolean checkMethodInInterface(Problem[] problem, Method method, String interfaceName) {
        return this.checkMethod(this.ifaceRefactors, problem, method, "TXT_EjbJarIfaceMethodWarningChangeParam", interfaceName);
    }

    public Problem fastCheckParameters(RefObject refObject) {
        return null;
    }

    public Problem checkParameters(RefObject refObject) {
        return this.fastCheckParameters(refObject);
    }

    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, ChangeParametersRefactoring.ParameterInfo[] paramInfo, int modifier, RefactoringElementsBag refactoringElements) {
        RefactoringSession session = refactoringElements.getSession();
        Problem problem = null;
        if (refObject instanceof Method) {
            int i;
            Method method = (Method)refObject;
            if (EjbJarChangeParamRefactoring.isChanged(method, paramInfo)) {
                this.processFinderMethods(refactoring, method, paramInfo, refactoringElements);
            }
            for (i = 0; i < this.ifaceRefactors.size(); ++i) {
                problem = this.prepareRefactoring((ChangeParametersRefactoring)this.ifaceRefactors.get(i), modifier, paramInfo, session, problem);
            }
            for (i = 0; i < this.implRefactors.size(); ++i) {
                problem = this.prepareRefactoring((ChangeParametersRefactoring)this.implRefactors.get(i), modifier, paramInfo, session, problem);
            }
        }
        return problem;
    }

    private void processFinderMethods(AbstractRefactoring refactoring, Method method, ChangeParametersRefactoring.ParameterInfo[] paramInfo, RefactoringElementsBag refactoringElements) {
        if (this.isCmpImplFinder || this.isCmpHomeFinder || this.isCmpLocalHomeFinder) {
            String methodName = method.getName();
            if (this.isCmpImplFinder) {
                methodName = methodName.substring(9, 10).toLowerCase() + methodName.substring(10);
            }
            err.log("method name: " + methodName);
            FileObject fo = JavaModel.getFileObject((Resource)method.getResource());
            if (fo == null) {
                return;
            }
            Project prj = FileOwnerQuery.getOwner((FileObject)fo);
            if (prj == null) {
                return;
            }
            EjbJar emod = EjbJar.getEjbJar((FileObject)prj.getProjectDirectory());
            ClassDefinition declaringClass = method.getDeclaringClass();
            err.log("classdefinition jc: " + declaringClass);
            if (declaringClass instanceof JavaClass) {
                Entity[] eBeans = Utility.getEntityBeans(emod);
                org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD = Utility.getEjbJar(emod);
                if (eBeans != null && ejbJarDD != null) {
                    for (int i = 0; i < eBeans.length; ++i) {
                        Entity entity = eBeans[i];
                        if (this.isCmpImplFinder) {
                            this.prepareQueries(declaringClass, entity.getEjbClass(), entity, methodName, ejbJarDD, paramInfo, emod, refactoringElements, refactoring);
                            continue;
                        }
                        if (this.isCmpHomeFinder) {
                            this.prepareQueries(declaringClass, entity.getHome(), entity, methodName, ejbJarDD, paramInfo, emod, refactoringElements, refactoring);
                        }
                        if (!this.isCmpLocalHomeFinder) continue;
                        this.prepareQueries(declaringClass, entity.getLocalHome(), entity, methodName, ejbJarDD, paramInfo, emod, refactoringElements, refactoring);
                    }
                }
            }
        }
    }

    private Problem prepareRefactoring(ChangeParametersRefactoring chr, int modifier, ChangeParametersRefactoring.ParameterInfo[] paramInfo, RefactoringSession session, Problem problem) {
        chr.setModifiers(modifier);
        chr.setParameterInfo(paramInfo);
        Problem p = chr.prepare(session);
        problem = Utility.addProblemsToEnd(problem, p);
        return problem;
    }

    private void prepareQueries(ClassDefinition jc, String ejbClass, Entity entity, String methodName, org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD, ChangeParametersRefactoring.ParameterInfo[] paramInfo, EjbJar emod, RefactoringElementsBag refactoringElements, AbstractRefactoring refactoring) {
        if (jc.getName().equals(ejbClass)) {
            Query[] queries = entity.getQuery();
            for (int q = 0; q < queries.length; ++q) {
                QueryMethod qm = queries[q].getQueryMethod();
                err.log("query method: " + qm);
                if (!methodName.equals(qm.getMethodName())) continue;
                EjbJarFinderMethodChangeParamsRefactoringElement elem = new EjbJarFinderMethodChangeParamsRefactoringElement(ejbJarDD, methodName, paramInfo, entity, emod.getDeploymentDescriptor());
                refactoringElements.add(refactoring, (RefactoringElementImplementation)elem);
            }
        }
    }

    private static boolean isChanged(Method method, ChangeParametersRefactoring.ParameterInfo[] paramInfo) {
        if (paramInfo != null) {
            if (paramInfo.length < method.getParameters().size()) {
                return true;
            }
            if (paramInfo.length > 0) {
                for (int i = 0; i < paramInfo.length; ++i) {
                    ChangeParametersRefactoring.ParameterInfo pi = paramInfo[i];
                    if (pi.getDefaultValue() == null && pi.getOriginalIndex() == i && pi.getType() == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static String[] getNewParameters(ChangeParametersRefactoring.ParameterInfo[] paramInfo, String[] methodParams) {
        String[] newParams = new String[paramInfo.length];
        if (paramInfo != null && paramInfo.length > 0) {
            for (int i = 0; i < paramInfo.length; ++i) {
                ChangeParametersRefactoring.ParameterInfo pi = paramInfo[i];
                Type newParamType = pi.getType();
                newParams[i] = newParamType == null ? methodParams[pi.getOriginalIndex()] : newParamType.getName();
            }
        }
        return newParams;
    }

    public final class EjbJarFinderMethodChangeParamsRefactoringElement
    extends AbstractChangeParamsRefactoringElement
    implements ExternalChange {
        protected org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD;
        private Entity entity;
        private String[] oldParams = new String[0];

        public EjbJarFinderMethodChangeParamsRefactoringElement(org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD, String methodName, ChangeParametersRefactoring.ParameterInfo[] paramInfo, Entity entity, FileObject parentFile) {
            this.ejbJarDD = ejbJarDD;
            this.entity = entity;
            this.methodName = methodName;
            this.paramInfo = paramInfo;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.methodName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarChangeParamRefactoring.class, (String)"TXT_EjbJarFinderMethodChangeParam"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            Query[] queries = this.entity.getQuery();
            for (int q = 0; q < queries.length; ++q) {
                QueryMethod qm = queries[q].getQueryMethod();
                if (!this.methodName.equals(qm.getMethodName())) continue;
                MethodParams mp = qm.getMethodParams();
                if (mp != null) {
                    this.oldParams = mp.getMethodParam();
                    String[] newParams = EjbJarChangeParamRefactoring.getNewParameters(this.paramInfo, this.oldParams);
                    if (newParams != null) {
                        mp.setMethodParam(newParams);
                    }
                }
                try {
                    this.ejbJarDD.write(this.parentFile);
                    continue;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }

        public void undoExternalChange() {
            Query[] queries = this.entity.getQuery();
            for (int q = 0; q < queries.length; ++q) {
                QueryMethod qm = queries[q].getQueryMethod();
                if (!this.methodName.equals(qm.getMethodName())) continue;
                MethodParams mp = qm.getMethodParams();
                if (mp != null && this.oldParams != null) {
                    mp.setMethodParam(this.oldParams);
                }
                try {
                    this.ejbJarDD.write(this.parentFile);
                    continue;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }
}

