/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.ui.support;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.netbeans.modules.project.uiapi.CategoryChangeSupport;
import org.netbeans.modules.project.uiapi.CategoryModel;
import org.netbeans.modules.project.uiapi.CategoryView;
import org.netbeans.modules.project.uiapi.CustomizerDialog;
import org.netbeans.modules.project.uiapi.CustomizerPane;
import org.netbeans.modules.project.uiapi.Utilities;
import org.openide.util.HelpCtx;

public final class ProjectCustomizer {
    private ProjectCustomizer() {
    }

    public static Dialog createCustomizerDialog(Category[] categories, CategoryComponentProvider componentProvider, String preselectedCategory, ActionListener okOptionListener, HelpCtx helpCtx) {
        CustomizerPane innerPane = ProjectCustomizer.createCustomizerPane(categories, componentProvider, preselectedCategory);
        Dialog dialog = CustomizerDialog.createDialog(okOptionListener, innerPane, helpCtx, categories);
        return dialog;
    }

    private static CustomizerPane createCustomizerPane(Category[] categories, CategoryComponentProvider componentProvider, String preselectedCategory) {
        Category c;
        CategoryChangeSupport changeSupport = new CategoryChangeSupport();
        ProjectCustomizer.registerCategoryChangeSupport(changeSupport, categories);
        CategoryModel categoryModel = new CategoryModel(categories);
        CategoryView categoryView = new CategoryView(categoryModel);
        CustomizerPane customizerPane = new CustomizerPane(categoryView, categoryModel, componentProvider);
        if (preselectedCategory == null) {
            preselectedCategory = categories[0].getName();
        }
        if ((c = categoryModel.getCategory(preselectedCategory)) != null) {
            categoryModel.setCurrentCategory(c);
        }
        return customizerPane;
    }

    private static void registerCategoryChangeSupport(CategoryChangeSupport changeSupport, Category[] categories) {
        for (int i = 0; i < categories.length; ++i) {
            Utilities.putCategoryChangeSupport(categories[i], changeSupport);
            Category[] subCategories = categories[i].getSubcategories();
            if (subCategories == null) continue;
            ProjectCustomizer.registerCategoryChangeSupport(changeSupport, subCategories);
        }
    }

    public static final class Category {
        private String name;
        private String displayName;
        private Image icon;
        private Category[] subcategories;
        private boolean valid;
        private String errorMessage;

        private Category(String name, String displayName, Image icon, Category[] subcategories) {
            this.name = name;
            this.displayName = displayName;
            this.icon = icon;
            this.subcategories = subcategories;
            this.valid = true;
        }

        public static Category create(String name, String displayName, Image icon, Category[] subcategories) {
            return new Category(name, displayName, icon, subcategories);
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Image getIcon() {
            return this.icon;
        }

        public Category[] getSubcategories() {
            return this.subcategories;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            if (this.valid != valid) {
                this.valid = valid;
                Utilities.getCategoryChangeSupport(this).firePropertyChange("isCategoryValid", !valid, valid);
            }
        }

        public void setErrorMessage(String message) {
            if (message == null) {
                message = "";
            }
            if (!message.equals(this.errorMessage)) {
                String oldMessage = this.errorMessage;
                this.errorMessage = message;
                Utilities.getCategoryChangeSupport(this).firePropertyChange("categoryErrorMessage", oldMessage, message);
            }
        }
    }

    public static interface CategoryComponentProvider {
        public JComponent create(Category var1);
    }
}

