/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.netbeans.modules.project.uiapi.Utilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerDialog {
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";

    private CustomizerDialog() {
    }

    public static Dialog createDialog(ActionListener okOptionListener, JPanel innerPane, HelpCtx helpCtx, final ProjectCustomizer.Category[] categories) {
        ListeningButton okButton = new ListeningButton(NbBundle.getMessage((Class)CustomizerDialog.class, (String)"LBL_Customizer_Ok_Option"), categories);
        okButton.setEnabled(CustomizerDialog.checkValidity(categories));
        Object[] options = new JButton[]{okButton, new JButton(NbBundle.getMessage((Class)CustomizerDialog.class, (String)"LBL_Customizer_Cancel_Option"))};
        options[0].setActionCommand(COMMAND_OK);
        options[1].setActionCommand(COMMAND_CANCEL);
        options[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)CustomizerDialog.class, (String)"AD_Customizer_Ok_Option"));
        options[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)CustomizerDialog.class, (String)"AD_Customizer_Cancel_Option"));
        OptionListener optionsListener = new OptionListener(okOptionListener);
        options[0].addActionListener(optionsListener);
        options[1].addActionListener(optionsListener);
        innerPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)CustomizerDialog.class, (String)"AN_ProjectCustomizer"));
        innerPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)CustomizerDialog.class, (String)"AD_ProjectCustomizer"));
        if (helpCtx == null) {
            helpCtx = HelpCtx.DEFAULT_HELP;
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)innerPane, NbBundle.getMessage((Class)CustomizerDialog.class, (String)"LBL_Customizer_Title"), false, options, (Object)options[0], 0, helpCtx, null);
        innerPane.addPropertyChangeListener(new HelpCtxChangeListener(dialogDescriptor, helpCtx));
        if (innerPane instanceof HelpCtx.Provider) {
            dialogDescriptor.setHelpCtx(((HelpCtx.Provider)innerPane).getHelpCtx());
        }
        dialogDescriptor.setClosingOptions(new Object[]{options[0], options[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                LinkedList<ProjectCustomizer.Category> queue = new LinkedList<ProjectCustomizer.Category>(Arrays.asList(categories));
                while (!queue.isEmpty()) {
                    ProjectCustomizer.Category category = (ProjectCustomizer.Category)queue.remove(0);
                    Utilities.removeCategoryChangeSupport(category);
                    if (category.getSubcategories() == null) continue;
                    queue.addAll(Arrays.asList(category.getSubcategories()));
                }
            }
        });
        return dialog;
    }

    private static boolean checkValidity(ProjectCustomizer.Category[] categories) {
        for (int i = 0; i < categories.length; ++i) {
            if (!categories[i].isValid()) {
                return false;
            }
            ProjectCustomizer.Category[] subCategories = categories[i].getSubcategories();
            if (subCategories == null || CustomizerDialog.checkValidity(subCategories)) continue;
            return false;
        }
        return true;
    }

    private static class ListeningButton
    extends JButton
    implements PropertyChangeListener {
        private ProjectCustomizer.Category[] categories;

        public ListeningButton(String label, ProjectCustomizer.Category[] categories) {
            super(label);
            this.categories = categories;
            for (int i = 0; i < categories.length; ++i) {
                Utilities.getCategoryChangeSupport(categories[i]).addPropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "isCategoryValid") {
                boolean valid = (Boolean)evt.getNewValue();
                this.setEnabled(valid && CustomizerDialog.checkValidity(this.categories));
            }
        }
    }

    private static class HelpCtxChangeListener
    implements PropertyChangeListener {
        DialogDescriptor dialogDescriptor;
        HelpCtx defaultHelpCtx;

        HelpCtxChangeListener(DialogDescriptor dialogDescriptor, HelpCtx defaultHelpCtx) {
            this.dialogDescriptor = dialogDescriptor;
            this.defaultHelpCtx = defaultHelpCtx;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("helpCtxProperty".equals(evt.getPropertyName())) {
                HelpCtx newHelp = (HelpCtx)evt.getNewValue();
                this.dialogDescriptor.setHelpCtx(newHelp == null || newHelp == HelpCtx.DEFAULT_HELP ? this.defaultHelpCtx : newHelp);
            }
        }
    }

    private static class OptionListener
    implements ActionListener {
        private ActionListener okOptionListener;

        OptionListener(ActionListener okOptionListener) {
            this.okOptionListener = okOptionListener;
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (CustomizerDialog.COMMAND_OK.equals(command)) {
                this.okOptionListener.actionPerformed(e);
            }
        }
    }
}

