/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.Actions;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.FreeformProjectGenerator;
import org.netbeans.modules.ant.freeform.Util;
import org.netbeans.modules.ant.freeform.ui.TargetMappingPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

public final class UnboundTargetAlert
extends JPanel {
    private final FreeformProject project;
    private final String command;
    private final String label;
    private JTextArea explanation;
    private JLabel introLabel;
    private JComboBox selectCombo;
    private JLabel selectLabel;

    public UnboundTargetAlert(FreeformProject project, String command) {
        this.project = project;
        this.command = command;
        this.label = NbBundle.getMessage((Class)Actions.class, (String)("CMD_" + command));
        this.initComponents();
        this.listTargets();
    }

    public static void main(String[] args) {
        UnboundTargetAlert alert = new UnboundTargetAlert("Twiddle Project", new String[]{"targ1", "targ2", "targ3"});
        boolean accepted = alert.displayAlert("BazzBuilder");
        System.out.println("accepted=" + accepted + " value=" + alert.selectCombo.getSelectedItem());
        System.exit(0);
    }

    private UnboundTargetAlert(String label, String[] targets) {
        this.project = null;
        this.command = null;
        this.label = label;
        this.initComponents();
        this.selectCombo.setModel(new DefaultComboBoxModel<String>(targets));
        this.selectCombo.setSelectedItem("");
    }

    private void listTargets() {
        List targets;
        FileObject script = FreeformProjectGenerator.getAntScript(this.project.helper(), this.project.evaluator());
        if (script != null && (targets = Util.getAntScriptTargetNames(script)) != null) {
            this.selectCombo.setModel(new DefaultComboBoxModel<String>(targets.toArray(new String[targets.size()])));
            this.selectCombo.setSelectedItem("");
        }
    }

    private boolean displayAlert(String projectDisplayName) {
        String title = NbBundle.getMessage((Class)UnboundTargetAlert.class, (String)"UTA_TITLE", (Object)this.label, (Object)projectDisplayName);
        final DialogDescriptor d = new DialogDescriptor((Object)this, title);
        d.setOptionType(2);
        d.setMessageType(0);
        d.setValid(false);
        this.selectCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                d.setValid(((String)UnboundTargetAlert.this.selectCombo.getSelectedItem()).trim().length() > 0);
            }
        });
        Dialog dlg = DialogDisplayer.getDefault().createDialog(d);
        this.selectCombo.requestFocusInWindow();
        Dimension sz = dlg.getSize();
        dlg.setSize(sz.width, sz.height + 30);
        dlg.setVisible(true);
        return d.getValue() == NotifyDescriptor.OK_OPTION;
    }

    public boolean accepted() throws IOException {
        String projectDisplayName = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        if (this.displayAlert(projectDisplayName)) {
            try {
                ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                    public Object run() throws IOException {
                        UnboundTargetAlert.this.generateBindingAndAddContextMenuItem();
                        ProjectManager.getDefault().saveProject((Project)UnboundTargetAlert.this.project);
                        return null;
                    }
                });
            }
            catch (MutexException e) {
                throw (IOException)e.getException();
            }
            return true;
        }
        return false;
    }

    void generateBindingAndAddContextMenuItem() {
        List mappings = FreeformProjectGenerator.getTargetMappings(this.project.helper());
        FreeformProjectGenerator.TargetMapping mapping = new FreeformProjectGenerator.TargetMapping();
        mapping.name = this.command;
        mapping.script = TargetMappingPanel.defaultAntScript(this.project.evaluator());
        mapping.targets = Collections.list(new StringTokenizer((String)this.selectCombo.getSelectedItem()));
        mappings.add(mapping);
        FreeformProjectGenerator.putTargetMappings(this.project.helper(), mappings);
        FreeformProjectGenerator.putContextMenuAction(this.project.helper(), mappings);
    }

    private void initComponents() {
        this.introLabel = new JLabel();
        this.explanation = new JTextArea();
        this.selectLabel = new JLabel();
        this.selectCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.introLabel, (String)NbBundle.getMessage((Class)UnboundTargetAlert.class, (String)"UTA_LBL_intro", (Object)this.label));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.introLabel, gridBagConstraints);
        this.explanation.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.explanation.setEditable(false);
        this.explanation.setLineWrap(true);
        this.explanation.setText(NbBundle.getMessage((Class)UnboundTargetAlert.class, (String)"UTA_TEXT_explanation", (Object)this.label));
        this.explanation.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.explanation, gridBagConstraints);
        this.selectLabel.setLabelFor(this.selectCombo);
        Mnemonics.setLocalizedText((JLabel)this.selectLabel, (String)NbBundle.getMessage((Class)UnboundTargetAlert.class, (String)"UTA_LBL_select", (Object)this.label));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.selectLabel, gridBagConstraints);
        this.selectCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.selectCombo, gridBagConstraints);
    }

    void simulateTargetSelection(String comboText) {
        this.selectCombo.setSelectedItem(comboText);
    }
}

