/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.ant.freeform.Util;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BasicProjectInfoPanel
extends JPanel
implements HelpCtx.Provider {
    private DocumentListener documentListener;
    private ChangeListener listener;
    private boolean antScriptTouched = false;
    private boolean projectFolderTouched = false;
    private boolean projectNameTouched = false;
    private boolean antScriptValidityChecked;
    private boolean ignoreEvent = false;
    private JTextField antScript;
    private JButton browseAntScript;
    private JButton browseProjectFolder;
    private JButton browseProjectLocation;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JCheckBox mainProject;
    private JTextField projectFolder;
    private JTextField projectLocation;
    private JTextField projectName;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BasicProjectInfoPanel(String projectLocation, String antScript, String projectName, String projectFolder, ChangeListener listener) {
        this.initComponents();
        this.projectLocation.setText(projectLocation);
        this.antScript.setText(antScript);
        this.projectName.setText(projectName);
        this.projectFolder.setText(projectFolder);
        this.listener = listener;
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                BasicProjectInfoPanel.this.update(e);
            }

            public void removeUpdate(DocumentEvent e) {
                BasicProjectInfoPanel.this.update(e);
            }

            public void changedUpdate(DocumentEvent e) {
                BasicProjectInfoPanel.this.update(e);
            }
        };
        this.projectLocation.getDocument().addDocumentListener(this.documentListener);
        this.antScript.getDocument().addDocumentListener(this.documentListener);
        this.projectName.getDocument().addDocumentListener(this.documentListener);
        this.projectFolder.getDocument().addDocumentListener(this.documentListener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(BasicProjectInfoPanel.class);
    }

    public File getProjectLocation() {
        return this.getAsFile(this.projectLocation.getText());
    }

    public File getAntScript() {
        return this.getAsFile(this.antScript.getText());
    }

    public String getProjectName() {
        return this.projectName.getText();
    }

    public File getProjectFolder() {
        return this.getAsFile(this.projectFolder.getText());
    }

    public Boolean getMainProject() {
        return this.mainProject.isSelected();
    }

    public String getError() {
        if (this.projectLocation.getText().length() == 0) {
            return NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_1");
        }
        if (!this.getProjectLocation().exists()) {
            return NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_2");
        }
        if (this.antScript.getText().length() == 0) {
            return NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_3");
        }
        if (!this.getAntScript().exists()) {
            return NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_4");
        }
        if (!this.antScriptValidityChecked) {
            FileObject fo = FileUtil.toFileObject((File)this.getAntScript());
            if (fo != null && Util.getAntScriptTargetNames(fo) != null) {
                this.antScriptValidityChecked = true;
            } else {
                return NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_5");
            }
        }
        if (this.getProjectName().length() == 0) {
            return NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_6");
        }
        if (this.projectFolder.getText().length() == 0) {
            return NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_7");
        }
        if (this.getAsFile(this.projectFolder.getText() + File.separatorChar + "nbproject").exists()) {
            return NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_8");
        }
        File projectFolder = this.getProjectFolder();
        if (!$assertionsDisabled && projectFolder == null) {
            throw new AssertionError();
        }
        Project p = FileOwnerQuery.getOwner((URI)projectFolder.toURI());
        if (p != null && projectFolder.equals(FileUtil.toFile((FileObject)p.getProjectDirectory()))) {
            ProjectInformation pi = (ProjectInformation)p.getLookup().lookup(ProjectInformation.class);
            String displayName = pi == null ? "" : pi.getDisplayName();
            return MessageFormat.format(NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_9"), displayName);
        }
        File projectLocation = this.getProjectLocation();
        if (!$assertionsDisabled && projectLocation == null) {
            throw new AssertionError();
        }
        p = FileOwnerQuery.getOwner((URI)projectLocation.toURI());
        if (p != null && projectLocation.equals(FileUtil.toFile((FileObject)p.getProjectDirectory()))) {
            ProjectInformation pi = (ProjectInformation)p.getLookup().lookup(ProjectInformation.class);
            String displayName = pi == null ? "" : pi.getDisplayName();
            return MessageFormat.format(NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_10"), displayName);
        }
        return null;
    }

    private File getAsFile(String filename) {
        return FileUtil.normalizeFile((File)new File(filename));
    }

    private void update(DocumentEvent e) {
        if (this.ignoreEvent) {
            return;
        }
        this.ignoreEvent = true;
        if (this.projectLocation.getDocument() == e.getDocument()) {
            this.antScriptValidityChecked = false;
            this.updateAntScriptLocation();
            this.updateProjectName();
            this.updateProjectFolder();
        }
        if (this.antScript.getDocument() == e.getDocument()) {
            this.antScriptValidityChecked = false;
            this.updateProjectName();
        }
        this.ignoreEvent = false;
        if (this.projectFolder.getDocument() == e.getDocument()) {
            boolean bl = this.projectFolderTouched = !"".equals(this.projectFolder.getText());
        }
        if (this.antScript.getDocument() == e.getDocument()) {
            boolean bl = this.antScriptTouched = !"".equals(this.antScript.getText());
        }
        if (this.projectName.getDocument() == e.getDocument()) {
            this.projectNameTouched = !"".equals(this.projectName.getText());
        }
        this.listener.stateChanged(null);
    }

    private boolean isValidProjectLocation() {
        return this.getProjectLocation().exists() && this.getProjectLocation().isDirectory() && this.projectLocation.getText().length() > 0 && !this.projectLocation.getText().endsWith(":");
    }

    private void updateAntScriptLocation() {
        File as;
        if (this.antScriptTouched) {
            return;
        }
        if (this.isValidProjectLocation() && (as = new File(this.getProjectLocation().getAbsolutePath() + File.separatorChar + "build.xml")).exists()) {
            this.antScript.setText(as.getAbsolutePath());
            return;
        }
        this.antScript.setText("");
    }

    private void updateProjectName() {
        File as;
        if (this.projectNameTouched) {
            return;
        }
        if (this.getAntScript().exists() && (as = new File(this.getAntScript().getAbsolutePath())).exists()) {
            FileObject fo = FileUtil.toFileObject((File)as);
            if (!$assertionsDisabled && fo == null) {
                throw new AssertionError(as);
            }
            String name = Util.getAntScriptName(fo);
            if (name != null) {
                this.projectName.setText(name);
                return;
            }
        }
        this.projectName.setText("");
    }

    private void updateProjectFolder() {
        if (this.projectFolderTouched) {
            return;
        }
        if (this.isValidProjectLocation()) {
            this.projectFolder.setText(this.getProjectLocation().getAbsolutePath());
        } else {
            this.projectFolder.setText("");
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.antScript = new JTextField();
        this.projectName = new JTextField();
        this.projectFolder = new JTextField();
        this.browseAntScript = new JButton();
        this.browseProjectFolder = new JButton();
        this.projectLocation = new JTextField();
        this.jLabel6 = new JLabel();
        this.browseProjectLocation = new JButton();
        this.jSeparator1 = new JSeparator();
        this.mainProject = new JCheckBox();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(323, 223));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel1"));
        this.jLabel2.setLabelFor(this.antScript);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel2"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 0, 12, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel3"));
        this.jLabel4.setLabelFor(this.projectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel4"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel4"));
        this.jLabel5.setLabelFor(this.projectFolder);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.antScript, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.projectName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.projectFolder, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseAntScript, (String)NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"BTN_BasicProjectInfoPanel_browseAntScript"));
        this.browseAntScript.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.browseAntScript, gridBagConstraints);
        this.browseAntScript.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_browseAntScript"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseProjectFolder, (String)NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"BTN_BasicProjectInfoPanel_browseProjectFolder"));
        this.browseProjectFolder.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.browseProjectFolder, gridBagConstraints);
        this.browseProjectFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_browseProjectFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.projectLocation, gridBagConstraints);
        this.jLabel6.setLabelFor(this.projectLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel6"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel6"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseProjectLocation, (String)NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"BTN_BasicProjectInfoPanel_browseProjectLocation"));
        this.browseProjectLocation.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.browseProjectLocation, gridBagConstraints);
        this.browseProjectLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_browseProjectLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.mainProject.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.mainProject, (String)NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_mainProject"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.mainProject, gridBagConstraints);
        this.mainProject.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_mainProject"));
    }

    private void browseProjectLocationActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        if (this.projectLocation.getText().length() > 0 && this.getProjectLocation().exists()) {
            chooser.setSelectedFile(this.getProjectLocation());
        } else {
            chooser.setSelectedFile(ProjectChooser.getProjectsFolder());
        }
        chooser.setDialogTitle(NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_Browse_Location"));
        if (0 == chooser.showOpenDialog(this)) {
            File projectLoc = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.projectLocation.setText(projectLoc.getAbsolutePath());
        }
    }

    private void browseProjectFolderActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        if (this.projectFolder.getText().length() > 0 && this.getProjectFolder().exists()) {
            chooser.setSelectedFile(this.getProjectFolder());
        } else if (this.projectLocation.getText().length() > 0 && this.getProjectLocation().exists()) {
            chooser.setSelectedFile(this.getProjectLocation());
        } else {
            chooser.setSelectedFile(ProjectChooser.getProjectsFolder());
        }
        chooser.setDialogTitle(NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_Browse_Project_Folder"));
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.projectFolder.setText(projectDir.getAbsolutePath());
        }
    }

    private void browseAntScriptActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(0);
        if (this.antScript.getText().length() > 0 && this.getAntScript().exists()) {
            chooser.setSelectedFile(this.getAntScript());
        } else if (this.projectLocation.getText().length() > 0 && this.getProjectLocation().exists()) {
            chooser.setSelectedFile(this.getProjectLocation());
        } else {
            chooser.setSelectedFile(ProjectChooser.getProjectsFolder());
        }
        chooser.setDialogTitle(NbBundle.getMessage((Class)BasicProjectInfoPanel.class, (String)"LBL_Browse_Build_Script"));
        if (0 == chooser.showOpenDialog(this)) {
            File script = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.antScript.setText(script.getAbsolutePath());
        }
    }

    static {
        $assertionsDisabled = !BasicProjectInfoPanel.class.desiredAssertionStatus();
    }

    private class FormListener
    implements ActionListener {
        private FormListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == BasicProjectInfoPanel.this.browseAntScript) {
                BasicProjectInfoPanel.this.browseAntScriptActionPerformed(evt);
            } else if (evt.getSource() == BasicProjectInfoPanel.this.browseProjectFolder) {
                BasicProjectInfoPanel.this.browseProjectFolderActionPerformed(evt);
            } else if (evt.getSource() == BasicProjectInfoPanel.this.browseProjectLocation) {
                BasicProjectInfoPanel.this.browseProjectLocationActionPerformed(evt);
            }
        }
    }
}

