/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class VariablesNodeModel
implements NodeModel {
    public static final String FIELD = "org/netbeans/modules/debugger/resources/watchesView/Field";
    public static final String LOCAL = "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
    public static final String FIXED_WATCH = "org/netbeans/modules/debugger/resources/watchesView/FixedWatch";
    public static final String STATIC_FIELD = "org/netbeans/modules/debugger/resources/watchesView/StaticField";
    public static final String SUPER = "org/netbeans/modules/debugger/resources/watchesView/SuperVariable";
    private JPDADebugger debugger;
    private RequestProcessor evaluationRP = new RequestProcessor();
    private final Collection modelListeners = new HashSet();
    private Map shortDescriptionMap = new HashMap();

    public VariablesNodeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
    }

    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle((Class)VariablesNodeModel.class).getString("CTL_LocalsModel_Column_Name_Name");
        }
        if (o instanceof Field) {
            return ((Field)o).getName();
        }
        if (o instanceof LocalVariable) {
            return ((LocalVariable)o).getName();
        }
        if (o instanceof Super) {
            return "super";
        }
        if (o instanceof This) {
            return "this";
        }
        if (o == "NoInfo") {
            return NbBundle.getMessage((Class)VariablesNodeModel.class, (String)"CTL_No_Info");
        }
        if (o == "No current thread") {
            return NbBundle.getMessage((Class)VariablesNodeModel.class, (String)"NoCurrentThreadVar");
        }
        String str = o.toString();
        if (str.startsWith("SubArray")) {
            int index = str.indexOf(45);
            return NbBundle.getMessage((Class)VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Name_SubArray", (Object)str.substring(8, index), (Object)str.substring(index + 1));
        }
        throw new UnknownTypeException(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(final Object o) throws UnknownTypeException {
        Map map = this.shortDescriptionMap;
        synchronized (map) {
            Object shortDescription = this.shortDescriptionMap.remove(o);
            if (shortDescription instanceof String) {
                return (String)shortDescription;
            }
            if (shortDescription instanceof UnknownTypeException) {
                throw (UnknownTypeException)((Object)shortDescription);
            }
        }
        this.testKnown(o);
        this.evaluationRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String shortDescription = VariablesNodeModel.this.getShortDescriptionSynch(o);
                if (shortDescription != null && !"".equals(shortDescription)) {
                    Map map = VariablesNodeModel.this.shortDescriptionMap;
                    synchronized (map) {
                        VariablesNodeModel.this.shortDescriptionMap.put(o, shortDescription);
                    }
                    VariablesNodeModel.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesNodeModel.this, o, 4));
                }
            }
        });
        return "";
    }

    private String getShortDescriptionSynch(Object o) {
        if (o == "Root") {
            return NbBundle.getBundle((Class)VariablesNodeModel.class).getString("CTL_LocalsModel_Column_Name_Desc");
        }
        if (o instanceof Field) {
            if (o instanceof ObjectVariable) {
                String declaredType;
                String type = ((ObjectVariable)o).getType();
                if (type.equals(declaredType = ((Field)o).getDeclaredType())) {
                    try {
                        return "(" + type + ") " + ((ObjectVariable)o).getToStringValue();
                    }
                    catch (InvalidExpressionException ex) {
                        return ex.getLocalizedMessage();
                    }
                }
                try {
                    return "(" + declaredType + ") " + "(" + type + ") " + ((ObjectVariable)o).getToStringValue();
                }
                catch (InvalidExpressionException ex) {
                    return ex.getLocalizedMessage();
                }
            }
            return "(" + ((Field)o).getDeclaredType() + ") " + ((Field)o).getValue();
        }
        if (o instanceof LocalVariable) {
            if (o instanceof ObjectVariable) {
                String declaredType;
                String type = ((ObjectVariable)o).getType();
                if (type.equals(declaredType = ((LocalVariable)o).getDeclaredType())) {
                    try {
                        return "(" + type + ") " + ((ObjectVariable)o).getToStringValue();
                    }
                    catch (InvalidExpressionException ex) {
                        return ex.getLocalizedMessage();
                    }
                }
                try {
                    return "(" + declaredType + ") " + "(" + type + ") " + ((ObjectVariable)o).getToStringValue();
                }
                catch (InvalidExpressionException ex) {
                    return ex.getLocalizedMessage();
                }
            }
            return "(" + ((LocalVariable)o).getDeclaredType() + ") " + ((LocalVariable)o).getValue();
        }
        if (o instanceof Super) {
            return ((Super)o).getType();
        }
        if (o instanceof This) {
            try {
                return "(" + ((This)o).getType() + ") " + ((This)o).getToStringValue();
            }
            catch (InvalidExpressionException ex) {
                return ex.getLocalizedMessage();
            }
        }
        String str = o.toString();
        if (str.startsWith("SubArray")) {
            int index = str.indexOf(45);
            return NbBundle.getMessage((Class)VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Descr_SubArray", (Object)str.substring(8, index), (Object)str.substring(index + 1));
        }
        if (o == "NoInfo") {
            return NbBundle.getMessage((Class)VariablesNodeModel.class, (String)"CTL_No_Info_descr");
        }
        if (o == "No current thread") {
            return NbBundle.getMessage((Class)VariablesNodeModel.class, (String)"NoCurrentThreadVar");
        }
        return null;
    }

    private void testKnown(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return;
        }
        if (o instanceof Field) {
            return;
        }
        if (o instanceof LocalVariable) {
            return;
        }
        if (o instanceof Super) {
            return;
        }
        if (o instanceof This) {
            return;
        }
        String str = o.toString();
        if (str.startsWith("SubArray")) {
            return;
        }
        if (o == "NoInfo") {
            return;
        }
        if (o == "No current thread") {
            return;
        }
        throw new UnknownTypeException(o);
    }

    public String getIconBase(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return FIELD;
        }
        if (o instanceof Field) {
            if (((Field)o).isStatic()) {
                return STATIC_FIELD;
            }
            return FIELD;
        }
        if (o instanceof LocalVariable) {
            return LOCAL;
        }
        if (o instanceof Super) {
            return SUPER;
        }
        if (o instanceof This) {
            return FIELD;
        }
        if (o.toString().startsWith("SubArray")) {
            return LOCAL;
        }
        if (o == "NoInfo" || o == "No current thread") {
            return null;
        }
        throw new UnknownTypeException(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent me) {
        Object[] listeners;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            listeners = this.modelListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((ModelListener)listeners[i]).modelChanged(me);
        }
    }
}

