/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class SourcesModel
implements TreeModel,
TableModel,
NodeActionsProvider {
    private static final String FILTER_PREFIX = "Do not stop in: ";
    private static final String DISP_FILTER_PREFIX = NbBundle.getBundle((Class)SourcesModel.class).getString("CTL_SourcesModel_Name_DoNotStopIn");
    private Listener listener;
    private SourcePath sourcePath;
    private JPDADebugger debugger;
    private Vector listeners = new Vector();
    private Set filters = new HashSet();
    private Set enabledFilters = new HashSet();
    private Set enabledSourceRoots = new HashSet();
    private Set disabledSourceRoots = new HashSet();
    private Properties filterProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
    private final Action NEW_FILTER_ACTION = new AbstractAction(NbBundle.getBundle((Class)SourcesModel.class).getString("CTL_SourcesModel_Action_AddFilter")){

        public void actionPerformed(ActionEvent e) {
            NotifyDescriptor.InputLine descriptor = new NotifyDescriptor.InputLine(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel == null ? (class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel = SourcesModel.class$("org.netbeans.modules.debugger.jpda.ui.models.SourcesModel")) : class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel)).getString("CTL_SourcesModel_NewFilter_Filter_Label"), NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel == null ? (class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel = SourcesModel.class$("org.netbeans.modules.debugger.jpda.ui.models.SourcesModel")) : class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel)).getString("CTL_SourcesModel_NewFilter_Title"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.OK_OPTION) {
                String filter = descriptor.getInputText();
                SourcesModel.this.filters.add(filter);
                SourcesModel.this.enabledFilters.add(filter);
                SourcesModel.this.debugger.getSmartSteppingFilter().addExclusionPatterns(Collections.singleton(filter));
                SourcesModel.this.saveFilters();
                SourcesModel.this.fireTreeChanged();
            }
        }
    };
    private final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle((Class)SourcesModel.class).getString("CTL_SourcesModel_Action_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            int k = nodes.length;
            for (int i = 0; i < k; ++i) {
                SourcesModel.this.filters.remove(((String)nodes[i]).substring(DISP_FILTER_PREFIX.length()));
                SourcesModel.this.enabledFilters.remove(((String)nodes[i]).substring(DISP_FILTER_PREFIX.length()));
            }
            SourcesModel.this.saveFilters();
            SourcesModel.this.fireTreeChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel$DefaultSourcesColumn;

    public SourcesModel(ContextProvider lookupProvider) {
        this.sourcePath = (SourcePath)lookupProvider.lookupFirst(null, SourcePath.class);
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.loadFilters();
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            String[] sourceRoots = this.sourcePath.getOriginalSourceRoots();
            String[] ep = new String[this.filters.size()];
            ep = this.filters.toArray(ep);
            int k = ep.length;
            for (int i = 0; i < k; ++i) {
                ep[i] = DISP_FILTER_PREFIX + ep[i];
            }
            Object[] os = new Object[sourceRoots.length + ep.length];
            System.arraycopy(sourceRoots, 0, os, 0, sourceRoots.length);
            System.arraycopy(ep, 0, os, sourceRoots.length, ep.length);
            to = Math.min(os.length, to);
            from = Math.min(os.length, from);
            Object[] fos = new Object[to - from];
            System.arraycopy(os, from, fos, 0, to - from);
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            return fos;
        }
        throw new UnknownTypeException(parent);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            return this.sourcePath.getOriginalSourceRoots().length + this.filters.size();
        }
        throw new UnknownTypeException(node);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof String) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public void fireTreeChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged(null);
        }
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (columnID.equals("use") && node instanceof String) {
            return this.isEnabled((String)node);
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (columnID.equals("use") && node instanceof String) {
            return false;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        if (columnID.equals("use") && node instanceof String) {
            this.setEnabled((String)node, (Boolean)value);
            return;
        }
        throw new UnknownTypeException(node);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node instanceof String) {
            if (((String)node).startsWith(DISP_FILTER_PREFIX)) {
                return new Action[]{this.NEW_FILTER_ACTION, this.DELETE_ACTION};
            }
            return new Action[]{this.NEW_FILTER_ACTION};
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node instanceof String) {
            return;
        }
        throw new UnknownTypeException(node);
    }

    private boolean isEnabled(String root) {
        if (root.startsWith(DISP_FILTER_PREFIX)) {
            return this.enabledFilters.contains(root.substring(DISP_FILTER_PREFIX.length()));
        }
        String[] sourceRoots = this.sourcePath.getSourceRoots();
        int k = sourceRoots.length;
        for (int i = 0; i < k; ++i) {
            if (!sourceRoots[i].equals(root)) continue;
            return true;
        }
        return false;
    }

    private void setEnabled(String root, boolean enabled) {
        if (root.startsWith(DISP_FILTER_PREFIX)) {
            String filter = root.substring(DISP_FILTER_PREFIX.length());
            if (enabled) {
                this.enabledFilters.add(filter);
                this.debugger.getSmartSteppingFilter().addExclusionPatterns(Collections.singleton(filter));
            } else {
                this.enabledFilters.remove(filter);
                this.debugger.getSmartSteppingFilter().removeExclusionPatterns(Collections.singleton(filter));
            }
            this.saveFilters();
            return;
        }
        HashSet<String> sourceRoots = new HashSet<String>(Arrays.asList(this.sourcePath.getSourceRoots()));
        if (enabled) {
            this.enabledSourceRoots.add(root);
            this.disabledSourceRoots.remove(root);
            sourceRoots.add(root);
        } else {
            this.disabledSourceRoots.add(root);
            this.enabledSourceRoots.remove(root);
            sourceRoots.remove(root);
        }
        String[] ss = new String[sourceRoots.size()];
        this.sourcePath.setSourceRoots(sourceRoots.toArray(ss));
        this.saveFilters();
    }

    private void loadFilters() {
        this.filters = new HashSet(this.filterProperties.getProperties("class_filters").getCollection("all", (Collection)Collections.EMPTY_SET));
        this.enabledFilters = new HashSet(this.filterProperties.getProperties("class_filters").getCollection("enabled", (Collection)Collections.EMPTY_SET));
        this.enabledSourceRoots = new HashSet(this.filterProperties.getProperties("source_roots").getCollection("enabled", (Collection)Collections.EMPTY_SET));
        this.disabledSourceRoots = new HashSet(this.filterProperties.getProperties("source_roots").getCollection("disabled", (Collection)Collections.EMPTY_SET));
    }

    private void saveFilters() {
        this.filterProperties.getProperties("class_filters").setCollection("all", (Collection)this.filters);
        this.filterProperties.getProperties("class_filters").setCollection("enabled", (Collection)this.enabledFilters);
        this.filterProperties.getProperties("source_roots").setCollection("enabled", (Collection)this.enabledSourceRoots);
        this.filterProperties.getProperties("source_roots").setCollection("disabled", (Collection)this.disabledSourceRoots);
    }

    public static abstract class AbstractColumn
    extends ColumnModel {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("views");

        public void setVisible(boolean visible) {
            this.properties.setBoolean(this.getID() + ".visible", visible);
        }

        public void setSorted(boolean sorted) {
            this.properties.setBoolean(this.getID() + ".sorted", sorted);
        }

        public void setSortedDescending(boolean sortedDescending) {
            this.properties.setBoolean(this.getID() + ".sortedDescending", sortedDescending);
        }

        public int getCurrentOrderNumber() {
            return this.properties.getInt(this.getID() + ".currentOrderNumber", -1);
        }

        public void setCurrentOrderNumber(int newOrderNumber) {
            this.properties.setInt(this.getID() + ".currentOrderNumber", newOrderNumber);
        }

        public int getColumnWidth() {
            return this.properties.getInt(this.getID() + ".columnWidth", 150);
        }

        public void setColumnWidth(int newColumnWidth) {
            this.properties.setInt(this.getID() + ".columnWidth", newColumnWidth);
        }

        public boolean isVisible() {
            return this.properties.getBoolean(this.getID() + ".visible", true);
        }

        public boolean isSorted() {
            return this.properties.getBoolean(this.getID() + ".sorted", false);
        }

        public boolean isSortedDescending() {
            return this.properties.getBoolean(this.getID() + ".sortedDescending", false);
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference model;

        private Listener(SourcesModel tm) {
            this.model = new WeakReference<SourcesModel>(tm);
            tm.sourcePath.addPropertyChangeListener(this);
            tm.debugger.getSmartSteppingFilter().addPropertyChangeListener((PropertyChangeListener)this);
        }

        private SourcesModel getModel() {
            SourcesModel tm = (SourcesModel)this.model.get();
            if (tm == null) {
                tm.sourcePath.removePropertyChangeListener(this);
                tm.debugger.getSmartSteppingFilter().removePropertyChangeListener((PropertyChangeListener)this);
            }
            return tm;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            SourcesModel m = this.getModel();
            if (m == null) {
                return;
            }
            m.fireTreeChanged();
        }
    }

    public static class SourcesUsedColumn
    extends AbstractColumn {
        public String getID() {
            return "use";
        }

        public String getDisplayName() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel == null ? (class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel = SourcesModel.class$("org.netbeans.modules.debugger.jpda.ui.models.SourcesModel")) : class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel)).getString("CTL_SourcesModel_Column_Debugging_Name");
        }

        public Class getType() {
            return Boolean.TYPE;
        }

        public String getShortDescription() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel == null ? (class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel = SourcesModel.class$("org.netbeans.modules.debugger.jpda.ui.models.SourcesModel")) : class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel)).getString("CTL_SourcesModel_Column_Debugging_Desc");
        }

        public boolean initiallyVisible() {
            return true;
        }
    }

    public static class DefaultSourcesColumn
    extends AbstractColumn {
        public String getID() {
            return "DefaultSourcesColumn";
        }

        public String getDisplayName() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel$DefaultSourcesColumn == null ? (class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel$DefaultSourcesColumn = SourcesModel.class$("org.netbeans.modules.debugger.jpda.ui.models.SourcesModel$DefaultSourcesColumn")) : class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel$DefaultSourcesColumn)).getString("CTL_SourcesModel_Column_Name_Name");
        }

        public String getShortDescription() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel$DefaultSourcesColumn == null ? (class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel$DefaultSourcesColumn = SourcesModel.class$("org.netbeans.modules.debugger.jpda.ui.models.SourcesModel$DefaultSourcesColumn")) : class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel$DefaultSourcesColumn)).getString("CTL_SourcesModel_Column_Name_Desc");
        }

        public Class getType() {
            return null;
        }
    }
}

