/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class JPDASessionActionsProvider
implements NodeActionsProviderFilter {
    private HashSet listeners;
    private ContextProvider contextProvider;
    static /* synthetic */ Class class$org$netbeans$api$debugger$jpda$JPDADebugger;

    public JPDASessionActionsProvider(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        original.performDefaultAction(node);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        Action[] actions;
        if (!(node instanceof Session)) {
            return original.getActions(node);
        }
        try {
            actions = original.getActions(node);
        }
        catch (UnknownTypeException e) {
            actions = new Action[]{};
        }
        ArrayList<Action> myActions = new ArrayList<Action>();
        if (node instanceof Session) {
            Session session = (Session)node;
            myActions.add(new CustomizeSession(session));
            myActions.add(new LanguageSelection(session));
        }
        myActions.addAll(Arrays.asList(actions));
        return myActions.toArray(new Action[myActions.size()]);
    }

    private String localize(String s) {
        return NbBundle.getBundle((Class)JPDASessionActionsProvider.class).getString(s);
    }

    public void addModelListener(ModelListener l) {
        HashSet newListeners = this.listeners == null ? new HashSet() : (HashSet)this.listeners.clone();
        newListeners.add(l);
        this.listeners = newListeners;
    }

    public void removeModelListener(ModelListener l) {
        if (this.listeners == null) {
            return;
        }
        HashSet newListeners = (HashSet)this.listeners.clone();
        newListeners.remove(l);
        this.listeners = newListeners;
    }

    private class CustomizeSession
    extends AbstractAction
    implements Presenter.Popup {
        private Session session;

        public CustomizeSession(Session session) {
            this.session = session;
        }

        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            JMenu displayAsPopup = new JMenu(JPDASessionActionsProvider.this.localize("CTL_Session_Resume_Threads"));
            JRadioButtonMenuItem resumeAllItem = new JRadioButtonMenuItem(new AbstractAction(JPDASessionActionsProvider.this.localize("CTL_Session_Resume_All_Threads")){

                public void actionPerformed(ActionEvent e) {
                    JPDADebugger dbg = (JPDADebugger)JPDASessionActionsProvider.this.contextProvider.lookupFirst(null, class$org$netbeans$api$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$api$debugger$jpda$JPDADebugger = JPDASessionActionsProvider.class$("org.netbeans.api.debugger.jpda.JPDADebugger")) : class$org$netbeans$api$debugger$jpda$JPDADebugger);
                    dbg.setSuspend(2);
                }
            });
            JRadioButtonMenuItem resumeCurrentItem = new JRadioButtonMenuItem(new AbstractAction(JPDASessionActionsProvider.this.localize("CTL_Session_Resume_Current_Thread")){

                public void actionPerformed(ActionEvent e) {
                    JPDADebugger dbg = (JPDADebugger)JPDASessionActionsProvider.this.contextProvider.lookupFirst(null, class$org$netbeans$api$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$api$debugger$jpda$JPDADebugger = JPDASessionActionsProvider.class$("org.netbeans.api.debugger.jpda.JPDADebugger")) : class$org$netbeans$api$debugger$jpda$JPDADebugger);
                    dbg.setSuspend(1);
                }
            });
            JPDADebugger dbg = (JPDADebugger)JPDASessionActionsProvider.this.contextProvider.lookupFirst(null, class$org$netbeans$api$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$api$debugger$jpda$JPDADebugger = JPDASessionActionsProvider.class$("org.netbeans.api.debugger.jpda.JPDADebugger")) : class$org$netbeans$api$debugger$jpda$JPDADebugger);
            if (dbg.getSuspend() == 2) {
                resumeAllItem.setSelected(true);
            } else {
                resumeCurrentItem.setSelected(true);
            }
            displayAsPopup.add(resumeAllItem);
            displayAsPopup.add(resumeCurrentItem);
            return displayAsPopup;
        }
    }

    private class LanguageSelection
    extends AbstractAction
    implements Presenter.Popup {
        private Session session;

        public LanguageSelection(Session session) {
            this.session = session;
        }

        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            JMenu displayAsPopup = new JMenu(JPDASessionActionsProvider.this.localize("CTL_Session_Popup_Language"));
            String[] languages = this.session.getSupportedLanguages();
            String currentLanguage = this.session.getCurrentLanguage();
            for (int i = 0; i < languages.length; ++i) {
                final String language = languages[i];
                JRadioButtonMenuItem langItem = new JRadioButtonMenuItem(new AbstractAction(language){

                    public void actionPerformed(ActionEvent e) {
                        LanguageSelection.this.session.setCurrentLanguage(language);
                    }
                });
                if (currentLanguage.equals(language)) {
                    langItem.setSelected(true);
                }
                displayAsPopup.add(langItem);
            }
            return displayAsPopup;
        }
    }
}

