/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Vector;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.ui.models.BoldVariablesTableModelFilterFirst;
import org.netbeans.modules.debugger.jpda.ui.models.BreakpointsNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class CallStackNodeModel
implements NodeModel {
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private JPDADebugger debugger;
    private Session session;
    private Vector listeners = new Vector();

    public CallStackNodeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.session = (Session)lookupProvider.lookupFirst(null, Session.class);
        new Listener(this, this.debugger);
    }

    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle((Class)CallStackNodeModel.class).getString("CTL_CallstackModel_Column_Name_Name");
        }
        if (o instanceof CallStackFrame) {
            CallStackFrame sf = (CallStackFrame)o;
            CallStackFrame ccsf = this.debugger.getCurrentCallStackFrame();
            if (ccsf != null && ccsf.equals(sf)) {
                return BoldVariablesTableModelFilterFirst.toHTML(CallStackNodeModel.getCSFName(this.session, sf, false), true, false, null);
            }
            return CallStackNodeModel.getCSFName(this.session, sf, false);
        }
        if ("No current thread" == o) {
            return NbBundle.getMessage((Class)CallStackNodeModel.class, (String)"NoCurrentThread");
        }
        if ("Thread is running" == o) {
            return NbBundle.getMessage((Class)CallStackNodeModel.class, (String)"ThreadIsRunning");
        }
        throw new UnknownTypeException(o);
    }

    public String getShortDescription(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle((Class)CallStackNodeModel.class).getString("CTL_CallstackModel_Column_Name_Desc");
        }
        if (o instanceof CallStackFrame) {
            CallStackFrame sf = (CallStackFrame)o;
            return CallStackNodeModel.getCSFName(this.session, sf, true);
        }
        if ("No current thread" == o) {
            return NbBundle.getMessage((Class)CallStackNodeModel.class, (String)"NoCurrentThread");
        }
        if ("Thread is running" == o) {
            return NbBundle.getMessage((Class)CallStackNodeModel.class, (String)"ThreadIsRunning");
        }
        throw new UnknownTypeException(o);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof String) {
            return null;
        }
        if (node instanceof CallStackFrame) {
            CallStackFrame ccsf = this.debugger.getCurrentCallStackFrame();
            if (ccsf != null && ccsf.equals(node)) {
                return CURRENT_CALL_STACK;
            }
            return CALL_STACK;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireTreeChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged(null);
        }
    }

    public static String getCSFName(Session s, CallStackFrame sf, boolean l) {
        String fileName;
        String language = sf.getDefaultStratum();
        int ln = sf.getLineNumber(language);
        String string = fileName = l ? sf.getClassName() : BreakpointsNodeModel.getShort(sf.getClassName());
        if (language.equals("Java")) {
            fileName = fileName + "." + sf.getMethodName();
        } else {
            try {
                fileName = sf.getSourcePath(language);
            }
            catch (AbsentInformationException e) {
                fileName = fileName + "." + sf.getMethodName();
            }
        }
        if (ln < 0) {
            return fileName;
        }
        return fileName + ":" + ln;
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference ref;
        private JPDADebugger debugger;

        private Listener(CallStackNodeModel rm, JPDADebugger debugger) {
            this.ref = new WeakReference<CallStackNodeModel>(rm);
            this.debugger = debugger;
            debugger.addPropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)this);
        }

        private CallStackNodeModel getModel() {
            CallStackNodeModel rm = (CallStackNodeModel)this.ref.get();
            if (rm == null) {
                this.debugger.removePropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)this);
            }
            return rm;
        }

        public void propertyChange(PropertyChangeEvent e) {
            CallStackNodeModel rm = this.getModel();
            if (rm == null) {
                return;
            }
            rm.fireTreeChanged();
        }
    }
}

