/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.actions.JPDADebuggerAction;
import org.netbeans.spi.debugger.ContextProvider;

public class MakeCallerCurrentActionProvider
extends JPDADebuggerAction {
    private ContextProvider lookupProvider;

    public MakeCallerCurrentActionProvider(ContextProvider lookupProvider) {
        super((JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class));
        this.lookupProvider = lookupProvider;
        this.getDebuggerImpl().addPropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)this);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_MAKE_CALLER_CURRENT);
    }

    public void doAction(Object action) {
        JPDAThread t = this.getDebuggerImpl().getCurrentThread();
        if (t == null) {
            return;
        }
        int i = MakeCallerCurrentActionProvider.getCurrentCallStackFrameIndex(this.getDebuggerImpl());
        if (i >= t.getStackDepth() - 1) {
            return;
        }
        MakeCallerCurrentActionProvider.setCurrentCallStackFrameIndex(this.getDebuggerImpl(), ++i, this.lookupProvider);
    }

    protected void checkEnabled(int debuggerState) {
        JPDAThread t;
        this.getDebuggerImpl();
        if (debuggerState == 3 && (t = this.getDebuggerImpl().getCurrentThread()) != null) {
            int i = MakeCallerCurrentActionProvider.getCurrentCallStackFrameIndex(this.getDebuggerImpl());
            this.setEnabled(ActionsManager.ACTION_MAKE_CALLER_CURRENT, i < t.getStackDepth() - 1);
            return;
        }
        this.setEnabled(ActionsManager.ACTION_MAKE_CALLER_CURRENT, false);
    }

    static int getCurrentCallStackFrameIndex(JPDADebugger debuggerImpl) {
        try {
            JPDAThread t = debuggerImpl.getCurrentThread();
            if (t == null) {
                return -1;
            }
            CallStackFrame csf = debuggerImpl.getCurrentCallStackFrame();
            if (csf == null) {
                return -1;
            }
            CallStackFrame[] s = t.getCallStack();
            int k = s.length;
            for (int i = 0; i < k; ++i) {
                if (!csf.equals(s[i])) continue;
                return i;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return -1;
    }

    static void setCurrentCallStackFrameIndex(JPDADebugger debuggerImpl, int index, ContextProvider lookupProvider) {
        try {
            JPDAThread t = debuggerImpl.getCurrentThread();
            if (t == null) {
                return;
            }
            if (t.getStackDepth() <= index) {
                return;
            }
            CallStackFrame csf = t.getCallStack(index, index + 1)[0];
            csf.makeCurrent();
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }
}

