/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.FilteredKeymap;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class Evaluator
extends JPanel {
    private static final int MAX_ITEMS_TO_KEEP = 20;
    private JPDADebugger debugger;
    private EvaluatorModelListener viewModelListener;
    private Variable result;
    private RequestProcessor.Task evalTask = new RequestProcessor("Debugger Evaluator", 1).create((Runnable)new EvaluateTask());
    private boolean ignoreEvents = false;
    private SessionListener sessionListener;
    private JComboBox expressionComboBox;
    private JLabel expressionLabel;
    private JLabel resultLabel;
    private JPanel resultPanel;
    private static Dialog evalDialog;
    private static volatile Evaluator currentEvaluator;
    static /* synthetic */ Class class$org$netbeans$api$debugger$jpda$JPDADebugger;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$TreeModel;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$TreeModelFilter;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$TreeExpansionModel;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$NodeModel;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$NodeModelFilter;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$TableModel;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$TableModelFilter;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$NodeActionsProvider;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$NodeActionsProviderFilter;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$ColumnModel;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$Model;

    public Evaluator(JPDADebugger debugger) {
        this.debugger = debugger;
        this.initComponents();
        this.initCombo();
        this.initResult();
        this.expressionLabel.setLabelFor(this.expressionComboBox);
        this.expressionLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Expression_Mnc").charAt(0));
        this.resultLabel.setLabelFor(this.resultPanel);
        this.resultLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Result_Mnc").charAt(0));
        this.sessionListener = new SessionListener();
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentSession", (DebuggerManagerListener)this.sessionListener);
    }

    private void initComponents() {
        this.expressionLabel = new JLabel();
        this.expressionComboBox = new JComboBox();
        this.resultLabel = new JLabel();
        this.resultPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.expressionLabel.setText(NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Expression"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 12);
        this.add((Component)this.expressionLabel, gridBagConstraints);
        this.expressionComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Evaluator.this.expressionComboBoxItemStateChanged(evt);
            }
        });
        this.expressionComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Evaluator.this.expressionComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 12, 12);
        this.add((Component)this.expressionComboBox, gridBagConstraints);
        this.resultLabel.setText(NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Result"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 11, 12);
        this.add((Component)this.resultLabel, gridBagConstraints);
        this.resultPanel.setLayout(new BoxLayout(this.resultPanel, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 11, 12, 12);
        this.add((Component)this.resultPanel, gridBagConstraints);
    }

    private void expressionComboBoxItemStateChanged(ItemEvent evt) {
        if (this.ignoreEvents) {
            return;
        }
        this.evaluate();
    }

    private void expressionComboBoxActionPerformed(ActionEvent evt) {
    }

    private void initCombo() {
        this.expressionComboBox.setEditor(new CompletionedEditor());
        this.expressionComboBox.setEditable(true);
    }

    private void initResult() {
        JComponent tree = Models.createView((Models.CompoundModel)Models.EMPTY_MODEL);
        this.resultPanel.add((Component)tree, "Center");
        this.viewModelListener = new EvaluatorModelListener(tree);
        Dimension tps = tree.getPreferredSize();
        tps.height = tps.width / 2;
        tree.setPreferredSize(tps);
    }

    private void destroy() {
        this.viewModelListener.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExpression() {
        String textInEditor = (String)this.expressionComboBox.getEditor().getItem();
        String exp = (String)this.expressionComboBox.getSelectedItem();
        if (textInEditor != null && !textInEditor.equals(exp)) {
            try {
                this.ignoreEvents = true;
                this.expressionComboBox.setSelectedItem(textInEditor);
                exp = textInEditor;
            }
            finally {
                this.ignoreEvents = false;
            }
        }
        return exp;
    }

    private void evaluate() {
        this.evalTask.schedule(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExpressionToHistory(String exp) {
        try {
            int i;
            this.ignoreEvents = true;
            int ic = this.expressionComboBox.getItemCount();
            for (i = 0; i < ic; ++i) {
                String item = (String)this.expressionComboBox.getItemAt(i);
                if (!item.equals(exp)) continue;
                this.expressionComboBox.removeItemAt(i);
                break;
            }
            if (i >= 20) {
                this.expressionComboBox.removeItemAt(i - 1);
            }
            if (ic > 0) {
                this.expressionComboBox.insertItemAt(exp, 0);
            } else {
                this.expressionComboBox.addItem(exp);
            }
            this.expressionComboBox.setSelectedItem(exp);
        }
        finally {
            this.ignoreEvents = false;
        }
    }

    private void displayResult(Variable var) {
        this.result = var;
        this.viewModelListener.updateModel();
    }

    public static void open(JPDADebugger debugger) {
        if (evalDialog != null) {
            evalDialog.setVisible(true);
            evalDialog.requestFocus();
            return;
        }
        final Evaluator evaluatorPanel = new Evaluator(debugger);
        final String evalStr = NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Evaluate");
        final String watchStr = NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Watch");
        final String closeStr = NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Close");
        DialogDescriptor dd = new DialogDescriptor((Object)evaluatorPanel, NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Title"), false, new Object[]{evalStr, watchStr, closeStr}, (Object)evalStr, 0, new HelpCtx(Evaluator.class.getName()), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object option = e.getSource();
                if (evalStr.equals(option)) {
                    evaluatorPanel.evaluate();
                } else if (watchStr.equals(option)) {
                    DebuggerManager.getDebuggerManager().createWatch(evaluatorPanel.getExpression());
                } else if (closeStr.equals(option)) {
                    Evaluator.close();
                }
            }
        });
        evalDialog = DialogDisplayer.getDefault().createDialog(dd);
        evalDialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.A11YDescr"));
        currentEvaluator = evaluatorPanel;
        evalDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close() {
        evalDialog.setVisible(false);
        try {
            Evaluator.currentEvaluator.ignoreEvents = true;
            Evaluator.currentEvaluator.expressionComboBox.setSelectedItem("");
        }
        finally {
            Evaluator.currentEvaluator.ignoreEvents = false;
        }
        Evaluator.currentEvaluator.result = null;
        Evaluator.currentEvaluator.viewModelListener.updateModel();
    }

    private static class EvaluatorModel
    implements TreeModel,
    NodeModel {
        private Models.CompoundModel treeModel;
        private Models.CompoundModel nodeModel;

        public EvaluatorModel(Models.CompoundModel treeModel, Models.CompoundModel nodeModel) {
            this.treeModel = treeModel;
            this.nodeModel = nodeModel;
        }

        public void addModelListener(ModelListener l) {
            this.treeModel.addModelListener(l);
        }

        public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
            if ("Root".equals(parent)) {
                Evaluator eval = currentEvaluator;
                if (eval == null || eval.result == null) {
                    return new Object[0];
                }
                return new Object[]{eval.result};
            }
            return this.treeModel.getChildren(parent, from, to);
        }

        public int getChildrenCount(Object node) throws UnknownTypeException {
            if ("Root".equals(node)) {
                return currentEvaluator == null ? 0 : 1;
            }
            return this.treeModel.getChildrenCount(node);
        }

        public Object getRoot() {
            return "Root";
        }

        public boolean isLeaf(Object node) throws UnknownTypeException {
            if ("Root".equals(node)) {
                return false;
            }
            return this.treeModel.isLeaf(node);
        }

        public void removeModelListener(ModelListener l) {
            this.treeModel.removeModelListener(l);
        }

        public String getDisplayName(Object node) throws UnknownTypeException {
            Evaluator eval = currentEvaluator;
            if (eval != null && eval.result != null && node == eval.result) {
                return eval.getExpression();
            }
            return this.nodeModel.getDisplayName(node);
        }

        public String getIconBase(Object node) throws UnknownTypeException {
            Evaluator eval = currentEvaluator;
            if (eval != null && eval.result != null && node == eval.result) {
                return "org/netbeans/modules/debugger/resources/watchesView/Watch";
            }
            return this.nodeModel.getIconBase(node);
        }

        public String getShortDescription(Object node) throws UnknownTypeException {
            Evaluator eval = currentEvaluator;
            if (eval != null && eval.result != null && node == eval.result) {
                return eval.getExpression();
            }
            return this.nodeModel.getShortDescription(node);
        }
    }

    private static class EvaluatorModelListener
    extends DebuggerManagerAdapter {
        private String viewType = "LocalsView";
        private JComponent view;

        public EvaluatorModelListener(JComponent view) {
            this.view = view;
            DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
            this.updateModel();
        }

        public void destroy() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
            Models.setModelsToView((JComponent)this.view, (Models.CompoundModel)Models.EMPTY_MODEL);
        }

        public void propertyChange(PropertyChangeEvent e) {
            Evaluator eval = currentEvaluator;
            if (eval != null) {
                DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
                if (de == null) {
                    return;
                }
                JPDADebugger debugger = (JPDADebugger)de.lookupFirst(null, class$org$netbeans$api$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$api$debugger$jpda$JPDADebugger = Evaluator.class$("org.netbeans.api.debugger.jpda.JPDADebugger")) : class$org$netbeans$api$debugger$jpda$JPDADebugger);
                eval.debugger = debugger;
            }
            this.updateModel();
        }

        private List joinLookups(DebuggerEngine e, DebuggerManager dm, Class service) {
            List es = e.lookup(this.viewType, service);
            List ms = dm.lookup(this.viewType, service);
            ms.removeAll(es);
            es.addAll(ms);
            return es;
        }

        public void updateModel() {
            int i;
            List mm;
            List columnModels;
            List nodeActionsProviderFilters;
            List nodeActionsProviders;
            List tableModelFilters;
            List tableModels;
            List nodeModelFilters;
            List nodeModels;
            List treeExpansionModels;
            List treeModelFilters;
            List treeModels;
            DebuggerManager dm = DebuggerManager.getDebuggerManager();
            DebuggerEngine e = dm.getCurrentEngine();
            if (e != null) {
                treeModels = this.joinLookups(e, dm, class$org$netbeans$spi$viewmodel$TreeModel == null ? (class$org$netbeans$spi$viewmodel$TreeModel = Evaluator.class$("org.netbeans.spi.viewmodel.TreeModel")) : class$org$netbeans$spi$viewmodel$TreeModel);
                treeModelFilters = this.joinLookups(e, dm, class$org$netbeans$spi$viewmodel$TreeModelFilter == null ? (class$org$netbeans$spi$viewmodel$TreeModelFilter = Evaluator.class$("org.netbeans.spi.viewmodel.TreeModelFilter")) : class$org$netbeans$spi$viewmodel$TreeModelFilter);
                treeExpansionModels = this.joinLookups(e, dm, class$org$netbeans$spi$viewmodel$TreeExpansionModel == null ? (class$org$netbeans$spi$viewmodel$TreeExpansionModel = Evaluator.class$("org.netbeans.spi.viewmodel.TreeExpansionModel")) : class$org$netbeans$spi$viewmodel$TreeExpansionModel);
                nodeModels = this.joinLookups(e, dm, class$org$netbeans$spi$viewmodel$NodeModel == null ? (class$org$netbeans$spi$viewmodel$NodeModel = Evaluator.class$("org.netbeans.spi.viewmodel.NodeModel")) : class$org$netbeans$spi$viewmodel$NodeModel);
                nodeModelFilters = this.joinLookups(e, dm, class$org$netbeans$spi$viewmodel$NodeModelFilter == null ? (class$org$netbeans$spi$viewmodel$NodeModelFilter = Evaluator.class$("org.netbeans.spi.viewmodel.NodeModelFilter")) : class$org$netbeans$spi$viewmodel$NodeModelFilter);
                tableModels = this.joinLookups(e, dm, class$org$netbeans$spi$viewmodel$TableModel == null ? (class$org$netbeans$spi$viewmodel$TableModel = Evaluator.class$("org.netbeans.spi.viewmodel.TableModel")) : class$org$netbeans$spi$viewmodel$TableModel);
                tableModelFilters = this.joinLookups(e, dm, class$org$netbeans$spi$viewmodel$TableModelFilter == null ? (class$org$netbeans$spi$viewmodel$TableModelFilter = Evaluator.class$("org.netbeans.spi.viewmodel.TableModelFilter")) : class$org$netbeans$spi$viewmodel$TableModelFilter);
                nodeActionsProviders = this.joinLookups(e, dm, class$org$netbeans$spi$viewmodel$NodeActionsProvider == null ? (class$org$netbeans$spi$viewmodel$NodeActionsProvider = Evaluator.class$("org.netbeans.spi.viewmodel.NodeActionsProvider")) : class$org$netbeans$spi$viewmodel$NodeActionsProvider);
                nodeActionsProviderFilters = this.joinLookups(e, dm, class$org$netbeans$spi$viewmodel$NodeActionsProviderFilter == null ? (class$org$netbeans$spi$viewmodel$NodeActionsProviderFilter = Evaluator.class$("org.netbeans.spi.viewmodel.NodeActionsProviderFilter")) : class$org$netbeans$spi$viewmodel$NodeActionsProviderFilter);
                columnModels = this.joinLookups(e, dm, class$org$netbeans$spi$viewmodel$ColumnModel == null ? (class$org$netbeans$spi$viewmodel$ColumnModel = Evaluator.class$("org.netbeans.spi.viewmodel.ColumnModel")) : class$org$netbeans$spi$viewmodel$ColumnModel);
                mm = this.joinLookups(e, dm, class$org$netbeans$spi$viewmodel$Model == null ? (class$org$netbeans$spi$viewmodel$Model = Evaluator.class$("org.netbeans.spi.viewmodel.Model")) : class$org$netbeans$spi$viewmodel$Model);
            } else {
                treeModels = dm.lookup(this.viewType, class$org$netbeans$spi$viewmodel$TreeModel == null ? (class$org$netbeans$spi$viewmodel$TreeModel = Evaluator.class$("org.netbeans.spi.viewmodel.TreeModel")) : class$org$netbeans$spi$viewmodel$TreeModel);
                treeModelFilters = dm.lookup(this.viewType, class$org$netbeans$spi$viewmodel$TreeModelFilter == null ? (class$org$netbeans$spi$viewmodel$TreeModelFilter = Evaluator.class$("org.netbeans.spi.viewmodel.TreeModelFilter")) : class$org$netbeans$spi$viewmodel$TreeModelFilter);
                treeExpansionModels = dm.lookup(this.viewType, class$org$netbeans$spi$viewmodel$TreeExpansionModel == null ? (class$org$netbeans$spi$viewmodel$TreeExpansionModel = Evaluator.class$("org.netbeans.spi.viewmodel.TreeExpansionModel")) : class$org$netbeans$spi$viewmodel$TreeExpansionModel);
                nodeModels = dm.lookup(this.viewType, class$org$netbeans$spi$viewmodel$NodeModel == null ? (class$org$netbeans$spi$viewmodel$NodeModel = Evaluator.class$("org.netbeans.spi.viewmodel.NodeModel")) : class$org$netbeans$spi$viewmodel$NodeModel);
                nodeModelFilters = dm.lookup(this.viewType, class$org$netbeans$spi$viewmodel$NodeModelFilter == null ? (class$org$netbeans$spi$viewmodel$NodeModelFilter = Evaluator.class$("org.netbeans.spi.viewmodel.NodeModelFilter")) : class$org$netbeans$spi$viewmodel$NodeModelFilter);
                tableModels = dm.lookup(this.viewType, class$org$netbeans$spi$viewmodel$TableModel == null ? (class$org$netbeans$spi$viewmodel$TableModel = Evaluator.class$("org.netbeans.spi.viewmodel.TableModel")) : class$org$netbeans$spi$viewmodel$TableModel);
                tableModelFilters = dm.lookup(this.viewType, class$org$netbeans$spi$viewmodel$TableModelFilter == null ? (class$org$netbeans$spi$viewmodel$TableModelFilter = Evaluator.class$("org.netbeans.spi.viewmodel.TableModelFilter")) : class$org$netbeans$spi$viewmodel$TableModelFilter);
                nodeActionsProviders = dm.lookup(this.viewType, class$org$netbeans$spi$viewmodel$NodeActionsProvider == null ? (class$org$netbeans$spi$viewmodel$NodeActionsProvider = Evaluator.class$("org.netbeans.spi.viewmodel.NodeActionsProvider")) : class$org$netbeans$spi$viewmodel$NodeActionsProvider);
                nodeActionsProviderFilters = dm.lookup(this.viewType, class$org$netbeans$spi$viewmodel$NodeActionsProviderFilter == null ? (class$org$netbeans$spi$viewmodel$NodeActionsProviderFilter = Evaluator.class$("org.netbeans.spi.viewmodel.NodeActionsProviderFilter")) : class$org$netbeans$spi$viewmodel$NodeActionsProviderFilter);
                columnModels = dm.lookup(this.viewType, class$org$netbeans$spi$viewmodel$ColumnModel == null ? (class$org$netbeans$spi$viewmodel$ColumnModel = Evaluator.class$("org.netbeans.spi.viewmodel.ColumnModel")) : class$org$netbeans$spi$viewmodel$ColumnModel);
                mm = dm.lookup(this.viewType, class$org$netbeans$spi$viewmodel$Model == null ? (class$org$netbeans$spi$viewmodel$Model = Evaluator.class$("org.netbeans.spi.viewmodel.Model")) : class$org$netbeans$spi$viewmodel$Model);
            }
            ArrayList<List> treeNodeModelsCompound = new ArrayList<List>(11);
            treeNodeModelsCompound.add(treeModels);
            for (i = 0; i < 2; ++i) {
                treeNodeModelsCompound.add(Collections.EMPTY_LIST);
            }
            treeNodeModelsCompound.add(nodeModels);
            for (i = 0; i < 7; ++i) {
                treeNodeModelsCompound.add(Collections.EMPTY_LIST);
            }
            Models.CompoundModel treeNodeModel = Models.createCompoundModel(treeNodeModelsCompound);
            EvaluatorModel eTreeNodeModel = new EvaluatorModel(treeNodeModel, treeNodeModel);
            ArrayList<List> models = new ArrayList<List>(11);
            treeModels.clear();
            treeModels.add(eTreeNodeModel);
            models.add(treeModels);
            models.add(treeModelFilters);
            models.add(treeExpansionModels);
            nodeModels.clear();
            nodeModels.add(eTreeNodeModel);
            models.add(nodeModels);
            models.add(nodeModelFilters);
            models.add(tableModels);
            models.add(tableModelFilters);
            models.add(nodeActionsProviders);
            models.add(nodeActionsProviderFilters);
            models.add(columnModels);
            models.add(mm);
            Models.setModelsToView((JComponent)this.view, (Models.CompoundModel)Models.createCompoundModel(models));
        }
    }

    private static final class CompletionedEditor
    implements ComboBoxEditor {
        private JEditorPane editor = new JEditorPane("text/x-java", "");
        private Component component;
        private Object oldValue;

        public CompletionedEditor() {
            this.editor.setBorder(null);
            this.editor.setKeymap(new FilteredKeymap(this.editor.getKeymap()));
            this.component = new JScrollPane(this.editor, 21, 31);
        }

        public void addActionListener(ActionListener actionListener) {
        }

        public void removeActionListener(ActionListener actionListener) {
        }

        public Component getEditorComponent() {
            return this.component;
        }

        public Object getItem() {
            Object newValue = this.editor.getText();
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                if (newValue.equals(this.oldValue.toString())) {
                    return this.oldValue;
                }
                Class<?> cls = this.oldValue.getClass();
                try {
                    Method method = cls.getMethod("valueOf", class$java$lang$String == null ? (class$java$lang$String = Evaluator.class$("java.lang.String")) : class$java$lang$String);
                    newValue = method.invoke(this.oldValue, this.editor.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return newValue;
        }

        public void setItem(Object obj) {
            if (obj != null) {
                this.editor.setText(obj.toString());
                this.oldValue = obj;
            } else {
                this.editor.setText("");
            }
        }

        public void selectAll() {
            this.editor.selectAll();
            this.editor.requestFocus();
        }
    }

    private class EvaluateTask
    implements Runnable {
        private EvaluateTask() {
        }

        public void run() {
            String exp = Evaluator.this.getExpression();
            if (exp == null || exp.equals("")) {
                return;
            }
            try {
                Variable var = Evaluator.this.debugger.evaluate(exp);
                Evaluator.this.addExpressionToHistory(exp);
                Evaluator.this.displayResult(var);
            }
            catch (InvalidExpressionException ieex) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ieex.getLocalizedMessage()));
            }
        }
    }

    private class SessionListener
    extends DebuggerManagerAdapter {
        private boolean autoClosed = false;

        private SessionListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Session currentSession = DebuggerManager.getDebuggerManager().getCurrentSession();
            if (currentSession != null && currentSession.getCurrentLanguage().equals("Java")) {
                if (this.autoClosed) {
                    DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
                    if (de == null) {
                        return;
                    }
                    JPDADebugger debugger = (JPDADebugger)de.lookupFirst(null, class$org$netbeans$api$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$api$debugger$jpda$JPDADebugger = Evaluator.class$("org.netbeans.api.debugger.jpda.JPDADebugger")) : class$org$netbeans$api$debugger$jpda$JPDADebugger);
                    if (debugger == null) {
                        return;
                    }
                    Evaluator.open(debugger);
                    this.autoClosed = false;
                }
            } else if (evalDialog.isVisible()) {
                this.autoClosed = true;
                Evaluator.close();
            }
        }
    }
}

