/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.openide.util.RequestProcessor;

public class CurrentThreadAnnotationListener
extends DebuggerManagerAdapter {
    private transient Object currentPC;
    private transient Object currentPCLock = new Object();
    private transient boolean currentPCSet = false;
    private JPDAThread currentThread;
    private JPDADebugger currentDebugger;
    private HashMap stackAnnotations = new HashMap();
    private RequestProcessor rp = new RequestProcessor("Debugger Thread Annotation Refresher");
    private RequestProcessor.Task taskRemove;
    private RequestProcessor.Task taskAnnotate;
    private CallStackFrame[] stackToAnnotate;
    private SourcePath sourcePathToAnnotate;

    public String[] getProperties() {
        return new String[]{"currentEngine"};
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == "currentEngine") {
            this.updateCurrentDebugger();
            this.updateCurrentThread();
            this.annotate();
        } else if (e.getPropertyName() == "currentThread") {
            this.updateCurrentThread();
            this.annotate();
        } else if (e.getPropertyName() == "currentCallStackFrame") {
            this.updateCurrentThread();
            this.annotate();
        } else if (e.getPropertyName() == "state") {
            this.annotate();
        }
    }

    private void updateCurrentDebugger() {
        JPDADebugger newDebugger = CurrentThreadAnnotationListener.getCurrentDebugger();
        if (this.currentDebugger == newDebugger) {
            return;
        }
        if (this.currentDebugger != null) {
            this.currentDebugger.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (newDebugger != null) {
            newDebugger.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        this.currentDebugger = newDebugger;
    }

    private static JPDADebugger getCurrentDebugger() {
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return null;
        }
        return (JPDADebugger)currentEngine.lookupFirst(null, JPDADebugger.class);
    }

    private void updateCurrentThread() {
        this.currentThread = this.currentDebugger != null ? this.currentDebugger.getCurrentThread() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotate() {
        String language;
        CallStackFrame[] stack;
        if (this.currentThread == null || this.currentDebugger.getState() != 3) {
            Object object = this.currentPCLock;
            synchronized (object) {
                this.currentPCSet = false;
            }
            this.removeAnnotations();
            return;
        }
        try {
            stack = this.currentThread.getCallStack();
        }
        catch (AbsentInformationException ex) {
            Object object = this.currentPCLock;
            synchronized (object) {
                this.currentPCSet = false;
            }
            this.removeAnnotations();
            return;
        }
        final CallStackFrame csf = this.currentDebugger.getCurrentCallStackFrame();
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Session currentSession = DebuggerManager.getDebuggerManager().getCurrentSession();
        String string = language = currentSession == null ? null : currentSession.getCurrentLanguage();
        final SourcePath sourcePath = currentEngine == null ? null : (SourcePath)currentEngine.lookupFirst(null, SourcePath.class);
        Object object = this.currentPCLock;
        synchronized (object) {
            this.currentPCSet = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = CurrentThreadAnnotationListener.this.currentPCLock;
                synchronized (object) {
                    if (CurrentThreadAnnotationListener.this.currentPC != null) {
                        EditorContextBridge.removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                    }
                    if (csf != null && sourcePath != null && CurrentThreadAnnotationListener.this.currentThread != null) {
                        sourcePath.showSource(csf, language);
                        CurrentThreadAnnotationListener.this.currentPC = sourcePath.annotate(CurrentThreadAnnotationListener.this.currentThread, language);
                    }
                }
            }
        });
        this.annotateCallStack(stack, sourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAnnotations() {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove == null) {
                this.taskRemove = this.rp.create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = CurrentThreadAnnotationListener.this.currentPCLock;
                        synchronized (object) {
                            if (CurrentThreadAnnotationListener.this.currentPCSet) {
                                return;
                            }
                            if (CurrentThreadAnnotationListener.this.currentPC != null) {
                                EditorContextBridge.removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                            }
                            CurrentThreadAnnotationListener.this.currentPC = null;
                        }
                        Iterator i = CurrentThreadAnnotationListener.this.stackAnnotations.values().iterator();
                        while (i.hasNext()) {
                            EditorContextBridge.removeAnnotation(i.next());
                        }
                        CurrentThreadAnnotationListener.this.stackAnnotations.clear();
                    }
                });
            }
        }
        this.taskRemove.schedule(500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotateCallStack(CallStackFrame[] stack, SourcePath sourcePath) {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove != null) {
                this.taskRemove.cancel();
            }
            this.stackToAnnotate = stack;
            this.sourcePathToAnnotate = sourcePath;
            if (this.taskAnnotate == null) {
                this.taskAnnotate = this.rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        SourcePath sourcePath;
                        CallStackFrame[] stack;
                        RequestProcessor requestProcessor = CurrentThreadAnnotationListener.this.rp;
                        synchronized (requestProcessor) {
                            if (CurrentThreadAnnotationListener.this.stackToAnnotate == null) {
                                return;
                            }
                            stack = CurrentThreadAnnotationListener.this.stackToAnnotate;
                            sourcePath = CurrentThreadAnnotationListener.this.sourcePathToAnnotate;
                            CurrentThreadAnnotationListener.access$602(CurrentThreadAnnotationListener.this, null);
                            CurrentThreadAnnotationListener.this.sourcePathToAnnotate = null;
                        }
                        HashMap newAnnotations = new HashMap();
                        int k = stack.length;
                        for (int i = 1; i < k; ++i) {
                            String language = stack[i].getDefaultStratum();
                            String resourceName = EditorContextBridge.getRelativePath(stack[i], language);
                            int lineNumber = stack[i].getLineNumber(language);
                            String line = resourceName + lineNumber;
                            if (newAnnotations.containsKey(line)) continue;
                            Object da = CurrentThreadAnnotationListener.this.stackAnnotations.remove(line);
                            if (da == null) {
                                da = sourcePath.annotate(stack[i], language);
                            }
                            if (da == null) continue;
                            newAnnotations.put(line, da);
                        }
                        Iterator iter = CurrentThreadAnnotationListener.this.stackAnnotations.values().iterator();
                        while (iter.hasNext()) {
                            EditorContextBridge.removeAnnotation(iter.next());
                        }
                        CurrentThreadAnnotationListener.this.stackAnnotations = newAnnotations;
                    }
                });
            }
        }
        this.taskAnnotate.schedule(500);
    }

    static /* synthetic */ CallStackFrame[] access$602(CurrentThreadAnnotationListener x0, CallStackFrame[] x1) {
        x0.stackToAnnotate = x1;
        return x1;
    }
}

