/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class LibraryManager {
    public static final String PROP_LIBRARIES = "libraries";
    private static LibraryManager instance;
    private Lookup.Result result;
    private Collection currentStorages = new ArrayList();
    private PropertyChangeListener plistener;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private Collection cache;
    static final /* synthetic */ boolean $assertionsDisabled;

    private LibraryManager() {
    }

    public Library getLibrary(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        Library[] libs = this.getLibraries();
        for (int i = 0; i < libs.length; ++i) {
            if (!name.equals(libs[i].getName())) continue;
            return libs[i];
        }
        return null;
    }

    public synchronized Library[] getLibraries() {
        if (this.cache == null) {
            if (this.result == null) {
                this.plistener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        LibraryManager.this.resetCache();
                    }
                };
                this.result = Lookup.getDefault().lookup(new Lookup.Template(LibraryProvider.class));
                this.result.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent ev) {
                        LibraryManager.this.resetCache();
                    }
                });
            }
            ArrayList<Library> l = new ArrayList<Library>();
            Collection instances = this.result.allInstances();
            HashSet added = new HashSet(instances);
            added.removeAll(this.currentStorages);
            HashSet removed = new HashSet(this.currentStorages);
            removed.removeAll(instances);
            this.currentStorages.clear();
            Iterator it = instances.iterator();
            while (it.hasNext()) {
                LibraryProvider storage = (LibraryProvider)it.next();
                this.currentStorages.add(storage);
                LibraryImplementation[] impls = storage.getLibraries();
                for (int i = 0; i < impls.length; ++i) {
                    l.add(new Library(impls[i]));
                }
            }
            it = removed.iterator();
            while (it.hasNext()) {
                ((LibraryProvider)it.next()).removePropertyChangeListener(this.plistener);
            }
            it = added.iterator();
            while (it.hasNext()) {
                ((LibraryProvider)it.next()).addPropertyChangeListener(this.plistener);
            }
            this.cache = l;
        }
        return this.cache.toArray(new Library[this.cache.size()]);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!$assertionsDisabled && listener == null) {
            throw new AssertionError();
        }
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (!$assertionsDisabled && listener == null) {
            throw new AssertionError();
        }
        this.listeners.removePropertyChangeListener(listener);
    }

    private synchronized void resetCache() {
        this.cache = null;
        this.listeners.firePropertyChange(PROP_LIBRARIES, null, null);
    }

    public static synchronized LibraryManager getDefault() {
        if (instance == null) {
            instance = new LibraryManager();
        }
        return instance;
    }

    static {
        $assertionsDisabled = !LibraryManager.class.desiredAssertionStatus();
    }
}

