/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.sun.dd.api.VersionNotSupportedException;
import org.netbeans.modules.j2ee.sun.dd.api.common.LoginConfig;
import org.netbeans.modules.j2ee.sun.dd.api.common.MessageSecurityBinding;
import org.netbeans.modules.j2ee.sun.dd.api.common.WebserviceEndpoint;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.WebServiceDescriptor;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.TextMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.EditBinding;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.EndpointMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.WebServiceDescriptorCustomizer;
import org.openide.ErrorManager;

public class SelectedEndpointPanel
extends JPanel {
    private static final int SECURITY_NONE = 0;
    private static final int SECURITY_AUTHENTICATION = 1;
    private static final int SECURITY_MESSAGE = 2;
    private static final ResourceBundle commonBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private static final ResourceBundle webserviceBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.Bundle");
    private static final TextMapping[] authMethodTypes = new TextMapping[]{new TextMapping("", ""), new TextMapping("BASIC", webserviceBundle.getString("AUTHORIZATION_Basic")), new TextMapping("CLIENT-CERT", webserviceBundle.getString("AUTHORIZATION_ClientCert"))};
    private static final TextMapping[] transportTypes = new TextMapping[]{new TextMapping("", ""), new TextMapping("NONE", webserviceBundle.getString("TRANSPORT_None")), new TextMapping("INTEGRAL", webserviceBundle.getString("TRANSPORT_Integral")), new TextMapping("CONFIDENTIAL", webserviceBundle.getString("TRANSPORT_Confidential"))};
    private WebServiceDescriptorCustomizer masterPanel;
    private EndpointMapping selectedEndpointMap;
    private WebserviceEndpoint selectedEndpoint;
    private boolean selectedEndpointSetup;
    private LoginConfig loginConfig;
    private MessageSecurityBinding messageBinding;
    private DefaultComboBoxModel authMethodModel;
    private DefaultComboBoxModel transportGuaranteeModel;
    private boolean as90FeaturesVisible;
    private ButtonGroup bgSecurity;
    private JButton jBtnEditBindings;
    private JComboBox jCbxAuthentication;
    private JComboBox jCbxTransportGuarantee;
    private JCheckBox jChkDebugEnabled;
    private JCheckBox jChkEnableMsgSecurity;
    private JLabel jLblAuthentication;
    private JLabel jLblDebugEnabled;
    private JLabel jLblEnableMsgSecurity;
    private JLabel jLblEndpointAddressURI;
    private JLabel jLblRealm;
    private JLabel jLblSecuritySettings;
    private JLabel jLblTransportGuarantee;
    private JRadioButton jRBnLoginConfig;
    private JRadioButton jRBnMessageSecurity;
    private JRadioButton jRBnNoSecurity;
    private JTextField jTxtEndpointAddressURI;
    private JTextField jTxtRealm;

    public SelectedEndpointPanel(WebServiceDescriptorCustomizer src) {
        this.masterPanel = src;
        this.selectedEndpointSetup = false;
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.bgSecurity = new ButtonGroup();
        this.jLblEndpointAddressURI = new JLabel();
        this.jTxtEndpointAddressURI = new JTextField();
        this.jLblTransportGuarantee = new JLabel();
        this.jCbxTransportGuarantee = new JComboBox();
        this.jLblDebugEnabled = new JLabel();
        this.jChkDebugEnabled = new JCheckBox();
        this.jLblSecuritySettings = new JLabel();
        this.jRBnNoSecurity = new JRadioButton();
        this.jRBnMessageSecurity = new JRadioButton();
        this.jLblEnableMsgSecurity = new JLabel();
        this.jChkEnableMsgSecurity = new JCheckBox();
        this.jBtnEditBindings = new JButton();
        this.jRBnLoginConfig = new JRadioButton();
        this.jLblRealm = new JLabel();
        this.jTxtRealm = new JTextField();
        this.jLblAuthentication = new JLabel();
        this.jCbxAuthentication = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.jLblEndpointAddressURI.setLabelFor(this.jTxtEndpointAddressURI);
        this.jLblEndpointAddressURI.setText(WebServiceDescriptorCustomizer.bundle.getString("LBL_EndpointAddressURI_1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblEndpointAddressURI, gridBagConstraints);
        this.jTxtEndpointAddressURI.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                SelectedEndpointPanel.this.jTxtEndpointAddressURIKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jTxtEndpointAddressURI, gridBagConstraints);
        this.jTxtEndpointAddressURI.getAccessibleContext().setAccessibleName(WebServiceDescriptorCustomizer.bundle.getString("ACSN_EndpointAddressURI"));
        this.jTxtEndpointAddressURI.getAccessibleContext().setAccessibleDescription(WebServiceDescriptorCustomizer.bundle.getString("ACSD_EndpointAddressURI"));
        this.jLblTransportGuarantee.setLabelFor(this.jCbxTransportGuarantee);
        this.jLblTransportGuarantee.setText(WebServiceDescriptorCustomizer.bundle.getString("LBL_TransportGuarantee_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblTransportGuarantee, gridBagConstraints);
        this.jCbxTransportGuarantee.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectedEndpointPanel.this.jCbxTransportGuaranteeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jCbxTransportGuarantee, gridBagConstraints);
        this.jCbxTransportGuarantee.getAccessibleContext().setAccessibleName(WebServiceDescriptorCustomizer.bundle.getString("ACSN_TransportGuarantee"));
        this.jCbxTransportGuarantee.getAccessibleContext().setAccessibleDescription(WebServiceDescriptorCustomizer.bundle.getString("ACSD_TransportGuarantee"));
        this.jLblDebugEnabled.setLabelFor(this.jChkDebugEnabled);
        this.jLblDebugEnabled.setText(WebServiceDescriptorCustomizer.bundle.getString("LBL_DebugEnabled_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblDebugEnabled, gridBagConstraints);
        this.jChkDebugEnabled.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jChkDebugEnabled.setMargin(new Insets(0, 0, 0, 0));
        this.jChkDebugEnabled.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SelectedEndpointPanel.this.jChkDebugEnabledItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jChkDebugEnabled, gridBagConstraints);
        this.jChkDebugEnabled.getAccessibleContext().setAccessibleName(WebServiceDescriptorCustomizer.bundle.getString("ACSN_DebugEnabled"));
        this.jChkDebugEnabled.getAccessibleContext().setAccessibleDescription(WebServiceDescriptorCustomizer.bundle.getString("ACSD_DebugEnabled"));
        this.jLblSecuritySettings.setText("Security Settings :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 6, 0, 0);
        this.add((Component)this.jLblSecuritySettings, gridBagConstraints);
        this.bgSecurity.add(this.jRBnNoSecurity);
        this.jRBnNoSecurity.setText("No Security");
        this.jRBnNoSecurity.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRBnNoSecurity.setMargin(new Insets(0, 0, 0, 0));
        this.jRBnNoSecurity.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectedEndpointPanel.this.jRBnNoSecurityActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.jRBnNoSecurity, gridBagConstraints);
        this.bgSecurity.add(this.jRBnMessageSecurity);
        this.jRBnMessageSecurity.setText("Message Security");
        this.jRBnMessageSecurity.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRBnMessageSecurity.setMargin(new Insets(0, 0, 0, 0));
        this.jRBnMessageSecurity.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectedEndpointPanel.this.jRBnMessageSecurityActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 5, 0);
        this.add((Component)this.jRBnMessageSecurity, gridBagConstraints);
        this.jLblEnableMsgSecurity.setLabelFor(this.jChkEnableMsgSecurity);
        this.jLblEnableMsgSecurity.setText(WebServiceDescriptorCustomizer.bundle.getString("LBL_EnableMsgSecurity_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 5, 0);
        this.add((Component)this.jLblEnableMsgSecurity, gridBagConstraints);
        this.jChkEnableMsgSecurity.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jChkEnableMsgSecurity.setMargin(new Insets(0, 0, 0, 0));
        this.jChkEnableMsgSecurity.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SelectedEndpointPanel.this.jChkEnableMsgSecurityItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 5, 12);
        this.add((Component)this.jChkEnableMsgSecurity, gridBagConstraints);
        this.jChkEnableMsgSecurity.getAccessibleContext().setAccessibleName(WebServiceDescriptorCustomizer.bundle.getString("ACSN_EnableMsgSecurity"));
        this.jChkEnableMsgSecurity.getAccessibleContext().setAccessibleDescription(WebServiceDescriptorCustomizer.bundle.getString("ACSD_EnableMsgSecurity"));
        this.jBtnEditBindings.setText(WebServiceDescriptorCustomizer.bundle.getString("LBL_EditMsgSecBindings"));
        this.jBtnEditBindings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectedEndpointPanel.this.jBtnEditBindingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        this.add((Component)this.jBtnEditBindings, gridBagConstraints);
        this.jBtnEditBindings.getAccessibleContext().setAccessibleName(WebServiceDescriptorCustomizer.bundle.getString("ACSN_EditMsgSecBindings"));
        this.jBtnEditBindings.getAccessibleContext().setAccessibleDescription(WebServiceDescriptorCustomizer.bundle.getString("ACSD_EditMsgSecBindings"));
        this.bgSecurity.add(this.jRBnLoginConfig);
        this.jRBnLoginConfig.setText("Login Configuration");
        this.jRBnLoginConfig.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRBnLoginConfig.setMargin(new Insets(0, 0, 0, 0));
        this.jRBnLoginConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectedEndpointPanel.this.jRBnLoginConfigActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 12, 0, 0);
        this.add((Component)this.jRBnLoginConfig, gridBagConstraints);
        this.jLblRealm.setLabelFor(this.jTxtRealm);
        this.jLblRealm.setText("Realm :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 6, 0, 0);
        this.add((Component)this.jLblRealm, gridBagConstraints);
        this.jTxtRealm.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                SelectedEndpointPanel.this.jTxtRealmKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 6, 0, 5);
        this.add((Component)this.jTxtRealm, gridBagConstraints);
        this.jLblAuthentication.setLabelFor(this.jCbxAuthentication);
        this.jLblAuthentication.setText("Authentication Method :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 5, 0);
        this.add((Component)this.jLblAuthentication, gridBagConstraints);
        this.jCbxAuthentication.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectedEndpointPanel.this.jCbxAuthenticationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        this.add((Component)this.jCbxAuthentication, gridBagConstraints);
    }

    private void jRBnLoginConfigActionPerformed(ActionEvent evt) {
        if (!this.selectedEndpointSetup) {
            this.selectedEndpoint.setLoginConfig((LoginConfig)this.loginConfig.clone());
            String authMethod = this.loginConfig.getAuthMethod();
            this.jCbxAuthentication.setSelectedItem(this.getAuthorizationMethodMapping(authMethod));
            if (this.as90FeaturesVisible) {
                try {
                    String realm = this.loginConfig.getRealm();
                    this.jTxtRealm.setText(realm);
                }
                catch (VersionNotSupportedException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            this.enableMessageSecurityUI(false);
            this.enableAuthenticationUI(true);
            this.masterPanel.getBean().firePropertyChange("loginConfig", null, this.loginConfig);
        }
    }

    private void jRBnMessageSecurityActionPerformed(ActionEvent evt) {
        if (!this.selectedEndpointSetup) {
            try {
                this.selectedEndpoint.setMessageSecurityBinding((MessageSecurityBinding)this.messageBinding.clone());
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            this.jCbxAuthentication.setSelectedItem(this.getAuthorizationMethodMapping(""));
            this.jTxtRealm.setText("");
            this.enableMessageSecurityUI(true);
            this.enableAuthenticationUI(false);
            this.masterPanel.getBean().firePropertyChange("messageSecurity", null, this.messageBinding);
        }
    }

    private void jRBnNoSecurityActionPerformed(ActionEvent evt) {
        if (!this.selectedEndpointSetup) {
            this.selectedEndpoint.setLoginConfig(null);
            try {
                this.selectedEndpoint.setMessageSecurityBinding(null);
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            this.jCbxAuthentication.setSelectedItem(this.getAuthorizationMethodMapping(""));
            this.jTxtRealm.setText("");
            this.enableMessageSecurityUI(false);
            this.enableAuthenticationUI(false);
            this.masterPanel.getBean().setDirty();
        }
    }

    private void jTxtRealmKeyReleased(KeyEvent evt) {
        String newRealm;
        if (!this.selectedEndpointSetup && this.jRBnLoginConfig.isSelected() && this.jRBnLoginConfig.isVisible() && Utils.notEmpty(newRealm = this.jTxtRealm.getText())) {
            try {
                String oldRealm = this.loginConfig.getRealm();
                newRealm = newRealm.trim();
                if (!Utils.strEquals(newRealm, oldRealm)) {
                    this.loginConfig.setRealm(newRealm);
                    this.selectedEndpoint.getLoginConfig().setRealm(newRealm);
                    this.masterPanel.getBean().firePropertyChange("loginConfig-realm", oldRealm, newRealm);
                }
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    private void jCbxAuthenticationActionPerformed(ActionEvent evt) {
        if (!this.selectedEndpointSetup && this.jRBnLoginConfig.isSelected() && this.jRBnLoginConfig.isVisible()) {
            TextMapping authMapping = (TextMapping)this.authMethodModel.getSelectedItem();
            String oldAuthMethod = this.loginConfig.getAuthMethod();
            String newAuthMethod = authMapping.getXMLString();
            if (!Utils.strEquals(newAuthMethod, oldAuthMethod)) {
                this.loginConfig.setAuthMethod(newAuthMethod);
                this.selectedEndpoint.getLoginConfig().setAuthMethod(newAuthMethod);
                this.masterPanel.getBean().firePropertyChange("loginConfig-authMethod", oldAuthMethod, newAuthMethod);
            }
        }
    }

    private void jCbxTransportGuaranteeActionPerformed(ActionEvent evt) {
        if (!this.selectedEndpointSetup) {
            TextMapping transportMapping = (TextMapping)this.transportGuaranteeModel.getSelectedItem();
            String oldTransportGuarantee = this.selectedEndpoint.getTransportGuarantee();
            String newTransportGuarantee = transportMapping.getXMLString();
            if (!Utils.strEquals(newTransportGuarantee, oldTransportGuarantee)) {
                this.selectedEndpoint.setTransportGuarantee(newTransportGuarantee);
                this.masterPanel.getBean().firePropertyChange("transportGuarantee", oldTransportGuarantee, newTransportGuarantee);
            }
        }
    }

    private void jChkEnableMsgSecurityItemStateChanged(ItemEvent evt) {
        if (!this.selectedEndpointSetup) {
            boolean hasMessageSecurity = Utils.interpretCheckboxState(evt);
            try {
                MessageSecurityBinding oldBinding = null;
                MessageSecurityBinding newBinding = null;
                if (hasMessageSecurity) {
                    if (this.messageBinding != null) {
                        newBinding = (MessageSecurityBinding)this.messageBinding.clone();
                        this.selectedEndpoint.setMessageSecurityBinding(newBinding);
                    }
                } else {
                    oldBinding = this.messageBinding = this.selectedEndpoint.getMessageSecurityBinding();
                    this.selectedEndpoint.setMessageSecurityBinding(null);
                }
                this.masterPanel.getBean().firePropertyChange("messageSecurityBinding", oldBinding, newBinding);
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            this.enableMessageSecurityUI(hasMessageSecurity);
        }
    }

    private void jChkDebugEnabledItemStateChanged(ItemEvent evt) {
        if (!this.selectedEndpointSetup) {
            boolean newDebugEnabledFlag = Utils.interpretCheckboxState(evt);
            try {
                String oldDebugEnabled = this.selectedEndpoint.getDebuggingEnabled();
                String newDebugEnabled = newDebugEnabledFlag ? "true" : null;
                this.selectedEndpoint.setDebuggingEnabled(newDebugEnabled);
                this.masterPanel.getBean().firePropertyChange("debugEnabled", oldDebugEnabled, newDebugEnabled);
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    private void jTxtEndpointAddressURIKeyReleased(KeyEvent evt) {
        if (!this.selectedEndpointSetup) {
            String oldEndpointAddressUri = this.selectedEndpoint.getEndpointAddressUri();
            String newEndpointAddressUri = this.jTxtEndpointAddressURI.getText().trim();
            if (!Utils.strEquals(newEndpointAddressUri, oldEndpointAddressUri)) {
                this.selectedEndpoint.setEndpointAddressUri(newEndpointAddressUri);
                this.masterPanel.getBean().firePropertyChange("endpointAddressUri", oldEndpointAddressUri, newEndpointAddressUri);
            }
        }
    }

    private void jBtnEditBindingsActionPerformed(ActionEvent evt) {
        if (!this.selectedEndpointSetup) {
            try {
                WebServiceDescriptor theBean = this.masterPanel.getBean();
                ASDDVersion asVersion = theBean.getAppServerVersion();
                String asCloneVersion = "";
                if (theBean.isWarModule()) {
                    asCloneVersion = asVersion.getWebAppVersionAsString();
                } else if (theBean.isEjbModule()) {
                    asCloneVersion = asVersion.getEjbJarVersionAsString();
                }
                MessageSecurityBinding binding = this.selectedEndpoint.getMessageSecurityBinding();
                if (binding == null) {
                    binding = this.selectedEndpoint.newMessageSecurityBinding();
                    this.selectedEndpoint.setMessageSecurityBinding(binding);
                }
                EditBinding.editMessageSecurityBinding(this.masterPanel, theBean, false, binding, asVersion, asCloneVersion);
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    private void initUserComponents() {
        int i;
        this.as90FeaturesVisible = true;
        this.authMethodModel = new DefaultComboBoxModel();
        for (i = 0; i < authMethodTypes.length; ++i) {
            this.authMethodModel.addElement(authMethodTypes[i]);
        }
        this.jCbxAuthentication.setModel(this.authMethodModel);
        this.transportGuaranteeModel = new DefaultComboBoxModel();
        for (i = 0; i < transportTypes.length; ++i) {
            this.transportGuaranteeModel.addElement(transportTypes[i]);
        }
        this.jCbxTransportGuarantee.setModel(this.transportGuaranteeModel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JPanel(), gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndpointMapping(EndpointMapping endpointMapping) {
        block26: {
            try {
                this.selectedEndpointSetup = true;
                WebServiceDescriptor theBean = this.masterPanel.getBean();
                ASDDVersion asVersion = theBean.getAppServerVersion();
                String asCloneVersion = "";
                this.selectedEndpointMap = endpointMapping;
                if (theBean.isWarModule()) {
                    asCloneVersion = asVersion.getWebAppVersionAsString();
                } else if (theBean.isEjbModule()) {
                    asCloneVersion = asVersion.getEjbJarVersionAsString();
                }
                this.handleAS90FieldVisibility(ASDDVersion.SUN_APPSERVER_9_0.compareTo(asVersion) <= 0);
                this.showSecurityUI(theBean.isWarModule(), theBean.isEjbModule());
                this.selectedEndpoint = this.selectedEndpointMap != null ? this.selectedEndpointMap.getEndpoint() : null;
                if (this.selectedEndpoint != null) {
                    this.jTxtEndpointAddressURI.setText(this.selectedEndpoint.getEndpointAddressUri());
                    String transportGuarantee = this.selectedEndpoint.getTransportGuarantee();
                    this.jCbxTransportGuarantee.setSelectedItem(this.getTransportGuaranteeMapping(transportGuarantee));
                    if (this.as90FeaturesVisible) {
                        boolean debugEnabled;
                        try {
                            debugEnabled = Utils.booleanValueOf(this.selectedEndpoint.getDebuggingEnabled());
                        }
                        catch (VersionNotSupportedException ex) {
                            debugEnabled = false;
                        }
                        this.jChkDebugEnabled.setSelected(debugEnabled);
                    }
                    boolean authenticationEnabled = false;
                    boolean messageSecurityEnabled = false;
                    this.loginConfig = this.selectedEndpoint.getLoginConfig();
                    if (this.loginConfig != null) {
                        this.loginConfig = (LoginConfig)this.loginConfig.cloneVersion(asCloneVersion);
                        authenticationEnabled = true;
                    } else {
                        this.loginConfig = this.selectedEndpoint.newLoginConfig();
                    }
                    try {
                        this.messageBinding = this.selectedEndpoint.getMessageSecurityBinding();
                        if (this.messageBinding != null) {
                            this.messageBinding = (MessageSecurityBinding)this.messageBinding.cloneVersion(asCloneVersion);
                            messageSecurityEnabled = true;
                        } else {
                            this.messageBinding = this.masterPanel.getBean().getConfig().getStorageFactory().createMessageSecurityBinding();
                        }
                    }
                    catch (VersionNotSupportedException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                        this.messageBinding = null;
                    }
                    if (theBean.isWarModule()) {
                        this.jChkEnableMsgSecurity.setSelected(messageSecurityEnabled);
                        this.enableMessageSecurityUI(messageSecurityEnabled);
                    } else if (theBean.isEjbModule()) {
                        if (messageSecurityEnabled) {
                            this.jRBnMessageSecurity.setSelected(true);
                            this.jCbxAuthentication.setSelectedItem(this.getAuthorizationMethodMapping(""));
                            this.jTxtRealm.setText("");
                        } else if (authenticationEnabled) {
                            this.jRBnLoginConfig.setSelected(true);
                            String authMethod = this.loginConfig.getAuthMethod();
                            this.jCbxAuthentication.setSelectedItem(this.getAuthorizationMethodMapping(authMethod));
                            if (this.as90FeaturesVisible) {
                                try {
                                    String realm = this.loginConfig.getRealm();
                                    this.jTxtRealm.setText(realm);
                                }
                                catch (VersionNotSupportedException ex) {
                                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                                }
                            }
                        } else {
                            this.jRBnNoSecurity.setSelected(true);
                            this.jCbxAuthentication.setSelectedItem(this.getAuthorizationMethodMapping(""));
                            this.jTxtRealm.setText("");
                        }
                        this.enableMessageSecurityUI(messageSecurityEnabled);
                        this.enableAuthenticationUI(authenticationEnabled);
                    }
                    break block26;
                }
                this.jTxtEndpointAddressURI.setText("");
                this.jCbxTransportGuarantee.setSelectedItem(this.getTransportGuaranteeMapping(null));
                this.jChkDebugEnabled.setSelected(false);
                this.enableMessageSecurityUI(false);
            }
            finally {
                this.selectedEndpointSetup = false;
            }
        }
    }

    private void handleAS90FieldVisibility(boolean visible) {
        if (this.as90FeaturesVisible != visible) {
            this.jLblDebugEnabled.setVisible(visible);
            this.jChkDebugEnabled.setVisible(visible);
            this.as90FeaturesVisible = visible;
        }
    }

    void reloadEndpointMapping() {
        this.setEndpointMapping(this.selectedEndpointMap);
    }

    private void showSecurityUI(boolean showForWebApp, boolean showForEjbJar) {
        this.jLblEnableMsgSecurity.setVisible(showForWebApp);
        this.jChkEnableMsgSecurity.setVisible(showForWebApp);
        this.jLblSecuritySettings.setVisible(showForEjbJar);
        this.jRBnNoSecurity.setVisible(showForEjbJar);
        this.jRBnMessageSecurity.setVisible(showForEjbJar);
        this.jRBnLoginConfig.setVisible(showForEjbJar);
        this.jLblRealm.setVisible(showForEjbJar && this.as90FeaturesVisible);
        this.jTxtRealm.setVisible(showForEjbJar && this.as90FeaturesVisible);
        this.jLblAuthentication.setVisible(showForEjbJar);
        this.jCbxAuthentication.setVisible(showForEjbJar);
        this.jBtnEditBindings.setVisible(showForWebApp || showForEjbJar);
    }

    private void enableMessageSecurityUI(boolean enable) {
        this.jBtnEditBindings.setEnabled(enable);
    }

    private void enableAuthenticationUI(boolean enable) {
        this.jLblRealm.setEnabled(enable);
        this.jTxtRealm.setEnabled(enable);
        this.jLblAuthentication.setEnabled(enable);
        this.jCbxAuthentication.setEnabled(enable);
    }

    private TextMapping getAuthorizationMethodMapping(String xmlKey) {
        TextMapping result = authMethodTypes[0];
        if (xmlKey == null) {
            xmlKey = "";
        }
        for (int i = 0; i < authMethodTypes.length; ++i) {
            if (authMethodTypes[i].getXMLString().compareTo(xmlKey) != 0) continue;
            result = authMethodTypes[i];
            break;
        }
        return result;
    }

    private TextMapping getTransportGuaranteeMapping(String xmlKey) {
        TextMapping result = transportTypes[0];
        if (xmlKey == null) {
            xmlKey = "";
        }
        for (int i = 0; i < transportTypes.length; ++i) {
            if (transportTypes[i].getXMLString().compareTo(xmlKey) != 0) continue;
            result = transportTypes[i];
            break;
        }
        return result;
    }

    public void setContainerEnabled(Container container, boolean enabled) {
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(enabled);
            if (!(components[i] instanceof Container)) continue;
            this.setContainerEnabled((Container)components[i], enabled);
        }
    }
}

