/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.StorageBeanFactory;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppCache;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTablePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.DynamicPropertyPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyListMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.CacheHelperEntryPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.PropertiesEntry;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.WebAppRootCustomizer;

public class CacheHelperPanel
extends JPanel
implements TableModelListener {
    private static final ResourceBundle commonBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private static final ResourceBundle webappBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");
    private WebAppRootCustomizer masterPanel;
    private GenericTableModel defaultHelperPropertiesModel;
    private GenericTablePanel defaultHelperPropertiesPanel;
    private GenericTableModel cacheHelperClassesModel;
    private GenericTablePanel cacheHelperClassesPanel;
    static GenericTableModel.ParentPropertyFactory cacheHelperFactory = new GenericTableModel.ParentPropertyFactory(){

        public CommonDDBean newParentProperty(ASDDVersion asVersion) {
            return StorageBeanFactory.getStorageBeanFactory(asVersion).createCacheHelper();
        }
    };

    public CacheHelperPanel(WebAppRootCustomizer src) {
        this.masterPanel = src;
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_CacheHelpersTab"));
        this.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_CacheHelpersTab"));
    }

    private void initUserComponents() {
        ArrayList<GenericTableModel.TableEntry> tableColumns = new ArrayList<GenericTableModel.TableEntry>(3);
        tableColumns.add(new GenericTableModel.AttributeEntry("Name", commonBundle.getString("LBL_Name"), true));
        tableColumns.add(new GenericTableModel.AttributeEntry("Value", commonBundle.getString("LBL_Value"), true));
        tableColumns.add(new GenericTableModel.ValueEntry("Description", commonBundle.getString("LBL_Description")));
        this.defaultHelperPropertiesModel = new GenericTableModel("WebProperty", WebAppRootCustomizer.webPropertyFactory, tableColumns);
        this.defaultHelperPropertiesPanel = new GenericTablePanel(this.defaultHelperPropertiesModel, webappBundle, "DefaultHelperProperties", DynamicPropertyPanel.class, "AS_CFG_WebAppCacheDefaultHelperProperty", PropertyListMapping.getPropertyList("CacheDefaultHelperProperties"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.defaultHelperPropertiesPanel, gridBagConstraints);
        tableColumns = new ArrayList(3);
        tableColumns.add(new GenericTableModel.AttributeEntry("Name", commonBundle.getString("LBL_Name"), true));
        tableColumns.add(new GenericTableModel.AttributeEntry("ClassName", webappBundle.getString("LBL_Classname"), true));
        tableColumns.add(new PropertiesEntry());
        this.cacheHelperClassesModel = new GenericTableModel(cacheHelperFactory, tableColumns);
        this.cacheHelperClassesPanel = new GenericTablePanel(this.cacheHelperClassesModel, webappBundle, "CacheHelperProperties", CacheHelperEntryPanel.class, "AS_CFG_WebAppCacheHelperDefinition");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 5);
        this.add((Component)this.cacheHelperClassesPanel, gridBagConstraints);
    }

    public void addListeners() {
        this.defaultHelperPropertiesModel.addTableModelListener(this);
        this.cacheHelperClassesModel.addTableModelListener(this);
    }

    public void removeListeners() {
        this.defaultHelperPropertiesModel.removeTableModelListener(this);
        this.cacheHelperClassesModel.removeTableModelListener(this);
    }

    public void initFields(WebAppCache cacheBean) {
        ASDDVersion asVersion = cacheBean.getParent().getAppServerVersion();
        this.defaultHelperPropertiesPanel.setModel((CommonDDBean)cacheBean.getDefaultHelper(), asVersion);
        this.cacheHelperClassesPanel.setModel(cacheBean.getCacheHelpers(), asVersion);
    }

    public void tableChanged(TableModelEvent e) {
        WebAppRoot bean = this.masterPanel.getBean();
        if (bean != null) {
            WebAppCache cacheBean = bean.getCacheBean();
            Object eventSource = e.getSource();
            try {
                if (eventSource != this.defaultHelperPropertiesModel && eventSource == this.cacheHelperClassesModel) {
                    List cacheHelperList = this.cacheHelperClassesModel.getData();
                    cacheBean.setCacheHelpers(cacheHelperList);
                    this.masterPanel.firePropertyChange("CacheHelperListChanged", false, true);
                }
                bean.setDirty();
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
        }
    }
}

