/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.FixedHeightJTable;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.MethodTableModel;

public abstract class MethodTablePanel
extends JPanel {
    private MethodTableModel model;
    protected TableWithToolTips methodTable;
    protected JScrollPane tablePane;
    protected JPanel tablePanel;
    public static final Color DisabledBackgroundColor = Color.lightGray;
    public static final Color EnabledBackgroundColor = Color.white;
    public static final Color DisabledTextColor = Color.darkGray;

    public MethodTablePanel(MethodTableModel model) {
        this.model = model;
        this.initComponents();
    }

    public MethodTablePanel() {
        this.model = this.getMethodTableModel();
        this.initComponents();
    }

    protected void setData() {
        this.methodTable.setModel(this.model);
    }

    protected abstract MethodTableModel getMethodTableModel();

    protected abstract String getTablePaneAcsblName();

    protected abstract String getTablePaneAcsblDesc();

    protected abstract String getTablePaneToolTip();

    protected String getToolTip(int row, int col) {
        return null;
    }

    protected String getToolTip(int col) {
        return null;
    }

    protected void initComponents() {
        if (this.model == null) {
            return;
        }
        this.setLayout(new GridBagLayout());
        this.methodTable = new TableWithToolTips();
        JTableHeader header = this.methodTable.getTableHeader();
        ColumnHeaderToolTips tips = new ColumnHeaderToolTips();
        header.addMouseMotionListener(tips);
        this.methodTable.setModel(this.model);
        this.methodTable.setRowSelectionAllowed(false);
        this.methodTable.setSelectionMode(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel panel = this.getPanel();
        if (panel != null) {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(6, 6, 0, 5);
            this.add((Component)panel, gridBagConstraints);
        }
        this.tablePane = new JScrollPane(this.methodTable);
        this.tablePane.setOpaque(true);
        this.tablePane.setToolTipText(this.getTablePaneToolTip());
        this.add((Component)this.tablePane, this.getTableGridBagConstraints());
        this.tablePane.getAccessibleContext().setAccessibleName(this.getTablePaneAcsblName());
        this.tablePane.getAccessibleContext().setAccessibleDescription(this.getTablePaneAcsblDesc());
    }

    protected JPanel getPanel() {
        return null;
    }

    protected GridBagConstraints getTableGridBagConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        return gridBagConstraints;
    }

    protected void setColumnRenderer(TableCellRenderer renderer, int col) {
        TableColumnModel columnModel = this.methodTable.getColumnModel();
        TableColumn column = columnModel.getColumn(col);
        column.setCellRenderer(renderer);
    }

    protected void setColumnEditor(TableCellEditor editor, int col) {
        TableColumnModel columnModel = this.methodTable.getColumnModel();
        TableColumn column = columnModel.getColumn(col);
        column.setCellEditor(editor);
    }

    protected TableColumn getColumn(int n, JTable table) {
        return n >= 0 && n < table.getColumnCount() ? table.getColumnModel().getColumn(n) : null;
    }

    protected void adjustColumnWidth(int c, boolean includeEditor) {
        this.adjustColumnWidth(this.methodTable, c, null, includeEditor);
    }

    protected void adjustColumnWidth(JTable table, int c, Object templateValue, boolean includeEditor) {
        TableColumn tc = this.getColumn(c, table);
        if (tc == null) {
            System.out.println("Invalid column index: " + c);
            return;
        }
        int actualWidth = tc.getWidth();
        TableCellRenderer hr = tc.getHeaderRenderer();
        if (hr == null) {
            hr = table.getTableHeader().getDefaultRenderer();
        }
        Component hc = hr.getTableCellRendererComponent(table, tc.getHeaderValue(), false, false, 0, c);
        int prefWidth = hc.getPreferredSize().width;
        if (templateValue != null) {
            TableCellRenderer rend = table.getCellRenderer(0, c);
            Component comp = this.getTableCellRendererComponent(rend, table, templateValue, false, false, 0, c, false);
            Dimension ps = comp.getPreferredSize();
            if (ps.width > prefWidth) {
                prefWidth = ps.width;
            }
        }
        for (int r = 0; r < this.methodTable.getRowCount(); ++r) {
            Object v;
            Component comp;
            TableCellEditor tce;
            if (includeEditor && table.getModel().isCellEditable(r, c) && (tce = table.getCellEditor(r, c)) instanceof DefaultCellEditor && (comp = ((DefaultCellEditor)tce).getComponent()) instanceof JComboBox) {
                Dimension ps = comp.getPreferredSize();
                if (ps.width > prefWidth) {
                    prefWidth = ps.width;
                }
            }
            if ((v = table.getValueAt(r, c)) == null) continue;
            TableCellRenderer rend = table.getCellRenderer(r, c);
            Component comp2 = this.getTableCellRendererComponent(rend, table, v, false, false, r, c, false);
            Dimension ps = comp2.getPreferredSize();
            if (ps.width <= prefWidth) continue;
            prefWidth = ps.width;
        }
        tc.setMinWidth(prefWidth += 4);
        tc.setMaxWidth(prefWidth);
        tc.setPreferredWidth(prefWidth);
    }

    public Component getTableCellRendererComponent(TableCellRenderer rend, JTable tbl, Object val, boolean isSel, boolean focus, int r, int c, boolean rightAlign) {
        Component renderer = rend.getTableCellRendererComponent(tbl, val, isSel, focus, r, c);
        if (renderer instanceof JComponent) {
            JComponent comp = (JComponent)renderer;
            if (comp instanceof JLabel) {
                String str = val == null ? "" : val.toString();
                FontMetrics fm = this.getFontMetrics(((JLabel)comp).getFont());
                String displayedVal = null;
                displayedVal = rightAlign ? MethodTablePanel.rightAlignLongText(str, fm, this.cellWidth(tbl, (JLabel)comp, r, c)) : MethodTablePanel.leftAlignLongText(str, fm, this.cellWidth(tbl, (JLabel)comp, r, c));
                ((JLabel)comp).setText(displayedVal);
                if (!displayedVal.equals(str)) {
                    ((JLabel)comp).setToolTipText(str);
                } else {
                    ((JLabel)comp).setToolTipText(null);
                }
            }
            if (isSel) {
                comp.setBackground(tbl.getSelectionBackground());
                comp.setOpaque(true);
            } else {
                TableModel model = tbl.getModel();
                Color bg = model.isCellEditable(r, c) ? EnabledBackgroundColor : DisabledBackgroundColor;
                comp.setBackground(bg);
                comp.setOpaque(true);
            }
        } else {
            System.out.println("Not a JComponent: " + renderer);
        }
        return renderer;
    }

    public int cellWidth(JTable tbl, JLabel label, int r, int c) {
        int cellWidth = tbl.getCellRect((int)r, (int)c, (boolean)false).width;
        Insets insets = label.getInsets();
        return cellWidth -= insets.left + insets.right;
    }

    public static String rightAlignLongText(String str, FontMetrics fm, int width) {
        if (str.length() > 0) {
            int swidth = fm.stringWidth(str);
            if (width > 0 && swidth > width) {
                int i = 0;
                while (swidth > width && i < str.length()) {
                    String test = "..." + str.substring(++i);
                    swidth = fm.stringWidth(test);
                }
                str = "..." + str.substring(i);
            }
        }
        return str;
    }

    public static String leftAlignLongText(String str, FontMetrics fm, int width) {
        if (str.length() > 0) {
            int swidth = fm.stringWidth(str);
            if (width > 0 && swidth > width) {
                int i = 0;
                while (swidth > width && i < str.length()) {
                    String test = str.substring(0, str.length() - ++i) + "...";
                    swidth = fm.stringWidth(test);
                }
                str = str.substring(0, str.length() - i) + "...";
            }
        }
        return str;
    }

    public static Color brighter(Color color, double factor) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        if (factor > 0.0 && factor < 1.0) {
            factor = 1.0 - factor;
            int f = (int)(1.0 / (1.0 - factor));
            if (r == 0 && g == 0 && b == 0) {
                return new Color(f, f, f);
            }
            if (r > 0 && r < f) {
                r = f;
            }
            if (g > 0 && g < f) {
                g = f;
            }
            if (b > 0 && b < f) {
                b = f;
            }
            return new Color(Math.min((int)((double)r / factor), 255), Math.min((int)((double)g / factor), 255), Math.min((int)((double)b / factor), 255));
        }
        if (factor < 0.0 && factor > -1.0) {
            factor = 1.0 + factor;
            return new Color(Math.max((int)((double)r * factor), 0), Math.max((int)((double)g * factor), 0), Math.max((int)((double)b * factor), 0));
        }
        return color;
    }

    public void setTablePanePreferredSize(Dimension dimension) {
        this.tablePane.setMinimumSize(dimension);
        this.tablePane.setPreferredSize(dimension);
    }

    protected class TableWithToolTips
    extends FixedHeightJTable {
        protected TableWithToolTips() {
        }

        public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
            Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                jc.setToolTipText(MethodTablePanel.this.getToolTip(rowIndex, vColIndex));
            }
            return c;
        }
    }

    protected class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        int curCol = -1;
        Map tips = new HashMap();

        protected ColumnHeaderToolTips() {
        }

        public void setToolTip(TableColumn col, String tooltip) {
            if (tooltip == null) {
                this.tips.remove(col);
            } else {
                this.tips.put(col, tooltip);
            }
        }

        public void mouseMoved(MouseEvent evt) {
            int col = -1;
            JTableHeader header = (JTableHeader)evt.getSource();
            JTable table = header.getTable();
            TableColumnModel colModel = table.getColumnModel();
            col = colModel.getColumnIndexAtX(evt.getX());
            if (col >= 0 && col != this.curCol) {
                header.setToolTipText(MethodTablePanel.this.getToolTip(col));
                this.curCol = col;
            }
        }
    }
}

