/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

public final class ValidationError
implements Comparable {
    private final Partition partition;
    private final String fieldId;
    private final String message;
    private volatile int hashCode = 0;
    public static final Partition PARTITION_GLOBAL = new Partition("Global");
    public static final Partition PARTITION_WEB_GENERAL = new Partition("WebGeneral", 0);
    public static final Partition PARTITION_WEB_CLASSLOADER = new Partition("WebClassLoader", 1);
    public static final Partition PARTITION_WEB_PROPERTIES = new Partition("WebProperties", 2);
    public static final Partition PARTITION_SESSION_MANAGER = new Partition("SessionManager", 3, 0);
    public static final Partition PARTITION_SESSION_STORE = new Partition("SessionStore", 3, 1);
    public static final Partition PARTITION_SESSION_SESSION = new Partition("SessionSession", 3, 2);
    public static final Partition PARTITION_SESSION_COOKIE = new Partition("SessionCookie", 3, 3);
    public static final Partition PARTITION_WEB_MESSAGES = new Partition("WebMessages", 4);
    public static final Partition PARTITION_WEB_LOCALE = new Partition("WebLocale", 5);
    public static final Partition PARTITION_CACHE_GENERAL = new Partition("CacheGeneral", 6, 0);
    public static final Partition PARTITION_CACHE_HELPERS = new Partition("CacheHelpers", 6, 1);
    public static final Partition PARTITION_CACHE_CONSTRAINTS = new Partition("CacheConstraints", 6, 2);
    public static final Partition PARTITION_SECURITY_ASSIGN = new Partition("SecurityAssign", 0);
    public static final Partition PARTITION_SECURITY_MASTER = new Partition("SecurityMaster", 1);
    public static final Partition PARTITION_SERVICEREF_GENERAL = new Partition("ServiceRefGeneral", 0);
    public static final Partition PARTITION_SERVICEREF_PORTINFO = new Partition("ServiceRefPortInfo", 1);
    public static final Partition PARTITION_CONNECTOR_ADAPTER = new Partition("ConnectorAdapter", 0);
    public static final Partition PARTITION_CONNECTOR_ROLES = new Partition("ConnectorRoles", 1);
    public static final Partition PARTITION_EJBJAR_CMP_RESOURCE = new Partition("EjbJarCmpResource", 0);
    public static final Partition PARTITION_EJBJAR_PM_DESCRIPTORS = new Partition("EjbJarPmDescriptors", 1);
    public static final Partition PARTITION_EJBJAR_MESSAGES = new Partition("EjbJarMessages", 2);

    private ValidationError(String fieldId, String message) {
        this(PARTITION_GLOBAL, fieldId, message);
    }

    private ValidationError(Partition partition, String fieldId, String message) {
        this.partition = partition;
        this.fieldId = fieldId;
        this.message = message;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else {
            ValidationError target = (ValidationError)obj;
            result = this.partition.equals(target.partition) && this.fieldId.equals(target.fieldId);
        }
        return result;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.fieldId.hashCode();
            if (this.partition != null) {
                result = 37 * result + this.partition.hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public int compareTo(Object obj) {
        int result;
        if (this == obj) {
            result = 0;
        } else {
            ValidationError target = (ValidationError)obj;
            result = this.partition.compareTo(target.partition);
            if (result == 0) {
                result = this.fieldId.compareTo(target.fieldId);
            }
        }
        return result;
    }

    public static ValidationError getValidationError(String fieldId, String message) {
        return new ValidationError(fieldId, message);
    }

    public static ValidationError getValidationErrorMask(String fieldId) {
        return new ValidationError(fieldId, "");
    }

    public static ValidationError getValidationError(Partition partition, String fieldId, String message) {
        return new ValidationError(partition, fieldId, message);
    }

    public static ValidationError getValidationErrorMask(Partition partition, String fieldId) {
        return new ValidationError(partition, fieldId, "");
    }

    public static final class Partition
    implements Comparable {
        private final String partitionName;
        private int tabIndex;
        private int subTabIndex;

        private Partition(String name) {
            this(name, -1, -1);
        }

        private Partition(String name, int index) {
            this(name, index, -1);
        }

        private Partition(String name, int index, int subIndex) {
            this.partitionName = name;
            this.tabIndex = index;
            this.subTabIndex = subIndex;
        }

        public String toString() {
            return this.partitionName;
        }

        public int getTabIndex() {
            return this.tabIndex;
        }

        public int getSubTabIndex() {
            return this.subTabIndex;
        }

        public int compareTo(Object obj) {
            Partition target = (Partition)obj;
            return this.partitionName.compareTo(target.partitionName);
        }
    }
}

