/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute.ui;

import java.io.IOException;
import java.sql.SQLException;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;
import org.netbeans.modules.db.sql.execute.ui.ResultSetTableModel;

public class SQLResultPanelModel {
    private final ResultSetTableModel resultSetModel;
    private final String affectedRows;

    public static SQLResultPanelModel create(SQLExecutionResults executionResults) throws IOException, SQLException {
        ResultSetTableModel resultSetModel = null;
        String affectedRows = null;
        if (executionResults != null && executionResults.size() > 0) {
            SQLExecutionResult result = (SQLExecutionResult)executionResults.getResults().iterator().next();
            if (result.getResultSet() != null) {
                resultSetModel = ResultSetTableModel.create(result.getResultSet());
                if (resultSetModel == null) {
                    return null;
                }
            } else {
                return new SQLResultPanelModel();
            }
        }
        return new SQLResultPanelModel(resultSetModel, affectedRows);
    }

    private SQLResultPanelModel() {
        this(null, null);
    }

    private SQLResultPanelModel(ResultSetTableModel resultSetModel, String affectedRows) {
        this.resultSetModel = resultSetModel;
        this.affectedRows = affectedRows;
    }

    public ResultSetTableModel getResultSetModel() {
        return this.resultSetModel;
    }

    public String getAffectedRows() {
        return this.affectedRows;
    }

    public boolean isEmpty() {
        return this.resultSetModel == null && this.affectedRows == null;
    }
}

