/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.impl;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import org.netbeans.modules.xml.catalog.impl.AbstractCatalog;
import org.netbeans.modules.xml.catalog.impl.Util;
import org.netbeans.modules.xml.catalog.lib.Categorizer;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class XCatalog
extends AbstractCatalog
implements CatalogReader,
CatalogDescriptor,
Serializable,
EntityResolver {
    private static final long serialVersionUID = 1582081L;
    public static final String DTD_PUBLIC_ID_4 = "-//DTD XMLCatalog//EN";
    static final String DTD = "xcatalog.dtd";
    static final String PUBLICID_ATT_4 = "PublicId";
    static final String SYSTEMID_ATT_4 = "SystemID";
    public static final String DTD_PUBLIC_ID_2 = "-//DTD XCatalog//EN";
    static final String XCATALOG_2 = "XMLCatalog";
    static final String VERSION_2 = "Version";
    static final String PUBLICID_ATT_2 = "PublicID";
    static final String SYSTEMID_ATT_2 = "SystemID";
    static final String MAP = "Map";
    static final String EXTEND = "Extend";
    static final String BASE = "Base";
    static final String DELEGATE = "Delegate";
    static final String REMAP = "Remap";
    static final String HREF_ATT = "HRef";
    private String catalogSrc = null;
    private transient String shortDescription;
    private transient Image icon;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.loadCatalog(this.catalogSrc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCatalog(String systemID) {
        try {
            this.clearAll();
            if (systemID == null) {
                return;
            }
            new CatalogParser(new InputSource(systemID));
            this.updateShortDescription(this.catalogSrc);
            this.updateIcon(this.getDefaultIcon(0));
        }
        catch (SAXException ex) {
            this.handleLoadError(ex);
        }
        catch (IOException ex) {
            this.handleLoadError(ex);
        }
        finally {
            this.notifyInvalidate();
        }
    }

    private void handleLoadError(Exception ex) {
        this.updateShortDescription(ex.getLocalizedMessage());
        this.updateIcon(this.getDefaultErrorIcon(0));
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Can not read: " + this.shortDescription);
        }
    }

    private void updateShortDescription(String loc) {
        String old = this.shortDescription;
        this.shortDescription = loc;
        this.firePropertyChange("ca-desc", old, this.shortDescription);
    }

    private void updateIcon(Image newIcon) {
        Image old = this.icon;
        this.icon = newIcon;
        this.firePropertyChange("ca-icon", old, this.icon);
    }

    public void setSource(String source) {
        this.catalogSrc = source;
        this.loadCatalog(source);
        this.firePropertyChange("ca-name", null, this.getDisplayName());
    }

    public String getSource() {
        return this.catalogSrc;
    }

    public void refresh() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Refreshing catalog...impl...");
        }
        this.loadCatalog(this.getSource());
    }

    public String getDisplayName() {
        String location = this.catalogSrc;
        if (location == null || "".equals(location.trim())) {
            return Util.THIS.getString("PROP_missing_location");
        }
        return Util.THIS.getString("PROP_display_name", this.catalogSrc);
    }

    public Image getIcon(int type) {
        return this.icon;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String toString() {
        return super.toString() + ":" + this.catalogSrc;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String value;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("resolveEntity(\"" + publicId + "\", \"" + systemId + "\")");
        }
        if (publicId != null) {
            value = this.getPublicMapping(publicId);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("  map: \"" + publicId + "\" -> \"" + value + "\"");
            }
            if (value != null) {
                InputSource source = this.resolveEntity(null, value);
                if (source == null) {
                    source = new InputSource(value);
                }
                source.setPublicId(publicId);
                return source;
            }
            Enumeration delegates = this.getDelegateCatalogKeys();
            while (delegates.hasMoreElements()) {
                AbstractCatalog catalog;
                InputSource source;
                String key = (String)delegates.nextElement();
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("  delegate: \"" + key + "\"");
                }
                if (!publicId.startsWith(key) || (source = (catalog = this.getDelegateCatalog(key)).resolveEntity(publicId, systemId)) == null) continue;
                return source;
            }
        }
        if ((value = this.getSystemMapping(systemId)) != null) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("  remap: \"" + systemId + "\" -> \"" + value + "\"");
            }
            InputSource source = new InputSource(value);
            source.setPublicId(publicId);
            return source;
        }
        Iterator it = this.extenders.iterator();
        while (it.hasNext()) {
            XCatalog cat = (XCatalog)it.next();
            InputSource mytry = cat.resolveEntity(publicId, systemId);
            if (mytry == null) continue;
            return mytry;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("  returning null!");
        }
        return null;
    }

    private class CatalogParser
    extends DefaultHandler {
        private String base;

        public CatalogParser(InputSource source) throws SAXException, IOException {
            XMLReader parser = XMLUtil.createXMLReader((boolean)true);
            parser.setEntityResolver(new Resolver());
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            this.setBase(source.getSystemId());
            parser.parse(source);
        }

        private void setBase(String systemId) throws SAXException {
            int index;
            if (systemId == null) {
                systemId = "";
            }
            if ((index = systemId.lastIndexOf(47)) != -1) {
                systemId = systemId.substring(0, index + 1);
            }
            this.base = systemId;
        }

        public void fatalError(SAXException ex) throws SAXException {
            throw ex;
        }

        public void error(SAXException ex) throws SAXException {
            throw ex;
        }

        public void startElement(String ns, String local, String qName, Attributes attrList) throws SAXException {
            try {
                if (qName.equals(XCatalog.MAP)) {
                    String publicId = attrList.getValue(XCatalog.PUBLICID_ATT_4);
                    if (publicId == null) {
                        publicId = attrList.getValue(XCatalog.PUBLICID_ATT_2);
                    }
                    String href = attrList.getValue(XCatalog.HREF_ATT);
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("MAP \"" + publicId + "\" \"" + href + "\"");
                    }
                    if (!Categorizer.isURL(href)) {
                        href = this.base + href;
                    }
                    if (publicId != null) {
                        XCatalog.this.addPublicMapping(publicId, href);
                    }
                } else if (qName.equals(XCatalog.DELEGATE)) {
                    String publicId = attrList.getValue(XCatalog.PUBLICID_ATT_4);
                    if (publicId == null) {
                        publicId = attrList.getValue(XCatalog.PUBLICID_ATT_2);
                    }
                    String href = attrList.getValue(XCatalog.HREF_ATT);
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("DELEGATE \"" + publicId + "\" \"" + href + "\"");
                    }
                    if (!Categorizer.isURL(href)) {
                        href = this.base + href;
                    }
                    String systemId = href;
                    XCatalog catalog = new XCatalog();
                    catalog.loadCatalog(systemId);
                    XCatalog.this.addDelegateCatalog(publicId, catalog);
                } else if (qName.equals(XCatalog.EXTEND)) {
                    String href = attrList.getValue(XCatalog.HREF_ATT);
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("EXTEND \"" + href + "\"");
                    }
                    if (!Categorizer.isURL(href)) {
                        href = this.base + href;
                    }
                    String systemId = href;
                    XCatalog extender = new XCatalog();
                    extender.loadCatalog(systemId);
                    XCatalog.this.extenders.add(extender);
                } else if (qName.equals(XCatalog.BASE)) {
                    String href = attrList.getValue(XCatalog.HREF_ATT);
                    if (href != null) {
                        this.base = href;
                    }
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("BASE \"" + href + "\" -> \"" + this.base + "\"");
                    }
                } else if (qName.equals(XCatalog.REMAP)) {
                    String systemId = attrList.getValue("SystemID");
                    if (systemId == null) {
                        systemId = attrList.getValue("SystemID");
                    }
                    String href = attrList.getValue(XCatalog.HREF_ATT);
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("REMAP \"" + systemId + "\" \"" + href + "\"");
                    }
                    if (!Categorizer.isURL(href)) {
                        href = this.base + href;
                    }
                    XCatalog.this.addSystemMapping(systemId, href);
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        private class Resolver
        implements EntityResolver {
            private Resolver() {
            }

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (XCatalog.DTD_PUBLIC_ID_2.equals(publicId) || XCatalog.DTD_PUBLIC_ID_4.equals(publicId)) {
                    InputSource src = new InputSource();
                    src.setPublicId(publicId);
                    ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
                    src.setByteStream(is);
                    src.setCharacterStream(new InputStreamReader((InputStream)is, "UTF8"));
                    return src;
                }
                return null;
            }
        }
    }
}

