/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.html.HTMLDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.completion.CompletionImpl;
import org.netbeans.modules.editor.completion.CompletionSettings;
import org.netbeans.modules.editor.completion.HTMLDocView;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DocumentationScrollPane
extends JScrollPane {
    private static final String BACK = "org/netbeans/modules/editor/completion/resources/back.png";
    private static final String FORWARD = "org/netbeans/modules/editor/completion/resources/forward.png";
    private static final String GOTO_SOURCE = "org/netbeans/modules/editor/completion/resources/open_source_in_editor.png";
    private static final String SHOW_WEB = "org/netbeans/modules/editor/completion/resources/open_in_external_browser.png";
    private static final String JAVADOC_ESCAPE = "javadoc-escape";
    private static final String JAVADOC_BACK = "javadoc-back";
    private static final String JAVADOC_FORWARD = "javadoc-forward";
    private static final String JAVADOC_OPEN_IN_BROWSER = "javadoc-open-in-browser";
    private static final String JAVADOC_OPEN_SOURCE = "javadoc-open-source";
    private static final int ACTION_JAVADOC_ESCAPE = 0;
    private static final int ACTION_JAVADOC_BACK = 1;
    private static final int ACTION_JAVADOC_FORWARD = 2;
    private static final int ACTION_JAVADOC_OPEN_IN_BROWSER = 3;
    private static final int ACTION_JAVADOC_OPEN_SOURCE = 4;
    private JTextComponent editorComponent;
    private JButton bBack;
    private JButton bForward;
    private JButton bGoToSource;
    private JButton bShowWeb;
    private HTMLDocView view;
    private List history = new ArrayList(5);
    private int currentHistoryIndex = -1;
    private CompletionDocumentation currentDocumentation = null;
    private Dimension documentationPreferredSize;

    public DocumentationScrollPane(JTextComponent editorComponent) {
        this.editorComponent = editorComponent;
        this.documentationPreferredSize = CompletionSettings.INSTANCE.documentationPopupPreferredSize();
        this.setPreferredSize(null);
        Color bgColor = CompletionSettings.INSTANCE.documentationBackgroundColor();
        this.view = new HTMLDocView(bgColor);
        this.view.addHyperlinkListener(new HyperlinkAction());
        this.setViewportView(this.view);
        this.installTitleComponent();
        this.installKeybindings();
    }

    public void setPreferredSize(Dimension preferredSize) {
        if (preferredSize == null) {
            preferredSize = this.documentationPreferredSize;
        }
        super.setPreferredSize(preferredSize);
    }

    public void setData(CompletionDocumentation doc) {
        this.setDocumentation(doc);
        this.addToHistory(doc);
    }

    private ImageIcon resolveIcon(String res) {
        return new ImageIcon(Utilities.loadImage((String)res));
    }

    private void installTitleComponent() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("controlDkShadow")));
        toolbar.setLayout(new GridBagLayout());
        GridBagConstraints gdc = new GridBagConstraints();
        gdc.gridx = 0;
        gdc.gridy = 0;
        gdc.anchor = 17;
        ImageIcon icon = this.resolveIcon(BACK);
        if (icon != null) {
            this.bBack = new BrowserButton((Icon)icon);
            this.bBack.addMouseListener(new MouseEventListener(this.bBack));
            this.bBack.setEnabled(false);
            this.bBack.setContentAreaFilled(false);
            this.bBack.setMargin(new Insets(0, 0, 0, 0));
            this.bBack.setToolTipText(NbBundle.getMessage((Class)DocumentationScrollPane.class, (String)"HINT_doc_browser_back_button"));
            toolbar.add((Component)this.bBack, gdc);
        }
        gdc.gridx = 1;
        gdc.gridy = 0;
        gdc.anchor = 17;
        icon = this.resolveIcon(FORWARD);
        if (icon != null) {
            this.bForward = new BrowserButton((Icon)icon);
            this.bForward.addMouseListener(new MouseEventListener(this.bForward));
            this.bForward.setEnabled(false);
            this.bForward.setContentAreaFilled(false);
            this.bForward.setToolTipText(NbBundle.getMessage((Class)DocumentationScrollPane.class, (String)"HINT_doc_browser_forward_button"));
            this.bForward.setMargin(new Insets(0, 0, 0, 0));
            toolbar.add((Component)this.bForward, gdc);
        }
        gdc.gridx = 2;
        gdc.gridy = 0;
        gdc.anchor = 17;
        icon = this.resolveIcon(SHOW_WEB);
        if (icon != null) {
            this.bShowWeb = new BrowserButton((Icon)icon);
            this.bShowWeb.addMouseListener(new MouseEventListener(this.bShowWeb));
            this.bShowWeb.setEnabled(false);
            this.bShowWeb.setContentAreaFilled(false);
            this.bShowWeb.setMargin(new Insets(0, 0, 0, 0));
            this.bShowWeb.setToolTipText(NbBundle.getMessage((Class)DocumentationScrollPane.class, (String)"HINT_doc_browser_show_web_button"));
            toolbar.add((Component)this.bShowWeb, gdc);
        }
        gdc.gridx = 3;
        gdc.gridy = 0;
        gdc.weightx = 1.0;
        gdc.anchor = 17;
        icon = this.resolveIcon(GOTO_SOURCE);
        if (icon != null) {
            this.bGoToSource = new BrowserButton((Icon)icon);
            this.bGoToSource.addMouseListener(new MouseEventListener(this.bGoToSource));
            this.bGoToSource.setEnabled(false);
            this.bGoToSource.setContentAreaFilled(false);
            this.bGoToSource.setMargin(new Insets(0, 0, 0, 0));
            this.bGoToSource.setToolTipText(NbBundle.getMessage((Class)DocumentationScrollPane.class, (String)"HINT_doc_browser_goto_source_button"));
            toolbar.add((Component)this.bGoToSource, gdc);
        }
        this.setColumnHeaderView(toolbar);
    }

    private synchronized void setDocumentation(CompletionDocumentation doc) {
        this.currentDocumentation = doc;
        String text = this.currentDocumentation.getText();
        URL url = this.currentDocumentation.getURL();
        if (text != null) {
            Document document;
            if (url != null && (document = this.view.getDocument()) instanceof HTMLDocument) {
                ((HTMLDocument)document).setBase(url);
            }
            this.view.setContent(text);
        } else if (url != null) {
            try {
                this.view.setPage(url);
            }
            catch (IOException ioe) {
                StatusDisplayer.getDefault().setStatusText(ioe.toString());
            }
        }
        this.bShowWeb.setEnabled(url != null);
        this.bGoToSource.setEnabled(this.currentDocumentation.getGotoSourceAction() != null);
    }

    private synchronized void addToHistory(CompletionDocumentation doc) {
        int histSize = this.history.size();
        for (int i = this.currentHistoryIndex + 1; i < histSize; ++i) {
            this.history.remove(this.history.size() - 1);
        }
        this.history.add(doc);
        this.currentHistoryIndex = this.history.size() - 1;
        if (this.currentHistoryIndex > 0) {
            this.bBack.setEnabled(true);
        }
        this.bForward.setEnabled(false);
    }

    private synchronized void backHistory() {
        if (this.currentHistoryIndex > 0) {
            --this.currentHistoryIndex;
            this.setDocumentation((CompletionDocumentation)this.history.get(this.currentHistoryIndex));
            if (this.currentHistoryIndex == 0) {
                this.bBack.setEnabled(false);
            }
            this.bForward.setEnabled(true);
        }
    }

    private synchronized void forwardHistory() {
        if (this.currentHistoryIndex < this.history.size() - 1) {
            ++this.currentHistoryIndex;
            this.setDocumentation((CompletionDocumentation)this.history.get(this.currentHistoryIndex));
            if (this.currentHistoryIndex == this.history.size() - 1) {
                this.bForward.setEnabled(false);
            }
            this.bBack.setEnabled(true);
        }
    }

    synchronized void clearHistory() {
        this.currentHistoryIndex = -1;
        this.history.clear();
        this.bBack.setEnabled(false);
        this.bForward.setEnabled(false);
    }

    private void openInExternalBrowser() {
        URL url = this.currentDocumentation.getURL();
        if (url != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
    }

    private void goToSource() {
        Action action = this.currentDocumentation.getGotoSourceAction();
        if (action != null) {
            action.actionPerformed(new ActionEvent(this.editorComponent, 0, null));
        }
    }

    private KeyStroke[] findEditorKeys(String editorActionName, KeyStroke defaultKey) {
        KeyStroke[] ret = new KeyStroke[]{defaultKey};
        if (this.editorComponent != null) {
            KeyStroke[] keys;
            Action a;
            EditorKit kit;
            TextUI ui = this.editorComponent.getUI();
            Keymap km = this.editorComponent.getKeymap();
            if (ui != null && km != null && (kit = ui.getEditorKit(this.editorComponent)) instanceof BaseKit && (a = ((BaseKit)kit).getActionByName(editorActionName)) != null && (keys = km.getKeyStrokesForAction(a)) != null && keys.length > 0) {
                ret = keys;
            }
        }
        return ret;
    }

    private void registerKeybinding(int action, String actionName, KeyStroke stroke, String editorActionName) {
        KeyStroke[] keys = this.findEditorKeys(editorActionName, stroke);
        for (int i = 0; i < keys.length; ++i) {
            this.getInputMap().put(keys[i], actionName);
        }
        this.getActionMap().put(actionName, new DocPaneAction(action));
    }

    private void installKeybindings() {
        this.registerKeybinding(0, JAVADOC_ESCAPE, KeyStroke.getKeyStroke(27, 0), "escape");
        this.registerKeybinding(1, JAVADOC_BACK, KeyStroke.getKeyStroke(37, 8), null);
        this.registerKeybinding(2, JAVADOC_FORWARD, KeyStroke.getKeyStroke(39, 8), null);
        this.registerKeybinding(3, JAVADOC_OPEN_IN_BROWSER, KeyStroke.getKeyStroke(112, 9), null);
        this.registerKeybinding(4, JAVADOC_OPEN_SOURCE, KeyStroke.getKeyStroke(79, 10), null);
        this.mapWithShift(KeyStroke.getKeyStroke(38, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(40, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(33, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(34, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(36, 2));
        this.mapWithShift(KeyStroke.getKeyStroke(35, 2));
        this.mapWithShift(KeyStroke.getKeyStroke(39, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(37, 0));
    }

    private void mapWithShift(KeyStroke key) {
        InputMap inputMap = this.getInputMap(1);
        Object actionKey = inputMap.get(key);
        if (actionKey != null) {
            key = KeyStroke.getKeyStroke(key.getKeyCode(), key.getModifiers() | 1);
            this.getInputMap().put(key, actionKey);
        }
    }

    private class DocPaneAction
    extends AbstractAction {
        private int action;

        private DocPaneAction(int action) {
            this.action = action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.action) {
                case 0: {
                    CompletionImpl.get().hideDocumentation();
                    break;
                }
                case 1: {
                    DocumentationScrollPane.this.backHistory();
                    break;
                }
                case 2: {
                    DocumentationScrollPane.this.forwardHistory();
                    break;
                }
                case 3: {
                    DocumentationScrollPane.this.openInExternalBrowser();
                    break;
                }
                case 4: {
                    DocumentationScrollPane.this.goToSource();
                }
            }
        }
    }

    private class HyperlinkAction
    implements HyperlinkListener {
        private HyperlinkAction() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            String desc;
            if (e != null && HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && (desc = e.getDescription()) != null) {
                CompletionDocumentation doc = DocumentationScrollPane.this.currentDocumentation.resolveLink(desc);
                if (doc == null) {
                    doc = new CompletionDocumentation(){
                        private URL base;
                        {
                            this.base = DocumentationScrollPane.this.currentDocumentation.getURL();
                        }

                        public Action getGotoSourceAction() {
                            return null;
                        }

                        public String getText() {
                            return null;
                        }

                        public URL getURL() {
                            try {
                                return new URL(this.base, desc);
                            }
                            catch (MalformedURLException malformedURLException) {
                                return null;
                            }
                        }

                        public CompletionDocumentation resolveLink(String link) {
                            return null;
                        }
                    };
                }
                DocumentationScrollPane.this.setData(doc);
            }
        }
    }

    private class MouseEventListener
    extends MouseAdapter {
        private JButton button;

        MouseEventListener(JButton button) {
            this.button = button;
        }

        public void mouseEntered(MouseEvent ev) {
            if (this.button.isEnabled()) {
                this.button.setContentAreaFilled(true);
                this.button.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent ev) {
            this.button.setContentAreaFilled(false);
            this.button.setBorderPainted(false);
        }

        public void mouseClicked(MouseEvent evt) {
            if (this.button.equals(DocumentationScrollPane.this.bBack)) {
                DocumentationScrollPane.this.backHistory();
            } else if (this.button.equals(DocumentationScrollPane.this.bForward)) {
                DocumentationScrollPane.this.forwardHistory();
            } else if (this.button.equals(DocumentationScrollPane.this.bGoToSource)) {
                DocumentationScrollPane.this.goToSource();
            } else if (this.button.equals(DocumentationScrollPane.this.bShowWeb)) {
                DocumentationScrollPane.this.openInExternalBrowser();
            }
        }
    }

    private class BrowserButton
    extends JButton {
        public BrowserButton() {
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }

        public BrowserButton(String text) {
            super(text);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }

        public BrowserButton(Icon icon) {
            super(icon);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }

        public void setEnabled(boolean b) {
            super.setEnabled(b);
        }
    }
}

