/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.web.project.ui.wizards.FileSearchUtility;
import org.netbeans.modules.web.project.ui.wizards.FolderList;
import org.netbeans.modules.web.project.ui.wizards.PanelConfigureProjectVisual;
import org.netbeans.modules.web.project.ui.wizards.SettingsPanel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PanelSourceFolders
extends SettingsPanel
implements PropertyChangeListener {
    private Panel firer;
    private WizardDescriptor wizardDescriptor;
    private JButton jButtonLibraries;
    private JButton jButtonWebpagesLocation;
    private JLabel jLabel3;
    private JLabel jLabelLibraries;
    private JLabel jLabelWebPages;
    private JTextField jTextFieldLibraries;
    private JTextField jTextFieldWebPages;
    private JPanel sourcePanel;
    private JPanel testsPanel;

    public PanelSourceFolders(Panel panel) {
        this.firer = panel;
        this.initComponents();
        this.setName(NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"LAB_ConfigureSourceRoots"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_WebExtSources"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelSourceFolders.class, (String)"AN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_PanelSourceFolders"));
        this.sourcePanel.addPropertyChangeListener(this);
        this.testsPanel.addPropertyChangeListener(this);
        ((FolderList)this.sourcePanel).setRelatedFolderList((FolderList)this.testsPanel);
        ((FolderList)this.testsPanel).setRelatedFolderList((FolderList)this.sourcePanel);
        DocumentListener pl = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                PanelSourceFolders.this.firer.fireChangeEvent();
            }

            public void insertUpdate(DocumentEvent e) {
                PanelSourceFolders.this.firer.fireChangeEvent();
            }

            public void removeUpdate(DocumentEvent e) {
                PanelSourceFolders.this.firer.fireChangeEvent();
            }
        };
        this.jTextFieldWebPages.getDocument().addDocumentListener(pl);
    }

    public void initValues(FileObject fo) {
        ((FolderList)this.sourcePanel).setLastUsedDir(FileUtil.toFile((FileObject)fo));
        ((FolderList)this.testsPanel).setLastUsedDir(FileUtil.toFile((FileObject)fo));
        String webPages = "";
        String libraries = "";
        File[] javaRoots = null;
        FileObject guessFO = FileSearchUtility.guessDocBase(fo);
        if (guessFO != null) {
            webPages = FileUtil.toFile((FileObject)guessFO).getPath();
        }
        if ((guessFO = FileSearchUtility.guessLibrariesFolder(fo)) != null) {
            libraries = FileUtil.toFile((FileObject)guessFO).getPath();
        }
        javaRoots = FileSearchUtility.guessJavaRootsAsFiles(fo);
        if (this.jTextFieldWebPages.getText().trim().equals("")) {
            this.jTextFieldWebPages.setText(webPages);
        }
        if (this.jTextFieldLibraries.getText().trim().equals("")) {
            this.jTextFieldLibraries.setText(libraries);
        }
        if (((FolderList)this.sourcePanel).getFiles().length == 0 && javaRoots.length > 0) {
            ((FolderList)this.sourcePanel).setFiles(javaRoots);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("files".equals(evt.getPropertyName())) {
            this.dataChanged();
        } else if ("lastUsedDir".equals(evt.getPropertyName())) {
            if (evt.getSource() == this.sourcePanel) {
                ((FolderList)this.testsPanel).setLastUsedDir((File)evt.getNewValue());
            } else if (evt.getSource() == this.testsPanel) {
                ((FolderList)this.sourcePanel).setLastUsedDir((File)evt.getNewValue());
            }
        }
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    void read(WizardDescriptor settings) {
        File[] testRoot;
        this.wizardDescriptor = settings;
        File[] srcRoot = (File[])settings.getProperty("javaRoot");
        if (srcRoot != null) {
            ((FolderList)this.sourcePanel).setFiles(srcRoot);
        }
        if ((testRoot = (File[])settings.getProperty("testRoot")) != null) {
            ((FolderList)this.testsPanel).setFiles(testRoot);
        }
        File projectLocation = (File)settings.getProperty("sourceRoot");
        ((FolderList)this.sourcePanel).setProjectFolder(projectLocation);
        ((FolderList)this.testsPanel).setProjectFolder(projectLocation);
        this.initValues(FileUtil.toFileObject((File)projectLocation));
    }

    void store(WizardDescriptor settings) {
        File[] sourceRoots = ((FolderList)this.sourcePanel).getFiles();
        File[] testRoots = ((FolderList)this.testsPanel).getFiles();
        settings.putProperty("javaRoot", (Object)sourceRoots);
        settings.putProperty("testRoot", (Object)testRoots);
        settings.putProperty("docBase", (Object)this.jTextFieldWebPages.getText().trim());
        settings.putProperty("libFolder", (Object)this.jTextFieldLibraries.getText().trim());
    }

    boolean valid(WizardDescriptor settings) {
        File[] testRoots;
        File[] sourceRoots;
        File projectLocation = (File)settings.getProperty("projdir");
        if (this.jTextFieldWebPages.getText().trim().length() == 0) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WebPagesMandatory"));
            return false;
        }
        File webPages = this.getWebPages();
        String result = this.checkValidity(projectLocation, webPages, sourceRoots = ((FolderList)this.sourcePanel).getFiles(), testRoots = ((FolderList)this.testsPanel).getFiles());
        if (result == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)result);
        return false;
    }

    private String checkValidity(File projectLocation, File webPages, File[] sources, File[] tests) {
        int i;
        String ploc = projectLocation.getAbsolutePath();
        if (projectLocation.equals(webPages)) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WebPagesFolderOverlapsProjectFolder");
        }
        if (!webPages.exists() || !webPages.isDirectory()) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WebPagesFolderDoesNotExist");
        }
        FileObject webInf = FileUtil.toFileObject((File)webPages).getFileObject("WEB-INF");
        if (webInf == null) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WebInfCorrupted", (Object)webPages.getPath());
        }
        FileObject webXml = webInf.getFileObject("web.xml");
        if (webXml != null && !webXml.isValid()) {
            webXml = null;
        }
        String j2eeLevel = (String)this.wizardDescriptor.getProperty("j2eeLevel");
        if (webXml == null && (j2eeLevel.equals("1.3") || j2eeLevel.equals("1.4"))) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FileNotFound", (Object)webPages.getPath());
        }
        for (i = 0; i < sources.length; ++i) {
            if (!sources[i].isDirectory() || !sources[i].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalSources"), sources[i].getAbsolutePath());
            }
            String sloc = sources[i].getAbsolutePath();
            if (!ploc.equals(sloc) && !ploc.startsWith(sloc + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        for (i = 0; i < tests.length; ++i) {
            if (!tests[i].isDirectory() || !tests[i].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalTests"), sources[i].getAbsolutePath());
            }
            String tloc = tests[i].getAbsolutePath();
            if (!ploc.equals(tloc) && !ploc.startsWith(tloc + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        return null;
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
        this.searchClassFiles(((FolderList)this.sourcePanel).getFiles());
    }

    private void searchClassFiles(File[] folders) throws WizardValidationException {
        boolean found = false;
        for (int i = 0; i < folders.length; ++i) {
            FileObject folder = FileUtil.toFileObject((File)folders[i]);
            if (folder == null) continue;
            Enumeration en = folder.getData(true);
            while (!found && en.hasMoreElements()) {
                Object obj = en.nextElement();
                assert (obj instanceof FileObject) : "Instance of FileObject: " + obj;
                FileObject fo = (FileObject)obj;
                found = "class".equals(fo.getExt());
            }
        }
        if (found) {
            String DELETE_OPTION = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_DeleteOption");
            String KEEP_OPTION = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_KeepOption");
            String CANCEL_OPTION = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_CancelOption");
            NotifyDescriptor desc = new NotifyDescriptor((Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles_Title"), 1, 3, new Object[]{DELETE_OPTION, KEEP_OPTION, CANCEL_OPTION}, null);
            Object result = DialogDisplayer.getDefault().notify(desc);
            if (DELETE_OPTION.equals(result)) {
                this.deleteClassFiles(folders);
            } else if (!KEEP_OPTION.equals(result)) {
                throw new WizardValidationException((JComponent)this.sourcePanel, "", "");
            }
        }
    }

    private void deleteClassFiles(File[] folders) {
        for (int i = 0; i < folders.length; ++i) {
            FileObject folder = FileUtil.toFileObject((File)folders[i]);
            Enumeration en = folder.getData(true);
            while (en.hasMoreElements()) {
                Object obj = en.nextElement();
                assert (obj instanceof FileObject) : "Instance of FileObject: " + obj;
                FileObject fo = (FileObject)obj;
                try {
                    if (!"class".equals(fo.getExt())) continue;
                    fo.delete();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jLabelWebPages = new JLabel();
        this.jTextFieldWebPages = new JTextField();
        this.jButtonWebpagesLocation = new JButton();
        this.jLabelLibraries = new JLabel();
        this.jTextFieldLibraries = new JTextField();
        this.jButtonLibraries = new JButton();
        this.sourcePanel = new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_SourceRoots").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddSourceRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_AddSourceFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddSourceFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_RemoveSourceFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveSourceFolder"));
        this.testsPanel = new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_TestRoots").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddTestRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_AddTestFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddTestFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_RemoveTestFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveTestFolder"));
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(500, 340));
        this.getAccessibleContext().setAccessibleName(null);
        this.getAccessibleContext().setAccessibleDescription(null);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_LocationDesc_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleName(null);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(null);
        this.jLabelWebPages.setDisplayedMnemonic(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_WebPagesLocation_LabelMnemonic").charAt(0));
        this.jLabelWebPages.setLabelFor(this.jTextFieldWebPages);
        this.jLabelWebPages.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_WebPagesLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.add((Component)this.jLabelWebPages, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.add((Component)this.jTextFieldWebPages, gridBagConstraints);
        this.jTextFieldWebPages.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_WebPagesFolder"));
        this.jButtonWebpagesLocation.setMnemonic(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_WebPagesFolder_MNE").charAt(0));
        this.jButtonWebpagesLocation.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.jButtonWebpagesLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelSourceFolders.this.jButtonWebpagesLocationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jButtonWebpagesLocation, gridBagConstraints);
        this.jButtonWebpagesLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_BrowseWebPageFolder"));
        this.jLabelLibraries.setDisplayedMnemonic(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_LibrariesLocation_LabelMnemonic").charAt(0));
        this.jLabelLibraries.setLabelFor(this.jTextFieldLibraries);
        this.jLabelLibraries.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_LibrariesLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jLabelLibraries, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jTextFieldLibraries, gridBagConstraints);
        this.jTextFieldLibraries.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_LibrariesFolder"));
        this.jButtonLibraries.setMnemonic(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_BrowseProjectFolder_MNE").charAt(0));
        this.jButtonLibraries.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.jButtonLibraries.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelSourceFolders.this.jButtonLibrariesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jButtonLibraries, gridBagConstraints);
        this.jButtonLibraries.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_BrowseLibrariesFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.sourcePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.testsPanel, gridBagConstraints);
    }

    private void jButtonLibrariesActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        if (this.jTextFieldLibraries.getText().length() > 0 && this.getLibraries().exists()) {
            chooser.setSelectedFile(this.getLibraries());
        } else {
            chooser.setCurrentDirectory((File)this.wizardDescriptor.getProperty("sourceRoot"));
        }
        if (0 == chooser.showOpenDialog(this)) {
            File configFilesDir = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.jTextFieldLibraries.setText(configFilesDir.getAbsolutePath());
        }
    }

    private void jButtonWebpagesLocationActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        if (this.jTextFieldWebPages.getText().length() > 0 && this.getWebPages().exists()) {
            chooser.setSelectedFile(this.getWebPages());
        } else {
            chooser.setCurrentDirectory((File)this.wizardDescriptor.getProperty("sourceRoot"));
        }
        if (0 == chooser.showOpenDialog(this)) {
            File webPagesDir = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.jTextFieldWebPages.setText(webPagesDir.getAbsolutePath());
        }
    }

    private File getAsFile(String filename) {
        return FileUtil.normalizeFile((File)new File(filename));
    }

    public File getWebPages() {
        return this.getAsFile(this.jTextFieldWebPages.getText());
    }

    public File getLibraries() {
        return this.getAsFile(this.jTextFieldLibraries.getText());
    }

    static class Panel
    implements WizardDescriptor.ValidatingPanel {
        private ArrayList listeners;
        private PanelSourceFolders component;
        private WizardDescriptor settings;

        Panel() {
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(l);
        }

        public void addChangeListener(ChangeListener l) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(l);
        }

        public void readSettings(Object settings) {
            this.settings = (WizardDescriptor)settings;
            this.component.read(this.settings);
            Object substitute = this.component.getClientProperty("NewProjectWizard_Title");
            if (substitute != null) {
                this.settings.putProperty("NewProjectWizard_Title", substitute);
            }
        }

        public void storeSettings(Object settings) {
            this.component.store(this.settings);
        }

        public void validate() throws WizardValidationException {
            this.component.validate(this.settings);
        }

        public boolean isValid() {
            return this.component.valid(this.settings);
        }

        public synchronized Component getComponent() {
            if (this.component == null) {
                this.component = new PanelSourceFolders(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(PanelSourceFolders.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChangeEvent() {
            Iterator it = null;
            Panel panel = this;
            synchronized (panel) {
                if (this.listeners == null) {
                    return;
                }
                it = ((ArrayList)this.listeners.clone()).iterator();
            }
            ChangeEvent event = new ChangeEvent(this);
            while (it.hasNext()) {
                ((ChangeListener)it.next()).stateChanged(event);
            }
        }
    }
}

