/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModuleContainer;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.netbeans.modules.web.project.ui.FoldersListSettings;
import org.netbeans.modules.web.project.ui.wizards.J2eeVersionWarningPanel;
import org.netbeans.modules.web.project.ui.wizards.PanelConfigureProject;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PanelOptionsVisual
extends JPanel {
    private PanelConfigureProject panel;
    private String sourceStructure;
    private String j2eeLevel;
    private boolean contextModified = false;
    private final DefaultComboBoxModel serversModel = new DefaultComboBoxModel();
    private J2eeVersionWarningPanel warningPanel;
    private static final String J2EE_SPEC_13_LABEL = NbBundle.getMessage(PanelOptionsVisual.class, (String)"J2EESpecLevel_13");
    private static final String J2EE_SPEC_14_LABEL = NbBundle.getMessage(PanelOptionsVisual.class, (String)"J2EESpecLevel_14");
    private static final String JAVA_EE_SPEC_50_LABEL = NbBundle.getMessage(PanelOptionsVisual.class, (String)"JavaEESpecLevel_50");
    private List earProjects;
    private JComboBox j2eeSpecComboBox;
    private JLabel j2eeSpecLabel;
    private JComboBox jComboBoxEnterprise;
    private JLabel jLabelContextPath;
    private JLabel jLabelEnterprise;
    private JPanel jPanel1;
    protected JTextField jTextFieldContextPath;
    private JButton manageServersButton;
    private JComboBox serverInstanceComboBox;
    private JLabel serverInstanceLabel;
    private JCheckBox setAsMainCheckBox;
    private JComboBox srcStructComboBox;
    private JLabel srcStructLabel;
    private JPanel warningPlaceHolderPanel;

    public PanelOptionsVisual(PanelConfigureProject panel) {
        this.initComponents();
        this.setJ2eeVersionWarningPanel();
        this.panel = panel;
        this.initServers(FoldersListSettings.getDefault().getLastUsedServer());
        if (this.j2eeSpecComboBox.getModel().getSize() > 0) {
            this.j2eeSpecComboBox.setSelectedIndex(0);
        }
        this.initJSrcStructureSpecs();
        this.initEnterpriseApplications();
    }

    protected int computeHeight() {
        return this.srcStructComboBox.getFontMetrics(this.srcStructComboBox.getFont()).getHeight() * 9 + 100;
    }

    private void initComponents() {
        this.srcStructLabel = new JLabel();
        this.srcStructComboBox = new JComboBox();
        this.jLabelEnterprise = new JLabel();
        this.jComboBoxEnterprise = new JComboBox();
        this.jPanel1 = new JPanel();
        this.serverInstanceLabel = new JLabel();
        this.serverInstanceComboBox = new JComboBox();
        this.j2eeSpecLabel = new JLabel();
        this.j2eeSpecComboBox = new JComboBox();
        this.jLabelContextPath = new JLabel();
        this.jTextFieldContextPath = new JTextField();
        this.manageServersButton = new JButton();
        this.warningPlaceHolderPanel = new JPanel();
        this.setAsMainCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.srcStructLabel.setDisplayedMnemonic(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_SourceStructure_CheckBoxMnemonic").charAt(0));
        this.srcStructLabel.setLabelFor(this.srcStructComboBox);
        this.srcStructLabel.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_SourceStructure_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.srcStructLabel, gridBagConstraints);
        this.srcStructLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACS_LBL_NWP1_SourceStructureComboBox_A11YDesc"));
        this.srcStructComboBox.setPrototypeDisplayValue("MMMMMMMMMMMMMMM");
        this.srcStructComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.srcStructComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.srcStructComboBox, gridBagConstraints);
        this.jLabelEnterprise.setDisplayedMnemonic(NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_NWP1_AddToEnterprise_LabelMnemonic").charAt(0));
        this.jLabelEnterprise.setLabelFor(this.jComboBoxEnterprise);
        this.jLabelEnterprise.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_AddToEnterprise_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jLabelEnterprise, gridBagConstraints);
        this.jLabelEnterprise.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACS_LBL_NWP1_AddToEnterpriseComboBox_A11YDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jComboBoxEnterprise, gridBagConstraints);
        this.jComboBoxEnterprise.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACS_LBL_NWP1_AddToEnterpriseComboBox_A11YDesc"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.serverInstanceLabel.setDisplayedMnemonic(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_Server_LabelMnemonic").charAt(0));
        this.serverInstanceLabel.setLabelFor(this.serverInstanceComboBox);
        this.serverInstanceLabel.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_Server"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.jPanel1.add((Component)this.serverInstanceLabel, gridBagConstraints);
        this.serverInstanceComboBox.setModel(this.serversModel);
        this.serverInstanceComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.serverInstanceComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 6);
        this.jPanel1.add((Component)this.serverInstanceComboBox, gridBagConstraints);
        this.serverInstanceComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACS_NWP1_Server_ComboBox_A11YDesc"));
        this.j2eeSpecLabel.setDisplayedMnemonic(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_J2EESpecLevel_CheckBoxMnemonic").charAt(0));
        this.j2eeSpecLabel.setLabelFor(this.j2eeSpecComboBox);
        this.j2eeSpecLabel.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_J2EESpecLevel_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.jPanel1.add((Component)this.j2eeSpecLabel, gridBagConstraints);
        this.j2eeSpecComboBox.setPrototypeDisplayValue("MMMMMMMMM");
        this.j2eeSpecComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.j2eeSpecComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.j2eeSpecComboBox, gridBagConstraints);
        this.j2eeSpecComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACS_LBL_NPW1_J2EESpecLevel_A11YDesc"));
        this.jLabelContextPath.setDisplayedMnemonic(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_ContextPath_CheckBoxMnemonic").charAt(0));
        this.jLabelContextPath.setLabelFor(this.jTextFieldContextPath);
        this.jLabelContextPath.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_ContextPath_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.jPanel1.add((Component)this.jLabelContextPath, gridBagConstraints);
        this.jTextFieldContextPath.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                PanelOptionsVisual.this.jTextFieldContextPathKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jTextFieldContextPath, gridBagConstraints);
        this.jTextFieldContextPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACS_LBL_NWP1_ContextPath_A11YDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageServersButton, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_ManageServers"));
        this.manageServersButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.manageServersButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.manageServersButton, gridBagConstraints);
        this.manageServersButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ASCN_ManageServers"));
        this.manageServersButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ASCD_ManageServers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.warningPlaceHolderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.warningPlaceHolderPanel, gridBagConstraints);
        this.setAsMainCheckBox.setMnemonic(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_SetAsMain_CheckBoxMnemonic").charAt(0));
        this.setAsMainCheckBox.setSelected(true);
        this.setAsMainCheckBox.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_SetAsMain_CheckBox"));
        this.setAsMainCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.setAsMainCheckBox, gridBagConstraints);
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACS_LBL_NWP1_SetAsMain_A11YDesc"));
    }

    private void manageServersButtonActionPerformed(ActionEvent evt) {
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        String lastSelectedServerInstanceID = null;
        if (serverInstanceWrapper != null) {
            lastSelectedServerInstanceID = serverInstanceWrapper.getServerInstanceID();
        }
        ServerManager.showCustomizer(lastSelectedServerInstanceID);
        String lastSelectedJ2eeSpecLevel = (String)this.j2eeSpecComboBox.getSelectedItem();
        this.initServers(lastSelectedServerInstanceID);
        if (lastSelectedJ2eeSpecLevel != null) {
            this.j2eeSpecComboBox.setSelectedItem(lastSelectedJ2eeSpecLevel);
        }
    }

    private void j2eeSpecComboBoxActionPerformed(ActionEvent evt) {
        this.setJ2eeVersionWarningPanel();
    }

    private void serverInstanceComboBoxActionPerformed(ActionEvent evt) {
        String prevSelectedItem = (String)this.j2eeSpecComboBox.getSelectedItem();
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        if (serverInstanceWrapper != null) {
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceWrapper.getServerInstanceID());
            Set supportedVersions = j2eePlatform.getSupportedSpecVersions(J2eeModule.WAR);
            this.j2eeSpecComboBox.removeAllItems();
            if (supportedVersions.contains("1.5")) {
                this.j2eeSpecComboBox.addItem(JAVA_EE_SPEC_50_LABEL);
            }
            if (supportedVersions.contains("1.4")) {
                this.j2eeSpecComboBox.addItem(J2EE_SPEC_14_LABEL);
            }
            if (supportedVersions.contains("1.3")) {
                this.j2eeSpecComboBox.addItem(J2EE_SPEC_13_LABEL);
            }
            if (prevSelectedItem != null) {
                this.j2eeSpecComboBox.setSelectedItem(prevSelectedItem);
            }
        } else {
            this.j2eeSpecComboBox.removeAllItems();
        }
        this.panel.fireChangeEvent();
    }

    private void srcStructComboBoxActionPerformed(ActionEvent evt) {
        switch (this.srcStructComboBox.getSelectedIndex()) {
            case 0: {
                this.sourceStructure = "BluePrints";
                break;
            }
            case 1: {
                this.sourceStructure = "Jakarta";
            }
        }
    }

    private void jTextFieldContextPathKeyReleased(KeyEvent evt) {
        this.contextModified = true;
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.getSelectedServer() == null) {
            String errMsg = NbBundle.getMessage(PanelOptionsVisual.class, (String)"MSG_NoServer");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)errMsg);
            return false;
        }
        return true;
    }

    void store(WizardDescriptor d) {
        d.putProperty("setAsMain", (Object)(this.setAsMainCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        d.putProperty("serverInstanceID", (Object)this.getSelectedServer());
        d.putProperty("sourceStructure", (Object)this.sourceStructure);
        d.putProperty("j2eeLevel", (Object)this.getSelectedJ2eeSpec());
        d.putProperty("contextPath", (Object)this.jTextFieldContextPath.getText().trim());
        d.putProperty("earApplication", (Object)this.getSelectedEarApplication());
        if (this.warningPanel != null && this.warningPanel.getDowngradeAllowed()) {
            d.putProperty("setJavaPlatform", (Object)this.warningPanel.getSuggestedJavaPlatformName());
            String j2ee = this.getSelectedJ2eeSpec();
            if (j2ee != null) {
                String warningType = J2eeVersionWarningPanel.findWarningType(j2ee);
                FoldersListSettings fls = FoldersListSettings.getDefault();
                String srcLevel = "1.6";
                if (warningType.equals("warnSetSourceLevel14") && fls.isAgreedSetSourceLevel14() || warningType.equals("warnSetJdk14") && fls.isAgreedSetJdk14()) {
                    srcLevel = "1.4";
                } else if (warningType.equals("warnSetSourceLevel15") && fls.isAgreedSetSourceLevel15() || warningType.equals("warnSetJdk15") && fls.isAgreedSetJdk15()) {
                    srcLevel = "1.5";
                }
                d.putProperty("setSourceLevel", (Object)srcLevel);
            }
        } else {
            d.putProperty("setSourceLevel", null);
        }
    }

    void read(WizardDescriptor d) {
    }

    private void initServers(String selectedServerInstanceID) {
        this.serversModel.removeAllElements();
        TreeSet<ServerInstanceWrapper> servers = new TreeSet<ServerInstanceWrapper>();
        ServerInstanceWrapper selectedItem = null;
        boolean sjasFound = false;
        for (String serverInstanceID : Deployment.getDefault().getServerInstanceIDs()) {
            String displayName = Deployment.getDefault().getServerInstanceDisplayName(serverInstanceID);
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceID);
            if (displayName == null || j2eePlatform == null || !j2eePlatform.getSupportedModuleTypes().contains(J2eeModule.WAR)) continue;
            ServerInstanceWrapper serverWrapper = new ServerInstanceWrapper(serverInstanceID, displayName);
            if (selectedItem == null || !sjasFound) {
                if (selectedServerInstanceID != null) {
                    if (selectedServerInstanceID.equals(serverInstanceID)) {
                        selectedItem = serverWrapper;
                    }
                } else {
                    String shortName = Deployment.getDefault().getServerID(serverInstanceID);
                    if ("J2EE".equals(shortName)) {
                        selectedItem = serverWrapper;
                        sjasFound = true;
                    } else if ("JBoss4".equals(shortName)) {
                        selectedItem = serverWrapper;
                    }
                }
            }
            servers.add(serverWrapper);
        }
        for (ServerInstanceWrapper item : servers) {
            this.serversModel.addElement(item);
        }
        if (selectedItem != null) {
            this.serversModel.setSelectedItem(selectedItem);
        } else if (this.serversModel.getSize() > 0) {
            this.serversModel.setSelectedItem(this.serversModel.getElementAt(0));
        }
    }

    private String getSelectedJ2eeSpec() {
        Object item = this.j2eeSpecComboBox.getSelectedItem();
        return item == null ? null : (item.equals(JAVA_EE_SPEC_50_LABEL) ? "1.5" : (item.equals(J2EE_SPEC_14_LABEL) ? "1.4" : "1.3"));
    }

    private String getSelectedServer() {
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        if (serverInstanceWrapper == null) {
            return null;
        }
        return serverInstanceWrapper.getServerInstanceID();
    }

    private void initJSrcStructureSpecs() {
        this.srcStructComboBox.addItem(NbBundle.getMessage(PanelOptionsVisual.class, (String)"SourceStructure_0"));
        this.srcStructComboBox.addItem(NbBundle.getMessage(PanelOptionsVisual.class, (String)"SourceStructure_1"));
        this.srcStructComboBox.setSelectedIndex(0);
    }

    protected boolean isContextModified() {
        return this.contextModified;
    }

    private Project getSelectedEarApplication() {
        int idx = this.jComboBoxEnterprise.getSelectedIndex();
        return idx <= 0 ? null : (Project)this.earProjects.get(idx - 1);
    }

    private void initEnterpriseApplications() {
        this.jComboBoxEnterprise.addItem(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_AddToEnterprise_None"));
        this.jComboBoxEnterprise.setSelectedIndex(0);
        Project[] allProjects = OpenProjects.getDefault().getOpenProjects();
        this.earProjects = new ArrayList();
        for (int i = 0; i < allProjects.length; ++i) {
            J2eeModuleContainer container = (J2eeModuleContainer)allProjects[i].getLookup().lookup(J2eeModuleContainer.class);
            ProjectInformation projectInfo = ProjectUtils.getInformation((Project)allProjects[i]);
            if (container == null) continue;
            this.earProjects.add(projectInfo.getProject());
            this.jComboBoxEnterprise.addItem(projectInfo.getDisplayName());
        }
        if (this.earProjects.size() <= 0) {
            this.jComboBoxEnterprise.setEnabled(false);
        }
    }

    private void setJ2eeVersionWarningPanel() {
        String j2ee = this.getSelectedJ2eeSpec();
        if (j2ee == null) {
            return;
        }
        String warningType = J2eeVersionWarningPanel.findWarningType(j2ee);
        if (warningType == null && this.warningPanel == null) {
            return;
        }
        if (this.warningPanel == null) {
            this.warningPanel = new J2eeVersionWarningPanel(warningType);
            this.warningPlaceHolderPanel.add((Component)this.warningPanel, "Center");
            this.warningPanel.setWarningType(warningType);
        } else {
            this.warningPanel.setWarningType(warningType);
        }
    }

    private static class ServerInstanceWrapper
    implements Comparable {
        private final String serverInstanceID;
        private final String displayName;

        ServerInstanceWrapper(String serverInstanceID, String displayName) {
            this.serverInstanceID = serverInstanceID;
            this.displayName = displayName;
        }

        public String getServerInstanceID() {
            return this.serverInstanceID;
        }

        public String toString() {
            return this.displayName;
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }
    }
}

