/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;

public class J2eePlatformUiSupport {
    private J2eePlatformUiSupport() {
    }

    public static ComboBoxModel createPlatformComboBoxModel(String serverInstanceId, String j2eeLevel) {
        return new J2eePlatformComboBoxModel(serverInstanceId, j2eeLevel);
    }

    public static String getServerInstanceID(Object j2eePlatformModelObject) {
        if (j2eePlatformModelObject == null) {
            return null;
        }
        J2eePlatform j2eePlatform = ((J2eePlatformAdapter)j2eePlatformModelObject).getJ2eePlatform();
        String[] serverInstanceIDs = Deployment.getDefault().getServerInstanceIDs();
        for (int i = 0; i < serverInstanceIDs.length; ++i) {
            J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(serverInstanceIDs[i]);
            if (platform == null || !platform.getDisplayName().equals(j2eePlatform.getDisplayName())) continue;
            return serverInstanceIDs[i];
        }
        return null;
    }

    public static void setSelectedPlatform(ComboBoxModel model, String serverInstanceID) {
        if (!(model instanceof J2eePlatformComboBoxModel)) {
            return;
        }
        ((J2eePlatformComboBoxModel)model).setSelectedItem(serverInstanceID);
    }

    private static final class J2eePlatformAdapter
    implements Comparable {
        private J2eePlatform platform;
        private String serverInstanceID;

        public J2eePlatformAdapter(J2eePlatform platform, String serverInstanceID) {
            this.platform = platform;
            this.serverInstanceID = serverInstanceID;
        }

        public J2eePlatform getJ2eePlatform() {
            return this.platform;
        }

        public String getServerInstanceID() {
            return this.serverInstanceID;
        }

        public String toString() {
            return this.platform.getDisplayName();
        }

        public int compareTo(Object o) {
            J2eePlatformAdapter oa = (J2eePlatformAdapter)o;
            return this.toString().compareTo(oa.toString());
        }
    }

    private static final class J2eePlatformComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private J2eePlatformAdapter[] j2eePlatforms;
        private String initialJ2eePlatform;
        private J2eePlatformAdapter selectedJ2eePlatform;
        private String j2eeLevel;

        public J2eePlatformComboBoxModel(String serverInstanceID, String j2eeLevel) {
            this.initialJ2eePlatform = serverInstanceID;
            this.j2eeLevel = j2eeLevel;
            this.getJ2eePlatforms();
        }

        public Object getElementAt(int index) {
            return this.getJ2eePlatforms()[index];
        }

        public int getSize() {
            return this.getJ2eePlatforms().length;
        }

        public Object getSelectedItem() {
            return this.selectedJ2eePlatform;
        }

        public void setSelectedItem(Object obj) {
            this.selectedJ2eePlatform = (J2eePlatformAdapter)obj;
        }

        public void setSelectedItem(String serverInstanceID) {
            for (int i = 0; i < this.j2eePlatforms.length; ++i) {
                if (!this.j2eePlatforms[i].getServerInstanceID().equals(serverInstanceID)) continue;
                this.selectedJ2eePlatform = this.j2eePlatforms[i];
                return;
            }
        }

        private synchronized J2eePlatformAdapter[] getJ2eePlatforms() {
            if (this.j2eePlatforms == null) {
                String[] serverInstanceIDs = Deployment.getDefault().getServerInstanceIDs();
                TreeSet<J2eePlatformAdapter> orderedNames = new TreeSet<J2eePlatformAdapter>();
                boolean activeFound = false;
                for (int i = 0; i < serverInstanceIDs.length; ++i) {
                    J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceIDs[i]);
                    if (j2eePlatform == null || !j2eePlatform.getSupportedModuleTypes().contains(J2eeModule.WAR) || !j2eePlatform.getSupportedSpecVersions(J2eeModule.WAR).contains(this.j2eeLevel)) continue;
                    J2eePlatformAdapter adapter = new J2eePlatformAdapter(j2eePlatform, serverInstanceIDs[i]);
                    orderedNames.add(adapter);
                    if (this.selectedJ2eePlatform != null || activeFound || this.initialJ2eePlatform == null || !serverInstanceIDs[i].equals(this.initialJ2eePlatform)) continue;
                    this.selectedJ2eePlatform = adapter;
                    activeFound = true;
                }
                this.j2eePlatforms = orderedNames.toArray(new J2eePlatformAdapter[orderedNames.size()]);
            }
            return this.j2eePlatforms;
        }
    }
}

