/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.web.project.ui.ActionFilterNode;
import org.netbeans.modules.web.project.ui.LibrariesNode;
import org.netbeans.modules.web.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.web.project.ui.ShowJavadocAction;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

class PlatformNode
extends AbstractNode
implements ChangeListener {
    private static final String PLATFORM_ICON = "org/netbeans/modules/web/project/ui/resources/platform";
    private static final String ARCHIVE_ICON = "org/netbeans/modules/web/project/ui/resources/jar.gif";
    private final PlatformProvider pp;

    private PlatformNode(PlatformProvider pp) {
        super((Children)new PlatformContentChildren(), Lookups.singleton((Object)new JavadocProvider(pp)));
        this.pp = pp;
        this.pp.addChangeListener(this);
        this.setIconBase(PLATFORM_ICON);
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        String platformId;
        JavaPlatform plat = this.pp.getPlatform();
        String name = plat != null ? plat.getDisplayName() : ((platformId = this.pp.getPlatformId()) == null ? NbBundle.getMessage(PlatformNode.class, (String)"TXT_BrokenPlatform") : MessageFormat.format(NbBundle.getMessage(PlatformNode.class, (String)"FMT_BrokenPlatform"), platformId));
        return name;
    }

    public String getHtmlDisplayName() {
        if (this.pp.getPlatform() == null) {
            String displayName = this.getDisplayName();
            try {
                displayName = XMLUtil.toElementContent((String)displayName);
            }
            catch (CharConversionException ex) {
                return null;
            }
            return "<font color=\"#A40000\">" + displayName + "</font>";
        }
        return null;
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(ShowJavadocAction.class)};
    }

    public void stateChanged(ChangeEvent e) {
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        LibrariesNode.rp.post(new Runnable(){

            public void run() {
                ((PlatformContentChildren)PlatformNode.this.getChildren()).addNotify();
            }
        });
    }

    static PlatformNode create(PropertyEvaluator eval, String platformPropName) {
        PlatformProvider pp = new PlatformProvider(eval, platformPropName);
        return new PlatformNode(pp);
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        PlatformProvider platformProvider;

        private JavadocProvider(PlatformProvider platformProvider) {
            this.platformProvider = platformProvider;
        }

        public boolean hasJavadoc() {
            JavaPlatform platform = this.platformProvider.getPlatform();
            if (platform == null) {
                return false;
            }
            URL[] javadocRoots = JavadocProvider.getJavadocRoots(platform);
            return javadocRoots.length > 0;
        }

        public void showJavadoc() {
            JavaPlatform platform = this.platformProvider.getPlatform();
            if (platform != null) {
                URL[] javadocRoots = JavadocProvider.getJavadocRoots(platform);
                URL pageURL = ShowJavadocAction.findJavadoc("/overview-summary.html", javadocRoots);
                if (pageURL == null) {
                    pageURL = ShowJavadocAction.findJavadoc("/index.html", javadocRoots);
                }
                ShowJavadocAction.showJavaDoc(pageURL, platform.getDisplayName());
            }
        }

        private static URL[] getJavadocRoots(JavaPlatform platform) {
            HashSet<URL> result = new HashSet<URL>();
            List l = platform.getBootstrapLibraries().entries();
            for (ClassPath.Entry e : l) {
                result.addAll(Arrays.asList(JavadocForBinaryQuery.findJavadoc((URL)e.getURL()).getRoots()));
            }
            return result.toArray(new URL[result.size()]);
        }
    }

    private static class PlatformProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator evaluator;
        private final String platformPropName;
        private JavaPlatform platformCache;
        private List listeners;

        public PlatformProvider(PropertyEvaluator evaluator, String platformPropName) {
            this.evaluator = evaluator;
            this.platformPropName = platformPropName;
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
        }

        public String getPlatformId() {
            return this.evaluator.getProperty(this.platformPropName);
        }

        public JavaPlatform getPlatform() {
            if (this.platformCache == null) {
                String platformSystemName = this.getPlatformId();
                if (platformSystemName == null) {
                    this.platformCache = JavaPlatformManager.getDefault().getDefaultPlatform();
                } else {
                    JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
                    for (int i = 0; i < platforms.length; ++i) {
                        if (!platformSystemName.equals(platforms[i].getProperties().get("platform.ant.name"))) continue;
                        if (platforms[i].getInstallFolders().size() <= 0) break;
                        this.platformCache = platforms[i];
                        break;
                    }
                }
            }
            return this.platformCache;
        }

        public synchronized void addChangeListener(ChangeListener l) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(l);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.platformPropName.equals(evt.getPropertyName())) {
                this.platformCache = null;
                this.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ChangeListener[] _listeners;
            PlatformProvider platformProvider = this;
            synchronized (platformProvider) {
                if (this.listeners == null) {
                    return;
                }
                _listeners = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            ChangeEvent event = new ChangeEvent(this);
            for (int i = 0; i < _listeners.length; ++i) {
                _listeners[i].stateChanged(event);
            }
        }
    }

    private static class PlatformContentChildren
    extends Children.Keys {
        PlatformContentChildren() {
        }

        protected void addNotify() {
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            SourceGroup sg = (SourceGroup)key;
            return new Node[]{ActionFilterNode.create(PackageView.createPackageView((SourceGroup)sg), null, null, null, null, null, null)};
        }

        private List getKeys() {
            JavaPlatform platform = ((PlatformNode)this.getNode()).pp.getPlatform();
            if (platform == null) {
                return Collections.EMPTY_LIST;
            }
            FileObject[] roots = platform.getBootstrapLibraries().getRoots();
            ArrayList<LibrariesSourceGroup> result = new ArrayList<LibrariesSourceGroup>(roots.length);
            for (int i = 0; i < roots.length; ++i) {
                try {
                    ImageIcon icon;
                    ImageIcon openedIcon;
                    FileObject file;
                    if ("jar".equals(roots[i].getURL().getProtocol())) {
                        file = FileUtil.getArchiveFile((FileObject)roots[i]);
                        icon = openedIcon = new ImageIcon(Utilities.loadImage((String)PlatformNode.ARCHIVE_ICON));
                    } else {
                        file = roots[i];
                        icon = null;
                        openedIcon = null;
                    }
                    if (!file.isValid()) continue;
                    result.add(new LibrariesSourceGroup(roots[i], file.getNameExt(), icon, openedIcon));
                    continue;
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
            return result;
        }
    }
}

