/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.Utils;
import org.netbeans.modules.j2ee.ejbjarproject.api.EjbJarProjectGenerator;
import org.netbeans.modules.j2ee.ejbjarproject.ui.FoldersListSettings;
import org.netbeans.modules.j2ee.ejbjarproject.ui.wizards.ImportLocation;
import org.netbeans.modules.j2ee.ejbjarproject.ui.wizards.PanelSourceFolders;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ImportEjbJarProjectWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    private static final String[] STEPS = new String[]{NbBundle.getMessage(ImportEjbJarProjectWizardIterator.class, (String)"LBL_IW_ImportTitle"), NbBundle.getMessage(ImportEjbJarProjectWizardIterator.class, (String)"LAB_ConfigureSourceRoots")};
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new ImportLocation(), new PanelSourceFolders.Panel()};
    }

    public Set instantiate() throws IOException {
        Ear ear;
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        File dirF = (File)this.wiz.getProperty("projdir");
        if (dirF != null) {
            dirF = FileUtil.normalizeFile((File)dirF);
        }
        String name = (String)this.wiz.getProperty("name");
        File[] sourceFolders = (File[])this.wiz.getProperty("javaRoot");
        File[] testFolders = (File[])this.wiz.getProperty("testRoot");
        File configFilesFolder = (File)this.wiz.getProperty("configFilesFolder");
        File libName = (File)this.wiz.getProperty("libFolder");
        String serverInstanceID = (String)this.wiz.getProperty("serverInstanceID");
        String j2eeLevel = (String)this.wiz.getProperty("j2eeLevel");
        AntProjectHelper h = EjbJarProjectGenerator.importProject(dirF, name, sourceFolders, testFolders, configFilesFolder, libName, j2eeLevel, serverInstanceID);
        FileObject dir = FileUtil.toFileObject((File)dirF);
        Project earProject = (Project)this.wiz.getProperty("earApplication");
        EjbJarProject createdEjbJarProject = (EjbJarProject)ProjectManager.getDefault().findProject(dir);
        if (earProject != null && createdEjbJarProject != null && (ear = Ear.getEar((FileObject)earProject.getProjectDirectory())) != null) {
            ear.addEjbJarModule(createdEjbJarProject.getAPIEjbJar());
        }
        resultSet.add(dir);
        File file = dirF = dirF != null ? dirF.getParentFile() : null;
        if (dirF != null && dirF.exists()) {
            ProjectChooser.setProjectsFolder((File)dirF);
        }
        FoldersListSettings.getDefault().setLastUsedServer(serverInstanceID);
        String platformName = (String)this.wiz.getProperty("setJavaPlatform");
        String sourceLevel = (String)this.wiz.getProperty("setSourceLevel");
        if (platformName != null || sourceLevel != null) {
            EjbJarProjectGenerator.setPlatform(h, platformName, sourceLevel);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        Utils.setSteps(this.panels, STEPS);
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz.putProperty("sourceRoot", null);
        this.wiz.putProperty("javaRoot", null);
        this.wiz.putProperty("testRoot", null);
        this.wiz.putProperty("configFilesFolder", null);
        this.wiz.putProperty("libFolder", null);
        this.wiz.putProperty("serverInstanceID", null);
        this.wiz.putProperty("j2eeLevel", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(ImportEjbJarProjectWizardIterator.class, (String)"LBL_WizardStepsCount"), new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

