/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.ui.logicalview.libraries;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.ejbjarproject.UpdateHelper;
import org.netbeans.modules.j2ee.ejbjarproject.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.EjbJarProjectProperties;
import org.netbeans.modules.j2ee.ejbjarproject.ui.logicalview.libraries.RemoveClassPathRootAction;
import org.netbeans.modules.j2ee.ejbjarproject.ui.logicalview.libraries.ShowJavadocAction;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.actions.EditAction;
import org.openide.actions.FindAction;
import org.openide.actions.OpenAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

class ActionFilterNode
extends FilterNode {
    private static final int MODE_ROOT = 1;
    private static final int MODE_PACKAGE = 2;
    private static final int MODE_FILE = 3;
    private static final int MODE_FILE_CONTENT = 4;
    private final int mode;
    private Action[] actionCache;

    static ActionFilterNode create(Node original, UpdateHelper helper, PropertyEvaluator eval, ReferenceHelper refHelper, String classPathId, String entryId, String includedLibrariesElement) {
        DataObject dobj = (DataObject)original.getLookup().lookup(DataObject.class);
        assert (dobj != null);
        FileObject root = dobj.getPrimaryFile();
        ProxyLookup lkp = new ProxyLookup(new Lookup[]{original.getLookup(), helper == null ? Lookups.singleton((Object)new JavadocProvider(root, root)) : Lookups.fixed((Object[])new Object[]{new Removable(helper, eval, refHelper, classPathId, entryId, includedLibrariesElement), new JavadocProvider(root, root)})});
        return new ActionFilterNode(original, helper == null ? 2 : 1, root, (Lookup)lkp);
    }

    private ActionFilterNode(Node original, int mode, FileObject cpRoot, FileObject resource) {
        this(original, mode, cpRoot, (Lookup)new ProxyLookup(new Lookup[]{original.getLookup(), Lookups.singleton((Object)new JavadocProvider(cpRoot, resource))}));
    }

    private ActionFilterNode(Node original, int mode) {
        super(original, (Children)new ActionFilterChildren(original, mode, null));
        this.mode = mode;
    }

    private ActionFilterNode(Node original, int mode, FileObject root, Lookup lkp) {
        super(original, (Children)new ActionFilterChildren(original, mode, root), lkp);
        this.mode = mode;
    }

    public Action[] getActions(boolean context) {
        Action[] result = this.initActions();
        return result;
    }

    public Action getPreferredAction() {
        Action[] actions;
        if (this.mode == 3 && (actions = this.initActions()).length > 0 && (actions[0] instanceof OpenAction || actions[0] instanceof EditAction)) {
            return actions[0];
        }
        return null;
    }

    private Action[] initActions() {
        if (this.actionCache == null) {
            ArrayList<Action> result = new ArrayList<Action>(2);
            if (this.mode == 3) {
                Action[] superActions = super.getActions(false);
                for (int i = 0; i < superActions.length; ++i) {
                    if (!(superActions[i] instanceof OpenAction) && !(superActions[i] instanceof EditAction)) continue;
                    result.add(superActions[i]);
                }
                result.add((Action)SystemAction.get(ShowJavadocAction.class));
            } else if (this.mode == 2 || this.mode == 1) {
                result.add((Action)SystemAction.get(ShowJavadocAction.class));
                Action[] superActions = super.getActions(false);
                for (int i = 0; i < superActions.length; ++i) {
                    if (!(superActions[i] instanceof FindAction)) continue;
                    result.add(superActions[i]);
                }
                if (this.mode == 1) {
                    result.add((Action)SystemAction.get(RemoveClassPathRootAction.class));
                }
            }
            this.actionCache = result.toArray(new Action[result.size()]);
        }
        return this.actionCache;
    }

    private static class Removable
    implements RemoveClassPathRootAction.Removable {
        private final UpdateHelper helper;
        private final PropertyEvaluator eval;
        private final ReferenceHelper refHelper;
        private final String classPathId;
        private final String entryId;
        private final String includedLibrariesElement;
        private final ClassPathSupport cs;

        Removable(UpdateHelper helper, PropertyEvaluator eval, ReferenceHelper refHelper, String classPathId, String entryId, String includedLibrariesElement) {
            this.helper = helper;
            this.eval = eval;
            this.refHelper = refHelper;
            this.classPathId = classPathId;
            this.includedLibrariesElement = includedLibrariesElement;
            this.entryId = entryId;
            this.cs = new ClassPathSupport(eval, refHelper, helper.getAntProjectHelper(), EjbJarProjectProperties.WELL_KNOWN_PATHS, "${libs.", ".classpath}", "${reference.");
        }

        public boolean canRemove() {
            EditableProperties props = this.helper.getProperties("nbproject/project.properties");
            return props.getProperty(this.classPathId) != null;
        }

        public Project remove() {
            boolean removed = false;
            EditableProperties props = this.helper.getProperties("nbproject/project.properties");
            String raw = props.getProperty(this.classPathId);
            List resources = this.cs.itemsList(raw, this.includedLibrariesElement);
            Iterator i = resources.iterator();
            while (i.hasNext()) {
                ClassPathSupport.Item item = (ClassPathSupport.Item)i.next();
                if (!this.entryId.equals(EjbJarProjectProperties.getAntPropertyName(item.getReference()))) continue;
                i.remove();
                removed = true;
            }
            if (removed) {
                String[] itemRefs = this.cs.encodeToStrings(resources.iterator(), this.includedLibrariesElement);
                props = this.helper.getProperties("nbproject/project.properties");
                props.setProperty(this.classPathId, itemRefs);
                this.helper.putProperties("nbproject/project.properties", props);
                EditableProperties privateProps = this.helper.getProperties("nbproject/private/private.properties");
                ArrayList l = new ArrayList();
                l.addAll(resources);
                EjbJarProjectProperties.storeLibrariesLocations(l.iterator(), privateProps);
                this.helper.putProperties("nbproject/private/private.properties", privateProps);
                return FileOwnerQuery.getOwner((FileObject)this.helper.getAntProjectHelper().getProjectDirectory());
            }
            return null;
        }
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        private final FileObject cpRoot;
        private final FileObject resource;

        JavadocProvider(FileObject cpRoot, FileObject resource) {
            this.cpRoot = cpRoot;
            this.resource = resource;
        }

        public boolean hasJavadoc() {
            try {
                return this.resource != null && JavadocForBinaryQuery.findJavadoc((URL)this.cpRoot.getURL()).getRoots().length > 0;
            }
            catch (FileStateInvalidException fsi) {
                return false;
            }
        }

        public void showJavadoc() {
            try {
                URL pageURL;
                String relativeName = FileUtil.getRelativePath((FileObject)this.cpRoot, (FileObject)this.resource);
                URL[] urls = JavadocForBinaryQuery.findJavadoc((URL)this.cpRoot.getURL()).getRoots();
                if (relativeName.length() == 0) {
                    pageURL = ShowJavadocAction.findJavadoc("overview-summary.html", urls);
                    if (pageURL == null) {
                        pageURL = ShowJavadocAction.findJavadoc("index.html", urls);
                    }
                } else if (this.resource.isFolder()) {
                    pageURL = ShowJavadocAction.findJavadoc("package-summary.html", urls);
                } else {
                    String javadocFileName = relativeName.substring(0, relativeName.lastIndexOf(46)) + ".html";
                    pageURL = ShowJavadocAction.findJavadoc(javadocFileName, urls);
                }
                ShowJavadocAction.showJavaDoc(pageURL, relativeName.replace('/', '.'));
            }
            catch (FileStateInvalidException fsi) {
                ErrorManager.getDefault().notify((Throwable)fsi);
            }
        }
    }

    private static class ActionFilterChildren
    extends FilterNode.Children {
        private final int mode;
        private final FileObject cpRoot;

        ActionFilterChildren(Node original, int mode, FileObject cpRooot) {
            super(original);
            this.mode = mode;
            this.cpRoot = cpRooot;
        }

        protected Node[] createNodes(Object key) {
            Node n = (Node)key;
            switch (this.mode) {
                case 1: 
                case 2: {
                    DataObject dobj = (DataObject)n.getCookie(DataObject.class);
                    if (dobj == null) {
                        assert (false) : "DataNode without DataObject in Lookup";
                        return new Node[0];
                    }
                    if (dobj.getPrimaryFile().isFolder()) {
                        return new Node[]{new ActionFilterNode((Node)key, 2, this.cpRoot, dobj.getPrimaryFile())};
                    }
                    return new Node[]{new ActionFilterNode((Node)key, 3, this.cpRoot, dobj.getPrimaryFile())};
                }
                case 3: 
                case 4: {
                    return new Node[]{new ActionFilterNode((Node)key, 4)};
                }
            }
            assert (false) : "Unknown mode";
            return new Node[0];
        }
    }
}

