/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.ui.logicalview;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.UpdateHelper;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.j2ee.ejbjarproject.ui.logicalview.libraries.LibrariesNode;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.persistence.ui.PersistenceNode;
import org.netbeans.modules.j2ee.spi.ejbjar.support.J2eeProjectView;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.client.WebServicesClientView;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientView;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.api.webservices.WebServicesView;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.JAXWSView;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class LogicalViewChildren
extends Children.Keys
implements ChangeListener {
    private static final boolean DISPLAY_EJB_NODE = Boolean.getBoolean("org.netbeans.modules.j2ee.ejbjarproject.ui.logicalview.DISPLAY_EJB_NODE");
    private static final boolean DISPLAY_ORM_NODE = Boolean.getBoolean("org.netbeans.modules.j2ee.ejbjarproject.ui.logicalview.DISPLAY_ORM_NODE");
    public static final String KEY_TEST_DIR = "testDir";
    public static final String KEY_DOC_BASE = "docBase";
    public static final String KEY_EJBS = "ejbKey";
    public static final String KEY_ORM = "persistenceKey";
    public static final String KEY_SERVICE_REFS = "serviceRefs";
    public static final String WEBSERVICES_DIR = "webservicesDir";
    public static final String KEY_SETUP_DIR = "setupDir";
    public static final String KEY_LIBRARIES = "libraries";
    public static final String KEY_TEST_LIBRARIES = "testLibraries";
    private static final String JAX_WS_PATH = "nbproject/jax-ws.xml";
    private Sources sources;
    private org.netbeans.modules.j2ee.api.ejbjar.EjbJar jp;
    private ClassPath cp;
    private Project project;
    private PropertyEvaluator evaluator;
    private UpdateHelper updateHelper;
    private ReferenceHelper refHelper;
    private AntProjectHelper helper;
    private JaxWsChangeListener jaxWsListener;
    private MetaInfListener metaInfListener;
    private WsdlCreationListener wsdlListener;
    private JaxRPCChangeListener jaxrpcChangeListener;
    private FileObject wsdlFolder;

    public LogicalViewChildren(Project project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper refHelper) {
        assert (project != null);
        this.project = project;
        this.evaluator = evaluator;
        this.updateHelper = updateHelper;
        if (updateHelper != null) {
            this.helper = updateHelper.getAntProjectHelper();
        }
        this.refHelper = refHelper;
        org.netbeans.modules.j2ee.api.ejbjar.EjbJar[] jps = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJars((Project)project);
        assert (jps.length > 0);
        this.jp = jps[0];
        this.sources = ProjectUtils.getSources((Project)project);
        assert (this.sources != null);
        this.cp = ClassPathSupport.createClassPath((FileObject[])this.getRoots());
        this.metaInfListener = new MetaInfListener();
        this.wsdlListener = new WsdlCreationListener();
        this.jaxrpcChangeListener = new JaxRPCChangeListener();
        this.jaxWsListener = new JaxWsChangeListener();
    }

    private FileObject[] getRoots() {
        SourceGroup[] groups = this.sources.getSourceGroups("java");
        FileObject[] roots = new FileObject[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            roots[i] = groups[i].getRootFolder();
        }
        return roots;
    }

    protected void addNotify() {
        FileObject metaInf;
        org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejbModule;
        super.addNotify();
        this.sources.addChangeListener((ChangeListener)this);
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            jaxWsModel.addPropertyChangeListener((PropertyChangeListener)this.jaxWsListener);
        }
        if ((ejbModule = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)this.helper.getProjectDirectory())) != null && (metaInf = ejbModule.getMetaInf()) != null) {
            metaInf.addFileChangeListener((FileChangeListener)this.metaInfListener);
            metaInf.addFileChangeListener((FileChangeListener)this.jaxrpcChangeListener);
        }
        WebServicesClientSupport wsClientSupportImpl = WebServicesClientSupport.getWebServicesClientSupport((FileObject)this.helper.getProjectDirectory());
        FileObject wsdlDir = null;
        try {
            wsdlDir = wsClientSupportImpl.getWsdlFolder(false);
            if (wsdlDir != null) {
                this.wsdlFolder = wsdlDir;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (this.wsdlFolder != null) {
            this.wsdlFolder.addFileChangeListener((FileChangeListener)this.wsdlListener);
        }
        this.createNodes();
    }

    private void createNodes() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(KEY_EJBS);
        l.add(KEY_ORM);
        JAXWSSupport jwss = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jwss != null && jaxWsModel != null && jaxWsModel.getServices() != null && jaxWsModel.getServices().length > 0) {
            l.add(WEBSERVICES_DIR);
        } else {
            List wServices;
            WebServicesSupport wss = WebServicesSupport.getWebServicesSupport((FileObject)this.project.getProjectDirectory());
            if (wss != null && (wServices = wss.getServices()) != null && !wServices.isEmpty()) {
                l.add(WEBSERVICES_DIR);
            }
        }
        JAXWSClientSupport jwcss = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.project.getProjectDirectory());
        if (jwcss != null && jaxWsModel != null && jaxWsModel.getClients() != null && jaxWsModel.getClients().length > 0) {
            l.add(KEY_SERVICE_REFS);
        } else {
            List wsClients;
            WebServicesClientSupport wscs = WebServicesClientSupport.getWebServicesClientSupport((FileObject)this.project.getProjectDirectory());
            if (wscs != null && (wsClients = wscs.getServiceClients()) != null && !wsClients.isEmpty()) {
                l.add(KEY_SERVICE_REFS);
            }
        }
        FileObject docBaseDir = this.jp.getMetaInf();
        if (docBaseDir != null) {
            l.add(KEY_DOC_BASE);
        }
        l.add(KEY_SETUP_DIR);
        l.addAll(this.getSourceRoots());
        l.add(KEY_LIBRARIES);
        l.add(KEY_TEST_LIBRARIES);
        this.setKeys(l);
    }

    protected void removeNotify() {
        FileObject metaInf;
        org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejbModule;
        this.setKeys(Collections.EMPTY_SET);
        this.sources.removeChangeListener((ChangeListener)this);
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            jaxWsModel.removePropertyChangeListener((PropertyChangeListener)this.jaxWsListener);
        }
        if ((ejbModule = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)this.helper.getProjectDirectory())) != null && (metaInf = ejbModule.getMetaInf()) != null) {
            metaInf.removeFileChangeListener((FileChangeListener)this.metaInfListener);
            metaInf.removeFileChangeListener((FileChangeListener)this.jaxrpcChangeListener);
        }
        if (this.wsdlFolder != null) {
            this.wsdlFolder.removeFileChangeListener((FileChangeListener)this.wsdlListener);
        }
        this.setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }

    public Node[] createNodes(Object key) {
        Node[] nodeArray;
        Object n;
        block29: {
            block31: {
                FileObject dd;
                EjbJar ejbJar;
                block33: {
                    block32: {
                        block30: {
                            block28: {
                                n = null;
                                if (!(key instanceof SourceGroupKey)) break block28;
                                n = new PackageViewFilterNode(((SourceGroupKey)key).group, this.project);
                                break block29;
                            }
                            if (key != KEY_DOC_BASE) break block30;
                            n = J2eeProjectView.createConfigFilesView((FileObject)this.jp.getMetaInf());
                            break block29;
                        }
                        if (key != KEY_EJBS) break block31;
                        ejbJar = null;
                        dd = this.jp.getDeploymentDescriptor();
                        try {
                            ejbJar = DDProvider.getDefault().getMergedDDRoot(this.jp.getMetadataUnit());
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().notify((Throwable)ioe);
                        }
                        if (ejbJar == null) break block32;
                        if (!ejbJar.getVersion().equals(new BigDecimal("3.0"))) break block33;
                    }
                    if (!DISPLAY_EJB_NODE) break block29;
                }
                n = J2eeProjectView.createEjbsView((EjbJar)ejbJar, (ClassPath)this.cp, (FileObject)dd, (Project)this.project);
                break block29;
            }
            if (key == KEY_ORM && DISPLAY_ORM_NODE) {
                EntityMappings entityMappings = PersistenceUtils.getAnnotationEntityMappings((Project)this.project);
                if (entityMappings != null) {
                    n = new PersistenceNode(entityMappings, this.cp);
                }
            } else if (key == WEBSERVICES_DIR) {
                boolean jwsdpSupported;
                org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejbModule = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)this.helper.getProjectDirectory());
                Map properties = ((EjbJarProject)this.project).getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
                String serverInstance = (String)properties.get("j2ee.server.instance");
                J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance);
                boolean bl = jwsdpSupported = j2eePlatform != null && j2eePlatform.isToolSupported("jwsdp");
                if (ejbModule != null && ("1.5".equals(ejbModule.getJ2eePlatformVersion()) || jwsdpSupported)) {
                    JAXWSView view = JAXWSView.getJAXWSView();
                    n = view.createJAXWSView(this.project);
                } else {
                    WebServicesView webServicesView;
                    FileObject srcRoot;
                    SourceGroup[] srcGroup = this.sources.getSourceGroups("java");
                    if (srcGroup.length > 0 && (srcRoot = srcGroup[0].getRootFolder()) != null && (webServicesView = WebServicesView.getWebServicesView((FileObject)srcRoot)) != null) {
                        n = webServicesView.createWebServicesView(srcRoot);
                    }
                }
            } else if (key == KEY_SETUP_DIR) {
                n = J2eeProjectView.createServerResourcesNode((Project)this.project);
            } else if (key == KEY_LIBRARIES) {
                assert (this.updateHelper != null);
                assert (this.evaluator != null);
                assert (this.refHelper != null);
                n = new LibrariesNode(NbBundle.getMessage(LogicalViewChildren.class, (String)"CTL_LibrariesNode"), this.project, this.evaluator, this.updateHelper, this.refHelper, "javac.classpath", new String[]{"build.classes.dir"}, "platform.active", "j2ee.server.instance", new Action[]{LibrariesNode.createAddProjectAction(this.project, "javac.classpath", "included-library"), LibrariesNode.createAddLibraryAction(this.project, this.updateHelper.getAntProjectHelper(), "javac.classpath", "included-library"), LibrariesNode.createAddFolderAction(this.project, "javac.classpath", "included-library"), null, new PreselectPropertiesAction(this.project, "Libraries", "COMPILE")}, "included-library");
            } else if (key == KEY_SERVICE_REFS) {
                Map properties = ((EjbJarProject)this.project).getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
                String serverInstance = (String)properties.get("j2ee.server.instance");
                J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance);
                boolean jwsdpSupported = j2eePlatform != null && j2eePlatform.isToolSupported("jwsdp");
                org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejbModule = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory());
                if (ejbModule != null && ("1.5".equals(ejbModule.getJ2eePlatformVersion()) || jwsdpSupported)) {
                    JAXWSClientView view = JAXWSClientView.getJAXWSClientView();
                    n = view.createJAXWSClientView(this.project);
                } else {
                    FileObject wsdlFolder;
                    WebServicesClientSupport wss;
                    WebServicesClientView clientView;
                    FileObject clientRoot = this.helper.resolveFileObject(this.evaluator.getProperty("meta.inf"));
                    if (clientRoot == null) {
                        clientRoot = this.helper.resolveFileObject(this.evaluator.getProperty("src.dir"));
                    }
                    if (clientRoot != null && (clientView = WebServicesClientView.getWebServicesClientView((FileObject)clientRoot)) != null && (wss = WebServicesClientSupport.getWebServicesClientSupport((FileObject)clientRoot)) != null && (wsdlFolder = wss.getWsdlFolder()) != null) {
                        n = clientView.createWebServiceClientView(wsdlFolder);
                    }
                }
            } else if (key == KEY_TEST_LIBRARIES) {
                n = new LibrariesNode(NbBundle.getMessage(LogicalViewChildren.class, (String)"CTL_TestLibrariesNode"), this.project, this.evaluator, this.updateHelper, this.refHelper, "javac.test.classpath", new String[]{"build.test.classes.dir", "javac.classpath", "build.classes.dir"}, null, null, new Action[]{LibrariesNode.createAddProjectAction(this.project, "javac.test.classpath", null), LibrariesNode.createAddLibraryAction(this.project, this.updateHelper.getAntProjectHelper(), "javac.test.classpath", null), LibrariesNode.createAddFolderAction(this.project, "javac.test.classpath", null), null, new PreselectPropertiesAction(this.project, "Libraries", "COMPILE_TESTS")}, null);
            }
        }
        if (n == null) {
            nodeArray = new Node[]{};
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = n;
        }
        return nodeArray;
    }

    public void stateChanged(ChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LogicalViewChildren.this.createNodes();
            }
        });
    }

    private Collection getSourceRoots() {
        SourceGroup[] groups = this.sources.getSourceGroups("java");
        ArrayList<SourceGroupKey> result = new ArrayList<SourceGroupKey>(groups.length);
        for (int i = 0; i < groups.length; ++i) {
            result.add(new SourceGroupKey(groups[i]));
        }
        return result;
    }

    private final class JaxRPCChangeListener
    extends FileChangeAdapter {
        String webservicesFile = "webservices.xml";

        private JaxRPCChangeListener() {
        }

        public void fileDataCreated(FileEvent fe) {
            if (this.webservicesFile.equalsIgnoreCase(fe.getFile().getNameExt())) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LogicalViewChildren.this.createNodes();
                    }
                });
            }
        }

        public void fileDeleted(FileEvent fe) {
            if (this.webservicesFile.equalsIgnoreCase(fe.getFile().getNameExt())) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LogicalViewChildren.this.createNodes();
                    }
                });
            }
        }

        public void fileChanged(FileEvent fe) {
            if (this.webservicesFile.equalsIgnoreCase(fe.getFile().getNameExt())) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LogicalViewChildren.this.createNodes();
                    }
                });
            }
        }
    }

    private final class WsdlCreationListener
    extends FileChangeAdapter {
        private WsdlCreationListener() {
        }

        public void fileDataCreated(FileEvent fe) {
            if ("wsdl".equalsIgnoreCase(fe.getFile().getExt())) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LogicalViewChildren.this.refreshKey(LogicalViewChildren.KEY_SERVICE_REFS);
                    }
                });
            }
        }

        public void fileDeleted(FileEvent fe) {
            if ("wsdl".equalsIgnoreCase(fe.getFile().getExt())) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LogicalViewChildren.this.refreshKey(LogicalViewChildren.KEY_SERVICE_REFS);
                    }
                });
            }
        }
    }

    private final class MetaInfListener
    extends FileChangeAdapter {
        private MetaInfListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
            if (fe.getFile().isFolder() && "wsdl".equals(fe.getFile().getName())) {
                fe.getFile().addFileChangeListener((FileChangeListener)LogicalViewChildren.this.wsdlListener);
                LogicalViewChildren.this.wsdlFolder = fe.getFile();
            }
        }

        public void fileDeleted(FileEvent fe) {
            if (fe.getFile().isFolder() && "wsdl".equals(fe.getFile().getName())) {
                fe.getFile().removeFileChangeListener((FileChangeListener)LogicalViewChildren.this.wsdlListener);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LogicalViewChildren.this.refreshKey(LogicalViewChildren.KEY_SERVICE_REFS);
                    }
                });
            }
        }
    }

    private final class JaxWsChangeListener
    implements PropertyChangeListener {
        private JaxWsChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LogicalViewChildren.this.createNodes();
                }
            });
        }
    }

    private static class PreselectPropertiesAction
    extends AbstractAction {
        private Project project;
        private String nodeName;
        private String panelName;

        public PreselectPropertiesAction(Project project, String nodeName, String panelName) {
            super(NbBundle.getMessage(LogicalViewChildren.class, (String)"LBL_Properties_Action"));
            this.project = project;
            this.nodeName = nodeName;
            this.panelName = panelName;
        }

        public void actionPerformed(ActionEvent e) {
            CustomizerProviderImpl cp = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
            if (cp != null) {
                cp.showCustomizer(this.nodeName, this.panelName);
            }
        }
    }

    private static class PackageViewFilterNode
    extends FilterNode {
        private String nodeName;
        private Project project;
        private Action[] actions;

        public PackageViewFilterNode(SourceGroup sourceGroup, Project project) {
            super(PackageView.createPackageView((SourceGroup)sourceGroup));
            this.project = project;
            this.nodeName = "Sources";
        }

        public Action[] getActions(boolean context) {
            if (!context) {
                if (this.actions == null) {
                    Action[] superActions = super.getActions(context);
                    this.actions = new Action[superActions.length + 2];
                    System.arraycopy(superActions, 0, this.actions, 0, superActions.length);
                    this.actions[superActions.length] = null;
                    this.actions[superActions.length + 1] = new PreselectPropertiesAction(this.project, this.nodeName, null);
                }
                return this.actions;
            }
            return super.getActions(context);
        }
    }

    private static class SourceGroupKey {
        public final SourceGroup group;
        public final FileObject fileObject;

        SourceGroupKey(SourceGroup group) {
            this.group = group;
            this.fileObject = group.getRootFolder();
        }

        public int hashCode() {
            return this.fileObject.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SourceGroupKey)) {
                return false;
            }
            SourceGroupKey otherKey = (SourceGroupKey)obj;
            String thisDisplayName = this.group.getDisplayName();
            String otherDisplayName = otherKey.group.getDisplayName();
            return this.fileObject.equals(otherKey.fileObject) && thisDisplayName == null ? otherDisplayName == null : thisDisplayName.equals(otherDisplayName);
        }
    }
}

