/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarActionProvider;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarFileBuiltQuery;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarPersistenceProvider;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProjectOperations;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProvider;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarSharabilityQuery;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarSources;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarWebServicesClientSupport;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarWebServicesSupport;
import org.netbeans.modules.j2ee.ejbjarproject.ProjectEjbJarProvider;
import org.netbeans.modules.j2ee.ejbjarproject.ProjectWebServicesSupportProvider;
import org.netbeans.modules.j2ee.ejbjarproject.PropertyHelper;
import org.netbeans.modules.j2ee.ejbjarproject.SourceRoots;
import org.netbeans.modules.j2ee.ejbjarproject.UpdateHelper;
import org.netbeans.modules.j2ee.ejbjarproject.Utils;
import org.netbeans.modules.j2ee.ejbjarproject.classpath.ClassPathProviderImpl;
import org.netbeans.modules.j2ee.ejbjarproject.classpath.EjbJarProjectClassPathExtender;
import org.netbeans.modules.j2ee.ejbjarproject.jaxws.EjbJAXWSMetadataFinder;
import org.netbeans.modules.j2ee.ejbjarproject.jaxws.EjbProjectJAXWSClientSupport;
import org.netbeans.modules.j2ee.ejbjarproject.jaxws.EjbProjectJAXWSSupport;
import org.netbeans.modules.j2ee.ejbjarproject.queries.CompiledSourceForBinaryQuery;
import org.netbeans.modules.j2ee.ejbjarproject.queries.JavadocForBinaryQueryImpl;
import org.netbeans.modules.j2ee.ejbjarproject.queries.SourceLevelQueryImpl;
import org.netbeans.modules.j2ee.ejbjarproject.queries.UnitTestForSourceQueryImpl;
import org.netbeans.modules.j2ee.ejbjarproject.ui.BrokenReferencesAlertPanel;
import org.netbeans.modules.j2ee.ejbjarproject.ui.EjbJarLogicalViewProvider;
import org.netbeans.modules.j2ee.ejbjarproject.ui.FoldersListSettings;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.EjbJarProjectProperties;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarFactory;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.support.EjbEnterpriseReferenceContainerSupport;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.GeneratedFilesHelper;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModelProvider;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSSupportFactory;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSSupportImpl;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportFactory;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportImpl;
import org.netbeans.modules.websvc.spi.jaxws.client.JAXWSClientSupportFactory;
import org.netbeans.modules.websvc.spi.jaxws.client.JAXWSClientSupportImpl;
import org.netbeans.modules.websvc.spi.webservices.WebServicesSupportFactory;
import org.netbeans.modules.websvc.spi.webservices.WebServicesSupportImpl;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class EjbJarProject
implements Project,
AntProjectListener,
FileChangeListener,
PropertyChangeListener {
    private static final Icon PROJECT_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/j2ee/ejbjarproject/ui/resources/ejbjarProjectIcon.gif"));
    private final AuxiliaryConfiguration aux;
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final ReferenceHelper refHelper;
    private FileObject libFolder = null;
    private final GeneratedFilesHelper genFilesHelper;
    private final Lookup lookup;
    private final UpdateHelper updateHelper;
    private final EjbJarProvider ejbModule;
    private final EjbJar apiEjbJar;
    private WebServicesSupport apiWebServicesSupport;
    private JAXWSSupport apiJaxwsSupport;
    private EjbProjectJAXWSSupport jaxwsSupport;
    private WebServicesClientSupport apiWebServicesClientSupport;
    private JAXWSClientSupport apiJAXWSClientSupport;
    private EjbJarWebServicesSupport ejbJarWebServicesSupport;
    private EjbJarWebServicesClientSupport ejbJarWebServicesClientSupport;
    private EjbProjectJAXWSClientSupport jaxWsClientSupport;
    private SourceRoots sourceRoots;
    private SourceRoots testRoots;
    private PropertyHelper propertyHelper;
    private final EjbJarProjectClassPathExtender classpathExtender;
    private PropertyChangeListener j2eePlatformListener;
    private PropertyChangeListener evalListener;
    private JaxWsModel jaxWsModel;
    private JaxWsListener jaxWsListener;
    private FileObject jaxWsFo;
    private JaxWsModel.ServiceListener jaxWsServiceListener;
    private static long brokenAlertLastTime = 0L;
    private static boolean brokenAlertShown = false;
    private static int BROKEN_ALERT_TIMEOUT = 1000;
    private static final String[] TYPES = new String[]{"java-classes", "ejb-types_2_1", "ejb-types", "ejb-types-server", "web-services", "wsdl", "j2ee-14-types", "j2ee-types", "java-beans", "java-main-class", "persistence", "oasis-XML-catalogs", "XML", "ant-script", "ant-task", "junit", "simple-files"};
    private static final String[] JAVAEE5_TYPES = new String[]{"java-classes", "ejb-types", "ejb-types-server", "ejb-types_3_0", "web-services", "web-service-clients", "wsdl", "j2ee-types", "java-beans", "java-main-class", "persistence", "oasis-XML-catalogs", "XML", "ant-script", "ant-task", "junit", "simple-files"};
    private static final String[] ARCHIVE_TYPES = new String[]{"ejb-deployment-descriptor", "deployment-descriptor", "XML"};
    private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/J2EE/Session", "Templates/J2EE/Entity", "Templates/J2EE/RelatedCMP", "Templates/J2EE/Message", "Templates/Classes/Class.java", "Templates/Classes/Package", "Templates/WebServices/WebService.java", "Templates/WebServices/MessageHandler"};
    private static final String[] PRIVILEGED_NAMES_EE5 = new String[]{"Templates/J2EE/Session", "Templates/J2EE/Message", "Templates/Classes/Class.java", "Templates/Classes/Package", "Templates/Persistence/Entity.java", "Templates/Persistence/RelatedCMP", "Templates/WebServices/WebService.java", "Templates/WebServices/WebServiceClient"};
    private static final String[] PRIVILEGED_NAMES_ARCHIVE = new String[]{"Templates/J2EE/ejbJarXml"};

    EjbJarProject(AntProjectHelper helper) throws IOException {
        this.helper = helper;
        this.eval = this.createEvaluator();
        this.aux = helper.createAuxiliaryConfiguration();
        this.refHelper = new ReferenceHelper(helper, this.aux, helper.getStandardPropertyEvaluator());
        this.genFilesHelper = new GeneratedFilesHelper(helper);
        this.ejbModule = new EjbJarProvider(this, helper);
        this.apiEjbJar = EjbJarFactory.createEjbJar((EjbJarImplementation)this.ejbModule);
        this.ejbJarWebServicesSupport = new EjbJarWebServicesSupport(this, helper, this.refHelper);
        this.jaxwsSupport = new EjbProjectJAXWSSupport(this, helper);
        this.ejbJarWebServicesClientSupport = new EjbJarWebServicesClientSupport(this, helper, this.refHelper);
        this.jaxWsClientSupport = new EjbProjectJAXWSClientSupport(this);
        this.apiWebServicesSupport = WebServicesSupportFactory.createWebServicesSupport((WebServicesSupportImpl)this.ejbJarWebServicesSupport);
        this.apiJaxwsSupport = JAXWSSupportFactory.createJAXWSSupport((JAXWSSupportImpl)this.jaxwsSupport);
        this.apiWebServicesClientSupport = WebServicesClientSupportFactory.createWebServicesClientSupport((WebServicesClientSupportImpl)this.ejbJarWebServicesClientSupport);
        this.apiJAXWSClientSupport = JAXWSClientSupportFactory.createJAXWSClientSupport((JAXWSClientSupportImpl)this.jaxWsClientSupport);
        this.updateHelper = new UpdateHelper(this, this.helper, this.aux, this.genFilesHelper, UpdateHelper.createDefaultNotifier());
        this.classpathExtender = new EjbJarProjectClassPathExtender(this, this.updateHelper, this.evaluator(), this.refHelper);
        this.lookup = this.createLookup(this.aux);
        helper.addAntProjectListener((AntProjectListener)this);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    EjbJarProject.this.updateProjectXML();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                }
            }
        });
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public String toString() {
        return "EjbJarProject[" + this.getProjectDirectory() + "]";
    }

    private PropertyEvaluator createEvaluator() {
        PropertyEvaluator eval = this.helper.getStandardPropertyEvaluator();
        this.evalListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)eval);
        eval.addPropertyChangeListener(this.evalListener);
        return eval;
    }

    PropertyEvaluator evaluator() {
        return this.eval;
    }

    public ReferenceHelper getReferenceHelper() {
        return this.refHelper;
    }

    public UpdateHelper getUpdateHelper() {
        return this.updateHelper;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    private Lookup createLookup(AuxiliaryConfiguration aux) {
        SubprojectProvider spp = this.refHelper.createSubprojectProvider();
        final SourcesHelper sourcesHelper = new SourcesHelper(this.helper, this.evaluator());
        String ejbModuleLabel = NbBundle.getMessage(EjbJarLogicalViewProvider.class, (String)"LBL_Node_EJBModule");
        String configFilesLabel = NbBundle.getMessage(EjbJarLogicalViewProvider.class, (String)"LBL_Node_DocBase");
        sourcesHelper.addPrincipalSourceRoot("${source.root}", ejbModuleLabel, null, null);
        sourcesHelper.addPrincipalSourceRoot("${meta.inf}", configFilesLabel, null, null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                sourcesHelper.registerExternalRoots(0);
            }
        });
        return Lookups.fixed((Object[])new Object[]{new Info(), aux, this.helper.createCacheDirectoryProvider(), new ProjectWebServicesSupportProvider(), spp, EjbEnterpriseReferenceContainerSupport.createEnterpriseReferenceContainer((Project)this, (AntProjectHelper)this.helper), new ProjectEjbJarProvider(this), this.ejbModule, new EjbJarActionProvider(this, this.helper, this.refHelper), new EjbJarLogicalViewProvider(this, this.updateHelper, this.evaluator(), spp, this.refHelper), new CustomizerProviderImpl(this, this.updateHelper, this.evaluator(), this.refHelper), new ClassPathProviderImpl(this.helper, this.evaluator(), this.getSourceRoots(), this.getTestSourceRoots()), new CompiledSourceForBinaryQuery(this.helper, this.evaluator(), this.getSourceRoots(), this.getTestSourceRoots()), new JavadocForBinaryQueryImpl(this.helper, this.evaluator()), new AntArtifactProviderImpl(), new ProjectXmlSavedHookImpl(), new ProjectOpenedHookImpl(), new UnitTestForSourceQueryImpl(this.getSourceRoots(), this.getTestSourceRoots()), new SourceLevelQueryImpl(this.helper, this.evaluator()), new EjbJarSources(this.helper, this.evaluator(), this.getSourceRoots(), this.getTestSourceRoots()), new EjbJarSharabilityQuery(this.helper, this.evaluator(), this.getSourceRoots(), this.getTestSourceRoots()), new EjbJarFileBuiltQuery(this.helper, this.evaluator(), this.getSourceRoots(), this.getTestSourceRoots()), new RecommendedTemplatesImpl(this.updateHelper), this.refHelper, this.classpathExtender, new EjbJarProjectOperations(this), new EjbJarPersistenceProvider(this, this.evaluator()), new EjbJAXWSMetadataFinder(this), this.getJaxWsModel()});
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        if (ev.getPath().equals("nbproject/project.xml")) {
            Info info = (Info)this.getLookup().lookup(ProjectInformation.class);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    String getBuildXmlName() {
        String storedName = this.helper.getStandardPropertyEvaluator().getProperty("buildfile");
        return storedName == null ? "build.xml" : storedName;
    }

    public synchronized SourceRoots getSourceRoots() {
        if (this.sourceRoots == null) {
            this.sourceRoots = new SourceRoots(this.updateHelper, this.evaluator(), this.getReferenceHelper(), "source-roots", false, "src.{0}{1}.dir");
        }
        return this.sourceRoots;
    }

    public synchronized SourceRoots getTestSourceRoots() {
        if (this.testRoots == null) {
            this.testRoots = new SourceRoots(this.updateHelper, this.evaluator(), this.getReferenceHelper(), "test-roots", true, "test.{0}{1}.dir");
        }
        return this.testRoots;
    }

    WebServicesSupport getAPIWebServicesSupport() {
        return this.apiWebServicesSupport;
    }

    JAXWSSupport getAPIJAXWSSupport() {
        return this.apiJaxwsSupport;
    }

    WebServicesClientSupport getAPIWebServicesClientSupport() {
        return this.apiWebServicesClientSupport;
    }

    JAXWSClientSupport getAPIJAXWSClientSupport() {
        return this.apiJAXWSClientSupport;
    }

    public PropertyHelper getPropertyHelper() {
        if (this.propertyHelper == null) {
            this.propertyHelper = new PropertyHelper(this, this.updateHelper);
        }
        return this.propertyHelper;
    }

    public EjbJarProvider getEjbModule() {
        return this.ejbModule;
    }

    public EjbJar getAPIEjbJar() {
        return this.apiEjbJar;
    }

    private static synchronized void showBrokenReferencesAlert() {
        if (brokenAlertShown || brokenAlertLastTime + (long)BROKEN_ALERT_TIMEOUT > System.currentTimeMillis() || !FoldersListSettings.getDefault().isShowAgainBrokenRefAlert()) {
            return;
        }
        brokenAlertShown = true;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    String ok = NbBundle.getMessage(BrokenReferencesAlertPanel.class, (String)"MSG_Broken_References_OK");
                    DialogDescriptor dd = new DialogDescriptor((Object)new BrokenReferencesAlertPanel(), NbBundle.getMessage(BrokenReferencesAlertPanel.class, (String)"MSG_Broken_References_Title"), true, new Object[]{ok}, (Object)ok, 0, null, null);
                    Dialog dlg = null;
                    try {
                        dlg = DialogDisplayer.getDefault().createDialog(dd);
                        dlg.setVisible(true);
                    }
                    finally {
                        if (dlg != null) {
                            dlg.dispose();
                        }
                    }
                }
                finally {
                    Class<EjbJarProject> clazz = EjbJarProject.class;
                    synchronized (EjbJarProject.class) {
                        brokenAlertLastTime = System.currentTimeMillis();
                        brokenAlertShown = false;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
            }
        });
    }

    public String getName() {
        return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Element data = EjbJarProject.this.updateHelper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "name");
                if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                    return ((Text)nl.item(0)).getNodeValue();
                }
                return "EJB???";
            }
        });
    }

    public void setName(final String name) {
        ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                Element nameEl;
                Element data = EjbJarProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "name");
                if (nl.getLength() == 1) {
                    nameEl = (Element)nl.item(0);
                    NodeList deadKids = nameEl.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameEl.removeChild(deadKids.item(0));
                    }
                } else {
                    nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "name");
                    data.insertBefore(nameEl, data.getChildNodes().item(0));
                }
                nameEl.appendChild(data.getOwnerDocument().createTextNode(name));
                EjbJarProject.this.helper.putPrimaryConfigurationData(data, true);
                return null;
            }
        });
    }

    private void updateProjectXML() throws IOException {
        Element element = this.aux.getConfigurationFragment("data", "http://www.netbeans.org/ns/EjbJar-project/1", true);
        if (element != null) {
            Document doc = element.getOwnerDocument();
            Element newRoot = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "data");
            EjbJarProject.copyDocument(doc, element, newRoot);
            Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "source-roots");
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
            root.setAttribute("id", "src.dir");
            sourceRoots.appendChild(root);
            newRoot.appendChild(sourceRoots);
            Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "test-roots");
            root = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
            root.setAttribute("id", "test.src.dir");
            testRoots.appendChild(root);
            newRoot.appendChild(testRoots);
            this.helper.putPrimaryConfigurationData(newRoot, true);
            ProjectManager.getDefault().saveProject((Project)this);
        }
    }

    private static void copyDocument(Document doc, Element from, Element to) {
        NodeList nl = from.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nl.item(i);
            Node newNode = null;
            switch (node.getNodeType()) {
                case 1: {
                    Element oldElement = (Element)node;
                    newNode = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", oldElement.getTagName());
                    EjbJarProject.copyDocument(doc, oldElement, (Element)newNode);
                    break;
                }
                case 3: {
                    Text oldText = (Text)node;
                    newNode = doc.createTextNode(oldText.getData());
                    break;
                }
                case 8: {
                    Comment oldComment = (Comment)node;
                    newNode = doc.createComment(oldComment.getData());
                }
            }
            if (newNode == null) continue;
            to.appendChild(newNode);
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
        FileObject fo = fe.getFile();
        this.checkLibraryFolder(fo);
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void registerJ2eePlatformListener(final J2eePlatform platform) {
        this.j2eePlatformListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("classpath")) {
                    ProjectManager.mutex().writeAccess(new Mutex.Action(){

                        public Object run() {
                            EditableProperties ep = EjbJarProject.this.helper.getProperties("nbproject/private/private.properties");
                            String classpath = Utils.toClasspathString(platform.getClasspathEntries());
                            ep.setProperty("j2ee.platform.classpath", classpath);
                            EjbJarProject.this.helper.putProperties("nbproject/private/private.properties", ep);
                            try {
                                ProjectManager.getDefault().saveProject((Project)EjbJarProject.this);
                            }
                            catch (IOException e) {
                                ErrorManager.getDefault().notify((Throwable)e);
                            }
                            return null;
                        }
                    });
                }
            }
        };
        platform.addPropertyChangeListener(this.j2eePlatformListener);
    }

    public void unregisterJ2eePlatformListener(J2eePlatform platform) {
        if (this.j2eePlatformListener != null) {
            platform.removePropertyChangeListener(this.j2eePlatformListener);
        }
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
        FileObject fo = fe.getFile();
        this.checkLibraryFolder(fo);
    }

    private void checkLibraryFolder(FileObject fo) {
        if (!FileUtil.isArchiveFile((FileObject)fo)) {
            return;
        }
        if (fo.getParent().equals(this.libFolder)) {
            try {
                this.classpathExtender.addArchiveFile(fo);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private String getProperty(String path, String name) {
        return this.helper.getProperties(path).getProperty(name);
    }

    private void refreshBuildImplXml(int askUserIfFlags, boolean askInCurrentThread, boolean checkForProjectXmlModified) {
        int flags = this.genFilesHelper.getBuildScriptState("nbproject/build-impl.xml", EjbJarProject.class.getResource("resources/build-impl.xsl"), this.jaxWsFo);
        if ((flags & (askUserIfFlags |= 4)) == askUserIfFlags) {
            Runnable run = new Runnable(){

                public void run() {
                    JButton updateOption = new JButton(NbBundle.getMessage(EjbJarProject.class, (String)"CTL_Regenerate"));
                    if (DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(EjbJarProject.class, (String)"TXT_BuildImplRegenerate"), NbBundle.getMessage(EjbJarProject.class, (String)"TXT_BuildImplRegenerateTitle"), -1, 2, new Object[]{updateOption, NotifyDescriptor.CANCEL_OPTION}, (Object)updateOption)) == updateOption) {
                        try {
                            EjbJarProject.this.genFilesHelper.generateBuildScriptFromStylesheet("nbproject/build-impl.xml", EjbJarProject.class.getResource("resources/build-impl.xsl"), EjbJarProject.this.jaxWsFo);
                        }
                        catch (IOException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                        catch (IllegalStateException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    }
                }
            };
            if (askInCurrentThread) {
                run.run();
            } else {
                RequestProcessor.getDefault().post(run);
            }
        } else {
            try {
                this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", EjbJarProject.class.getResource("resources/build-impl.xsl"), this.jaxWsFo, checkForProjectXmlModified);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("javac.classpath")) {
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                public void run() {
                    EditableProperties props = EjbJarProject.this.helper.getProperties("nbproject/project.properties");
                    EditableProperties privateProps = EjbJarProject.this.helper.getProperties("nbproject/private/private.properties");
                    Iterator cpItems = EjbJarProject.this.classpathExtender.getClassPathSupport().itemsIterator(props.getProperty("javac.classpath"), "included-library");
                    EjbJarProjectProperties.storeLibrariesLocations(cpItems, privateProps);
                    EjbJarProject.this.helper.putProperties("nbproject/private/private.properties", privateProps);
                }
            });
        }
    }

    public void createJaxWsFileObject() throws IOException {
        FileObject projectDir = this.helper.getProjectDirectory();
        WSUtils.retrieveJaxWsFromResource((FileObject)projectDir);
        this.jaxWsFo = this.findJaxWsFileObject(projectDir);
        if (this.jaxWsFo != null) {
            this.jaxWsListener = new JaxWsListener();
            this.jaxWsFo.addFileChangeListener((FileChangeListener)this.jaxWsListener);
            if (this.jaxWsModel != null) {
                this.jaxWsModel.setJaxWsFile(this.jaxWsFo);
            } else {
                this.jaxWsModel = JaxWsModelProvider.getDefault().getJaxWsModel(this.jaxWsFo);
                if (this.jaxWsModel != null) {
                    this.attachServiceListener(this.jaxWsModel);
                }
            }
        }
    }

    public FileObject findJaxWsFileObject() {
        return this.findJaxWsFileObject(this.helper.getProjectDirectory());
    }

    private FileObject findJaxWsFileObject(FileObject projectDir) {
        return projectDir.getFileObject("nbproject/jax-ws.xml");
    }

    private JaxWsModel getJaxWsModel() {
        if (this.jaxWsModel == null) {
            try {
                final FileObject projectDir = this.helper.getProjectDirectory();
                this.jaxWsFo = this.findJaxWsFileObject(projectDir);
                if (this.jaxWsFo == null) {
                    this.jaxWsModel = JaxWsModelProvider.getDefault().getJaxWsModel(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/jax-ws.xml"));
                    this.jaxWsModel.setJaxWsFile(projectDir);
                } else {
                    this.jaxWsListener = new JaxWsListener();
                    try {
                        this.jaxWsModel = JaxWsModelProvider.getDefault().getJaxWsModel(this.jaxWsFo);
                        this.jaxWsFo.addFileChangeListener((FileChangeListener)this.jaxWsListener);
                    }
                    catch (RuntimeException ex) {
                        this.jaxWsModel = JaxWsModelProvider.getDefault().getJaxWsModel(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/jax-ws.xml"));
                        this.jaxWsModel.setJaxWsFile(projectDir);
                        final FileObject oldJaxWsFo = this.jaxWsFo;
                        this.jaxWsFo = null;
                        final RuntimeException exception = ex;
                        RequestProcessor.getDefault().post(new Runnable(){

                            public void run() {
                                try {
                                    EjbJarProject.this.jaxWsFo = WSUtils.backupAndGenerateJaxWs((FileObject)projectDir, (FileObject)oldJaxWsFo, (RuntimeException)exception);
                                    if (EjbJarProject.this.jaxWsFo != null) {
                                        EjbJarProject.this.jaxWsModel.setJaxWsFile(EjbJarProject.this.jaxWsFo);
                                        EjbJarProject.this.jaxWsFo.addFileChangeListener((FileChangeListener)EjbJarProject.this.jaxWsListener);
                                    }
                                }
                                catch (IOException ex) {
                                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                                }
                            }
                        });
                    }
                }
                if (this.jaxWsModel != null) {
                    this.attachServiceListener(this.jaxWsModel);
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        }
        return this.jaxWsModel;
    }

    private void attachServiceListener(JaxWsModel jaxWsModel) {
        this.jaxWsServiceListener = new JaxWsModel.ServiceListener(){

            public void serviceAdded(String name, String implementationClass) {
                EjbJarProject.this.getAPIJAXWSSupport().addService(name, implementationClass, EjbJarProject.this.isJsr109Supported());
            }

            public void serviceRemoved(String name) {
                EjbJarProject.this.getAPIJAXWSSupport().serviceFromJavaRemoved(name);
            }
        };
        jaxWsModel.addServiceListener(this.jaxWsServiceListener);
    }

    private boolean isJsr109Supported() {
        J2eePlatform j2eePlatform;
        boolean jsr109Supported = true;
        String serverInstance = this.evaluator().getProperty("j2ee.server.instance");
        if (serverInstance != null && (j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance)) != null) {
            jsr109Supported = j2eePlatform.isToolSupported("jsr109");
        }
        return jsr109Supported;
    }

    private class JaxWsListener
    extends FileChangeAdapter {
        private JaxWsListener() {
        }

        public void fileChanged(FileEvent fe) {
            try {
                final JaxWsModel newModel = JaxWsModelProvider.getDefault().getJaxWsModel(fe.getFile());
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (EjbJarProject.this.jaxWsModel != null && newModel != null) {
                            EjbJarProject.this.jaxWsModel.merge(newModel);
                        }
                        try {
                            EjbJarProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", EjbJarProject.class.getResource("resources/build-impl.xsl"), EjbJarProject.this.jaxWsFo, false);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private transient boolean isEE5 = false;
        private transient boolean checked = false;
        private transient boolean isArchive = false;
        private transient UpdateHelper helper = null;

        RecommendedTemplatesImpl(UpdateHelper helper) {
            this.helper = helper;
        }

        public String[] getRecommendedTypes() {
            this.checkEnvironment();
            String[] retVal = null;
            retVal = this.isArchive ? ARCHIVE_TYPES : (this.isEE5 ? JAVAEE5_TYPES : TYPES);
            return retVal;
        }

        public String[] getPrivilegedTemplates() {
            this.checkEnvironment();
            String[] retVal = null;
            retVal = this.isArchive ? PRIVILEGED_NAMES_ARCHIVE : (this.isEE5 ? PRIVILEGED_NAMES_EE5 : PRIVILEGED_NAMES);
            return retVal;
        }

        private void checkEnvironment() {
            if (!this.checked) {
                this.isEE5 = "1.5".equals(EjbJarProject.this.getEjbModule().getJ2eePlatformVersion());
                String srcType = this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("java.source.based");
                if ("false".equals(srcType)) {
                    this.isArchive = true;
                }
                this.checked = true;
            }
        }
    }

    private final class AntArtifactProviderImpl
    implements AntArtifactProvider {
        private AntArtifactProviderImpl() {
        }

        public AntArtifact[] getBuildArtifacts() {
            return new AntArtifact[]{EjbJarProject.this.helper.createSimpleAntArtifact("jar", "dist.jar", EjbJarProject.this.helper.getStandardPropertyEvaluator(), "dist", "clean"), EjbJarProject.this.helper.createSimpleAntArtifact("j2ee_archive", "dist.jar", EjbJarProject.this.helper.getStandardPropertyEvaluator(), "dist", "clean"), EjbJarProject.this.helper.createSimpleAntArtifact("j2ee_ear_archive", "dist.ear.jar", EjbJarProject.this.helper.getStandardPropertyEvaluator(), "dist-ear", "clean-ear")};
        }
    }

    private final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        ProjectOpenedHookImpl() {
        }

        protected void projectOpened() {
            try {
                String libFolderName = EjbJarProject.this.helper.getStandardPropertyEvaluator().getProperty("lib.dir");
                try {
                    FileObject ddFO = EjbJarProject.this.ejbModule.getDeploymentDescriptor();
                    if (ddFO != null) {
                        DataObject.find((FileObject)ddFO);
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    // empty catch block
                }
                if (libFolderName != null && EjbJarProject.this.helper.resolveFile(libFolderName).isDirectory()) {
                    EjbJarProject.this.libFolder = EjbJarProject.this.helper.resolveFileObject(libFolderName);
                    FileObject[] children = EjbJarProject.this.libFolder.getChildren();
                    LinkedList<FileObject> libs = new LinkedList<FileObject>();
                    for (int i = 0; i < children.length; ++i) {
                        if (!FileUtil.isArchiveFile((FileObject)children[i])) continue;
                        libs.add(children[i]);
                    }
                    FileObject[] libsArray = new FileObject[libs.size()];
                    libs.toArray(libsArray);
                    EjbJarProject.this.classpathExtender.addArchiveFiles("javac.classpath", libsArray, "included-library");
                    EjbJarProject.this.libFolder.addFileChangeListener((FileChangeListener)EjbJarProject.this);
                }
                EjbJarProject.this.refreshBuildImplXml(8, true, true);
                EjbJarProject.this.genFilesHelper.refreshBuildScript(EjbJarProject.this.getBuildXmlName(), EjbJarProject.class.getResource("resources/build.xsl"), EjbJarProject.this.jaxWsFo, true);
                String servInstID = EjbJarProject.this.getProperty("nbproject/private/private.properties", "j2ee.server.instance");
                J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(servInstID);
                if (platform != null) {
                    EjbJarProjectProperties.setServerInstance(EjbJarProject.this, EjbJarProject.this.helper, servInstID);
                } else {
                    String[] servInstIDs;
                    String serverType = EjbJarProject.this.getProperty("nbproject/project.properties", "j2ee.server.type");
                    if (serverType != null && (servInstIDs = Deployment.getDefault().getInstancesOfServer(serverType)).length > 0) {
                        EjbJarProjectProperties.setServerInstance(EjbJarProject.this, EjbJarProject.this.helper, servInstIDs[0]);
                        platform = Deployment.getDefault().getJ2eePlatform(servInstIDs[0]);
                    }
                    if (platform == null) {
                        BrokenServerSupport.showAlert();
                    }
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)EjbJarProject.this.lookup.lookup(ClassPathProviderImpl.class);
            GlobalPathRegistry.getDefault().register("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().register("classpath/source", cpProvider.getProjectClassPaths("classpath/source"));
            GlobalPathRegistry.getDefault().register("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
            EjbJarProject.this.ejbModule.getConfigSupport().ensureConfigurationReady();
            ProjectManager.mutex().writeAccess(new Mutex.Action(){

                public Object run() {
                    EditableProperties ep = EjbJarProject.this.helper.getProperties("nbproject/private/private.properties");
                    ep.setProperty("netbeans.user", System.getProperty("netbeans.user"));
                    EjbJarProject.this.helper.putProperties("nbproject/private/private.properties", ep);
                    try {
                        ProjectManager.getDefault().saveProject((Project)EjbJarProject.this);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    return null;
                }
            });
            EjbJarLogicalViewProvider physicalViewProvider = (EjbJarLogicalViewProvider)EjbJarProject.this.getLookup().lookup(EjbJarLogicalViewProvider.class);
            if (physicalViewProvider != null && physicalViewProvider.hasBrokenLinks()) {
                BrokenReferencesSupport.showAlert();
            }
        }

        protected void projectClosed() {
            String servInstID = EjbJarProject.this.getProperty("nbproject/private/private.properties", "j2ee.server.instance");
            J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(servInstID);
            if (platform != null) {
                EjbJarProject.this.unregisterJ2eePlatformListener(platform);
            }
            if (EjbJarProject.this.evalListener != null) {
                EjbJarProject.this.evaluator().removePropertyChangeListener(EjbJarProject.this.evalListener);
            }
            if (EjbJarProject.this.jaxWsFo != null) {
                EjbJarProject.this.jaxWsFo.removeFileChangeListener((FileChangeListener)EjbJarProject.this.jaxWsListener);
            }
            if (EjbJarProject.this.jaxWsModel != null) {
                EjbJarProject.this.jaxWsModel.removeServiceListener(EjbJarProject.this.jaxWsServiceListener);
            }
            try {
                ProjectManager.getDefault().saveProject((Project)EjbJarProject.this);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)EjbJarProject.this.lookup.lookup(ClassPathProviderImpl.class);
            GlobalPathRegistry.getDefault().unregister("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().unregister("classpath/source", cpProvider.getProjectClassPaths("classpath/source"));
            GlobalPathRegistry.getDefault().unregister("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
        }
    }

    private final class ProjectXmlSavedHookImpl
    extends ProjectXmlSavedHook {
        ProjectXmlSavedHookImpl() {
        }

        protected void projectXmlSaved() throws IOException {
            EjbJarProject.this.refreshBuildImplXml(0, false, false);
            EjbJarProject.this.genFilesHelper.refreshBuildScript(EjbJarProject.this.getBuildXmlName(), EjbJarProject.class.getResource("resources/build.xsl"), EjbJarProject.this.jaxWsFo, false);
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
        }

        void firePropertyChange(String prop) {
            this.pcs.firePropertyChange(prop, null, null);
        }

        public String getName() {
            return EjbJarProject.this.getName();
        }

        public String getDisplayName() {
            return EjbJarProject.this.getName();
        }

        public Icon getIcon() {
            return PROJECT_ICON;
        }

        public Project getProject() {
            return EjbJarProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }
}

