/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.tomcat5.TomcatFactory;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.netbeans.modules.tomcat5.util.TomcatInstallUtil;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class InstallPanelVisual
extends JPanel {
    private final String SERVER_XML = "conf/server.xml";
    private final List listeners = new ArrayList();
    private final int tomcatVersion;
    private String errorMessage;
    private String serverPort;
    private String shutdownPort;
    private RequestProcessor.Task validationTask;
    private JButton jButtonBaseBrowse;
    private JButton jButtonHomeBrowse;
    private JCheckBox jCheckBoxShared;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelBaseDir;
    private JLabel jLabelHomeDir;
    private JLabel jLabelPassword;
    private JLabel jLabelUsername;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField jTextFieldBaseDir;
    private JTextField jTextFieldHomeDir;
    private JPasswordField jTextFieldPassword;
    private JTextField jTextFieldUsername;

    public InstallPanelVisual(int aTomcatVersion) {
        this.tomcatVersion = aTomcatVersion;
        this.initComponents();
        DocumentListener updateListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                InstallPanelVisual.this.fireChange();
            }

            public void removeUpdate(DocumentEvent e) {
                InstallPanelVisual.this.fireChange();
            }

            public void insertUpdate(DocumentEvent e) {
                InstallPanelVisual.this.fireChange();
            }
        };
        this.jTextFieldHomeDir.getDocument().addDocumentListener(updateListener);
        this.jTextFieldBaseDir.getDocument().addDocumentListener(updateListener);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (InstallPanelVisual.this.isJWSDP()) {
                    if (InstallPanelVisual.this.jCheckBoxShared.isEnabled()) {
                        InstallPanelVisual.this.jCheckBoxShared.setEnabled(false);
                        InstallPanelVisual.this.setBaseEnabled(false);
                    }
                } else if (!InstallPanelVisual.this.jCheckBoxShared.isEnabled()) {
                    InstallPanelVisual.this.jCheckBoxShared.setEnabled(true);
                    if (InstallPanelVisual.this.jCheckBoxShared.isSelected()) {
                        InstallPanelVisual.this.setBaseEnabled(true);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    private void initComponents() {
        this.jLabelHomeDir = new JLabel();
        this.jLabelBaseDir = new JLabel();
        this.jTextFieldHomeDir = new JTextField();
        this.jTextFieldBaseDir = new JTextField();
        this.jButtonBaseBrowse = new JButton();
        this.jButtonHomeBrowse = new JButton();
        this.jCheckBoxShared = new JCheckBox();
        this.jLabelUsername = new JLabel();
        this.jLabelPassword = new JLabel();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jTextFieldUsername = new JTextField();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jTextFieldPassword = new JPasswordField();
        this.jLabel3 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setName(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_InstanceProperties"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_panel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_panel"));
        this.jLabelHomeDir.setLabelFor(this.jTextFieldHomeDir);
        Mnemonics.setLocalizedText((JLabel)this.jLabelHomeDir, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_home_dir"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jLabelHomeDir, gridBagConstraints);
        this.jLabelHomeDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelHomeDir"));
        this.jLabelHomeDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelHomeDir"));
        this.jLabelBaseDir.setLabelFor(this.jTextFieldBaseDir);
        Mnemonics.setLocalizedText((JLabel)this.jLabelBaseDir, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_base_dir"));
        this.jLabelBaseDir.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jLabelBaseDir, gridBagConstraints);
        this.jLabelBaseDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelBaseDir"));
        this.jLabelBaseDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelBaseDir"));
        this.jTextFieldHomeDir.setColumns(15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jTextFieldHomeDir, gridBagConstraints);
        this.jTextFieldHomeDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_homeDir"));
        this.jTextFieldHomeDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_homeDir"));
        this.jTextFieldBaseDir.setColumns(15);
        this.jTextFieldBaseDir.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jTextFieldBaseDir, gridBagConstraints);
        this.jTextFieldBaseDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_baseDir"));
        this.jTextFieldBaseDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_baseDir"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonBaseBrowse, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_file_chooser_base"));
        this.jButtonBaseBrowse.setEnabled(false);
        this.jButtonBaseBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InstallPanelVisual.this.jButtonBaseBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jButtonBaseBrowse, gridBagConstraints);
        this.jButtonBaseBrowse.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_ButtonBaseBrowse"));
        this.jButtonBaseBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_ButtonBaseBrowse"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonHomeBrowse, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_file_chooser_home"));
        this.jButtonHomeBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InstallPanelVisual.this.jButtonHomeBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jButtonHomeBrowse, gridBagConstraints);
        this.jButtonHomeBrowse.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_ButtonHomeBrowse"));
        this.jButtonHomeBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_ButtonHomeBrowse"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxShared, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_SharedInstall"));
        this.jCheckBoxShared.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InstallPanelVisual.this.jCheckBoxSharedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jCheckBoxShared, gridBagConstraints);
        this.jCheckBoxShared.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_shared"));
        this.jCheckBoxShared.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_shared"));
        this.jLabelUsername.setLabelFor(this.jTextFieldUsername);
        Mnemonics.setLocalizedText((JLabel)this.jLabelUsername, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_Username"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabelUsername, gridBagConstraints);
        this.jLabelUsername.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelUsername"));
        this.jLabelUsername.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelUsername"));
        this.jLabelPassword.setLabelFor(this.jTextFieldPassword);
        Mnemonics.setLocalizedText((JLabel)this.jLabelPassword, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_Password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jLabelPassword, gridBagConstraints);
        this.jLabelPassword.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelPassword"));
        this.jLabelPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelPassword"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_TextAbove"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jTextFieldUsername.setColumns(15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        this.jPanel1.add((Component)this.jTextFieldUsername, gridBagConstraints);
        this.jTextFieldUsername.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_username"));
        this.jTextFieldUsername.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_username"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_ForManager"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jTextFieldPassword.setColumns(15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel2.add((Component)this.jTextFieldPassword, gridBagConstraints);
        this.jTextFieldPassword.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_password"));
        this.jTextFieldPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_password"));
        this.jLabel3.setForeground(this.getBackground());
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_ForManager"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void jButtonBaseBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setSelectedFile(new File(this.jTextFieldBaseDir.getText().trim()));
        if (chooser.showOpenDialog(this) == 0) {
            this.jTextFieldBaseDir.setText(chooser.getSelectedFile().getAbsolutePath());
            this.fireChange();
        }
    }

    private void jButtonHomeBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setSelectedFile(new File(this.jTextFieldHomeDir.getText().trim()));
        if (chooser.showOpenDialog(this) == 0) {
            this.jTextFieldHomeDir.setText(chooser.getSelectedFile().getAbsolutePath());
            this.fireChange();
        }
    }

    private void jCheckBoxSharedActionPerformed(ActionEvent evt) {
        this.setBaseEnabled(this.jCheckBoxShared.isSelected());
        this.fireChange();
    }

    public Properties getProperties() {
        Properties p = new Properties();
        p.put("httpportnumber", this.serverPort);
        p.put("admin_port", this.shutdownPort);
        p.put("monitor_enabled", "false");
        return p;
    }

    public String getUrl() {
        String url = this.tomcatVersion == 1 ? "tomcat55:" : "tomcat:";
        url = url + "home=" + this.jTextFieldHomeDir.getText();
        if (this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected()) {
            url = url + ":base=" + this.jTextFieldBaseDir.getText();
        }
        TomcatFactory.getEM().log("TomcatInstall.getUrl: " + url);
        return url;
    }

    public String getUsername() {
        return this.jTextFieldUsername.getText();
    }

    public String getPassword() {
        return new String(this.jTextFieldPassword.getPassword());
    }

    public File getHomeDir() {
        return new File(this.jTextFieldHomeDir.getText());
    }

    public String getErrorMessage() {
        return this.errorMessage == null ? null : "<html>" + this.errorMessage.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</html>";
    }

    boolean isServerXmlValid(File file) {
        try {
            Server server = Server.createGraph(file);
            this.serverPort = TomcatInstallUtil.getPort(server);
            this.shutdownPort = TomcatInstallUtil.getShutdownPort(server);
            if (this.serverPort != null && this.shutdownPort != null) {
                Integer.parseInt(this.serverPort);
                Integer.parseInt(this.shutdownPort);
                return true;
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        catch (NumberFormatException nfe) {
            ErrorManager.getDefault().notify(1, (Throwable)nfe);
        }
        catch (RuntimeException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return false;
    }

    private boolean isHomeValid() {
        String homeDir = this.jTextFieldHomeDir.getText();
        if (homeDir.length() == 0) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_SpecifyHomeDir");
            return false;
        }
        if (!new File(homeDir, "bin/bootstrap.jar").exists()) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_InvalidHomeDir");
            return false;
        }
        if (!(this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected() || this.isServerXmlValid(new File(homeDir, "conf/server.xml")))) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_CorruptedHomeServerXml");
            return false;
        }
        return true;
    }

    private boolean isJWSDP() {
        File homeDir;
        if (this.isHomeValid() && (homeDir = this.getHomeDir()) != null && homeDir.exists()) {
            File[] files = homeDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return "jwsdp-shared".equals(name);
                }
            });
            return files.length != 0;
        }
        return false;
    }

    private boolean isBaseValid() {
        if (this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected()) {
            String base = this.jTextFieldBaseDir.getText();
            if (base.length() == 0) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_SpecifyBaseDir");
                return false;
            }
            File baseDir = new File(base);
            String[] files = baseDir.list();
            File serverXml = new File(baseDir, "conf/server.xml");
            if (!baseDir.exists() || files == null || files.length > 0 && !serverXml.exists()) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_InvalidBaseDir");
                return false;
            }
            if (files.length > 0) {
                if (!this.isServerXmlValid(serverXml)) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_CorruptedBaseServerXml");
                    return false;
                }
            } else if (!this.isServerXmlValid(new File(this.jTextFieldHomeDir.getText(), "conf/server.xml"))) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_CorruptedHomeServerXml");
                return false;
            }
        }
        return true;
    }

    private boolean isAlreadyRegistered() {
        if (InstanceProperties.getInstanceProperties((String)this.getUrl()) != null) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)(this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected() ? "MSG_AlreadyRegisteredBase" : "MSG_AlreadyRegisteredHome"));
            return true;
        }
        return false;
    }

    private void setBaseEnabled(boolean enabled) {
        this.jLabelBaseDir.setEnabled(enabled);
        this.jTextFieldBaseDir.setEnabled(enabled);
        this.jButtonBaseBrowse.setEnabled(enabled);
    }

    public boolean isValid() {
        this.errorMessage = null;
        return this.isHomeValid() && this.isBaseValid() && !this.isAlreadyRegistered();
    }

    private void fireChange() {
        if (this.validationTask == null) {
            this.validationTask = RequestProcessor.getDefault().create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ArrayList tempList;
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    ChangeEvent event = new ChangeEvent(this);
                    List list = InstallPanelVisual.this.listeners;
                    synchronized (list) {
                        tempList = new ArrayList(InstallPanelVisual.this.listeners);
                    }
                    Iterator iter = tempList.iterator();
                    while (iter.hasNext()) {
                        ((ChangeListener)iter.next()).stateChanged(event);
                    }
                }
            });
        }
        this.validationTask.schedule(60);
    }
}

