/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.config;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.plugins.api.DatasourceManager;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.config.TomcatDatasource;
import org.netbeans.modules.tomcat5.config.gen.GlobalNamingResources;
import org.netbeans.modules.tomcat5.config.gen.Parameter;
import org.netbeans.modules.tomcat5.config.gen.ResourceParams;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatDatasourceManager
implements DatasourceManager {
    private final TomcatManager tm;

    public TomcatDatasourceManager(DeploymentManager dm) {
        this.tm = (TomcatManager)dm;
    }

    public Set<Datasource> getDatasources() {
        HashSet<Datasource> result;
        block9: {
            Server server;
            result = new HashSet<Datasource>();
            File serverXml = this.tm.getTomcatProperties().getServerXml();
            try {
                server = Server.createGraph(serverXml);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return Collections.emptySet();
            }
            catch (RuntimeException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return Collections.emptySet();
            }
            GlobalNamingResources[] globalNamingResources = server.getGlobalNamingResources();
            if (globalNamingResources.length <= 0) break block9;
            GlobalNamingResources globalNR = globalNamingResources[0];
            if (this.tm.getTomcatVersion() == 1) {
                int length = globalNR.getResource().length;
                for (int i = 0; i < length; ++i) {
                    String type = globalNR.getResourceType(i);
                    if (!"javax.sql.DataSource".equals(type)) continue;
                    String name = globalNR.getResourceName(i);
                    String username = globalNR.getResourceUsername(i);
                    String url = globalNR.getResourceUrl(i);
                    String password = globalNR.getResourcePassword(i);
                    String driverClassName = globalNR.getResourceDriverClassName(i);
                    if (name == null || username == null || url == null || driverClassName == null) continue;
                    result.add(new TomcatDatasource(username, url, password, name, driverClassName));
                }
            } else {
                int length = globalNR.getResource().length;
                ResourceParams[] resourceParams = globalNR.getResourceParams();
                for (int i = 0; i < length; ++i) {
                    String type = globalNR.getResourceType(i);
                    if (!"javax.sql.DataSource".equals(type)) continue;
                    String name = globalNR.getResourceName(i);
                    for (int j = 0; j < resourceParams.length; ++j) {
                        if (!name.equals(resourceParams[j].getName())) continue;
                        Parameter[] params = resourceParams[j].getParameter();
                        HashMap<String, String> paramNameValueMap = new HashMap<String, String>(params.length);
                        for (Parameter parameter : params) {
                            paramNameValueMap.put(parameter.getName(), parameter.getValue());
                        }
                        String username = (String)paramNameValueMap.get("username");
                        String url = (String)paramNameValueMap.get("url");
                        String password = (String)paramNameValueMap.get("password");
                        String driverClassName = (String)paramNameValueMap.get("driverClassName");
                        if (username == null || url == null || driverClassName == null) continue;
                        result.add(new TomcatDatasource(username, url, password, name, driverClassName));
                    }
                }
            }
        }
        return result;
    }

    public void deployDatasources(Set<Datasource> datasources) throws ConfigurationException, DatasourceAlreadyExistsException {
    }
}

