/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import org.netbeans.updater.ModuleUpdater;
import org.netbeans.updater.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class UpdateTracking {
    private static final String ELEMENT_MODULES = "installed_modules";
    private static final String ELEMENT_MODULE = "module";
    private static final String ATTR_CODENAMEBASE = "codename";
    private static final String ELEMENT_VERSION = "module_version";
    private static final String ATTR_VERSION = "specification_version";
    private static final String ATTR_ORIGIN = "origin";
    private static final String ATTR_LAST = "last";
    private static final String ATTR_INSTALL = "install_time";
    private static final String ELEMENT_FILE = "file";
    private static final String ATTR_FILE_NAME = "name";
    private static final String ATTR_CRC = "crc";
    private static final String NBM_ORIGIN = "nbm";
    private static final String INST_ORIGIN = "updater";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String LOCALE_DIR = FILE_SEPARATOR + "locale" + FILE_SEPARATOR;
    private static final String TRACKING_FILE_NAME = "update_tracking";
    private static final String XML_EXT = ".xml";
    private static final Map trackings = new HashMap();
    private LinkedHashMap installedModules = new LinkedHashMap();
    private boolean pError = false;
    private boolean fromUser = false;
    private final File directory;
    private final File trackingFile;
    private String origin = "nbm";

    public UpdateTracking() {
        this(null);
    }

    private UpdateTracking(File nbPath) {
        assert (nbPath != null) : "Path cannot be null";
        this.trackingFile = new File(nbPath + FILE_SEPARATOR + TRACKING_FILE_NAME);
        this.directory = nbPath;
        this.origin = INST_ORIGIN;
    }

    static UpdateTracking getTracking(boolean fromuser) {
        UpdateTracking ut = UpdateTracking.getTracking(System.getProperty(fromuser ? "netbeans.user" : "netbeans.home"), fromuser);
        return ut;
    }

    private static UpdateTracking getTracking(String cluster, boolean createIfDoesNotExists) {
        File f = new File(cluster);
        UpdateTracking ut = UpdateTracking.getTracking(f, createIfDoesNotExists);
        return ut;
    }

    public static UpdateTracking getTracking(File path) {
        path = new File(path.toURI().normalize()).getAbsoluteFile();
        File userDir = new File(System.getProperty("netbeans.user"));
        userDir = new File(userDir.toURI().normalize()).getAbsoluteFile();
        return UpdateTracking.getTracking(path, path.toString().equals(userDir.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdateTracking getTracking(File path, boolean createIfDoesNotExists) {
        try {
            path = path.getCanonicalFile();
        }
        catch (IOException ex) {
            IllegalStateException ill = new IllegalStateException(ex.getMessage());
            ill.initCause(ex);
            throw ill;
        }
        Map map = trackings;
        synchronized (map) {
            UpdateTracking track = (UpdateTracking)trackings.get(path);
            if (track == null) {
                File utFile = new File(path, TRACKING_FILE_NAME);
                if (!createIfDoesNotExists && !utFile.isDirectory()) {
                    return null;
                }
                File noAU = new File(path, ".noautoupdate");
                if (noAU.exists()) {
                    return null;
                }
                track = new UpdateTracking(path);
                trackings.put(path, track);
                track.read();
                track.scanDir();
            }
            return track;
        }
    }

    public static File getPlatformDir() {
        return new File(System.getProperty("netbeans.home"));
    }

    public static List clusters(boolean includeUserDir) {
        String dirs;
        ArrayList<File> files = new ArrayList<File>();
        if (includeUserDir) {
            File ud = new File(System.getProperty("netbeans.user"));
            files.add(ud);
        }
        if ((dirs = System.getProperty("netbeans.dirs")) != null) {
            StringTokenizer en = new StringTokenizer(dirs, File.pathSeparator);
            while (en.hasMoreElements()) {
                File f = new File((String)en.nextElement());
                files.add(f);
            }
        }
        File id = UpdateTracking.getPlatformDir();
        files.add(id);
        return Collections.unmodifiableList(files);
    }

    public boolean isModuleInstalled(String codeBase) {
        for (Module m : this.installedModules.values()) {
            String mm = m.codenamebase;
            int indx = mm.indexOf(47);
            if (indx >= 0) {
                mm = mm.substring(0, indx);
            }
            if (!codeBase.equals(mm)) continue;
            return true;
        }
        return false;
    }

    public List getModulesToInstall() {
        File idir = new File(this.directory, ModuleUpdater.DOWNLOAD_DIR);
        class NbmFilter
        implements FilenameFilter {
            NbmFilter() {
            }

            public boolean accept(File dir, String name) {
                return name.endsWith(UpdateTracking.NBM_ORIGIN);
            }
        }
        File[] arr = idir.listFiles(new NbmFilter());
        if (arr == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(arr);
    }

    private void read() {
        Document document;
        try {
            File file = this.trackingFile;
            if (!file.isFile()) {
                return;
            }
            FileInputStream is = new FileInputStream(file);
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse(xmlInputSource, false, false, new ErrorCatcher(), XMLUtil.createAUResolver());
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (SAXException e) {
            System.out.println("Bad update_tracking");
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            System.out.println("Missing update_tracking");
            e.printStackTrace();
            return;
        }
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals(ELEMENT_MODULES)) {
            this.scanElement_installed_modules(element, this.fromUser);
        }
    }

    void scanElement_installed_modules(Element element, boolean fromuser) {
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals(ELEMENT_MODULE)) continue;
            throw new IllegalStateException("What now!?");
        }
    }

    Module scanElement_module(Element element, boolean fromuser) {
        Module module = new Module(fromuser);
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().startsWith(ATTR_CODENAMEBASE)) continue;
            module.setCodenamebase(attr.getValue());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals(ELEMENT_VERSION)) continue;
            this.scanElement_module_version(nodeElement, module);
        }
        return module;
    }

    void scanElement_module_version(Element element, Module module) {
        Version version = new Version();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals(ATTR_VERSION)) {
                version.setVersion(attr.getValue());
            }
            if (attr.getName().equals(ATTR_ORIGIN)) {
                version.setOrigin(attr.getValue());
            }
            if (attr.getName().equals(ATTR_LAST)) {
                version.setLast(Boolean.valueOf(attr.getValue()));
            }
            if (!attr.getName().equals(ATTR_INSTALL)) continue;
            long li = 0L;
            try {
                li = Long.parseLong(attr.getValue());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            version.setInstall_time(li);
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals(ELEMENT_FILE)) continue;
            this.scanElement_file(nodeElement, version);
        }
        module.addOldVersion(version);
    }

    void scanElement_file(Element element, Version version) {
        ModuleFile file = new ModuleFile();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals(ATTR_FILE_NAME)) {
                file.setName(attr.getValue());
            }
            if (attr.getName().equals(ATTR_CRC)) {
                file.setCrc(attr.getValue());
            }
            if (!attr.getName().equals(ATTR_VERSION)) continue;
            file.setLocaleversion(attr.getValue());
        }
        version.addFile(file);
    }

    Module readModuleTracking(boolean fromuser, String codename, boolean create) {
        new File(this.directory, TRACKING_FILE_NAME).mkdirs();
        File file = new File(new File(this.directory, TRACKING_FILE_NAME), UpdateTracking.getTrackingName(codename) + XML_EXT);
        try {
            if (file.exists() && file.length() == 0L) {
                file.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!file.exists()) {
            if (create) {
                return new Module(codename, file, fromuser);
            }
            return null;
        }
        return this.readModuleFromFile(file, codename, fromuser, create);
    }

    Version createVersion(String specversion) {
        Version ver = new Version();
        ver.setVersion(specversion);
        return ver;
    }

    private Module readModuleFromFile(File file, String codename, boolean fromuser, boolean create) {
        Document document;
        try {
            FileInputStream is = new FileInputStream(file);
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse(xmlInputSource, false, false, new ErrorCatcher(), XMLUtil.createAUResolver());
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (SAXException e) {
            System.out.println("Bad update_tracking");
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            if (create) {
                return new Module(codename, file, fromuser);
            }
            return null;
        }
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals(ELEMENT_MODULE)) {
            Module m = this.scanElement_module(element, fromuser);
            m.setFile(file);
            this.installedModules.put(file, m);
            return m;
        }
        if (create) {
            return new Module(codename, file, fromuser);
        }
        return null;
    }

    private static String getTrackingName(String codename) {
        String trackingName = codename;
        int pos = trackingName.indexOf(47);
        if (pos > -1) {
            trackingName = trackingName.substring(0, pos);
        }
        return trackingName.replace('.', '-');
    }

    public static void convertOldFormat(File oldfile, String path, boolean fromUserDir) {
        new File(path + FILE_SEPARATOR + TRACKING_FILE_NAME).mkdirs();
        UpdateTracking track = UpdateTracking.getTracking(fromUserDir);
        for (Module mod : track.installedModules.values()) {
            File newfile = new File(path + FILE_SEPARATOR + TRACKING_FILE_NAME + FILE_SEPARATOR + UpdateTracking.getTrackingName(mod.getCodenamebase()) + XML_EXT);
            mod.setFile(newfile);
            mod.write();
        }
        oldfile.delete();
    }

    public String getL10NSpecificationVersion(String codenamebase, boolean fromUserDir, String jarpath) {
        Module module = this.readModuleTracking(fromUserDir, codenamebase, false);
        if (module == null) {
            return null;
        }
        return module.getL10NSpecificationVersion(jarpath);
    }

    void deleteUnusedFiles() {
        ArrayList newModules = new ArrayList(this.installedModules.values());
        for (Module mod : newModules) {
            mod.deleteUnusedFiles();
        }
        this.scanDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileCRC(File file) throws IOException {
        BufferedInputStream bsrc = null;
        CRC32 crc = new CRC32();
        try {
            int i;
            bsrc = new BufferedInputStream(new FileInputStream(file));
            byte[] bytes = new byte[1024];
            while ((i = bsrc.read()) != -1) {
                crc.update((byte)i);
            }
        }
        finally {
            if (bsrc != null) {
                bsrc.close();
            }
        }
        return crc.getValue();
    }

    private void scanDir() {
        File dir = new File(this.directory, TRACKING_FILE_NAME);
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory() && file.getName().toUpperCase().endsWith(".XML");
            }
        });
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (this.installedModules.containsKey(files[i])) continue;
            this.readModuleFromFile(files[i], null, this.fromUser, true);
        }
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String level, SAXParseException e) {
            UpdateTracking.this.pError = true;
        }

        public void error(SAXParseException e) {
            UpdateTracking.this.pError = true;
        }

        public void warning(SAXParseException e) {
        }

        public void fatalError(SAXParseException e) {
            UpdateTracking.this.pError = true;
        }
    }

    class ModuleFile {
        private String name;
        private String crc;
        private String localeversion = null;

        ModuleFile() {
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        String getCrc() {
            return this.crc;
        }

        void setCrc(String crc) {
            this.crc = crc;
        }

        public String getLocaleversion() {
            return this.localeversion;
        }

        public void setLocaleversion(String localeversion) {
            this.localeversion = localeversion;
        }
    }

    public class Version
    implements Comparable {
        private String version;
        private String origin;
        private boolean last;
        private long install_time = 0L;
        private List files = new ArrayList();

        String getVersion() {
            return this.version;
        }

        void setVersion(String version) {
            this.version = version;
        }

        String getOrigin() {
            return this.origin;
        }

        void setOrigin(String origin) {
            this.origin = origin;
        }

        boolean isLast() {
            return this.last;
        }

        void setLast(boolean last) {
            this.last = last;
        }

        long getInstall_time() {
            return this.install_time;
        }

        void setInstall_time(long install_time) {
            this.install_time = install_time;
        }

        List getFiles() {
            return this.files;
        }

        void addL10NFiles(List l10nfiles) {
            for (ModuleFile lf : l10nfiles) {
                String lname = lf.getName();
                for (int i = this.files.size() - 1; i >= 0; --i) {
                    ModuleFile f = (ModuleFile)this.files.get(i);
                    if (!f.getName().equals(lname)) continue;
                    this.files.remove(i);
                }
            }
            this.files.addAll(l10nfiles);
        }

        void addFile(ModuleFile file) {
            this.files.add(file);
        }

        public void addFileWithCrc(String filename, String crc) {
            ModuleFile file = new ModuleFile();
            file.setName(filename);
            file.setCrc(crc);
            this.files.add(file);
        }

        public void addL10NFileWithCrc(String filename, String crc, String specver) {
            ModuleFile file = new ModuleFile();
            file.setName(filename);
            file.setCrc(crc);
            file.setLocaleversion(specver);
            this.files.add(file);
        }

        boolean containsFile(ModuleFile file) {
            for (ModuleFile f : this.files) {
                if (!f.getName().equals(file.getName())) continue;
                return true;
            }
            return false;
        }

        ModuleFile findFile(String filename) {
            for (ModuleFile f : this.files) {
                if (!f.getName().equals(filename)) continue;
                return f;
            }
            return null;
        }

        String getLocaleVersion(String filename) {
            String locver = null;
            ModuleFile f = this.findFile(filename);
            if (f != null && (locver = f.getLocaleversion()) == null) {
                locver = this.version;
            }
            return locver;
        }

        public int compareTo(Object obj) {
            Version oth = (Version)obj;
            if (this.install_time < oth.getInstall_time()) {
                return 1;
            }
            if (this.install_time > oth.getInstall_time()) {
                return -1;
            }
            return 0;
        }
    }

    class Module {
        private String codenamebase;
        private List versions = new ArrayList();
        private File file = null;
        private boolean fromUser = true;
        private Version lastVersion = null;
        private Version newVersion = null;

        public Module() {
        }

        public Module(boolean fromUser) {
            this.fromUser = fromUser;
        }

        public Module(String codenamebase, File file, boolean fromUser) {
            this.codenamebase = codenamebase;
            this.file = file;
            this.fromUser = fromUser;
        }

        String getCodenamebase() {
            return this.codenamebase;
        }

        void setCodenamebase(String codenamebase) {
            this.codenamebase = codenamebase;
        }

        List getVersions() {
            return this.versions;
        }

        void setVersions(List versions) {
            this.versions = versions;
        }

        boolean isFromUser() {
            return this.fromUser;
        }

        void setFromUser(boolean fromUser) {
            this.fromUser = fromUser;
        }

        private Version getNewOrLastVersion() {
            if (this.newVersion != null) {
                return this.newVersion;
            }
            return this.lastVersion;
        }

        boolean hasNewVersion() {
            return this.newVersion != null;
        }

        void setFile(File file) {
            this.file = file;
        }

        public Version addNewVersion(String spec_version) {
            Version version;
            if (this.lastVersion != null) {
                this.lastVersion.setLast(false);
            }
            this.newVersion = version = new Version();
            version.setVersion(spec_version);
            version.setOrigin(UpdateTracking.this.origin);
            version.setLast(true);
            version.setInstall_time(System.currentTimeMillis());
            this.versions.add(version);
            return version;
        }

        void addOldVersion(Version version) {
            if (version.isLast()) {
                this.lastVersion = version;
            }
            this.versions.add(version);
        }

        void addL10NVersion(Version l_version) {
            if (this.lastVersion != null) {
                this.lastVersion.addL10NFiles(l_version.getFiles());
            } else {
                l_version.setOrigin(UpdateTracking.this.origin);
                l_version.setLast(true);
                l_version.setInstall_time(System.currentTimeMillis());
                this.versions.add(l_version);
            }
        }

        void writeConfigModuleXMLIfMissing() {
            String replaced;
            File configDir = new File(new File(UpdateTracking.this.directory, "config"), "Modules");
            String candidate = null;
            String oldCandidate = null;
            String newCandidate = null;
            String name = this.codenamebase;
            int indx = name.indexOf(47);
            if (indx > 0) {
                name = name.substring(0, indx);
            }
            String searchFor = (replaced = name.replace('.', '-')).indexOf("modules") > 0 ? replaced + ".jar" : replaced.substring(replaced.lastIndexOf(45) > 0 ? replaced.lastIndexOf(45) + 1 : 0) + ".jar";
            String dash = name.replace('.', '-');
            File config = new File(configDir, dash + UpdateTracking.XML_EXT);
            if (config.isFile()) {
                return;
            }
            config.getParentFile().mkdirs();
            Boolean isAutoload = null;
            Boolean isEager = null;
            for (ModuleFile f : this.newVersion.getFiles()) {
                String n = f.getName();
                String parentDir = new File(f.getName()).getParentFile().getName();
                if (n.endsWith(".jar")) {
                    candidate = f.getName();
                    if (searchFor.endsWith(candidate) || candidate.endsWith(searchFor)) {
                        newCandidate = candidate;
                        oldCandidate = null;
                        isAutoload = "autoload".equals(parentDir) ? Boolean.TRUE : Boolean.FALSE;
                        isEager = "eager".equals(parentDir) ? Boolean.TRUE : Boolean.FALSE;
                    } else if (newCandidate == null) {
                        oldCandidate = (oldCandidate == null ? "" : oldCandidate + ", ") + candidate;
                    }
                }
                if (isAutoload == null && "autoload".equals(parentDir)) {
                    isAutoload = Boolean.TRUE;
                }
                if (isEager != null || !"eager".equals(parentDir)) continue;
                isEager = Boolean.TRUE;
            }
            assert (newCandidate != null || oldCandidate != null) : "No jar file present!";
            if (newCandidate == null && !oldCandidate.equals(candidate)) {
                System.out.println("NBM Error: More files look as module: " + oldCandidate);
                oldCandidate = candidate;
            }
            String moduleName = newCandidate == null ? oldCandidate : newCandidate;
            boolean autoload = isAutoload != null && isAutoload != false;
            boolean eager = isEager != null && isEager != false;
            boolean isEnabled = !autoload && !eager;
            String spec = this.newVersion.getVersion();
            try {
                FileOutputStream os = new FileOutputStream(config);
                PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                pw.println("<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"");
                pw.println("                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">");
                pw.println("<module name=\"" + name + "\">");
                pw.println("    <param name=\"autoload\">" + autoload + "</param>");
                pw.println("    <param name=\"eager\">" + eager + "</param>");
                if (isEnabled) {
                    pw.println("    <param name=\"enabled\">" + isEnabled + "</param>");
                }
                pw.println("    <param name=\"jar\">" + moduleName + "</param>");
                pw.println("    <param name=\"reloadable\">false</param>");
                pw.println("    <param name=\"specversion\">" + spec + "</param>");
                pw.println("</module>");
                pw.flush();
                pw.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        void write() {
            Document document = XMLUtil.createDocument(UpdateTracking.ELEMENT_MODULE);
            Element e_module = document.getDocumentElement();
            Element e_version = null;
            Element e_file = null;
            e_module.setAttribute(UpdateTracking.ATTR_CODENAMEBASE, this.getCodenamebase());
            for (Version ver : this.getVersions()) {
                e_version = document.createElement(UpdateTracking.ELEMENT_VERSION);
                if (ver.getVersion() != null) {
                    e_version.setAttribute(UpdateTracking.ATTR_VERSION, ver.getVersion());
                }
                e_version.setAttribute(UpdateTracking.ATTR_ORIGIN, ver.getOrigin());
                e_version.setAttribute(UpdateTracking.ATTR_LAST, new Boolean(ver.isLast()).toString());
                e_version.setAttribute(UpdateTracking.ATTR_INSTALL, Long.toString(ver.getInstall_time()));
                e_module.appendChild(e_version);
                for (ModuleFile file : ver.getFiles()) {
                    e_file = document.createElement(UpdateTracking.ELEMENT_FILE);
                    e_file.setAttribute(UpdateTracking.ATTR_FILE_NAME, file.getName());
                    e_file.setAttribute(UpdateTracking.ATTR_CRC, file.getCrc());
                    if (file.getLocaleversion() != null) {
                        e_file.setAttribute(UpdateTracking.ATTR_VERSION, file.getLocaleversion());
                    }
                    e_version.appendChild(e_file);
                }
            }
            document.getDocumentElement().normalize();
            try {
                FileOutputStream os = new FileOutputStream(this.file);
                XMLUtil.write(document, os);
                ((OutputStream)os).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void deleteUnusedFiles() {
            if (this.lastVersion == null || this.newVersion == null) {
                return;
            }
            for (ModuleFile modFile : this.lastVersion.getFiles()) {
                if (this.newVersion.containsFile(modFile) || modFile.getName().indexOf(LOCALE_DIR) != -1) continue;
                this.safeDelete(modFile);
            }
        }

        private void safeDelete(ModuleFile modFile) {
            File f = new File(this.file.getParentFile().getParent() + FILE_SEPARATOR + modFile.getName());
            if (f.exists()) {
                try {
                    if (!Long.toString(UpdateTracking.getFileCRC(f)).equals(modFile.getCrc())) {
                        return;
                    }
                }
                catch (IOException ioe) {
                    return;
                }
                UpdateTracking.this.scanDir();
                boolean found = false;
                Iterator it = UpdateTracking.this.installedModules.values().iterator();
                while (!found && it.hasNext()) {
                    Version v;
                    Module mod = (Module)it.next();
                    if (mod.equals(this) || (v = mod.getNewOrLastVersion()) == null || !v.containsFile(modFile)) continue;
                    found = true;
                }
                if (!found) {
                    f.delete();
                }
            }
        }

        String getL10NSpecificationVersion(String jarpath) {
            String localever = null;
            Collections.sort(this.versions);
            for (Version ver : this.versions) {
                localever = ver.getLocaleVersion(jarpath);
                if (localever == null) continue;
                return localever;
            }
            return null;
        }
    }
}

