/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.ejb;

import com.sun.jdo.api.persistence.mapping.ejb.AbstractNameMapper;
import com.sun.jdo.api.persistence.model.DevelopmentModel;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.modules.persistence.mapping.ejb.DevelopmentNameMapper;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.openide.filesystems.FileObject;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.Type;

public class EJBDevelopmentModel
extends DevelopmentModel {
    private ClassLoader classLoader;
    private DevelopmentNameMapper nameMapper;

    public EJBDevelopmentModel(DevelopmentNameMapper nameMapper, ClassLoader classLoader, FileObject[] sourceRoots) {
        super(sourceRoots);
        this.classLoader = classLoader;
        this.nameMapper = nameMapper;
    }

    private ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private DevelopmentNameMapper getNameMapper() {
        return this.nameMapper;
    }

    protected BufferedInputStream getInputStreamForResource(String className, ClassLoader classLoader, String resourceName) {
        return super.getInputStreamForResource(className, this.getClassLoader(), resourceName);
    }

    protected String findPenultimateSuperclass(String className) {
        return this.isPCClassName(className) ? className : super.findPenultimateSuperclass(className);
    }

    protected String getSuperclass(String className) {
        return this.isPCClassName(className) ? "java.lang.Object" : super.getSuperclass(className);
    }

    protected BufferedOutputStream createFile(String className, String baseFileName, String extension) throws IOException {
        BufferedOutputStream outputStream = super.createFile(className, baseFileName, extension);
        if (outputStream != null) {
            return outputStream;
        }
        throw new UnsupportedOperationException();
    }

    protected void deleteFile(String className, String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Object getClass(String className, ClassLoader classLoader) {
        String testClass = className;
        if (className != null) {
            String ejbName;
            DevelopmentNameMapper mapper = this.getNameMapper();
            String string = ejbName = this.isPCClassName(className) ? this.getEjbName(className) : className;
            if (((AbstractNameMapper)mapper).isEjbName(ejbName)) {
                testClass = ((AbstractNameMapper)mapper).getAbstractBeanClassForEjbName(ejbName);
            } else {
                String keyClass = mapper.getKeyClassForPersistenceKeyClass(className);
                if (keyClass != null) {
                    if (2 == this.getPersistenceKeyClassType(className)) {
                        if (this.isPrimitive(keyClass)) {
                            return JavaTypeHelper.getPrimitiveClass(keyClass);
                        }
                        if (this.isByteArray(keyClass) || keyClass.endsWith("[]")) {
                            return [B.class;
                        }
                    }
                    testClass = keyClass;
                }
            }
        }
        return super.getClass(testClass, this.getClassLoader());
    }

    public Object getConstructor(String className, String[] argTypeNames) {
        Object returnObject = null;
        if (2 == this.getPersistenceKeyClassType(className) && argTypeNames.equals(NO_ARGS)) {
            returnObject = new MemberWrapper(className, null, 1, (ClassElement)this.getClass(className));
        }
        if (returnObject == null && (returnObject = super.getConstructor(className, argTypeNames)) instanceof ConstructorElement) {
            returnObject = new MemberWrapper((MemberElement)((ConstructorElement)returnObject));
        }
        return returnObject;
    }

    public Object getMethod(String className, String methodName, String[] argTypeNames) {
        int keyClassType = this.getPersistenceKeyClassType(className);
        Object returnObject = null;
        if (this.isPCClassName(className) && (methodName.equals("readObject") && argTypeNames.equals(READ_OBJECT_ARGS) || methodName.equals("writeObject") && argTypeNames.equals(WRITE_OBJECT_ARGS))) {
            returnObject = new MemberWrapper(methodName, Type.VOID, 2, (ClassElement)this.getClass(className));
        }
        if (3 == keyClassType || 2 == keyClassType) {
            if (methodName.equals("equals") && argTypeNames.equals(EQUALS_ARGS)) {
                returnObject = new MemberWrapper(methodName, Type.BOOLEAN, 1, (ClassElement)this.getClass(className));
            } else if (methodName.equals("hashCode") && argTypeNames.equals(NO_ARGS)) {
                returnObject = new MemberWrapper(methodName, Type.INT, 1, (ClassElement)this.getClass(className));
            }
        }
        if (returnObject == null && (returnObject = super.getMethod(className, methodName, argTypeNames)) instanceof MethodElement) {
            returnObject = new MemberWrapper((MemberElement)((MethodElement)returnObject));
        }
        return returnObject;
    }

    public Object getInheritedMethod(String className, String methodName, String[] argTypeNames) {
        return 2 == this.getPersistenceKeyClassType(className) ? this.getMethod(className, methodName, argTypeNames) : super.getInheritedMethod(className, methodName, argTypeNames);
    }

    public List getFields(String className) {
        DevelopmentNameMapper mapper = this.getNameMapper();
        String testClass = className;
        if (this.getCMPDescriptor(className) != null) {
            String ejbName = this.isPCClassName(className) ? this.getEjbName(className) : className;
            return mapper.getFieldsForEjb(ejbName);
        }
        String ejbName = mapper.getEjbNameForPersistenceKeyClass(className);
        switch (this.getPersistenceKeyClassType(className)) {
            case 1: {
                testClass = mapper.getKeyClassForEjbName(ejbName);
                break;
            }
            case 2: {
                return Arrays.asList(this.getCMPDescriptor(ejbName).getPrimkeyField());
            }
            case 3: {
                String pcClassName = mapper.getPersistenceClassForEjbName(ejbName);
                PersistenceFieldElement[] fields = this.getPersistenceClass(pcClassName).getFields();
                int count = fields != null ? fields.length : 0;
                for (int i = 0; i < count; ++i) {
                    PersistenceFieldElement pfe = fields[i];
                    if (!pfe.isKey()) continue;
                    return Arrays.asList(pfe.getName());
                }
                break;
            }
        }
        return super.getFields(testClass);
    }

    public List getAllFields(String className) {
        return 2 == this.getPersistenceKeyClassType(className) ? this.getFields(className) : super.getAllFields(className);
    }

    public Object getField(String className, String fieldName) {
        String testClass = className;
        Object returnObject = null;
        if (className != null) {
            DevelopmentNameMapper mapper = this.getNameMapper();
            boolean isPCClass = this.isPCClassName(className);
            boolean isPKClassName = false;
            String searchClassName = className;
            String searchFieldName = fieldName;
            if (isPCClass) {
                searchFieldName = ((AbstractNameMapper)mapper).getEjbFieldForPersistenceField(className, fieldName);
                searchClassName = this.getEjbName(className);
            } else {
                String ejbName = mapper.getEjbNameForPersistenceKeyClass(className);
                switch (this.getPersistenceKeyClassType(className)) {
                    case 2: {
                        testClass = ejbName;
                        searchClassName = ejbName;
                        isPKClassName = true;
                        break;
                    }
                    case 3: {
                        testClass = ((AbstractNameMapper)mapper).getPersistenceClassForEjbName(ejbName);
                        isPCClass = true;
                        isPKClassName = true;
                    }
                }
            }
            if (((AbstractNameMapper)mapper).isEjbName(searchClassName)) {
                searchClassName = ((AbstractNameMapper)mapper).getAbstractBeanClassForEjbName(searchClassName);
            }
            if ((returnObject = super.getField(searchClassName, searchFieldName)) == null) {
                returnObject = this.getFieldWrapper(testClass, searchFieldName);
            } else if (returnObject instanceof FieldElement) {
                returnObject = new MemberWrapper((MemberElement)((FieldElement)returnObject));
            }
            if (isPCClass) {
                returnObject = this.updateFieldWrapper((MemberWrapper)returnObject, testClass, fieldName);
            }
            if (isPKClassName && returnObject instanceof MemberWrapper) {
                ((MemberWrapper)returnObject)._modifiers = 1;
            }
        }
        return returnObject;
    }

    public String getFieldType(String className, String fieldName) {
        String returnType = super.getFieldType(className, fieldName);
        if (!this.isCollection(returnType) && this.isPCClassName(className)) {
            String ejbField;
            String ejbName;
            DevelopmentNameMapper mapper = this.getNameMapper();
            if (mapper.isGeneratedEjbRelationship(ejbName = ((AbstractNameMapper)mapper).getEjbNameForPersistenceClass(className), ejbField = ((AbstractNameMapper)mapper).getEjbFieldForPersistenceField(className, fieldName))) {
                String[] inverse = mapper.getEjbFieldForGeneratedField(ejbName, ejbField);
                returnType = ((AbstractNameMapper)mapper).getPersistenceClassForEjbName(inverse[0]);
            }
            if (((AbstractNameMapper)mapper).isLocalInterface(returnType)) {
                returnType = mapper.getPersistenceClassForLocalInterface(className, fieldName, returnType);
            }
        }
        return returnType;
    }

    public String getDeclaringClass(Object memberElement) {
        if (memberElement != null && memberElement instanceof MemberWrapper) {
            ClassElement classElement = ((MemberWrapper)memberElement).getDeclaringClass();
            return classElement != null ? classElement.getName().getFullName() : null;
        }
        return super.getDeclaringClass(memberElement);
    }

    public int getModifiers(Object memberElement) {
        if (memberElement != null && memberElement instanceof MemberWrapper) {
            return ((MemberWrapper)memberElement).getModifiers();
        }
        return super.getModifiers(memberElement);
    }

    public int getModifiersForClass(String className) {
        int modifiers = super.getModifiersForClass(className);
        if (this.isPCClassName(className)) {
            modifiers &= 0xFFFFFBFF;
        } else if (this.getNameMapper().getKeyClassForPersistenceKeyClass(className) != null) {
            modifiers |= 8;
        }
        return modifiers;
    }

    public boolean isValidKeyType(String className, String fieldName) {
        return 2 == this.getPersistenceKeyClassType(className) && this.isPrimitive(className, fieldName) ? false : super.isValidKeyType(className, fieldName);
    }

    protected Type getTypeObject(Object element) {
        Type type = super.getTypeObject(element);
        if (element != null && element instanceof MemberWrapper) {
            type = ((MemberWrapper)element).getType();
        }
        return type;
    }

    private boolean isPCClassName(String className) {
        return this.getEjbName(className) != null;
    }

    private String getEjbName(String className) {
        return this.getNameMapper().getEjbNameForPersistenceClass(className);
    }

    private Entity getCMPDescriptor(String className) {
        String descriptorName = this.isPCClassName(className) ? this.getEjbName(className) : className;
        return this.getNameMapper().getDescriptorForEjbName(descriptorName);
    }

    private int getPersistenceKeyClassType(String className) {
        DevelopmentNameMapper mapper;
        String ejbName;
        int returnValue = -1;
        if (this.getCMPDescriptor(className) == null && (ejbName = (mapper = this.getNameMapper()).getEjbNameForPersistenceKeyClass(className)) != null) {
            returnValue = ((AbstractNameMapper)mapper).getKeyClassTypeForEjbName(ejbName);
        }
        return returnValue;
    }

    private MemberWrapper getFieldWrapper(String className, String fieldName) {
        Entity descriptor = this.getCMPDescriptor(className);
        MemberWrapper returnObject = null;
        if (descriptor != null) {
            String getter = "get" + StringHelper.getCapitalizedString(fieldName);
            Type fieldType = null;
            try {
                Object method = this.getMethod(className, getter, NO_ARGS);
                if (method != null) {
                    fieldType = this.getTypeObject(method);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            returnObject = fieldType == null ? null : new MemberWrapper(fieldName, fieldType, 2, (ClassElement)this.getClass(className));
        }
        return returnObject;
    }

    private MemberWrapper updateFieldWrapper(MemberWrapper returnObject, String className, String fieldName) {
        PersistenceFieldElement field;
        DevelopmentNameMapper mapper = this.getNameMapper();
        if (returnObject == null && (field = this.getPersistenceFieldInternal(className, fieldName)) != null) {
            String ejbName = this.getEjbName(className);
            String ejbFieldName = ((AbstractNameMapper)mapper).getEjbFieldForPersistenceField(className, fieldName);
            if (field.isKey() && ejbName != null && ((AbstractNameMapper)mapper).getKeyClassTypeForEjbName(ejbName) == 3) {
                returnObject = new MemberWrapper(ejbFieldName, Type.LONG, 2, (ClassElement)this.getClass(className));
            } else if (field instanceof RelationshipElement && mapper.isGeneratedEjbRelationship(ejbName, ejbFieldName)) {
                RelationshipElement rel = (RelationshipElement)field;
                Type classType = null;
                if (rel.getUpperBound() > 1) {
                    classType = Type.createClass((Identifier)Identifier.create((String)"java.util.HashSet"));
                } else {
                    String[] inverse = mapper.getEjbFieldForGeneratedField(ejbName, ejbFieldName);
                    classType = Type.createClass((Identifier)((ClassElement)this.getClass(inverse[0])).getName());
                }
                if (classType != null) {
                    returnObject = new MemberWrapper(ejbFieldName, classType, 2, (ClassElement)this.getClass(className));
                }
            } else if (ejbFieldName.startsWith("thisVersionFieldWasGeneratedByTheNameMapper") && mapper.isGeneratedField(ejbName, ejbFieldName)) {
                returnObject = new MemberWrapper(ejbFieldName, Type.LONG, 2, (ClassElement)this.getClass(className));
            }
        }
        if (!this.isPersistentTypeAllowed(this.getType(returnObject), this.getClassLoader()) && this.isSerializable(returnObject)) {
            returnObject.setType(Type.createArray((Type)Type.BYTE));
        }
        return returnObject;
    }

    private class MemberWrapper {
        private String _name;
        private Type _type;
        private int _modifiers;
        private ClassElement _declaringClass;

        private MemberWrapper(MemberElement member) {
            this(member.getName().getName(), (Type)(member instanceof FieldElement ? ((FieldElement)member).getType() : (member instanceof MethodElement ? ((MethodElement)member).getReturn() : null)), member.getModifiersMask(), member.getDeclaringClass());
        }

        private MemberWrapper(String name, Type type, int modifiers, ClassElement declaringClass) {
            this._name = name;
            this._type = type;
            this._modifiers = modifiers;
            this._declaringClass = declaringClass;
        }

        private Type getType() {
            return this._type;
        }

        private void setType(Type type) {
            this._type = type;
        }

        private String getName() {
            return this._name;
        }

        private int getModifiers() {
            return this._modifiers;
        }

        private ClassElement getDeclaringClass() {
            return this._declaringClass;
        }

        public String toString() {
            return this.getName();
        }
    }
}

